/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.domain.transfer.configitem.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.bos.utils.DbTypeConverter;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.FileUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.common.model.ConfItemMainValidFailBo;
import kd.hdtc.hrdt.business.common.model.ConfItemRelValidFailBo;
import kd.hdtc.hrdt.business.common.model.ConfItemValidEntityRelF7Bo;
import kd.hdtc.hrdt.business.common.utils.ConfItemDyObjectUtils;
import kd.hdtc.hrdt.business.domain.common.entity.impl.CommonServiceImpl;
import kd.hdtc.hrdt.business.domain.ext.IBosEntityObjectEntityService;
import kd.hdtc.hrdt.business.domain.file.IMetaDataPresetDataDomainService;
import kd.hdtc.hrdt.business.domain.file.impl.MetaDatePresetDataDomainServiceImpl;
import kd.hdtc.hrdt.business.domain.transfer.configitem.IConfigItemDomainService;
import kd.hdtc.hrdt.business.domain.transfer.configitem.model.ConfigItemBo;
import kd.hdtc.hrdt.business.domain.transfer.configitem.model.TransferDataBo;
import kd.hdtc.hrdt.common.constants.ConfigItemConstants;
import kd.hdtc.hrdt.common.enums.TransferConfEnum;
import kd.hdtc.hrdt.common.msgenum.BizModeMsgEnum;
import kd.hr.hbp.business.domain.model.newhismodel.HisBaseBo;
import kd.hr.hbp.business.domain.repository.HisEventEntityRepository;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisDeleteService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.revocation.HisModelEventDataService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class ConfigItemDomainServiceImpl
implements IConfigItemDomainService {
    private static final Log LOG = LogFactory.getLog(ConfigItemDomainServiceImpl.class);
    private static final String SELECT_CONFIG_TREE_FIELD = "id,name,number,parent,issyspreset,enable,orderfield";
    private static final String SELECT_REL_ENTITY_FIELD = "id,parent,sourceentity,sourcefieldnumber,relentity,relfieldnumber,relcomparator";
    private static final String SELECT_CONFIG_ITEM_FIELD = "id,name,number,confignumber,group,supportaddtopacket,issyspreset,importtype,plugin,custparampage,bizentity,enable,orderfield";
    private static final String PREFIX_C = "c_";
    private static final String ISPRESET = "ispreset";
    private static final String ORDER = "order";
    private static final CommonServiceImpl configItemEntityService = new CommonServiceImpl("hrdt_configitems");
    private static final CommonServiceImpl relEntityConfService = new CommonServiceImpl("hrdt_relentityconf");
    private static final CommonServiceImpl sysConfigItemEntityService = new CommonServiceImpl("ricc_configitems");
    private static final CommonServiceImpl configTreeEntityService = new CommonServiceImpl("hrdt_configtree");
    private IBosEntityObjectEntityService bosEntityObjectEntityService = ServiceFactory.createInstance(IBosEntityObjectEntityService.class);
    private List<Map<String, Map<String, Object>>> sysConfItemDataList;
    private Set<Object> failConfItemIdSet = new HashSet<Object>(16);
    private Map<String, Boolean> ctrlEntityMap = new HashMap<String, Boolean>(16);
    private Set<String> confItemEntityNumSet = new HashSet<String>(16);
    private Map<Object, Map<String, Object>> confItemIdDataMap = new HashMap<Object, Map<String, Object>>(16);
    private Set<String> confItemItselfNumSet = new HashSet<String>(16);
    private IMetaDataPresetDataDomainService metaDatePresetDataDomainService = new MetaDatePresetDataDomainServiceImpl();
    private CommonServiceImpl confSynLogService = new CommonServiceImpl("hrdt_confsynlog");
    private static final String Q_FILTER_STRING = "fid in (";
    private Date nowDate = new Date();
    private Long curUserId = RequestContext.get().getCurrUserId();
    private Map<String, String> confItemKeyFieldMap;
    private Map<Object, ConfItemMainValidFailBo> confItemValidFailBoMap = new HashMap<Object, ConfItemMainValidFailBo>(16);
    private Map<Object, ConfItemRelValidFailBo> relEntityValidFailBoMap = new HashMap<Object, ConfItemRelValidFailBo>(16);

    @Override
    public void batchDelConfigItem(Set<Long> idSet) {
        try (TXHandle txHandle = TX.requiresNew();){
            relEntityConfService.deleteByFilter(new QFilter("configitem", "in", idSet).toArray());
            configItemEntityService.deleteByFilter(new QFilter("id", "in", idSet).toArray());
        }
    }

    @Override
    public JSONObject batchDelRiccConfigItem(Set<Long> idSet) {
        JSONObject result;
        try {
            result = (JSONObject)HRMServiceHelper.invokeBizService((String)"imsc", (String)"ricc", (String)"configItemService", (String)"delConfigItems", (Object[])new Object[]{new ArrayList<Long>(idSet)});
        }
        catch (Exception e) {
            LOG.error("sync ricc error(delConfigItems):", (Throwable)e);
            throw new KDBizException(BizModeMsgEnum.DEL_RICC_CONFIG_ITEM_FAIL_TIP.get());
        }
        return result;
    }

    @Override
    public DynamicObject[] getSysPresetConfigItemInfo(Set<Long> idSet) {
        Object[] idArr = configItemEntityService.query("id", new QFilter("id", "in", idSet).and("issyspreset", "=", (Object)"1").toArray());
        if (ObjectUtils.isEmpty((Object[])idArr)) {
            return new DynamicObject[0];
        }
        return idArr;
    }

    @Override
    public JSONObject syncConfigTree() {
        DynamicObject[] configTreeArr = configTreeEntityService.query(SELECT_CONFIG_TREE_FIELD, null);
        ArrayList configTreeList = Lists.newArrayListWithCapacity((int)configTreeArr.length);
        Arrays.stream(configTreeArr).forEach(config -> {
            HashMap paramMap = Maps.newHashMap();
            DynamicObject parent = config.getDynamicObject("parent");
            String enable = config.getString("enable");
            boolean isSysPreset = config.getBoolean("issyspreset");
            paramMap.put("id", config.getLong("id"));
            paramMap.put("number", isSysPreset ? config.getString("number") : this.handlePrefixC(config.getString("number")));
            paramMap.put("name", config.getLocaleString("name").getLocaleValue());
            paramMap.put("parent.id", parent == null ? 0L : parent.getLong("id"));
            paramMap.put(ISPRESET, isSysPreset);
            paramMap.put("enable", HRStringUtils.equals((String)enable, (String)"1") ? enable : "0");
            paramMap.put("orderfield", config.getString("orderfield"));
            configTreeList.add(paramMap);
        });
        JSONObject result = new JSONObject();
        try {
            result = (JSONObject)HRMServiceHelper.invokeBizService((String)"imsc", (String)"ricc", (String)"configItemService", (String)"saveConfigTree", (Object[])new Object[]{configTreeList});
        }
        catch (Exception e) {
            LOG.error("sync ricc error(syncConfigTree):", (Throwable)e);
            if (e instanceof NullPointerException) {
                result.put("msg", (Object)BizModeMsgEnum.UNKNOWN_ERROR.get());
            }
            result.put("msg", (Object)e.getMessage());
        }
        return result;
    }

    @Override
    public JSONObject syncConfigItem() {
        DynamicObject[] configItemArr = configItemEntityService.query(SELECT_CONFIG_ITEM_FIELD, null);
        Set<String> numberSet = Arrays.stream(configItemArr).map(config -> config.getString("number")).collect(Collectors.toSet());
        Map<String, Set<Long>> allConfItemIdList = this.getAllConfItemIdList(numberSet);
        ArrayList configItemList = Lists.newArrayListWithCapacity((int)configItemArr.length);
        Arrays.stream(configItemArr).forEach(config -> {
            HashMap paramMap = Maps.newHashMap();
            DynamicObject bizEntity = config.getDynamicObject("bizentity");
            DynamicObject group = config.getDynamicObject("group");
            String enable = config.getString("enable");
            boolean isSysPreset = config.getBoolean("issyspreset");
            paramMap.put("id", config.getLong("id"));
            paramMap.put("name", config.getLocaleString("name").getLocaleValue());
            String confNumber = isSysPreset ? config.getString("number") : config.getString("confignumber");
            paramMap.put("number", HRStringUtils.isBlank((CharSequence)confNumber) ? this.handlePrefixC(config.getString("number")) : confNumber);
            paramMap.put("page.number", bizEntity.getString("number"));
            paramMap.put("group.id", group.getLong("id"));
            paramMap.put("group.number", group.getString("number"));
            paramMap.put("configtype", "A");
            paramMap.put(ISPRESET, isSysPreset);
            paramMap.put("enable", HRStringUtils.equals((String)enable, (String)"1") ? enable : "0");
            paramMap.put("supportaddtopacket", true);
            paramMap.put("importtype", "microService");
            paramMap.put("microParam", this.structMicroParam());
            paramMap.put("canexportall", true);
            Set relConfigItemSet = (Set)allConfItemIdList.get(config.getString("number"));
            ArrayList relyItemEntry = Lists.newArrayListWithExpectedSize((int)relConfigItemSet.size());
            relConfigItemSet.forEach(rel -> relyItemEntry.add(new HashMap<String, String>(16){
                {
                    super(x0);
                    this.put("relyitem.id", String.valueOf(rel));
                }
            }));
            paramMap.put("relyitementry", relyItemEntry);
            paramMap.put("orderfield", config.getString("orderfield"));
            configItemList.add(paramMap);
        });
        JSONObject result = new JSONObject();
        try {
            result = (JSONObject)HRMServiceHelper.invokeBizService((String)"imsc", (String)"ricc", (String)"configItemService", (String)"saveConfigItem", (Object[])new Object[]{configItemList});
        }
        catch (Exception e) {
            LOG.error("sync ricc error(syncConfigItem):", (Throwable)e);
            if (e instanceof NullPointerException) {
                result.put("msg", (Object)BizModeMsgEnum.UNKNOWN_ERROR.get());
            }
            result.put("msg", (Object)e.getMessage());
        }
        return result;
    }

    private String handlePrefixC(String number) {
        if (number.startsWith(PREFIX_C)) {
            return number;
        }
        return PREFIX_C + number;
    }

    private Map<String, Object> structMicroParam() {
        HashMap<String, Object> microParam = new HashMap<String, Object>(6);
        microParam.put("cloud", "hdtc");
        microParam.put("appid", "hrdt");
        microParam.put("servicename", "IConfigItemService");
        microParam.put("filetransfertype", "tempFile");
        microParam.put("batchcount", 1000);
        microParam.put("param", new ArrayList());
        return microParam;
    }

    @Override
    public void loadRelEntityEntry(DynamicObjectCollection treeEntry, long id) {
        DynamicObject[] relEntityArr = relEntityConfService.query(SELECT_REL_ENTITY_FIELD, new QFilter("configitem", "=", (Object)id).toArray(), ORDER);
        treeEntry.clear();
        Arrays.stream(relEntityArr).forEach(rel -> {
            DynamicObject dyc = new DynamicObject(treeEntry.getDynamicObjectType());
            dyc.set("id", (Object)rel.getLong("id"));
            DynamicObject parent = rel.getDynamicObject("parent");
            if (parent == null) {
                dyc.set("pid", (Object)0L);
            } else {
                dyc.set("pid", (Object)rel.getDynamicObject("parent").getLong("id"));
            }
            dyc.set("sourceentity", (Object)rel.getDynamicObject("sourceentity"));
            dyc.set("sourcerelfield", (Object)rel.getString("sourcefieldnumber"));
            dyc.set("targetentity", (Object)rel.getDynamicObject("relentity"));
            dyc.set("targetrelfield", (Object)rel.getString("relfieldnumber"));
            dyc.set("logicalrel", (Object)rel.getString("relcomparator"));
            treeEntry.add((Object)dyc);
        });
    }

    @Override
    public DynamicObject[] getEnableConfigItemByNumbers(Set<String> numberSet) {
        QFilter numberFilter = new QFilter("number", "in", numberSet);
        Object[] resultArr = configItemEntityService.query("number", numberFilter.and(new QFilter("enable", "=", (Object)"1")).toArray());
        if (ObjectUtils.isEmpty((Object[])resultArr)) {
            return new DynamicObject[0];
        }
        return resultArr;
    }

    @Override
    public Set<String> getConfigItemNumber() {
        DynamicObject[] result = configItemEntityService.query("number", new QFilter("enable", "=", (Object)"1").toArray());
        return Arrays.stream(result).map(dyc -> dyc.getString("number")).collect(Collectors.toSet());
    }

    @Override
    public DynamicObject[] getConfigItemInfoByConfigItemNumbers(Set<String> configItemNumberSet) {
        Object[] result = configItemEntityService.query("id,confignumber", new QFilter("confignumber", "in", configItemNumberSet).toArray());
        if (ObjectUtils.isEmpty((Object[])result)) {
            return new DynamicObject[0];
        }
        return result;
    }

    @Override
    public void batchSaveConfigItem(DynamicObject dataEntity) {
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        DynamicObject groupDyn = dataEntity.getDynamicObject("group");
        String relEntityInfo = dataEntity.getString("relentityinfo");
        ArrayList<DynamicObject> confItemList = new ArrayList<DynamicObject>(entryEntity.size());
        HashMap relEntityConfMap = Maps.newHashMap();
        LinkedList idQueue = new LinkedList();
        long[] ids = ID.genLongIds((int)(entryEntity.size() * 2));
        Arrays.stream(ids).forEach(id -> idQueue.offer(id));
        long currUserId = RequestContext.get().getCurrUserId();
        int maxOrderNum = this.queryMaxConfigItemOrderField(dataEntity);
        for (DynamicObject dyn : entryEntity) {
            Map resultTreeMap;
            List relEntityList;
            DynamicObject newDyn = configItemEntityService.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dyn, (DynamicObject)newDyn);
            newDyn.set("id", idQueue.poll());
            newDyn.set("group", (Object)groupDyn);
            newDyn.set("enable", (Object)"1");
            DynamicObject bizEntity = dyn.getDynamicObject("bizentity");
            String entityNumber = bizEntity.getString("number");
            newDyn.set("number", (Object)entityNumber);
            newDyn.set("confignumber", (Object)dyn.getString("confignumber"));
            newDyn.set("name", (Object)bizEntity.getLocaleString("name"));
            newDyn.set("status", (Object)"C");
            newDyn.set("orderfield", (Object)(groupDyn.getString("orderfield") + "." + this.getNewOrderNum(maxOrderNum)));
            ++maxOrderNum;
            newDyn.set("creator", (Object)currUserId);
            confItemList.add(newDyn);
            if (HRStringUtils.isEmpty((String)relEntityInfo) || CollectionUtils.isEmpty((Collection)(relEntityList = (List)(resultTreeMap = (Map)SerializationUtils.deSerializeFromBase64((String)relEntityInfo)).get(entityNumber)))) continue;
            this.structRelEntitySaveEntityMap(relEntityConfMap, dyn, newDyn, relEntityList);
        }
        configItemEntityService.save(confItemList.toArray(new DynamicObject[0]));
        relEntityConfService.save(relEntityConfMap.values().toArray(new DynamicObject[0]));
    }

    @Override
    public int queryMaxConfigItemOrderField(DynamicObject dynamicObject) {
        Object confItemDyn;
        String curOrderField;
        DynamicObject groupDyn = dynamicObject.getDynamicObject("group");
        QFilter groupIdFilter = new QFilter("group", "=", (Object)Long.parseLong(groupDyn.getString("masterid")));
        Object[] configItemArray = configItemEntityService.query(SELECT_CONFIG_ITEM_FIELD, new QFilter[]{groupIdFilter}, "orderfield desc");
        if (!ObjectUtils.isEmpty((Object[])configItemArray) && HRStringUtils.isNotEmpty((String)(curOrderField = (confItemDyn = configItemArray[0]).getString("orderfield")))) {
            String[] orderFieldArr = curOrderField.split("\\.");
            int maxOrderNum = 1;
            if (orderFieldArr.length > 1) {
                String lastOrderNumStr = orderFieldArr[orderFieldArr.length - 1];
                maxOrderNum = Integer.parseInt(lastOrderNumStr) + maxOrderNum;
                return maxOrderNum;
            }
        }
        return 1;
    }

    private String getNewOrderNum(int maxOrderNum) {
        return maxOrderNum >= 10 ? "0" + maxOrderNum : "00" + maxOrderNum;
    }

    @Override
    public String queryNewConfigItemOrderField(DynamicObject dynamicObject) {
        Object confItemDyn;
        String curOrderField;
        DynamicObject group;
        DynamicObject groupDyn = dynamicObject.getDynamicObject("group");
        QFilter groupIdFilter = new QFilter("group", "=", (Object)Long.parseLong(groupDyn.getString("masterid")));
        Object[] configItemArray = configItemEntityService.query(SELECT_CONFIG_ITEM_FIELD, new QFilter[]{groupIdFilter}, "orderfield desc");
        QFilter numberFilter = new QFilter("number", "=", (Object)dynamicObject.getString("number"));
        DynamicObject configItem = configItemEntityService.queryOne(SELECT_CONFIG_ITEM_FIELD, new QFilter[]{numberFilter});
        if (configItem != null && (group = (DynamicObject)configItem.get("group")).getLong("id") == groupDyn.getLong("id")) {
            return configItem.getString("orderfield");
        }
        if (!ObjectUtils.isEmpty((Object[])configItemArray) && HRStringUtils.isNotEmpty((String)(curOrderField = (confItemDyn = configItemArray[0]).getString("orderfield")))) {
            String[] orderFieldArr = curOrderField.split("\\.");
            int maxOrderNum = 1;
            if (orderFieldArr.length > 1) {
                String lastOrderNumStr = orderFieldArr[orderFieldArr.length - 1];
                maxOrderNum = Integer.parseInt(lastOrderNumStr) + maxOrderNum;
                return groupDyn.getString("orderfield") + "." + this.getNewOrderNum(maxOrderNum);
            }
        }
        return groupDyn.getString("orderfield") + "." + this.getNewOrderNum(1);
    }

    @Override
    public void saveConfigItem(DynamicObject dataEntity) {
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObjectCollection relEntityDys = dataEntity.getDynamicObjectCollection("treeentryentity");
        Map<Long, DynamicObject> relEntityConfMap = relEntityDys.stream().collect(Collectors.toMap(rel -> rel.getLong("id"), rel -> rel));
        ArrayList relEntitySaveList = Lists.newArrayListWithCapacity((int)relEntityDys.size());
        relEntityDys.stream().forEach(rel -> {
            DynamicObject relEntity = relEntityConfService.generateEmptyDynamicObject();
            Long id = rel.getLong("id");
            relEntity.set("id", (Object)id);
            Long pid = rel.getLong("pid");
            if (pid == 0L) {
                relEntity.set("parent", null);
                relEntity.set("longnumber", (Object)ID.toStringId((long)id));
            } else {
                DynamicObject parent = (DynamicObject)relEntityConfMap.get(pid);
                relEntity.set("parent", (Object)parent.getLong("id"));
                relEntity.set("longnumber", (Object)(this.structLongNumber(relEntityConfMap, parent) + "!" + ID.toStringId((long)id)));
            }
            relEntity.set("keyfields", (Object)dataEntity.getString("keyfields"));
            relEntity.set("sourceentity", (Object)rel.getDynamicObject("sourceentity"));
            relEntity.set("sourcefieldnumber", (Object)rel.getString("sourcerelfield"));
            relEntity.set("relcomparator", (Object)rel.getString("logicalrel"));
            relEntity.set("relentity", (Object)rel.getDynamicObject("targetentity"));
            relEntity.set("relfieldnumber", (Object)rel.getString("targetrelfield"));
            relEntity.set("configitem", (Object)dataEntity);
            relEntity.set("configitemnumber", (Object)dataEntity.getString("number"));
            relEntity.set("creator", (Object)currUserId);
            relEntity.set(ORDER, (Object)relEntityDys.indexOf(rel));
            relEntitySaveList.add(relEntity);
        });
        dataEntity.getDynamicObjectCollection("treeentryentity").clear();
        relEntityConfService.deleteByFilter(new QFilter("configitem", "=", (Object)dataEntity.getLong("id")).toArray());
        relEntityConfService.save(relEntitySaveList.toArray(new DynamicObject[0]));
    }

    @Override
    public void saveConfigItemNotOp(DynamicObject dataEntity) {
        this.delDbExistData(dataEntity);
        CommonServiceImpl commonService = new CommonServiceImpl("hrdt_configitems");
        DynamicObject toConfItemDyn = commonService.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)dataEntity, (DynamicObject)toConfItemDyn);
        toConfItemDyn.set("id", (Object)dataEntity.getLong("id"));
        configItemEntityService.save(toConfItemDyn);
    }

    private void delDbExistData(DynamicObject dataEntity) {
        String confNumber = dataEntity.getString("confignumber");
        Object[] dbDataDycArr = configItemEntityService.query("id,confignumber", new QFilter("confignumber", "=", (Object)confNumber).toArray());
        if (ObjectUtils.isEmpty((Object[])dbDataDycArr)) {
            return;
        }
        Map<Long, String> dbDataDycMap = Arrays.stream(dbDataDycArr).collect(Collectors.toMap(dyc -> dyc.getLong("id"), dyc -> dyc.getString("confignumber"), (k1, k2) -> k1));
        relEntityConfService.deleteByFilter(new QFilter("configitem", "in", dbDataDycMap.keySet()).toArray());
        configItemEntityService.deleteByFilter(new QFilter("confignumber", "in", dbDataDycMap.values()).toArray());
    }

    private String structLongNumber(Map<Long, DynamicObject> relEntityConfMap, DynamicObject parent) {
        long parentId = parent.getLong("id");
        Long pid = parent.getLong("pid");
        if (pid == 0L) {
            return ID.toStringId((long)parentId);
        }
        return this.structLongNumber(relEntityConfMap, relEntityConfMap.get(pid)) + "!" + ID.toStringId((long)parentId);
    }

    private void structRelEntitySaveEntityMap(Map<Long, DynamicObject> relEntityConfMap, DynamicObject dyn, DynamicObject newDyn, List<Map<String, Object>> relEntityList) {
        long currUserId = RequestContext.get().getCurrUserId();
        relEntityList.forEach(rel -> {
            DynamicObject relEntity = relEntityConfService.generateEmptyDynamicObject();
            Long id = (Long)rel.get("id");
            relEntity.set("id", (Object)id);
            Long pid = (Long)rel.get("pid");
            if (pid.equals(0L)) {
                relEntity.set("parent", null);
                relEntity.set("longnumber", (Object)ID.toStringId((long)id));
            } else {
                relEntity.set("parent", relEntityConfMap.get(pid));
                relEntity.set("longnumber", (Object)(((DynamicObject)relEntityConfMap.get(pid)).getString("longnumber") + "!" + ID.toStringId((long)id)));
            }
            relEntity.set("keyfields", (Object)dyn.getString("keyfields"));
            relEntity.set("sourceentity", rel.get("sourceentity"));
            relEntity.set("sourcefieldnumber", rel.get("sourcerelfield"));
            relEntity.set("relcomparator", rel.get("logicalrel"));
            relEntity.set("relentity", rel.get("targetentity"));
            relEntity.set("relfieldnumber", rel.get("targetrelfield"));
            relEntity.set("configitem", (Object)newDyn);
            relEntity.set("configitemnumber", (Object)newDyn.getString("number"));
            relEntity.set("creator", (Object)currUserId);
            relEntity.set(ORDER, (Object)relEntityList.indexOf(rel));
            relEntityConfMap.put(relEntity.getLong("id"), relEntity);
        });
    }

    @Override
    public boolean isHisModEntity(String entityNumber) {
        LOG.info("ConfigItemDomainServiceImpl config item entity number is {}", (Object)entityNumber);
        String inhRelation = HisCommonService.getInstance().entityInhRelation(entityNumber);
        return EnumEntityTpl.NONLINETIMESEQ_TPL.getNumber().equals(inhRelation) || EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(inhRelation);
    }

    @Override
    public DynamicObjectCollection handleRelConfigItem(String entityNumber, DynamicObject dyc, int fieldType) {
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        ArrayList entryNumberList = Lists.newArrayList();
        properties.stream().filter(pro -> pro instanceof BasedataProp).filter(pro -> HRStringUtils.isNotEmpty((String)pro.getAlias())).forEach(pro -> entryNumberList.add(((BasedataProp)pro).getBaseEntityId()));
        DynamicObjectCollection relConfigItemList = fieldType == 0 ? ((DynamicObject)dyc.getDynamicObjectCollection("entryentity").get(0)).getDynamicObjectCollection("relconfigitem") : dyc.getDynamicObjectCollection("relconfigitem");
        MulBasedataDynamicObjectCollection dys = new MulBasedataDynamicObjectCollection();
        Map<String, DynamicObject> entryMap = this.bosEntityObjectEntityService.queryOneByNumberList(entryNumberList);
        if (CollectionUtils.isEmpty(entryMap)) {
            return null;
        }
        entryMap.values().forEach(val -> {
            DynamicObject item = relConfigItemList.addNew();
            item.set("fbasedataid", val);
            dys.add(item);
        });
        return dys;
    }

    @Override
    public ConfigItemBo getEntityInfo(String entityNumber) {
        QFilter filter = new QFilter("number", "=", (Object)entityNumber);
        boolean existsHrConf = configItemEntityService.isExists(filter);
        MainEntityType dataEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
        ConfigItemBo configItemBo = new ConfigItemBo(dataEntityType);
        configItemBo.setHisMod(this.isHisModEntity(entityNumber));
        configItemBo.setControlMod(this.isCtrEntity(entityNumber));
        configItemBo.setHrConfItem(existsHrConf);
        if (!existsHrConf) {
            configItemBo.setSysConfItem(sysConfigItemEntityService.isExists(filter));
        }
        return configItemBo;
    }

    @Override
    public Map<String, String> getEntityIsConfItem(Set<String> entityNumSet) {
        HashMap<String, String> retMap = new HashMap<String, String>(16);
        if (ObjectUtils.isEmpty(entityNumSet)) {
            return retMap;
        }
        entityNumSet.forEach(number -> retMap.computeIfAbsent((String)number, key -> TransferConfEnum.COMMON_ENTITY.getNumber()));
        QFilter numberFilter = new QFilter("number", "in", entityNumSet);
        List hrConfList = configItemEntityService.queryOriginalList("number", new QFilter[]{numberFilter});
        if (!ObjectUtils.isEmpty((Object)hrConfList) && hrConfList.size() == entityNumSet.size()) {
            hrConfList.forEach(dyn -> retMap.put(dyn.getString("number"), TransferConfEnum.HR_CONFIG_ITEM_ENTITY.getNumber()));
            return retMap;
        }
        List sysConfList = sysConfigItemEntityService.queryOriginalList("page.number", new QFilter[]{numberFilter});
        HashSet sysConfKeySet = new HashSet(16);
        if (ObjectUtils.isEmpty((Object)sysConfList)) {
            return retMap;
        }
        sysConfList.forEach(dyn -> sysConfKeySet.add(dyn.getString("number")));
        hrConfList.forEach(dyn -> {
            String number = dyn.getString("number");
            sysConfKeySet.remove(number);
            retMap.put(dyn.getString("number"), "1");
        });
        sysConfKeySet.forEach(num -> retMap.put((String)num, TransferConfEnum.SYS_CONFIG_ITEM_ENTITY.getNumber()));
        return retMap;
    }

    @Override
    public List<Map<String, Object>> getConfItemData(TransferDataBo transferDataBo, List<Map<String, Object>> entityConfItemDataList, List<Map<String, Map<String, Object>>> sysConfItemDataList, Set<String> confItemItselfNumSet) {
        List<Map<String, Object>> relEntityData;
        if (entityConfItemDataList == null || sysConfItemDataList == null) {
            return new ArrayList<Map<String, Object>>(0);
        }
        this.sysConfItemDataList = sysConfItemDataList;
        String entityConfItemNumber = transferDataBo.getEntityNumber();
        confItemItselfNumSet.add(entityConfItemNumber);
        this.confItemItselfNumSet = confItemItselfNumSet;
        MainEntityType dataEntityType = MetadataUtils.getMainEntityType((String)entityConfItemNumber);
        List<DynamicObject> currentItemDynList = this.getEnableConfItemInfoByEntityNumbers("number,needallhis", (Set<String>)ImmutableSet.of((Object)entityConfItemNumber), "hrdt_configitems", "number");
        if (CollectionUtils.isEmpty(currentItemDynList)) {
            return new ArrayList<Map<String, Object>>(0);
        }
        DynamicObject currentConfig = currentItemDynList.get(0);
        boolean needAllHis = currentConfig.getBoolean("needallhis");
        transferDataBo.setNeedAllHis(needAllHis);
        Map<String, Object> entityRetDataMap = new HashMap<String, Object>(16);
        this.initParamTransferDataBo(transferDataBo, dataEntityType, transferDataBo.getFieldKey(), transferDataBo.getCp(), transferDataBo.getFieldValueList(), transferDataBo.getParentEntity());
        this.initEntityRetDataMap(transferDataBo, entityRetDataMap);
        ArrayList relSubDataMapList = new ArrayList(10);
        entityRetDataMap.put("relSubData", relSubDataMapList);
        entityRetDataMap = this.getEntityData(transferDataBo, entityRetDataMap);
        if (ObjectUtils.isEmpty(entityRetDataMap)) {
            return entityConfItemDataList;
        }
        entityConfItemDataList.add(entityRetDataMap);
        Object[] relEntityDynArr = this.getRelEntityDyn(entityConfItemNumber);
        HashMap<String, Map<String, Object>> allSourceEntityDataMap = new HashMap<String, Map<String, Object>>(16);
        allSourceEntityDataMap.put(entityConfItemNumber, entityRetDataMap);
        if (!ObjectUtils.isEmpty((Object[])relEntityDynArr) && !ObjectUtils.isEmpty(relEntityData = this.getRelEntityData(transferDataBo, (DynamicObject[])relEntityDynArr, allSourceEntityDataMap))) {
            entityRetDataMap.put("relSubData", relEntityData);
        }
        HashSet<String> allRelBaseDataEntityNumSet = new HashSet<String>(16);
        Map<String, String> baseEntityFieldMap = this.getRelBaseDataEntityNum(entityConfItemNumber);
        LOG.info("ConfigItemDomainServiceImpl.getConfItemData,baseEntityFieldMap={}", (Object)SerializationUtils.toJsonString(baseEntityFieldMap));
        allRelBaseDataEntityNumSet.addAll(baseEntityFieldMap.values());
        this.confItemEntityNumSet.add(entityConfItemNumber);
        List<DynamicObject> confItemDynList = this.getEnableConfItemInfoByEntityNumbers("number,needallhis", allRelBaseDataEntityNumSet, "hrdt_configitems", "number");
        HashSet<String> relHrConfItemNumberSet = new HashSet(16);
        if (!ObjectUtils.isEmpty(confItemDynList)) {
            relHrConfItemNumberSet = confItemDynList.stream().map(dyn -> dyn.getString("number")).collect(Collectors.toSet());
            LOG.info("ConfigItemDomainServiceImpl.getConfItemData,relHrConfItemNumberSet={},confItemEntityNumSet={}", relHrConfItemNumberSet, this.confItemEntityNumSet);
            this.handleConfItemRelBaseData(entityConfItemDataList, entityConfItemNumber, entityRetDataMap, baseEntityFieldMap, relHrConfItemNumberSet);
            if (relHrConfItemNumberSet.size() == allRelBaseDataEntityNumSet.size()) {
                return entityConfItemDataList;
            }
        }
        allRelBaseDataEntityNumSet.removeAll(relHrConfItemNumberSet);
        LOG.info("ConfigItemDomainServiceImpl.getConfItemData,allRelBaseDataEntityNumSet={}", (Object)SerializationUtils.toJsonString(allRelBaseDataEntityNumSet));
        this.handleSysConfItemData(sysConfItemDataList, entityConfItemNumber, entityRetDataMap, allRelBaseDataEntityNumSet, baseEntityFieldMap);
        return entityConfItemDataList;
    }

    public DynamicObject[] getRelEntityDyn(String entityConfItemNumber) {
        CommonServiceImpl relEntityConfHelper = new CommonServiceImpl("hrdt_relentityconf");
        DynamicObject[] relEntityDynArr = relEntityConfHelper.query("relentity,relcomparator,relfieldnumber,sourceentity,sourcefieldnumber,configitem", new QFilter[]{new QFilter("configitemnumber", "=", (Object)entityConfItemNumber)}, " longnumber asc");
        return relEntityDynArr;
    }

    @Override
    public List<DynamicObject> getEnableConfItemInfoByEntityNumbers(String selectFields, Set<String> filterValSet, String entityNumber, String filterProperty) {
        CommonServiceImpl configItemService = new CommonServiceImpl(entityNumber);
        return configItemService.queryOriginalList(selectFields, new QFilter[]{new QFilter(filterProperty, "in", filterValSet), ENABLE_FILTER});
    }

    @Override
    public List<DynamicObject> getAllConfItemInfoByEntityNumbers(String selectFields, Set<String> filterValSet, String entityNumber, String filterProperty) {
        return new CommonServiceImpl(entityNumber).queryOriginalList(selectFields, new QFilter(filterProperty, "in", filterValSet).toArray());
    }

    @Override
    public Map<String, Set<Long>> getAllConfItemIdList(Set<String> confItemEntityNumberSet) {
        List<DynamicObject> sysConfItemDynList;
        HashMap<String, Set<Long>> retMap = new HashMap<String, Set<Long>>(16);
        if (ObjectUtils.isEmpty(confItemEntityNumberSet)) {
            return retMap;
        }
        HashMap relBaseToConfItemEntitySetMap = new HashMap(16);
        HashSet<String> allBaseEntityNumberSet = new HashSet<String>(16);
        for (String confItemEntity : confItemEntityNumberSet) {
            Map<String, String> entityAllRefF7ProMap = this.getEntityAllRefF7ProMap(confItemEntity);
            for (String relBaseEntity : entityAllRefF7ProMap.values()) {
                relBaseToConfItemEntitySetMap.putIfAbsent(relBaseEntity, new HashSet(16));
                Set confItemEntitySet = (Set)relBaseToConfItemEntitySetMap.get(relBaseEntity);
                confItemEntitySet.add(confItemEntity);
            }
            allBaseEntityNumberSet.addAll(entityAllRefF7ProMap.values());
            retMap.putIfAbsent(confItemEntity, new HashSet(16));
        }
        List<DynamicObject> hrConfItemDynList = this.getEnableConfItemInfoByEntityNumbers("id,number", allBaseEntityNumberSet, "hrdt_configitems", "number");
        HashSet<String> sysEntityNumSet = new HashSet<String>(allBaseEntityNumberSet);
        if (!ObjectUtils.isEmpty(hrConfItemDynList)) {
            for (DynamicObject hrConfItemDyn : hrConfItemDynList) {
                String hrConfItemEntityNum = hrConfItemDyn.getString("number");
                sysEntityNumSet.remove(hrConfItemEntityNum);
                Set confItemRelBaseNumberSet = (Set)relBaseToConfItemEntitySetMap.get(hrConfItemEntityNum);
                if (ObjectUtils.isEmpty((Object)confItemRelBaseNumberSet)) continue;
                for (String confItemEntity : confItemRelBaseNumberSet) {
                    Set confItemIdSet = (Set)retMap.get(confItemEntity);
                    confItemIdSet.add(hrConfItemDyn.getLong("id"));
                }
            }
        } else if (!ObjectUtils.isEmpty(hrConfItemDynList) && hrConfItemDynList.size() == confItemEntityNumberSet.size()) {
            return retMap;
        }
        if (ObjectUtils.isEmpty(sysConfItemDynList = this.getEnableConfItemInfoByEntityNumbers("id,page.number", sysEntityNumSet, "ricc_configitems", "page.number"))) {
            return retMap;
        }
        for (DynamicObject sysConfItemDyn : sysConfItemDynList) {
            String sysConfItemEntityNum = sysConfItemDyn.getString("page.number");
            Set sysConfItemEntityNumberSet = (Set)relBaseToConfItemEntitySetMap.get(sysConfItemEntityNum);
            if (ObjectUtils.isEmpty((Object)sysConfItemEntityNumberSet)) continue;
            for (String confItemEntity : sysConfItemEntityNumberSet) {
                Set confItemIdSet = (Set)retMap.get(confItemEntity);
                confItemIdSet.add(sysConfItemDyn.getLong("id"));
            }
        }
        return retMap;
    }

    private void handleSysConfItemData(List<Map<String, Map<String, Object>>> sysConfItemDataList, String entityNumber, Map<String, Object> dataMap, Set<String> allRelBaseDataEntityNumSet, Map<String, String> baseEntityFieldMap) {
        List<DynamicObject> sysConfItemDynList = this.getEnableConfItemInfoByEntityNumbers("page.number", allRelBaseDataEntityNumSet, "ricc_configitems", "page.number");
        Set<String> relSysConfItemNumberSet = sysConfItemDynList.stream().map(dyn -> dyn.getString("page.number")).collect(Collectors.toSet());
        LOG.info("ConfigItemDomainServiceImpl.handleSysConfItemData,relSysConfItemNumberSet={}", (Object)SerializationUtils.toJsonString(relSysConfItemNumberSet));
        Map<String, List<Object>> fieldValueMap = this.getFieldFilterValueListMap(dataMap, baseEntityFieldMap, relSysConfItemNumberSet);
        LOG.info("ConfigItemDomainServiceImpl.handleSysConfItemData,fieldValueMap={}", (Object)SerializationUtils.toJsonString(fieldValueMap));
        HashMap sysRelBaseEntityMap = new HashMap(16);
        Set<String> relBaseEntityBlackListSet = this.getRelBaseEntityBlackList();
        for (Map.Entry<String, List<Object>> entry : fieldValueMap.entrySet()) {
            String fieldKey = entry.getKey();
            String sysBaseDataEntityNum = baseEntityFieldMap.get(fieldKey);
            if (!HRStringUtils.isNotEmpty((String)sysBaseDataEntityNum) || relBaseEntityBlackListSet.contains(sysBaseDataEntityNum)) continue;
            sysRelBaseEntityMap.putIfAbsent(sysBaseDataEntityNum, new HashMap(16));
            Map sysBaseDataMap = (Map)sysRelBaseEntityMap.get(sysBaseDataEntityNum);
            ArrayList idList = (ArrayList)sysBaseDataMap.get("id");
            if (idList == null) {
                idList = new ArrayList(10);
            }
            HashMap<String, Object> fieldFilterMap = new HashMap<String, Object>(16);
            idList.addAll(entry.getValue());
            HashSet idSet = new HashSet(idList);
            fieldFilterMap.put("id", new ArrayList(idSet));
            fieldFilterMap.put("parentEntity", entityNumber);
            sysRelBaseEntityMap.put(sysBaseDataEntityNum, fieldFilterMap);
        }
        if (ObjectUtils.isEmpty(sysRelBaseEntityMap)) {
            return;
        }
        sysConfItemDataList.add(sysRelBaseEntityMap);
    }

    private void handleConfItemRelBaseData(List<Map<String, Object>> retDataList, String entityNumber, Map<String, Object> dataMap, Map<String, String> baseEntityFieldMap, Set<String> relHrConfItemNumberSet) {
        Map<String, List<Object>> fieldValueMap = this.getFieldFilterValueListMap(dataMap, baseEntityFieldMap, relHrConfItemNumberSet);
        Set<String> relBaseEntityBlackSet = this.getRelBaseEntityBlackList();
        for (Map.Entry<String, List<Object>> entry : fieldValueMap.entrySet()) {
            String fieldKey = entry.getKey();
            List<Object> fieldValues = entry.getValue();
            String baseDataEntityNum = baseEntityFieldMap.get(fieldKey);
            if (this.confItemEntityNumSet.contains(baseDataEntityNum)) {
                LOG.info("handleConfItemRelBaseData,baseDataEntityNum={}", (Object)baseDataEntityNum);
                continue;
            }
            if (relBaseEntityBlackSet.contains(baseDataEntityNum)) {
                LOG.info("handleConfItemRelBaseData,baseDataEntityNum={},relBaseEntityBlackSet={}", (Object)baseDataEntityNum, relBaseEntityBlackSet);
                continue;
            }
            LOG.info("handleConfItemRelBaseData,baseDataEntityNum={},fieldValues={}", (Object)baseDataEntityNum, fieldValues);
            MainEntityType baseDataEntityType = MetadataUtils.getMainEntityType((String)baseDataEntityNum);
            TransferDataBo relTransferDataBo = new TransferDataBo(baseDataEntityNum);
            this.initParamTransferDataBo(relTransferDataBo, baseDataEntityType, "id", "in", fieldValues, entityNumber);
            this.getConfItemData(relTransferDataBo, retDataList, this.sysConfItemDataList, this.confItemItselfNumSet);
        }
    }

    private Map<String, List<Object>> getFieldFilterValueListMap(Map<String, Object> dataMap, Map<String, String> baseEntityFieldMap, Set<String> relConfItemNumberSet) {
        HashMap<String, List<Object>> fieldValueMap = new HashMap<String, List<Object>>(16);
        List dataList = (List)dataMap.get("data");
        if (ObjectUtils.isEmpty((Object)dataList)) {
            return fieldValueMap;
        }
        for (Map.Entry<String, String> entry : baseEntityFieldMap.entrySet()) {
            String entityNum = entry.getValue();
            String fieldKey = entry.getKey();
            if (!relConfItemNumberSet.contains(entityNum)) continue;
            List fieldValues = dataList.stream().map(map -> map.get((String)entry.getKey() + "_id")).collect(Collectors.toList());
            fieldValueMap.put(fieldKey, fieldValues);
        }
        return fieldValueMap;
    }

    private void initParamTransferDataBo(TransferDataBo transferDataBo, MainEntityType dataEntityType, String fieldKey, String cp, List<Object> fieldValueList, String parentEntity) {
        ArrayList<Object> newFieldValueList = new ArrayList<Object>(16);
        dataEntityType.getProperties().forEach(pro -> {
            if (fieldKey.equals(pro.getName()) && pro instanceof LongProp) {
                fieldValueList.forEach(obj -> newFieldValueList.add(Long.parseLong(obj.toString())));
            }
        });
        transferDataBo.setHisMod(this.isHisModEntity(transferDataBo.getEntityNumber()));
        transferDataBo.setControlMod(this.isCtrEntity(transferDataBo.getEntityNumber()));
        transferDataBo.setFieldValueList(ObjectUtils.isEmpty(newFieldValueList) ? fieldValueList : newFieldValueList);
        transferDataBo.setFieldKey(fieldKey);
        transferDataBo.setCp(cp);
        transferDataBo.setParentEntity(parentEntity);
        transferDataBo.setDataEntityType(dataEntityType);
    }

    public Map<String, String> getRelBaseDataEntityNum(String entityNumber) {
        HashMap<String, String> baseEntityFieldMap = new HashMap<String, String>(16);
        MainEntityType dataEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
        DataEntityPropertyCollection dePros = dataEntityType.getProperties();
        for (IDataEntityProperty pro : dePros) {
            if (!HRStringUtils.isNotEmpty((String)pro.getAlias()) || !(pro instanceof BasedataProp)) continue;
            BasedataProp basedataProp = (BasedataProp)pro;
            String baseEntityId = basedataProp.getBaseEntityId();
            baseEntityFieldMap.put(basedataProp.getName(), baseEntityId);
        }
        return baseEntityFieldMap;
    }

    @Override
    public Map<String, Object> getEntityData(TransferDataBo transferDataBo, Map<String, Object> dataMap) {
        String entityNumber = transferDataBo.getEntityNumber();
        QFilter filter = this.getTransferEntityDataFilter(transferDataBo);
        LOG.info("ConfigItemDomainServiceImpl.getEntityData,entityNumber={},filter={}", (Object)entityNumber, (Object)filter);
        CommonServiceImpl entityService = new CommonServiceImpl(entityNumber);
        Object[] entityDataArr = entityService.loadDynamicObjectArray(new QFilter[]{filter});
        if (ObjectUtils.isEmpty((Object[])entityDataArr)) {
            dataMap.clear();
            return dataMap;
        }
        Map<Object, Object> sourceRelFieldIdMap = transferDataBo.getSourceRelFieldIdMap();
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(10);
        HashSet<Long> hisIdSet = new HashSet<Long>(16);
        boolean isHisMod = transferDataBo.isHisMod();
        boolean isCurConfItemEntity = HRStringUtils.isEmpty((String)transferDataBo.getParentEntity());
        String fieldKey = transferDataBo.getFieldKey();
        boolean isF7Field = this.isF7Field((IDataEntityType)transferDataBo.getDataEntityType(), fieldKey);
        if (!isCurConfItemEntity) {
            Map<Object, List<DynamicObject>> proFieldGroupDynListMap = Arrays.stream(entityDataArr).collect(Collectors.groupingBy(dyn -> isF7Field ? dyn.get(transferDataBo.getFieldKey() + ".id") : (transferDataBo.isHisMod() ? dyn.get("boid") : dyn.get(transferDataBo.getFieldKey()))));
            for (Map.Entry entry : proFieldGroupDynListMap.entrySet()) {
                Object fieldProVal = entry.getKey();
                if (entry == null) {
                    LOG.info("getEntityData,objEntry is null,fieldProVal={}", fieldProVal);
                    continue;
                }
                ((List)entry.getValue()).stream().forEach(dyn -> {
                    Map<String, Object> curEntityDataMap = ConfItemDyObjectUtils.convertDynamicObjectToMap(dyn);
                    Object parentId = sourceRelFieldIdMap.get(fieldProVal);
                    Map<Object, Map<String, Object>> parentEntityDataMap = transferDataBo.getParentEntityDataMap();
                    Map<String, Object> parentDataMap = parentEntityDataMap.get(parentId);
                    String structLongId = ObjectUtils.isEmpty(parentDataMap) ? curEntityDataMap.get("id") + "" : parentDataMap.get("structLongId") + "!" + curEntityDataMap.get("id");
                    curEntityDataMap.put("parentId", parentId);
                    curEntityDataMap.put("structLongId", structLongId);
                    dataList.add(curEntityDataMap);
                    if (isHisMod) {
                        hisIdSet.add(dyn.getLong("id"));
                    }
                });
            }
        } else {
            for (Object entityDyn : entityDataArr) {
                Map<String, Object> curEntityDataMap = ConfItemDyObjectUtils.convertDynamicObjectToMap((DynamicObject)entityDyn);
                curEntityDataMap.put("parentId", 0L);
                curEntityDataMap.put("structLongId", curEntityDataMap.get("id"));
                dataList.add(curEntityDataMap);
                if (!isHisMod) continue;
                hisIdSet.add(entityDyn.getLong("id"));
            }
        }
        dataMap.put("data", dataList);
        if (isHisMod) {
            dataMap.put("hisModRelData", this.queryHisRelData(entityNumber, hisIdSet));
        }
        if (transferDataBo.isControlMod()) {
            List<Long> curEntityDataIdList = dataList.stream().map(map -> Long.parseLong(map.get("id").toString())).collect(Collectors.toList());
            transferDataBo.setCurEntityDataIdList(curEntityDataIdList);
            dataMap.put("controlModData", this.getControlModData(transferDataBo));
        }
        return dataMap;
    }

    private void initEntityRetDataMap(TransferDataBo transferDataBo, Map<String, Object> entityRetDataMap) {
        MainEntityType dataEntityType = transferDataBo.getDataEntityType();
        entityRetDataMap.computeIfAbsent("entityNumber", key -> transferDataBo.getEntityNumber());
        entityRetDataMap.computeIfAbsent("appId", key -> dataEntityType.getAppId());
        entityRetDataMap.computeIfAbsent("dbRouteKey", key -> dataEntityType.getDBRouteKey());
        entityRetDataMap.computeIfAbsent("isHisMod", key -> transferDataBo.isHisMod());
        entityRetDataMap.computeIfAbsent("isControlMod", key -> transferDataBo.isControlMod());
        entityRetDataMap.computeIfAbsent("parentEntity", key -> transferDataBo.getParentEntity());
        entityRetDataMap.computeIfAbsent("data", key -> new ArrayList(10));
        entityRetDataMap.computeIfAbsent("hisModRelData", key -> new ArrayList(10));
        entityRetDataMap.computeIfAbsent("controlModData", key -> new HashMap(16));
        entityRetDataMap.putIfAbsent("parentEntity", "");
    }

    @Override
    public DynamicObject getBosEntityObjectByNumber(String entityNubmer) {
        if (HRStringUtils.isEmpty((String)entityNubmer)) {
            return null;
        }
        return this.bosEntityObjectEntityService.queryOneByNumber(entityNubmer);
    }

    @Override
    public ILocaleString getWriteBackRelEntity(List<Map<String, Object>> resultTreeList) {
        StringBuilder sb = new StringBuilder();
        resultTreeList.forEach(entry -> {
            DynamicObject sourceEntity = (DynamicObject)entry.get("sourceentity");
            DynamicObject targetEntity = (DynamicObject)entry.get("targetentity");
            if (targetEntity == null) {
                return;
            }
            sb.append(sourceEntity.getLocaleString("name").getLocaleValue()).append(".").append(this.handleShowName(sourceEntity, entry.get("sourcerelfield").toString())).append(entry.get("logicalrel")).append(targetEntity.getLocaleString("name").getLocaleValue()).append(".").append(this.handleShowName(targetEntity, entry.get("targetrelfield").toString())).append("\n");
        });
        return new LocaleString(sb.toString());
    }

    private String handleShowName(DynamicObject entity, String relFieldName) {
        DataEntityPropertyCollection properties = MetadataUtils.getMainEntityType((String)entity.getString("number")).getProperties();
        if (!relFieldName.contains(".")) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)relFieldName);
            if (property == null) {
                return "";
            }
            return property.getName();
        }
        List fieldNameList = Splitter.on((String)".").splitToList((CharSequence)relFieldName);
        IDataEntityProperty pro = (IDataEntityProperty)properties.get(fieldNameList.get(0));
        StringBuilder sb = new StringBuilder(pro.getName());
        DataEntityPropertyCollection entryProperties = ((EntryProp)pro).getDynamicCollectionItemPropertyType().getProperties();
        IDataEntityProperty firstPro = (IDataEntityProperty)entryProperties.get(fieldNameList.get(1));
        if (firstPro instanceof EntryProp) {
            entryProperties = ((EntryProp)firstPro).getDynamicCollectionItemPropertyType().getProperties();
            IDataEntityProperty sencondPro = (IDataEntityProperty)entryProperties.get(fieldNameList.get(2));
            return sb.append(".").append(firstPro.getName()).append(".").append(sencondPro.getName()).toString();
        }
        return sb.append(".").append(firstPro.getName()).toString();
    }

    @Override
    public List<Map<String, Object>> assembleReturnInfo(DynamicObjectCollection treeList) {
        ArrayList resultTreeList = Lists.newArrayListWithExpectedSize((int)treeList.size());
        treeList.forEach(node -> {
            TreeMap resultTreeMap = Maps.newTreeMap();
            resultTreeMap.put("id", node.getLong("id"));
            resultTreeMap.put("seq", node.getInt("seq"));
            resultTreeMap.put("pid", node.getLong("pid"));
            resultTreeMap.put("isGroupNode", node.getBoolean("isGroupNode"));
            resultTreeMap.put("sourceentity", node.getDynamicObject("sourceentity"));
            resultTreeMap.put("sourcerelfield", node.getString("sourcerelfield"));
            resultTreeMap.put("targetentity", node.getDynamicObject("targetentity"));
            resultTreeMap.put("targetrelfield", node.getString("targetrelfield"));
            resultTreeMap.put("logicalrel", node.getString("logicalrel"));
            resultTreeList.add(resultTreeMap);
        });
        return resultTreeList;
    }

    @Override
    public int getCurrentLayer(Long pid, DynamicObjectCollection treeEntry, int layer) {
        if (pid != 0L) {
            DynamicObject parentNode = treeEntry.stream().filter(node -> (long)pid.compareTo(node.getLong("id")) == 0L).findFirst().get();
            return this.getCurrentLayer(parentNode.getLong("pid"), treeEntry, ++layer);
        }
        return layer;
    }

    @Override
    public String getRelEntityRequireMsgTip(DynamicObjectCollection treeEntry) {
        ArrayList msgList = Lists.newArrayList();
        treeEntry.forEach(node -> {
            StringBuilder sb = new StringBuilder();
            DynamicObject sourceEntity = node.getDynamicObject("sourceentity");
            String sourceRelField = node.getString("sourcerelfield");
            DynamicObject targetEntity = node.getDynamicObject("targetentity");
            String targetRelField = node.getString("targetrelfield");
            sb.append(BizModeMsgEnum.ENTITY_NAME_TIP.get());
            sb.append(sourceEntity.getLocaleString("name").getLocaleValue());
            sb.append(BizModeMsgEnum.CORRESPOND_TIP.get());
            ArrayList fieldNameList = Lists.newArrayList();
            if (HRStringUtils.isEmpty((String)sourceRelField)) {
                fieldNameList.add(BizModeMsgEnum.ENTITY_FIELD_TIP.get());
            }
            if (targetEntity == null) {
                fieldNameList.add(BizModeMsgEnum.REL_ENTITY_NAME_TIP.get());
            }
            if (HRStringUtils.isEmpty((String)targetRelField)) {
                fieldNameList.add(BizModeMsgEnum.REL_ENTITY_FIELD_TIP.get());
            }
            if (CollectionUtils.isEmpty((Collection)fieldNameList)) {
                return;
            }
            String msg = fieldNameList.stream().collect(Collectors.joining("\u3001", ConfigItemConstants.DOUBLE_QUOTATION_MARKS, ConfigItemConstants.DOUBLE_QUOTATION_MARKS));
            sb.append(msg).append(BizModeMsgEnum.IS_EMPTY_TIP.get());
            msgList.add(sb.toString());
        });
        return msgList.stream().collect(Collectors.joining());
    }

    @Override
    public List<Map<String, Object>> getRelEntityData(TransferDataBo transferDataBo, DynamicObject[] relEntityDynArr, Map<String, Map<String, Object>> allRelEntityDataMap) {
        if (ObjectUtils.isEmpty((Object[])relEntityDynArr)) {
            return new ArrayList<Map<String, Object>>();
        }
        String entityNumber = transferDataBo.getEntityNumber();
        HashMap<String, Map> relEntityFilterMap = new HashMap<String, Map>(16);
        ArrayList<Map<String, Object>> relEntityDataList = new ArrayList<Map<String, Object>>(16);
        relEntityFilterMap.computeIfAbsent(entityNumber, key -> new HashMap(16));
        HashSet<String> allSourceEntityNumSet = new HashSet<String>(16);
        allSourceEntityNumSet.addAll(allRelEntityDataMap.keySet());
        for (DynamicObject relEntityDyn : relEntityDynArr) {
            HashMap<String, Object> reEntityDataMap = new HashMap<String, Object>(16);
            String curRelEntityNumber = relEntityDyn.getDynamicObject("relentity").getString("number");
            if (relEntityDyn.getDynamicObject("relentity") == null || relEntityDyn.getDynamicObject("sourceentity") == null) continue;
            allSourceEntityNumSet.add(curRelEntityNumber);
            String curRelSourceEntityNumber = relEntityDyn.getDynamicObject("sourceentity").getString("number");
            if (!allSourceEntityNumSet.contains(curRelSourceEntityNumber)) continue;
            relEntityFilterMap.computeIfAbsent(curRelSourceEntityNumber, key -> new HashMap(8));
            Map fieldFilterMap = (Map)relEntityFilterMap.get(curRelSourceEntityNumber);
            String sourceFieldNumber = relEntityDyn.getString("sourcefieldnumber");
            if (fieldFilterMap.containsKey(sourceFieldNumber)) continue;
            List sourceEntityDataMapList = (List)allRelEntityDataMap.get(curRelSourceEntityNumber).get("data");
            if (ObjectUtils.isEmpty((Object)sourceEntityDataMapList)) break;
            MainEntityType dataEntityType = MetadataUtils.getMainEntityType((String)curRelEntityNumber);
            MainEntityType sourceDataEntityType = MetadataUtils.getMainEntityType((String)curRelSourceEntityNumber);
            DynamicObject confItemDyn = relEntityDyn.getDynamicObject("configitem");
            HashMap<Object, Object> sourceRelFieldIdMap = new HashMap<Object, Object>(16);
            HashMap<Object, Map<String, Object>> parentEntityDataMap = new HashMap<Object, Map<String, Object>>(16);
            boolean isHisMod = transferDataBo.isHisMod();
            HashSet sourceFieldValueSet = new HashSet(16);
            ArrayList<Object> valueList = new ArrayList<Object>(10);
            for (Map sourceRelEntityMapData : sourceEntityDataMapList) {
                this.getRefCol((IDataEntityType)sourceDataEntityType, sourceFieldNumber, sourceRelEntityMapData, valueList);
                for (Object e : valueList) {
                    if (isHisMod) {
                        sourceRelFieldIdMap.put(e, sourceRelEntityMapData.get("boid"));
                    } else {
                        sourceRelFieldIdMap.put(e, sourceRelEntityMapData.get("id"));
                    }
                    sourceFieldValueSet.add(e);
                }
                parentEntityDataMap.put(sourceRelEntityMapData.get("id"), sourceRelEntityMapData);
            }
            ArrayList<Object> sourFieldValueList = new ArrayList<Object>(sourceFieldValueSet);
            fieldFilterMap.putIfAbsent(sourceFieldNumber, sourFieldValueList);
            TransferDataBo relTransferDataBo = new TransferDataBo(curRelEntityNumber);
            relTransferDataBo.setSourceRelFieldIdMap(sourceRelFieldIdMap);
            relTransferDataBo.setParentEntityDataMap(parentEntityDataMap);
            relTransferDataBo.setNeedAllHis(confItemDyn.getBoolean("needallhis"));
            this.initParamTransferDataBo(relTransferDataBo, dataEntityType, relEntityDyn.getString("relfieldnumber"), "in", sourFieldValueList, curRelSourceEntityNumber);
            this.initEntityRetDataMap(relTransferDataBo, reEntityDataMap);
            LOG.info("ConfigItemDomainServiceImpl.getRelEntityData,entityNumber={},fieldKey={},parentEntity={},sourFieldValueList={}", new Object[]{relTransferDataBo.getEntityNumber(), relTransferDataBo.getFieldKey(), relTransferDataBo.getParentEntity(), SerializationUtils.toJsonString(sourFieldValueList)});
            Map<String, Object> entityData = this.getEntityData(relTransferDataBo, reEntityDataMap);
            allRelEntityDataMap.put(curRelEntityNumber, entityData);
            relEntityDataList.add(entityData);
        }
        return relEntityDataList;
    }

    private void getRefCol(IDataEntityType sourceDataEntityType, String sourceFieldNumber, Map<String, Object> sourceRelEntityMapData, List<Object> valueList) {
        block5: {
            block6: {
                block8: {
                    IDataEntityProperty type;
                    block7: {
                        block4: {
                            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)sourceFieldNumber)) {
                                return;
                            }
                            boolean isRelSourceF7Field = this.isF7Field(sourceDataEntityType, sourceFieldNumber);
                            if (!isRelSourceF7Field) break block4;
                            valueList.add(sourceRelEntityMapData.get(sourceFieldNumber + "_id"));
                            break block5;
                        }
                        if (sourceFieldNumber.indexOf(".") > 0) break block6;
                        type = this.getItemFromProps(sourceDataEntityType, sourceFieldNumber);
                        if (!(type instanceof MuliLangTextProp)) break block7;
                        ILocaleString mulInfo = (ILocaleString)sourceRelEntityMapData.get(sourceFieldNumber);
                        valueList.add(mulInfo.getLocaleValue());
                        break block5;
                    }
                    if (!(type instanceof MulBasedataProp)) break block8;
                    Object subData = sourceRelEntityMapData.get(sourceFieldNumber);
                    if (!(subData instanceof List)) break block5;
                    List dataList = (List)subData;
                    for (Map data : dataList) {
                        valueList.add(data.get("fbasedataid_id"));
                    }
                    break block5;
                }
                valueList.add(sourceRelEntityMapData.get(sourceFieldNumber));
                break block5;
            }
            int index = sourceFieldNumber.indexOf(".");
            String parentField = sourceFieldNumber.substring(0, index);
            String field = sourceFieldNumber.substring(index + 1);
            IDataEntityProperty type = this.getItemFromProps(sourceDataEntityType, parentField);
            Object subData = sourceRelEntityMapData.get(parentField);
            if (type instanceof EntryProp && subData instanceof List) {
                EntryProp entryProp = (EntryProp)type;
                List dataList = (List)subData;
                for (Map data : dataList) {
                    this.getRefCol(entryProp.getItemType(), field, data, valueList);
                }
            }
        }
    }

    private IDataEntityProperty getItemFromProps(IDataEntityType sourceDataEntityType, String sourceFieldNumber) {
        DataEntityPropertyCollection props = sourceDataEntityType.getProperties();
        Optional<IDataEntityProperty> subPropContainer = props.stream().filter(prop -> sourceFieldNumber.equalsIgnoreCase(prop.getName())).findAny();
        return subPropContainer.get();
    }

    private boolean isF7Field(IDataEntityType dataEntityType, String relField) {
        for (IDataEntityProperty property : dataEntityType.getProperties()) {
            if (!(property instanceof BasedataProp) || !relField.equals(property.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Map<String, Object>> getControlModData(TransferDataBo transferDataBo) {
        Map<String, Object> uDataMap;
        Map<String, Object> excDataMap;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (transferDataBo == null || !transferDataBo.isControlMod() || transferDataBo.getDataEntityType() == null) {
            return list;
        }
        Map<String, Object> useRegDataMap = this.getControlModSuffixTableData(transferDataBo, "usereg", "FDATAID");
        if (!ObjectUtils.isEmpty(useRegDataMap)) {
            list.add(useRegDataMap);
        }
        if (!ObjectUtils.isEmpty(excDataMap = this.getControlModSuffixTableData(transferDataBo, "exc", "FDATAID"))) {
            list.add(excDataMap);
        }
        if (!ObjectUtils.isEmpty(uDataMap = this.getControlModSuffixTableData(transferDataBo, "_u", "FDATAID"))) {
            list.add(uDataMap);
        }
        return list;
    }

    @Override
    public Map<String, Object> getControlModSuffixTableData(TransferDataBo transferDataBo, String tableNameSuffix, String filterFieldName) {
        if (transferDataBo == null || transferDataBo.getDataEntityType() == null) {
            return new HashMap<String, Object>(0);
        }
        String mainTableName = transferDataBo.getDataEntityType().getAlias();
        String excTableName = mainTableName + (HRStringUtils.isEmpty((String)tableNameSuffix) ? "" : tableNameSuffix);
        String filterField = " " + filterFieldName + " ";
        Map<String, Object> dataMap = this.getTableKsqlData(transferDataBo, excTableName, filterField);
        return dataMap;
    }

    @Override
    public Map<String, Object> getTableKsqlData(TransferDataBo transferDataBo, String tableName, String filterField) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
        if (transferDataBo == null || HRStringUtils.isEmpty((String)tableName) || transferDataBo.getDataEntityType() == null) {
            return dataMap;
        }
        MainEntityType dataEntityType = transferDataBo.getDataEntityType();
        DBRoute dbRoute = DBRoute.of((String)dataEntityType.getDBRouteKey());
        if (DB.exitsTable((DBRoute)dbRoute, (String)tableName)) {
            List<Long> curEntityDataIdList = transferDataBo.getCurEntityDataIdList();
            StringBuilder strWhere = new StringBuilder();
            if (!ObjectUtils.isEmpty(curEntityDataIdList) && HRStringUtils.isNotEmpty((String)filterField)) {
                strWhere.append(filterField).append(" in (");
                for (int i = 0; i < curEntityDataIdList.size(); ++i) {
                    Long id = curEntityDataIdList.get(i);
                    if (i != curEntityDataIdList.size() - 1) {
                        strWhere.append(id).append(", ");
                        continue;
                    }
                    strWhere.append(id);
                }
                strWhere.append(") ");
            }
            PreInsDataScriptBuilder preInsDataScriptBuilder = new PreInsDataScriptBuilder();
            List columnNames = DB.getColumnNames((DBRoute)dbRoute, (String)tableName);
            String ksql = preInsDataScriptBuilder.genInsertSQLScript(dbRoute, tableName, String.join((CharSequence)", ", columnNames), strWhere.toString(), null, null).get("sql").toString();
            dataMap.put("entityNumber", transferDataBo.getEntityNumber());
            dataMap.put("appId", dataEntityType.getAppId());
            dataMap.put("dbRouteKey", dataEntityType.getDBRouteKey());
            dataMap.put("tableName", tableName);
            dataMap.put("ksql", ksql);
            dataMap.put("controlModeField", filterField);
            dataMap.put(filterField, curEntityDataIdList);
        }
        return dataMap;
    }

    @Override
    public List<Map<String, Object>> queryHisRelData(String entityNumber, Set<Long> vidSet) {
        DynamicObject dyEventGroup;
        ArrayList<Map<String, Object>> retMapList = new ArrayList<Map<String, Object>>(3);
        if (!ObjectUtils.isEmpty(vidSet) && (dyEventGroup = HisModelEventDataService.getInstance().getEventGroupDyByEntity(entityNumber)) != null) {
            DynamicObject dyEvent = dyEventGroup.getDynamicObject("evententity");
            DynamicObject dyBsEvent = dyEventGroup.getDynamicObject("busevententity");
            DynamicObject dyVersionEvent = dyEventGroup.getDynamicObject("hisevententity");
            String eventEntityNumber = dyEvent.getString("number");
            String bussEventEntityNumber = dyBsEvent.getString("number");
            String versionEventEntityNumber = dyVersionEvent.getString("number");
            CommonServiceImpl eventServiceHelper = new CommonServiceImpl(eventEntityNumber);
            CommonServiceImpl bussEventServiceHelper = new CommonServiceImpl(bussEventEntityNumber);
            CommonServiceImpl versionEventServiceHelper = new CommonServiceImpl(versionEventEntityNumber);
            Object[] versionEventDataArr = versionEventServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("vid", "in", (Object)vidSet.toArray(new Long[0]))});
            if (ObjectUtils.isEmpty((Object[])versionEventDataArr)) {
                return retMapList;
            }
            ArrayList versionEventList = new ArrayList(16);
            Arrays.stream(versionEventDataArr).forEach(dyn -> versionEventList.add(ConfItemDyObjectUtils.convertDynamicObjectToMap(dyn)));
            HashMap<String, Object> versionEventMap = new HashMap<String, Object>(2);
            versionEventMap.put("entityNumber", versionEventEntityNumber);
            versionEventMap.put("data", versionEventList);
            retMapList.add(versionEventMap);
            Set bizIds = Arrays.stream(versionEventDataArr).map(data -> data.getLong("busievent")).collect(Collectors.toSet());
            Object[] dyBussEvents = bussEventServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", bizIds)});
            if (ObjectUtils.isEmpty((Object[])dyBussEvents)) {
                return retMapList;
            }
            ArrayList bussEventList = new ArrayList(16);
            Arrays.stream(dyBussEvents).forEach(dyn -> bussEventList.add(ConfItemDyObjectUtils.convertDynamicObjectToMap(dyn)));
            HashMap<String, Object> dyBussEventMap = new HashMap<String, Object>(2);
            dyBussEventMap.put("entityNumber", bussEventEntityNumber);
            dyBussEventMap.put("data", bussEventList);
            retMapList.add(dyBussEventMap);
            Set eventIdSet = Arrays.stream(dyBussEvents).map(data -> data.getLong("event")).collect(Collectors.toSet());
            Object[] eventDynArr = eventServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", eventIdSet)});
            if (!ObjectUtils.isEmpty((Object[])eventDynArr)) {
                ArrayList eventList = new ArrayList(16);
                Arrays.stream(eventDynArr).forEach(dyn -> eventList.add(ConfItemDyObjectUtils.convertDynamicObjectToMap(dyn)));
                HashMap<String, Object> eventMap = new HashMap<String, Object>(2);
                eventMap.put("entityNumber", eventEntityNumber);
                eventMap.put("data", eventList);
                retMapList.add(eventMap);
            }
        }
        return retMapList;
    }

    private QFilter getTransferEntityDataFilter(TransferDataBo transferDataBo) {
        if (ObjectUtils.isEmpty(transferDataBo.getFieldValueList())) {
            return null;
        }
        String fieldKey = transferDataBo.getFieldKey();
        QFilter filter = transferDataBo.isHisMod() && "id".equals(fieldKey) ? new QFilter("boid", "in", transferDataBo.getFieldValueList()) : new QFilter(fieldKey, transferDataBo.getCp(), transferDataBo.getFieldValueList());
        if (transferDataBo.isHisMod() && !transferDataBo.isNeedAllHis()) {
            filter.and(new QFilter("datastatus", "=", (Object)"1"));
        }
        return filter;
    }

    @Override
    public LinkedHashMap<String, Map<String, Object>> getHrConfItemMap(Set<String> confItemNumSet) {
        LinkedHashMap<String, Map<String, Object>> hrConfItemEntityMap = new LinkedHashMap<String, Map<String, Object>>(3);
        if (ObjectUtils.isEmpty(confItemNumSet)) {
            return null;
        }
        CommonServiceImpl confItemTreeService = new CommonServiceImpl("hrdt_configitems");
        QFilter confItemEnableFilter = new QFilter("enable", "=", (Object)"1");
        Object[] confItemDynArr = confItemTreeService.query("id, group,number", new QFilter[]{new QFilter("number", "in", confItemNumSet), confItemEnableFilter});
        if (ObjectUtils.isEmpty((Object[])confItemDynArr)) {
            return hrConfItemEntityMap;
        }
        List<Object> relIdList = new ArrayList(16);
        HashSet<Long> confItemIdSet = new HashSet<Long>(16);
        HashSet longNumberSet = new HashSet(16);
        for (Object confItemDyn : confItemDynArr) {
            confItemIdSet.add(confItemDyn.getLong("id"));
            String[] longNumberArr = confItemDyn.getString("group.longnumber").split("\\.");
            longNumberSet.addAll(Arrays.stream(longNumberArr).collect(Collectors.toSet()));
        }
        CommonServiceImpl confItemRelService = new CommonServiceImpl("hrdt_relentityconf");
        List relConfItemList = confItemRelService.queryOriginalList("id,configitem.id", new QFilter[]{new QFilter("configitem", "in", confItemIdSet)});
        if (!ObjectUtils.isEmpty((Object)relConfItemList)) {
            relIdList = relConfItemList.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        }
        CommonServiceImpl confTreeService = new CommonServiceImpl("hrdt_configtree");
        Object[] confTreeDynArr = confTreeService.query("id, number", new QFilter[]{new QFilter("number", "in", longNumberSet), ENABLE_FILTER});
        List<Object> confTreeIdList = new ArrayList(16);
        if (!ObjectUtils.isEmpty((Object[])confTreeDynArr)) {
            confTreeIdList = Arrays.stream(confTreeDynArr).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        }
        HashMap confItemMap = new HashMap(16);
        confItemMap.put("id", new ArrayList(confItemIdSet));
        HashMap confTreeMap = new HashMap(16);
        confTreeMap.put("id", confTreeIdList);
        hrConfItemEntityMap.put("hrdt_configtree", confTreeMap);
        hrConfItemEntityMap.put("hrdt_configitems", confItemMap);
        HashMap relEntityMap = new HashMap(16);
        if (!ObjectUtils.isEmpty(relIdList)) {
            relEntityMap.put("id", relIdList);
            hrConfItemEntityMap.put("hrdt_relentityconf", relEntityMap);
        }
        return hrConfItemEntityMap;
    }

    @Override
    public Map<String, Object> handleConfItemImportData(String exportUrl) {
        LOG.info("handleConfItemImportData start,exportUrl={}", (Object)exportUrl);
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> retMap = new HashMap<String, Object>(16);
        this.initBeforeHandleConfItemData(retMap);
        Map<String, Object> dataMap = this.getConfItemImportDataByUrl(exportUrl);
        if (ObjectUtils.isEmpty(dataMap)) {
            return retMap;
        }
        this.handleImportDataMap(retMap, dataMap);
        LOG.info("handleConfItemImportData end,cost={}ms", (Object)(System.currentTimeMillis() - startTime));
        return retMap;
    }

    public Map<String, Object> handleImportDataMap(Map<String, Object> retMap, Map<String, Object> dataMap) {
        List mainDataMapList = (List)dataMap.get("data");
        ArrayList dataMapList = new ArrayList(10);
        mainDataMapList.forEach(dMap -> dataMapList.add(dMap));
        this.confItemIdDataMap = dataMapList.stream().collect(Collectors.toMap(data -> data.get("id"), data -> data, (key1, key2) -> key1));
        String confItemEntityNum = (String)dataMap.get("entityNumber");
        this.initConfItemKeyField(confItemEntityNum);
        this.validConfItemSyncData(dataMap);
        this.delAndSaveData(dataMap);
        int successCount = mainDataMapList.size() - this.failConfItemIdSet.size();
        retMap.put("successCount", successCount);
        retMap.put("failedCount", this.failConfItemIdSet.size());
        if (!ObjectUtils.isEmpty(this.confItemValidFailBoMap)) {
            String failInfoMsg = this.assemblyConfItemFailInfo();
            retMap.put("code", 1);
            retMap.put("msg", failInfoMsg);
        }
        return retMap;
    }

    private void delAndSaveData(Map<String, Object> dataMap) {
        HashSet<Object> validFailDataIdSet = new HashSet<Object>(16);
        for (ConfItemMainValidFailBo confItemMainValidFailBo : this.confItemValidFailBoMap.values()) {
            if (!confItemMainValidFailBo.isValidSuccess()) {
                validFailDataIdSet.add(confItemMainValidFailBo.getEntityDataId());
            }
            List<ConfItemRelValidFailBo> relEntityValidFailBos = confItemMainValidFailBo.getRelEntityValidFailBoList();
            relEntityValidFailBos.stream().filter(reBo -> !reBo.isValidSuccess()).forEach(relBo -> validFailDataIdSet.add(relBo.getEntityDataId()));
        }
        List relDataMapList = (List)dataMap.get("relSubData");
        for (Map relEntityMap : relDataMapList) {
            String relEntityNumber = (String)relEntityMap.get("entityNumber");
            List relEntityData = (List)relEntityMap.get("data");
            if (ObjectUtils.isEmpty((Object)relEntityData)) continue;
            ArrayList<DynamicObject> dataDynList = new ArrayList<DynamicObject>(16);
            for (Map data : relEntityData) {
                CommonServiceImpl mainDynService = new CommonServiceImpl(relEntityNumber);
                DynamicObject curDyn = mainDynService.generateEmptyDynamicObject();
                Object dataId = data.get("id");
                if (validFailDataIdSet.contains(dataId)) continue;
                ConfItemDyObjectUtils.map2DynamicObject(curDyn, data);
                dataDynList.add(curDyn);
            }
            Object curEntityBoIdSet = null;
            if (this.isHisModEntity(relEntityNumber)) {
                curEntityBoIdSet = dataDynList.stream().filter(dyn -> !validFailDataIdSet.contains(dyn.getLong("boid"))).map(dyn -> dyn.getLong("boid")).collect(Collectors.toSet());
            }
            if (!ObjectUtils.isEmpty(dataDynList)) {
                this.handleHisModData(relEntityMap, relEntityNumber, (Set<Long>)curEntityBoIdSet);
                this.handleControlModData(relEntityMap);
            }
            this.handleData(relEntityNumber, dataDynList, relEntityData);
        }
        ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>(16);
        String entityNumber = (String)dataMap.get("entityNumber");
        List<Map<String, Object>> mainDataMapList = this.getEntityDataList(dataMap);
        CommonServiceImpl mainEntityConfHelper = new CommonServiceImpl(entityNumber);
        Set<Long> mainEntityBoIdSet = new HashSet<Long>(16);
        for (Map<String, Object> mainDataMap : mainDataMapList) {
            DynamicObject curConfItemDyn = mainEntityConfHelper.generateEmptyDynamicObject();
            Object dataId = mainDataMap.get("id");
            if (validFailDataIdSet.contains(dataId)) continue;
            ConfItemDyObjectUtils.map2DynamicObject(curConfItemDyn, mainDataMap);
            arrayList.add(curConfItemDyn);
        }
        List<Map<String, Object>> filterMainDataList = mainDataMapList.stream().filter(dMap -> !validFailDataIdSet.contains(dMap.get("id"))).collect(Collectors.toList());
        if (this.isHisModEntity(entityNumber)) {
            mainEntityBoIdSet = arrayList.stream().filter(dyn -> !validFailDataIdSet.contains(dyn.getLong("boid"))).map(dyn -> dyn.getLong("boid")).collect(Collectors.toSet());
        }
        this.handleHisModData(dataMap, entityNumber, mainEntityBoIdSet);
        this.handleControlModData(dataMap);
        this.handleData(entityNumber, arrayList, filterMainDataList);
    }

    private String assemblyConfItemFailInfo() {
        if (ObjectUtils.isEmpty(this.confItemValidFailBoMap)) {
            return null;
        }
        StringBuilder failMsg = new StringBuilder();
        String f7ProEntityNotExists = ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u5b9e\u4f53\u4e3a{0}\uff0c\u6570\u636eid\u4e3a{1}\uff0c\u6570\u636e\u6807\u8bc6\u4e3a{2}\uff0c\u5f15\u7528\u57fa\u7840\u8d44\u6599\u201c{3}\u201d\u4e0d\u5b58\u5728", (String)"ConfigItemDomainServiceImpl_0", (String)"hdtc-hrdt-business", (Object[])new Object[0]);
        String ctrBaseOrgFailMsg = ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u5b9e\u4f53\u4e3a{0}\uff0c\u6570\u636eid\u4e3a{1}\uff0c\u6570\u636e\u6807\u8bc6\u4e3a{2}\uff0c\u521b\u5efa\u7ec4\u7ec7\u3001\u4f7f\u7528\u7ec4\u7ec7\u5728\u6240\u5c5e\u7ba1\u7406\u89c6\u56fe\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"ConfigItemDomainServiceImpl_2", (String)"hdtc-hrdt-business", (Object[])new Object[0]);
        String relEntityF7ProNotExist = ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u5b9e\u4f53\u4e3a{0}\uff0c\u6570\u636eid\u4e3a{1}\uff0c\u6570\u636e\u6807\u8bc6\u4e3a{2}\u7684\u5173\u8054\u7684\u5b9e\u4f53\u4e3a{3}\uff0c\u5f15\u7528\u57fa\u7840\u8d44\u6599\u201c{4}\u201d\u4e0d\u5b58\u5728", (String)"ConfigItemDomainServiceImpl_1", (String)"hdtc-hrdt-business", (Object[])new Object[0]);
        String relCtrBaseOrgFailMsg = ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u5b9e\u4f53\u4e3a{0}\uff0c\u6570\u636eid\u4e3a{1}\uff0c\u6570\u636e\u6807\u8bc6\u4e3a{2}\u7684\u5173\u8054\u7684\u5b9e\u4f53\u4e3a{3}\u7684\u6570\u636e\u6807\u8bc6{4}\uff0c\u521b\u5efa\u7ec4\u7ec7\u3001\u4f7f\u7528\u7ec4\u7ec7\u5728\u6240\u5c5e\u7ba1\u7406\u89c6\u56fe\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"ConfigItemDomainServiceImpl_3", (String)"hdtc-hrdt-business", (Object[])new Object[0]);
        HashSet<Object> relEntityF7FailRepSet = new HashSet<Object>(16);
        HashSet<Object> relEntityCtrFailRepSet = new HashSet<Object>(16);
        for (Map.Entry<Object, ConfItemMainValidFailBo> failEntry : this.confItemValidFailBoMap.entrySet()) {
            ConfItemMainValidFailBo failBo = failEntry.getValue();
            String entityNumber = failBo.getEntityNumber();
            Object confItemEntityDataId = failBo.getEntityDataId();
            String entityDataIde = failBo.getEntityDataIde();
            if (!failBo.isAllRelF7ProExist()) {
                failMsg.append(MessageFormat.format(f7ProEntityNotExists, entityNumber, confItemEntityDataId, entityDataIde, String.join((CharSequence)";", failBo.getNotExistsF7ProSet()))).append("\r\n");
            }
            if (failBo.isBuNotInCtrView()) {
                failMsg.append(MessageFormat.format(ctrBaseOrgFailMsg, entityNumber, confItemEntityDataId, entityDataIde)).append("\r\n");
            }
            List<ConfItemRelValidFailBo> relEntityValidFailBos = failBo.getRelEntityValidFailBoList();
            for (ConfItemRelValidFailBo relFailBo : relEntityValidFailBos) {
                Object entityDataId = relFailBo.getEntityDataId();
                String confItemNum = relFailBo.getConfItemNum();
                Object confItemDataId = relFailBo.getConfItemDataId();
                String relEntityNumber = relFailBo.getEntityNumber();
                if (!relFailBo.isAllRelF7ProExist()) {
                    if (relEntityF7FailRepSet.contains(entityDataId)) continue;
                    failMsg.append(MessageFormat.format(relEntityF7ProNotExist, confItemNum, confItemDataId, entityDataIde, relEntityNumber, String.join((CharSequence)";", relFailBo.getNotExistsF7ProSet()))).append("\r\n");
                    relEntityF7FailRepSet.add(entityDataId);
                }
                if (!relFailBo.isBuNotInCtrView() || relEntityCtrFailRepSet.contains(entityDataId)) continue;
                String relEntityDataIde = relFailBo.getEntityDataIde();
                failMsg.append(MessageFormat.format(relCtrBaseOrgFailMsg, entityNumber, confItemDataId, entityDataIde, relEntityNumber, relEntityDataIde)).append("\r\n");
                relEntityCtrFailRepSet.add(entityDataId);
            }
        }
        return failMsg.toString();
    }

    public void initBeforeHandleConfItemData(Map<String, Object> retMap) {
        this.confItemKeyFieldMap = new HashMap<String, String>(16);
        retMap.put("code", 0);
        retMap.put("msg", "");
        retMap.put("dev_msg", "");
    }

    private Map<String, Object> getConfItemImportDataByUrl(String exportUrl) {
        Map<String, Object> dataMap = new HashMap<String, Object>(16);
        TempFileCacheDownloadable.Content cacheContentFromTempContent = FileUtils.getCacheContentFromTempUrl((String)exportUrl);
        if (null != cacheContentFromTempContent) {
            InputStream inputStream = cacheContentFromTempContent.getInputStream();
            String dataStr = FileUtils.inputStreamToString((InputStream)inputStream);
            dataMap = (Map)JSON.parseObject((String)dataStr, Map.class);
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOG.info("inputStream.close is exception,handleConfItemImportData,exportUrl={}", (Object)exportUrl);
            }
        }
        return dataMap;
    }

    private void validConfItemSyncData(Map<String, Object> dataMap) {
        List<Map<String, Object>> dataMapList = this.getEntityDataList(dataMap);
        String confItemEntityNum = (String)dataMap.get("entityNumber");
        boolean validMainEntityRelF7Result = this.validEntityRelF7(dataMapList, confItemEntityNum, confItemEntityNum, true);
        LOG.info("ConfigItemDomainServiceImpl.validConfItemSyncData,validMainEntityRelF7Result={}", (Object)validMainEntityRelF7Result);
        boolean validSubEntityRelF7Result = true;
        List relDataMapList = (List)dataMap.get("relSubData");
        for (Map relEntityMap : relDataMapList) {
            String relEntityNumber = (String)relEntityMap.get("entityNumber");
            List relEntityData = (List)relEntityMap.get("data");
            if (ObjectUtils.isEmpty((Object)relEntityData)) continue;
            validSubEntityRelF7Result = this.validEntityRelF7(relEntityData, confItemEntityNum, relEntityNumber, false);
            LOG.info("ConfigItemDomainServiceImpl.validConfItemSyncData,relEntityNumber={},validMainEntityRelF7Result={}", (Object)relEntityNumber, (Object)validSubEntityRelF7Result);
        }
    }

    private List<Map<String, Object>> getEntityDataList(Map<String, Object> dataMap) {
        List dataList = (List)dataMap.get("data");
        ArrayList<Map<String, Object>> dataMapList = new ArrayList<Map<String, Object>>(16);
        dataList.forEach(dMap -> dataMapList.add((Map<String, Object>)dMap));
        return dataMapList;
    }

    private boolean validEntityRelF7(List<Map<String, Object>> dataMapList, String confItemEntity, String entityNumber, boolean isMainEntity) {
        boolean validRelF7Result = true;
        Map<String, String> entityF7ProMap = this.getEntityAllRefF7ProMap(entityNumber);
        Map<String, Object> refF7ProFilterMap = this.getRefF7ProFilterMap(dataMapList, entityF7ProMap);
        Map<String, List<DynamicObject>> relF7ProDbDynListMap = this.getProF7EntityDynListMap(entityF7ProMap, refF7ProFilterMap);
        Set<String> entityF7MulProSet = this.getCurEntityMulProSet(entityNumber);
        boolean ctrEntity = this.isCtrEntity(entityNumber);
        ConfItemValidEntityRelF7Bo validEntityRelF7Bo = new ConfItemValidEntityRelF7Bo(confItemEntity, entityNumber, isMainEntity, ctrEntity);
        for (Map<String, Object> data : dataMapList) {
            Object dataId = data.get("id");
            boolean isRelF7AllExist = true;
            for (Map.Entry<String, Object> dataEntry : data.entrySet()) {
                Map<String, Object> refF7DataMap;
                String proName = dataEntry.getKey();
                if (!entityF7ProMap.containsKey(dataEntry.getKey()) || ObjectUtils.isEmpty(refF7DataMap = this.getEntityRelF7DataMap(entityF7MulProSet, dataEntry, proName))) continue;
                List<DynamicObject> refF7ProToDbDynList = relF7ProDbDynListMap.get(proName);
                String baseEntityNumber = entityF7ProMap.get(proName);
                boolean isHasNumberPro = this.isContainNumberField(baseEntityNumber);
                Object newId = refF7DataMap.get("id");
                if (newId == null || "0".equals(newId.toString()) || StringUtils.isEmpty((String)newId.toString())) {
                    LOG.info("validEntityRelF7,proName={},newId={},baseEntityNumber={}", new Object[]{proName, newId, baseEntityNumber});
                    continue;
                }
                String newNumber = (String)refF7DataMap.get("number");
                LOG.info("ConfigItemDomainServiceImpl.isRelProF7Success,proName={},baseEntityNumber={},newId={},newNumber={},isEntityIsCtr={}", new Object[]{proName, baseEntityNumber, newId, newNumber, ctrEntity});
                isRelF7AllExist = refF7ProToDbDynList.stream().anyMatch(baseEntityDyn -> newId.toString().equals(baseEntityDyn.getString("id")));
                if (!isRelF7AllExist && isHasNumberPro) {
                    for (DynamicObject baseEntityDyn2 : refF7ProToDbDynList) {
                        if (HRStringUtils.isEmpty((String)newNumber) || !newNumber.equals(baseEntityDyn2.getString("number"))) continue;
                        refF7DataMap.put("id", baseEntityDyn2.get("id"));
                        isRelF7AllExist = true;
                    }
                }
                if (!isRelF7AllExist && ("creator".equals(proName) || "modifier".equals(proName) || "disabler".equals(proName))) {
                    isRelF7AllExist = true;
                    refF7DataMap.put("id", this.curUserId);
                }
                validEntityRelF7Bo.setValidRelF7Result(validRelF7Result);
                validRelF7Result = this.handleRelF7CtrResult(validEntityRelF7Bo, data, proName, isRelF7AllExist, entityF7ProMap);
            }
            if (validRelF7Result) continue;
            Object curConfItemDataId = dataId;
            if (!isMainEntity) {
                curConfItemDataId = this.getCurConfItemDataId(data);
            }
            this.failConfItemIdSet.add(curConfItemDataId);
        }
        return validRelF7Result;
    }

    private Set<String> getCurEntityMulProSet(String confItemEntityNum) {
        HashSet<String> mulBaseProSet = new HashSet<String>(16);
        if (HRStringUtils.isEmpty((String)confItemEntityNum)) {
            return mulBaseProSet;
        }
        MainEntityType dataEntityType = MetadataUtils.getMainEntityType((String)confItemEntityNum);
        for (IDataEntityProperty property : dataEntityType.getProperties()) {
            String propertyName = property.getName();
            if (!(property instanceof MulBasedataProp)) continue;
            mulBaseProSet.add(propertyName);
        }
        return mulBaseProSet;
    }

    private Map<String, Object> getEntityRelF7DataMap(Set<String> entityF7MulProSet, Map.Entry<String, Object> dataEntry, String proName) {
        HashMap<String, Object> refF7DataMap = new HashMap(16);
        if (entityF7MulProSet.contains(proName)) {
            List mulBaseDataMapList = (List)dataEntry.getValue();
            for (Map mulBaseDataMap : mulBaseDataMapList) {
                Map mulBaseData = (Map)mulBaseDataMap.get("fbasedataid");
                if (ObjectUtils.isEmpty((Object)mulBaseData)) continue;
                refF7DataMap.putAll(mulBaseData);
            }
        } else {
            refF7DataMap = (Map)dataEntry.getValue();
        }
        return refF7DataMap;
    }

    private boolean handleRelF7CtrResult(ConfItemValidEntityRelF7Bo validEntityRelF7Bo, Map<String, Object> data, String proName, boolean isRelF7AllExist, Map<String, String> entityF7ProMap) {
        Object dataId = data.get("id");
        boolean validRelF7Result = validEntityRelF7Bo.isValidRelF7Result();
        boolean isEntityIsCtr = validEntityRelF7Bo.isEntityIsCtr();
        String confItemEntity = validEntityRelF7Bo.getConfItemEntity();
        String entityNumber = validEntityRelF7Bo.getEntityNumber();
        boolean isMainEntityValid = validEntityRelF7Bo.isMainEntity();
        String f7EntityNumber = entityF7ProMap.get(proName);
        if (!isRelF7AllExist) {
            if (isMainEntityValid) {
                ConfItemMainValidFailBo entityValidFailBo = this.getConfItemValidFailBo(confItemEntity, dataId);
                Set<String> notExistsF7ProSet = entityValidFailBo.getNotExistsF7ProSet();
                notExistsF7ProSet.add(proName);
                entityValidFailBo.setAllRelF7ProExist(false);
                entityValidFailBo.setEntityDataIde(this.getEntityDataIde(data, entityNumber));
                entityValidFailBo.setValidSuccess(false);
            } else {
                Long curConfItemDataId = this.getCurConfItemDataId(data);
                Map<String, Object> confItemDataMap = this.confItemIdDataMap.get(curConfItemDataId);
                ConfItemMainValidFailBo entityValidFailBo = this.getConfItemValidFailBo(confItemEntity, curConfItemDataId);
                List<ConfItemRelValidFailBo> relEntityValidFailBos = entityValidFailBo.getRelEntityValidFailBoList();
                ConfItemRelValidFailBo relEntityValidFailBo = this.getRelEntityValidFailBo(confItemEntity, curConfItemDataId, dataId, entityNumber);
                Set<String> notExistsF7ProSet = relEntityValidFailBo.getNotExistsF7ProSet();
                notExistsF7ProSet.add(proName);
                String relEntityDataIde = this.getEntityDataIde(data, entityNumber);
                relEntityValidFailBo.setEntityDataIde(relEntityDataIde);
                relEntityValidFailBo.setAllRelF7ProExist(false);
                relEntityValidFailBo.setValidSuccess(false);
                String confItemDataIde = this.getEntityDataIde(confItemDataMap, confItemEntity);
                entityValidFailBo.setEntityDataIde(confItemDataIde);
                Map<Object, Object> relVsConfIdMap = entityValidFailBo.getRelVsConfIdMap();
                Object confItemId = relVsConfIdMap.get(dataId);
                if (ObjectUtils.isEmpty((Object)confItemId)) {
                    relEntityValidFailBos.add(relEntityValidFailBo);
                    relVsConfIdMap.put(dataId, curConfItemDataId);
                }
            }
            validRelF7Result = false;
        } else if (isEntityIsCtr && HRStringUtils.isNotEmpty((String)f7EntityNumber) && "bos_org".equals(f7EntityNumber)) {
            Long orgId = this.idToLong(((Map)data.get(proName)).get("id"));
            HashSet<Long> idSet = new HashSet<Long>(16);
            idSet.add(orgId);
            Map<Long, Boolean> entityOrgCtrInfo = this.getEntityOrgCtrInfo(entityNumber, idSet);
            if (!entityOrgCtrInfo.get(orgId).booleanValue()) {
                ConfItemMainValidFailBo entityValidFailBo;
                Long curConfItemDataId = this.getCurConfItemDataId(data);
                if (isMainEntityValid) {
                    entityValidFailBo = this.getConfItemValidFailBo(entityNumber, curConfItemDataId);
                    entityValidFailBo.setBuNotInCtrView(true);
                    entityValidFailBo.setEntityDataIde(this.getEntityDataIde(data, entityNumber));
                    entityValidFailBo.setValidSuccess(false);
                } else {
                    entityValidFailBo = this.getConfItemValidFailBo(confItemEntity, curConfItemDataId);
                    List<ConfItemRelValidFailBo> relEntityValidFailBos = entityValidFailBo.getRelEntityValidFailBoList();
                    Map<Object, Object> relVsConfIdMap = entityValidFailBo.getRelVsConfIdMap();
                    ConfItemRelValidFailBo relEntityValidFailBo = this.getRelEntityValidFailBo(confItemEntity, curConfItemDataId, dataId, entityNumber);
                    relEntityValidFailBo.setBuNotInCtrView(true);
                    relEntityValidFailBo.setValidSuccess(false);
                    Object confItemId = relVsConfIdMap.get(dataId);
                    if (ObjectUtils.isEmpty((Object)confItemId)) {
                        relEntityValidFailBos.add(relEntityValidFailBo);
                        relVsConfIdMap.put(dataId, curConfItemDataId);
                    }
                    Map<String, Object> confItemDataMap = this.confItemIdDataMap.get(curConfItemDataId);
                    String confItemDataIde = this.getEntityDataIde(confItemDataMap, confItemEntity);
                    relEntityValidFailBo.setEntityDataIde(this.getEntityDataIde(data, entityNumber));
                    entityValidFailBo.setEntityDataIde(confItemDataIde);
                }
                this.confItemValidFailBoMap.putIfAbsent(curConfItemDataId, entityValidFailBo);
                validRelF7Result = false;
            }
        }
        return validRelF7Result;
    }

    private ConfItemMainValidFailBo getConfItemValidFailBo(String confItemEntityNum, Object confItemDataId) {
        ConfItemMainValidFailBo entityValidFailBo = this.confItemValidFailBoMap.get(confItemDataId);
        if (entityValidFailBo == null) {
            entityValidFailBo = new ConfItemMainValidFailBo(confItemDataId, confItemEntityNum);
            this.confItemValidFailBoMap.put(confItemDataId, entityValidFailBo);
        }
        return entityValidFailBo;
    }

    private ConfItemRelValidFailBo getRelEntityValidFailBo(String confItemNum, Object confItemDataId, Object entityDataId, String entityNumber) {
        ConfItemRelValidFailBo relEntityValidFailBo = this.relEntityValidFailBoMap.get(entityDataId);
        if (relEntityValidFailBo == null) {
            relEntityValidFailBo = new ConfItemRelValidFailBo(confItemNum, confItemDataId, entityDataId, entityNumber);
            this.relEntityValidFailBoMap.put(entityDataId, relEntityValidFailBo);
        }
        return relEntityValidFailBo;
    }

    private String getEntityDataIde(Map<String, Object> data, String entityNumber) {
        if (ObjectUtils.isEmpty(data)) {
            return null;
        }
        String relEntityDataIde = this.getLocalLangInfo((Map)data.get("name"));
        if (HRStringUtils.isEmpty((String)relEntityDataIde) && this.isContainNumberField(entityNumber)) {
            relEntityDataIde = (String)data.get("number");
        }
        return relEntityDataIde;
    }

    private void initConfItemKeyField(String confItemName) {
        CommonServiceImpl confItemService = new CommonServiceImpl("hrdt_configitems");
        DynamicObject confItemDyn = confItemService.queryOne("id, number,keyfields", new QFilter[]{new QFilter("number", "=", (Object)confItemName), ENABLE_FILTER});
        if (confItemDyn == null) {
            return;
        }
        long confItemPkId = confItemDyn.getLong("id");
        this.confItemKeyFieldMap.put(confItemDyn.getString("number"), confItemDyn.getString("keyfields"));
        CommonServiceImpl confItemRelEntityService = new CommonServiceImpl("hrdt_relentityconf");
        List configItemRelEntityDynList = confItemRelEntityService.queryOriginalList("id,relentity.number,keyfields", new QFilter[]{new QFilter("configitem", "=", (Object)confItemPkId)});
        if (!ObjectUtils.isEmpty((Object)configItemRelEntityDynList)) {
            configItemRelEntityDynList.forEach(relDyn -> this.confItemKeyFieldMap.put(relDyn.getString("relentity.number"), relDyn.getString("keyfields")));
        }
        LOG.info("initConfItemKeyField,confItemKeyFieldMap={}", (Object)SerializationUtils.toJsonString(this.confItemKeyFieldMap));
    }

    private void handleData(String entityNumber, List<DynamicObject> dataDynList, List<Map<String, Object>> dataMapList) {
        List pkIdList = dataDynList.stream().map(entityDyn -> entityDyn.getLong("id")).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(pkIdList)) {
            return;
        }
        String join = Joiner.on((char)',').join(pkIdList);
        this.saveConfSynLog(entityNumber, ObjectUtils.isEmpty(pkIdList), join, "data");
        CommonServiceImpl commonService = new CommonServiceImpl(entityNumber);
        QFilter delFilter = null;
        String keyFields = this.confItemKeyFieldMap.get(entityNumber);
        boolean isHisModEntity = this.isHisModEntity(entityNumber);
        boolean isIdKeyField = false;
        if (HRStringUtils.isEmpty((String)keyFields)) {
            delFilter = isHisModEntity ? new QFilter("boid", "in", pkIdList) : new QFilter("id", "in", pkIdList);
        } else {
            Object[] keyFieldArr = keyFields.split(",");
            HashSet<String> keyFieldSet = new HashSet<String>(4);
            Map<Object, Object> keyFieldFilterMap = new HashMap(0);
            if (!ObjectUtils.isEmpty((Object[])keyFieldArr)) {
                Arrays.stream(keyFieldArr).filter(keyField -> HRStringUtils.isNotEmpty((String)keyField)).forEach(keyField -> keyFieldSet.add((String)keyField));
                keyFieldFilterMap = this.getKeyFieldFilterValueMap(dataMapList, keyFieldSet);
            }
            if (keyFieldFilterMap.size() == 1 && keyFieldSet.contains("id")) {
                isIdKeyField = true;
            }
            if (!ObjectUtils.isEmpty(keyFieldFilterMap)) {
                for (Map.Entry keyFieldFilterEntry : keyFieldFilterMap.entrySet()) {
                    String proName = (String)keyFieldFilterEntry.getKey();
                    List filterValueList = (List)keyFieldFilterEntry.getValue();
                    LOG.info("ConfigItemDomainServiceImpl.handleData,proName={},filterValueList={}", (Object)proName, (Object)SerializationUtils.toJsonString((Object)filterValueList));
                    if (ObjectUtils.isEmpty((Object)filterValueList)) continue;
                    QFilter proFilter = new QFilter(proName, "in", (Object)filterValueList);
                    if (delFilter == null) {
                        delFilter = proFilter;
                        continue;
                    }
                    delFilter.and(proFilter);
                }
            } else {
                delFilter = new QFilter("id", "in", pkIdList);
            }
        }
        if (delFilter != null && !isIdKeyField) {
            delFilter.or(new QFilter("id", "in", pkIdList));
            if (isHisModEntity) {
                delFilter.or(new QFilter("boid", "in", pkIdList));
            }
        }
        this.entityDelAndSave(entityNumber, commonService, delFilter, dataDynList);
    }

    private void entityDelAndSave(String entityNumber, CommonServiceImpl commonService, QFilter delFilter, List<DynamicObject> newDataDynList) {
        LOG.info("ConfigItemDomainServiceImpl.entityDelAndSave,entityNumber={},delFilter={}", (Object)entityNumber, (Object)delFilter);
        long startTime = System.currentTimeMillis();
        if (!ObjectUtils.isEmpty((Object)delFilter)) {
            commonService.deleteByFilter(new QFilter[]{delFilter});
        }
        if (!ObjectUtils.isEmpty(newDataDynList)) {
            commonService.save(newDataDynList.toArray(new DynamicObject[0]));
            LOG.info("ConfigItemDomainServiceImpl.entityDelAndSave,entityNumber={},newDataDynList.size={},cost={}ms", new Object[]{entityNumber, newDataDynList.size(), System.currentTimeMillis() - startTime});
        }
    }

    private boolean isContainNumberField(String entityNumber) {
        MainEntityType dataEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
        return dataEntityType.getProperties().containsKey((Object)"number");
    }

    private void handleControlModData(Map<String, Object> dataMap) {
        String entityNumber = (String)dataMap.get("entityNumber");
        if (!this.isCtrEntity(entityNumber)) {
            return;
        }
        List controlDataList = (List)dataMap.get("controlModData");
        if (ObjectUtils.isEmpty((Object)controlDataList)) {
            return;
        }
        StringBuilder saveSqlSb = new StringBuilder();
        ArrayList<DynamicObject> confSynLogDynList = new ArrayList<DynamicObject>(16);
        DBRoute dbRoute = null;
        PreInsDataScriptBuilder preInsDataScriptBuilder = new PreInsDataScriptBuilder();
        StringBuilder delKsqlSb = new StringBuilder();
        StringBuilder insertKsqlSb = new StringBuilder();
        for (Map controlDataMap : controlDataList) {
            String tableKsql;
            Map<String, Object> ksql;
            String dbRouteKey = controlDataMap.get("dbRouteKey").toString();
            dbRoute = DBRoute.of((String)dbRouteKey);
            String dataSql = (String)controlDataMap.get("ksql");
            if (HRStringUtils.isEmpty((String)dataSql)) continue;
            saveSqlSb.append(dataSql).append("\r\n");
            String tableName = (String)controlDataMap.get("tableName");
            String filterField = (String)controlDataMap.get("controlModeField");
            List filterIdValList = (List)controlDataMap.get(filterField);
            if (ObjectUtils.isEmpty((Object)filterIdValList) || ObjectUtils.isEmpty(ksql = this.getControlEntityTableKsql(dbRoute, preInsDataScriptBuilder, tableName, filterField, filterIdValList)) || HRStringUtils.isEmpty((String)(tableKsql = ksql.get("sql").toString()))) continue;
            String[] bakKsqlArr = tableKsql.split("\r\n");
            for (int i = 0; i < bakKsqlArr.length; ++i) {
                String sql = bakKsqlArr[i];
                if (HRStringUtils.isEmpty((String)sql)) continue;
                if (sql.trim().startsWith("DELETE")) {
                    delKsqlSb.append(bakKsqlArr[i]).append("\r\n");
                    continue;
                }
                insertKsqlSb.append(bakKsqlArr[i]).append("\r\n");
            }
        }
        MainEntityType dataEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
        confSynLogDynList.add(this.assemblyConfSynLogDyn(entityNumber, dataEntityType.getAppId(), dataEntityType.getDBRouteKey(), delKsqlSb.toString(), insertKsqlSb.toString(), "controlModData"));
        if (!ObjectUtils.isEmpty(confSynLogDynList)) {
            this.confSynLogService.save(confSynLogDynList.toArray(new DynamicObject[0]));
        }
        if (HRStringUtils.isNotEmpty((String)saveSqlSb.toString())) {
            SqlBuilder sqlBuilder = new SqlBuilder().append(saveSqlSb.toString(), new Object[0]);
            DB.execute((DBRoute)dbRoute, (SqlBuilder)sqlBuilder);
        }
    }

    private Map<String, Object> getControlEntityTableKsql(DBRoute dbRoute, PreInsDataScriptBuilder preInsDataScriptBuilder, String tableName, String filterField, List<Long> filterIdValList) {
        List columnNames = DB.getColumnNames((DBRoute)dbRoute, (String)tableName);
        return preInsDataScriptBuilder.genInsertSQLScript(dbRoute, tableName, String.join((CharSequence)",", columnNames), filterField + " in (" + Joiner.on((char)',').join(filterIdValList) + ") ", null, null);
    }

    private DynamicObject assemblyConfSynLogDyn(String entityNumber, String appId, String dbRouteKey, String delSql, String insertSql, String description) {
        DynamicObject confSynLogDyn = this.confSynLogService.generateEmptyDynamicObject();
        confSynLogDyn.set("creator", (Object)this.curUserId);
        confSynLogDyn.set("createtime", (Object)this.nowDate);
        confSynLogDyn.set("confentitynumber", (Object)entityNumber);
        confSynLogDyn.set("delsql", (Object)(HRStringUtils.isNotEmpty((String)delSql) && delSql.length() > 255 ? delSql.substring(0, 255) : delSql));
        confSynLogDyn.set("delsql_tag", (Object)delSql);
        confSynLogDyn.set("insertsql", (Object)(HRStringUtils.isNotEmpty((String)insertSql) && insertSql.length() > 255 ? insertSql.substring(0, 255) : insertSql));
        confSynLogDyn.set("insertsql_tag", (Object)insertSql);
        confSynLogDyn.set("appid", (Object)appId);
        confSynLogDyn.set("dbroute", (Object)dbRouteKey);
        confSynLogDyn.set("description", (Object)description);
        return confSynLogDyn;
    }

    public void handleHisModData(Map<String, Object> dataMap, String entityNumber, Set<Long> entityBoIdSet) {
        if (this.isHisModEntity(entityNumber) && !ObjectUtils.isEmpty(entityBoIdSet) && !ObjectUtils.isEmpty(dataMap)) {
            List mainHisDataList = JSON.parseArray((String)dataMap.get("hisModRelData").toString(), Map.class);
            if (ObjectUtils.isEmpty((Object)mainHisDataList)) {
                return;
            }
            DynamicObject dyEventGroup = HisModelEventDataService.getInstance().getEventGroupDyByEntity(entityNumber);
            if (dyEventGroup != null) {
                DynamicObject dyEvent = dyEventGroup.getDynamicObject("evententity");
                DynamicObject dyBsEvent = dyEventGroup.getDynamicObject("busevententity");
                DynamicObject dyVersionEvent = dyEventGroup.getDynamicObject("hisevententity");
                String eventEntityNumber = dyEvent.getString("number");
                String bussEventEntityNumber = dyBsEvent.getString("number");
                String versionEventEntityNumber = dyVersionEvent.getString("number");
                LOG.info("ConfigItemDomainServiceImpl.handleHisModData,entityNumber={},eventEntityNumber={},bussEventEntityNumber={},versionEventEntityNumber={},entityBoIdSet={}", new Object[]{entityNumber, eventEntityNumber, bussEventEntityNumber, versionEventEntityNumber, SerializationUtils.toJsonString(entityBoIdSet)});
                HRBaseServiceHelper eventServiceHelper = new HRBaseServiceHelper(eventEntityNumber);
                HRBaseServiceHelper bussEventServiceHelper = new HRBaseServiceHelper(bussEventEntityNumber);
                HRBaseServiceHelper versionEventServiceHelper = new HRBaseServiceHelper(versionEventEntityNumber);
                List allBussEventMapList = null;
                List allVersionEventMapList = null;
                List allEventMapList = null;
                for (Map dMap : mainHisDataList) {
                    String hisEventEntityNumber = (String)dMap.get("entityNumber");
                    if (bussEventEntityNumber.equals(hisEventEntityNumber)) {
                        allBussEventMapList = (List)dMap.get("data");
                        continue;
                    }
                    if (versionEventEntityNumber.equals(hisEventEntityNumber)) {
                        allVersionEventMapList = (List)dMap.get("data");
                        continue;
                    }
                    allEventMapList = (List)dMap.get("data");
                }
                if (ObjectUtils.isEmpty(allBussEventMapList)) {
                    return;
                }
                ArrayList<DynamicObject> bussEventDynList = new ArrayList<DynamicObject>(10);
                ArrayList<DynamicObject> versionEventDynList = new ArrayList<DynamicObject>(10);
                ArrayList<DynamicObject> eventDynList = new ArrayList<DynamicObject>(10);
                HashSet<Long> bussEventIdSet = new HashSet<Long>(16);
                ArrayList<Long> versionEventIdList = new ArrayList<Long>(10);
                ArrayList<Long> eventIdList = new ArrayList<Long>(10);
                HashSet<Long> eventIdSet = new HashSet<Long>(16);
                this.assemblyBussEventData(entityBoIdSet, bussEventServiceHelper, allBussEventMapList, bussEventDynList, bussEventIdSet, eventIdSet);
                this.assemblyVerAndEventData(versionEventServiceHelper, allVersionEventMapList, versionEventDynList, bussEventIdSet, versionEventIdList, "busievent");
                this.hisFilterOtherBoEvent(entityBoIdSet, bussEventServiceHelper, eventIdSet);
                this.assemblyVerAndEventData(eventServiceHelper, allEventMapList, eventDynList, eventIdSet, eventIdList, "id");
                this.saveConfSynLog(bussEventEntityNumber, ObjectUtils.isEmpty(bussEventIdSet), Joiner.on((char)',').join(bussEventIdSet), "hisModRelData");
                this.saveConfSynLog(versionEventEntityNumber, ObjectUtils.isEmpty(versionEventIdList), Joiner.on((char)',').join(versionEventIdList), "hisModRelData");
                this.saveConfSynLog(eventEntityNumber, ObjectUtils.isEmpty(eventIdList), Joiner.on((char)',').join(eventIdList), "hisModRelData");
                this.delHisModData(entityNumber, new ArrayList<Long>(entityBoIdSet));
                bussEventServiceHelper.save(bussEventDynList.toArray(new DynamicObject[0]));
                versionEventServiceHelper.save(versionEventDynList.toArray(new DynamicObject[0]));
                if (CollectionUtils.isNotEmpty(eventDynList)) {
                    eventServiceHelper.save(eventDynList.toArray(new DynamicObject[0]));
                }
            }
        }
    }

    private void hisFilterOtherBoEvent(Set<Long> entityBoIdSet, HRBaseServiceHelper bussEventServiceHelper, Set<Long> eventIdSet) {
        if (entityBoIdSet != null) {
            DynamicObject[] dyRestEvent = HisEventEntityRepository.queryBussEventByEventIds((HRBaseServiceHelper)bussEventServiceHelper, (Long[])entityBoIdSet.toArray(new Long[0]), (Long[])eventIdSet.toArray(new Long[0]));
            Set restEventId = Arrays.stream(dyRestEvent).map(dy -> dy.getLong("event")).collect(Collectors.toSet());
            eventIdSet.removeAll(restEventId);
        }
    }

    private void assemblyVerAndEventData(HRBaseServiceHelper eventServiceHelper, List<Map<String, Object>> allEventMapList, List<DynamicObject> eventDynList, Set<Long> eventIdSet, List<Long> retEventIdList, String ventIdField) {
        if (!ObjectUtils.isEmpty(allEventMapList)) {
            for (Map<String, Object> verEventMap : allEventMapList) {
                if (!eventIdSet.contains(this.idToLong(verEventMap.get(ventIdField)))) continue;
                DynamicObject verEventDyn = eventServiceHelper.generateEmptyDynamicObject();
                ConfItemDyObjectUtils.map2DynamicObject(verEventDyn, verEventMap);
                eventDynList.add(verEventDyn);
                retEventIdList.add(verEventDyn.getLong("id"));
            }
        }
    }

    private void assemblyBussEventData(Set<Long> entityBoIdSet, HRBaseServiceHelper bussEventServiceHelper, List<Map<String, Object>> allBussEventMapList, List<DynamicObject> bussEventDynList, Set<Long> bussEventIdSet, Set<Long> eventIdSet) {
        if (ObjectUtils.isEmpty(allBussEventMapList)) {
            return;
        }
        for (Map<String, Object> bussEventMap : allBussEventMapList) {
            if (!entityBoIdSet.contains(this.idToLong(bussEventMap.get("boid")))) continue;
            DynamicObject bussEventDyn = bussEventServiceHelper.generateEmptyDynamicObject();
            ConfItemDyObjectUtils.map2DynamicObject(bussEventDyn, bussEventMap);
            bussEventDynList.add(bussEventDyn);
            bussEventIdSet.add(bussEventDyn.getLong("id"));
            eventIdSet.add(this.idToLong(bussEventDyn.getLong("event")));
        }
    }

    private void delHisModData(String entityNumber, List<Long> boIdList) {
        HisBaseBo hisBaseBo = new HisBaseBo();
        hisBaseBo.setEntityNumber(entityNumber);
        hisBaseBo.setBoIdList(boIdList);
        HisDeleteService.getInstance().deleteBoEventData(hisBaseBo);
    }

    private void saveConfSynLog(String entityNumber, boolean empty, String join, String description) {
        if (!empty) {
            if (HRStringUtils.isEmpty((String)join)) {
                return;
            }
            ArrayList<DynamicObject> confSynLogDynList = new ArrayList<DynamicObject>(16);
            StringBuilder qFilterSb = new StringBuilder();
            qFilterSb.append(Q_FILTER_STRING).append(join).append(')');
            String bussEventSql = this.metaDatePresetDataDomainService.getPresetDataString(entityNumber, qFilterSb.toString());
            MainEntityType dataEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
            Object[] ksqlArr = bussEventSql.split("\n");
            StringBuilder delSqlSb = new StringBuilder();
            StringBuilder insertSqlSb = new StringBuilder();
            if (!ObjectUtils.isEmpty((Object[])ksqlArr)) {
                for (int i = 0; i < ksqlArr.length; ++i) {
                    Object sql = ksqlArr[i];
                    if (HRStringUtils.isEmpty((String)sql)) continue;
                    if (((String)sql).trim().startsWith("DELETE")) {
                        delSqlSb.append((String)ksqlArr[i]).append("\r\n");
                        continue;
                    }
                    insertSqlSb.append((String)ksqlArr[i]).append("\r\n");
                }
            }
            confSynLogDynList.add(this.assemblyConfSynLogDyn(entityNumber, dataEntityType.getAppId(), dataEntityType.getDBRouteKey(), delSqlSb.toString(), insertSqlSb.toString(), description));
            if (ObjectUtils.isEmpty(confSynLogDynList)) {
                return;
            }
            this.confSynLogService.save(confSynLogDynList.toArray(new DynamicObject[0]));
        }
    }

    private long getCurConfItemDataId(Map<String, Object> relEntityDatum) {
        return Long.parseLong(relEntityDatum.get("structLongId").toString().split("!")[0]);
    }

    private String getLocalLangInfo(Map<String, String> mulDataMap) {
        if (mulDataMap == null) {
            return null;
        }
        return mulDataMap.get(RequestContext.get().getLang().name());
    }

    private Map<String, List<DynamicObject>> getProF7EntityDynListMap(Map<String, String> allF7EntityProMap, Map<String, Object> refF7ProFilterMap) {
        HashMap<String, List<DynamicObject>> refBaseEntityDynListMap = new HashMap<String, List<DynamicObject>>(16);
        if (allF7EntityProMap == null) {
            return refBaseEntityDynListMap;
        }
        for (Map.Entry<String, String> proEntry : allF7EntityProMap.entrySet()) {
            Object[] baseDataDynArr;
            String proName = proEntry.getKey();
            String baseEntityNum = proEntry.getValue();
            Map filedValueMap = (Map)refF7ProFilterMap.get(baseEntityNum);
            if (ObjectUtils.isEmpty((Object)filedValueMap)) continue;
            refBaseEntityDynListMap.putIfAbsent(proName, new ArrayList(10));
            List idList = (List)filedValueMap.get("id");
            ArrayList<String> numberList = new ArrayList(10);
            Object numbObj = filedValueMap.get("number");
            if (numbObj != null) {
                numberList = (List)numbObj;
            }
            if (ObjectUtils.isEmpty((Object[])(baseDataDynArr = this.loadBaseDataFromDB(baseEntityNum, idList, numberList)))) continue;
            List dataList = Arrays.stream(baseDataDynArr).collect(Collectors.toList());
            refBaseEntityDynListMap.computeIfPresent(proName, (key, val) -> dataList);
        }
        return refBaseEntityDynListMap;
    }

    private Map<String, Object> getRefF7ProFilterMap(List<Map<String, Object>> dataMapList, Map<String, String> allF7EntityProMap) {
        LOG.info("getRefF7ProFilterMap\uff0callF7EntityProMap={}", (Object)SerializationUtils.toJsonString(allF7EntityProMap));
        HashMap<String, Object> refBaseMap = new HashMap<String, Object>(16);
        if (allF7EntityProMap == null) {
            return refBaseMap;
        }
        for (Map.Entry<String, String> f7Entry : allF7EntityProMap.entrySet()) {
            String proName = f7Entry.getKey();
            String baseEntityId = f7Entry.getValue();
            refBaseMap.putIfAbsent(baseEntityId, new HashMap(16));
            Map filedValueMap = (Map)refBaseMap.get(baseEntityId);
            filedValueMap.putIfAbsent("id", new ArrayList(10));
            filedValueMap.putIfAbsent("number", new ArrayList(10));
            List idList = (List)filedValueMap.get("id");
            List numberList = (List)filedValueMap.get("number");
            for (Map<String, Object> data : dataMapList) {
                Object dataValueObj = data.get(proName);
                if ("creator".equals(proName) || "modifier".equals(proName) || "disabler".equals(proName)) {
                    LOG.info("----------------proName={},dataValueObj={}", (Object)proName, (Object)SerializationUtils.toJsonString((Object)dataValueObj));
                }
                if (!ObjectUtils.isEmpty((Object)dataValueObj) && dataValueObj instanceof List) {
                    LOG.info("getRefF7ProFilterMap,proName={},List.dataValueObj={}", (Object)proName, (Object)SerializationUtils.toJsonString((Object)dataValueObj));
                    List mulBaseMapList = (List)dataValueObj;
                    List<Map<String, Object>> mulBaseDataMapList = mulBaseMapList.stream().map(mulMap -> (Map)mulMap.get("fbasedataid")).collect(Collectors.toList());
                    this.handleMulBaseDataNumList(idList, numberList, mulBaseDataMapList);
                    continue;
                }
                if (ObjectUtils.isEmpty((Object)dataValueObj) || !(dataValueObj instanceof Map)) continue;
                Map baseEntityMap = (Map)dataValueObj;
                idList.add(baseEntityMap.get("id"));
                Object numObj = baseEntityMap.get("number");
                if (numObj == null) continue;
                numberList.add((String)numObj);
            }
            HashSet idSet = new HashSet(idList);
            HashSet numberSet = new HashSet(numberList);
            filedValueMap.put("id", new ArrayList(idSet));
            filedValueMap.put("number", new ArrayList(numberSet));
            refBaseMap.put(baseEntityId, filedValueMap);
        }
        LOG.info("getRefF7ProFilterMap,refBaseMap={}", (Object)SerializationUtils.toJsonString(refBaseMap));
        return refBaseMap;
    }

    private void handleMulBaseDataNumList(List<Object> idList, List<String> numberList, List<Map<String, Object>> mulBaseDataMapList) {
        for (Map<String, Object> mulDataMap : mulBaseDataMapList) {
            if (ObjectUtils.isEmpty(mulDataMap)) continue;
            idList.add(mulDataMap.get("id"));
            Object numObj = mulDataMap.get("number");
            if (numObj == null) continue;
            numberList.add((String)numObj);
        }
    }

    @Override
    public Map<String, List<Object>> getKeyFieldFilterValueMap(List<Map<String, Object>> dataMapList, Set<String> keyFieldSet) {
        if (ObjectUtils.isEmpty(dataMapList) || ObjectUtils.isEmpty(keyFieldSet)) {
            return new HashMap<String, List<Object>>(0);
        }
        HashMap<String, List<Object>> keyFieldFilterValueMap = new HashMap<String, List<Object>>(16);
        for (String keyFieldPro : keyFieldSet) {
            keyFieldFilterValueMap.put(keyFieldPro, dataMapList.stream().filter(dataMap -> null != dataMap.get(keyFieldPro)).map(dataMap -> dataMap.get(keyFieldPro)).collect(Collectors.toList()));
        }
        return keyFieldFilterValueMap;
    }

    @Override
    public Map<String, String> getEntityAllRefF7ProMap(String entityNumber) {
        if (HRStringUtils.isEmpty((String)entityNumber)) {
            return new HashMap<String, String>(0);
        }
        MainEntityType entityType = MetadataUtils.getMainEntityType((String)entityNumber);
        DataEntityPropertyCollection entityProperties = entityType.getProperties();
        HashMap<String, String> allF7EntityProMap = new HashMap<String, String>(16);
        HashMap mapList = new HashMap(16);
        for (IDataEntityProperty property : entityProperties) {
            if (HRStringUtils.isEmpty((String)property.getAlias()) || !(property instanceof IBasedataField)) continue;
            String proName = property.getName();
            String baseEntityId = ((IBasedataField)property).getBaseEntityId();
            mapList.putIfAbsent(baseEntityId, new HashSet(16));
            Set set = (Set)mapList.get(baseEntityId);
            set.add(proName);
            allF7EntityProMap.put(proName, baseEntityId);
        }
        return allF7EntityProMap;
    }

    @Override
    public Set<String> getRelBaseEntityBlackList() {
        HashSet<String> retSet = new HashSet<String>(16);
        CommonServiceImpl commonService = new CommonServiceImpl("hrdt_baseconfig");
        QFilter blackListNumFilter = new QFilter("number", "=", (Object)"hrdt_configitems");
        Map mapFromCacheDyn = commonService.getMapFromCache("id,number,value", new QFilter[]{blackListNumFilter});
        if (ObjectUtils.isEmpty((Object)mapFromCacheDyn)) {
            return retSet;
        }
        for (DynamicObject blackDyn : mapFromCacheDyn.values()) {
            String confValue = blackDyn.getString("value");
            if (HRStringUtils.isEmpty((String)confValue)) continue;
            HashSet<String> finalRetSet = retSet;
            Arrays.stream(confValue.split(",")).forEach(be -> finalRetSet.add(be.trim()));
        }
        return retSet;
    }

    private Long idToLong(Object obj) {
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).longValue();
        }
        if (obj instanceof String) {
            return Long.parseLong(obj.toString());
        }
        return (Long)obj;
    }

    public DynamicObject[] loadBaseDataFromDB(String entityType, List<Long> idList, List<String> numberList) {
        LOG.info("loadBaseDataFromDB,entityType={},idList={},numberList={}", new Object[]{entityType, SerializationUtils.toJsonString(idList), SerializationUtils.toJsonString(numberList)});
        if (entityType == null || ObjectUtils.isEmpty(idList)) {
            return null;
        }
        String selectedProperties = "id";
        CommonServiceImpl serviceHelper = new CommonServiceImpl(entityType);
        BasedataEntityType dataEntityType = (BasedataEntityType)MetadataUtils.getMainEntityType((String)entityType);
        QFilter filter = new QFilter("id", "in", idList);
        if (this.entityContainsNumber(dataEntityType)) {
            selectedProperties = selectedProperties + ",number";
            if (!ObjectUtils.isEmpty(numberList)) {
                filter.or(new QFilter("number", "in", numberList));
            }
        }
        LOG.info("loadBaseDataFromDB,filter={}", (Object)filter);
        return serviceHelper.query(selectedProperties, new QFilter[]{filter});
    }

    public boolean entityContainsNumber(BasedataEntityType dataEntityType) {
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        IDataEntityProperty numberProp = (IDataEntityProperty)properties.get((Object)"number");
        return Objects.nonNull(numberProp) && HRStringUtils.isNotEmpty((String)numberProp.getAlias());
    }

    @Override
    public Map<Long, Boolean> getEntityOrgCtrInfo(String entityKey, Set<Long> orgIds) {
        HashMap<Long, Boolean> retMap = new HashMap<Long, Boolean>(16);
        if (HRStringUtils.isEmpty((String)entityKey) || ObjectUtils.isEmpty(orgIds)) {
            return retMap;
        }
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityKey);
        if (ctrlView == null) {
            return retMap;
        }
        LOG.info("ConfigItemDomainServiceImpl.getEntityOrgCtrInfo,entityKey={},orgIds={}", (Object)entityKey, (Object)SerializationUtils.toJsonString(orgIds));
        Set<Long> orgIdSet = this.getCuOrgIds(ctrlView, new ArrayList<Object>(orgIds));
        orgIdSet.forEach(orgId -> retMap.put((Long)orgId, Boolean.TRUE));
        orgIds.forEach(orgId -> retMap.putIfAbsent((Long)orgId, Boolean.FALSE));
        return retMap;
    }

    @Override
    public boolean isCtrEntity(String entityKey) {
        Boolean ctrEntity = this.ctrlEntityMap.get(entityKey);
        if (ctrEntity != null) {
            return ctrEntity;
        }
        ctrEntity = BaseDataServiceHelper.checkBaseDataCtrl((String)entityKey);
        this.ctrlEntityMap.put(entityKey, ctrEntity);
        return ctrEntity;
    }

    private Set<Long> getCuOrgIds(DynamicObject ctrlView, List<Object> orgIds) {
        Long viewId = (Long)ctrlView.getPkValue();
        LOG.info("ConfigItemDomainServiceImpl.getCuOrgIds,viewId={},viewName=", (Object)viewId, (Object)ctrlView.getString("name"));
        SqlBuilder builder = new SqlBuilder();
        builder.append("select forgid from t_org_structure where fviewid = ", new Object[0]).append(viewId.toString(), new Object[0]);
        builder.append(" and fisctrlunit = '1' and ", new Object[0]);
        builder.appendIn("forgid", orgIds);
        return (Set)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)builder, resultSet -> {
            HashSet<Long> result = new HashSet<Long>(16);
            while (resultSet.next()) {
                result.add(resultSet.getLong("forgid"));
            }
            return result;
        });
    }

    @Override
    public DynamicObjectCollection getChildrenDynamicObject(Object[] ids, BasedataEntityType entityType) {
        ORM orm = ORM.create();
        String number = entityType.getNumberProperty();
        if (entityType.getProperty("longnumber") == null) {
            return null;
        }
        String entityName = entityType.getName();
        String selectFields = "id,longnumber,parent.longnumber," + number + ",enable";
        String orderBy = "longnumber desc";
        int dbType = entityType.getPrimaryKey().getDbType();
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = DbTypeConverter.safeConvert((int)dbType, (Object)ids[i]);
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)ids)};
        DynamicObjectCollection collection = orm.query(entityName, selectFields, filters, orderBy);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)collection.get(i);
            if (dynamicObject.getString("longnumber") == null || "".equals(dynamicObject.getString("longnumber").trim())) continue;
            list.add(dynamicObject.getString("longnumber"));
        }
        selectFields = "id,longnumber,parent.longnumber," + number + ",enable";
        ParentBasedataProp parentProp = null;
        DataEntityPropertyCollection props = entityType.getProperties();
        for (IDataEntityProperty prop : props) {
            if (!(prop.getParent() instanceof MainEntityType) || !(prop instanceof ParentBasedataProp)) continue;
            parentProp = (ParentBasedataProp)prop;
            break;
        }
        String longNumberDLM = ".";
        if (parentProp != null) {
            longNumberDLM = parentProp.getLongNumberDLM();
        }
        QFilter baseQfilter = new QFilter("id", "in", (Object)ids);
        if (ids.length > 1000) {
            return collection;
        }
        for (int i = 0; i < list.size(); ++i) {
            baseQfilter.or(new QFilter("longnumber", "like", (Object)((String)list.get(i) + longNumberDLM + "%")));
        }
        return list.isEmpty() ? collection : orm.query(entityName, selectFields, new QFilter[]{baseQfilter}, orderBy);
    }

    @Override
    public JSONObject delSysConfigTrees(List<Long> idList) {
        JSONObject result = new JSONObject();
        try {
            LOG.info("delSysConfigTrees,idList={}", (Object)SerializationUtils.toJsonString(idList));
            result = (JSONObject)HRMServiceHelper.invokeBizService((String)"imsc", (String)"ricc", (String)"configItemService", (String)"delConfigTrees", (Object[])new Object[]{idList});
            if (!HRStringUtils.equals((String)result.getString("success"), (String)"true")) {
                return result;
            }
        }
        catch (Exception e) {
            LOG.error("delSysConfigTrees error:", (Throwable)e);
            result.put("msg", (Object)e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FormShowParameter getDelConfGroupFormShowParameter(Map<Long, Object> delDataMap, OperationResult curOperationResult, String operateName, Map<Long, Object> syncDelSysGroupFailMap) {
        void var10_17;
        List successPkIds = curOperationResult.getSuccessPkIds();
        int totalBillCount = curOperationResult.getBillCount();
        HashMap<Long, OperateErrorInfo> curResultFailMap = new HashMap<Long, OperateErrorInfo>(16);
        if (curOperationResult.getValidateResult() != null && curOperationResult.getValidateResult().getValidateErrors() != null) {
            for (ValidateResult res : curOperationResult.getValidateResult().getValidateErrors()) {
                List list = res.getAllErrorInfo();
                if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
                for (OperateErrorInfo info : list) {
                    curResultFailMap.put(Long.parseLong(info.getPkValue().toString()), info);
                }
            }
        }
        for (Map.Entry<Long, Object> sysGroupFailEntry : syncDelSysGroupFailMap.entrySet()) {
            Map map = (Map)sysGroupFailEntry.getValue();
            String errorCode = (String)map.get("errorCode");
            if ("notExistRecords".equals(errorCode)) continue;
            ++totalBillCount;
        }
        StringBuilder failMsgSb = new StringBuilder();
        for (Map.Entry entry : delDataMap.entrySet()) {
            Long pkId = (Long)entry.getKey();
            Object sysDelSysGroupObj = syncDelSysGroupFailMap.get(pkId);
            OperateErrorInfo curOperateErrorInfo = (OperateErrorInfo)curResultFailMap.get(pkId);
            if (sysDelSysGroupObj != null && curOperateErrorInfo == null) {
                Map sysSyncFailMsgMap = (Map)sysDelSysGroupObj;
                String errorCode = (String)sysSyncFailMsgMap.get("errorCode");
                if ("notExistRecords".equals(errorCode)) continue;
                String sysSyncErrorMsg = (String)sysSyncFailMsgMap.get("errorMsg");
                failMsgSb.append(sysSyncErrorMsg).append("\r\n");
                continue;
            }
            if (curOperateErrorInfo == null) continue;
            String curOpErrMsg = curOperateErrorInfo.getMessage();
            failMsgSb.append(curOpErrMsg).append("\r\n");
        }
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(false);
        parameters.setCustomParam("operateName", (Object)operateName);
        parameters.setCustomParam("errorMsg", (Object)failMsgSb);
        int successCount = successPkIds.size();
        int validError = totalBillCount - successCount;
        if (validError > 0) {
            String string = String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u5206\u7ec4\uff0c%2$s\u6210\u529f%3$s\u6761\uff0c\u5931\u8d25%4$s\u6761", (String)"ConfigItemDomainServiceImpl_4", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]), totalBillCount, kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)operateName) ? "" : operateName, successCount, validError);
        } else {
            String string = String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u5206\u7ec4\uff0c%2$s\u6210\u529f%3$s\u6761", (String)"ConfigItemDomainServiceImpl_5", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]), totalBillCount, kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)operateName) ? "" : operateName, successCount);
        }
        parameters.setCustomParam("title", (Object)var10_17);
        return parameters;
    }

    @Override
    public Set<Long> queryNotSyncConfigNumber() {
        QFilter configItemFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] configItemDynArr = configItemEntityService.query("id,number,group", new QFilter[]{configItemFilter});
        Set<Long> configItemIds = Arrays.asList(configItemDynArr).stream().map(a -> a.getLong("id")).collect(Collectors.toSet());
        ArrayList<Long> groupIdList = new ArrayList<Long>(configItemDynArr.length);
        for (DynamicObject object : configItemDynArr) {
            groupIdList.add(object.getLong("group.id"));
        }
        QFilter ricConfigFilter = new QFilter("group", "in", groupIdList);
        CommonServiceImpl helper = new CommonServiceImpl("ricc_configitems");
        String fields = "id,number,name,group";
        QFilter[] filters = new QFilter[]{configItemFilter, ricConfigFilter};
        DynamicObject[] dynamicObjects = helper.query(fields, filters);
        Set ricConfigIds = Arrays.asList(dynamicObjects).stream().map(a -> a.getLong("id")).collect(Collectors.toSet());
        configItemIds.removeAll(ricConfigIds);
        return configItemIds;
    }

    @Override
    public int queryExtendConfigNumber() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter sysPresetsFilter = new QFilter("issyspreset", "=", (Object)Character.valueOf('0'));
        DynamicObject[] configItemDynArr = configItemEntityService.query("id,number", new QFilter[]{enableFilter, sysPresetsFilter});
        return configItemDynArr.length;
    }

    @Override
    public int queryPresetConfigNumber() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter sysPresetsFilter = new QFilter("issyspreset", "=", (Object)Character.valueOf('1'));
        DynamicObject[] configItemDynArr = configItemEntityService.query("id,number", new QFilter[]{enableFilter, sysPresetsFilter});
        return configItemDynArr.length;
    }
}

