/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.domain.workbench.impl;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.domain.workbench.IToolDetailDomainService;
import kd.hdtc.hrdt.business.domain.workbench.entity.IComToolRecordEntityService;
import kd.hdtc.hrdt.business.domain.workbench.entity.IToolDetailEntityService;
import kd.hr.hbp.common.util.HRObjectUtils;

public class ToolDetailDomainServiceImpl
implements IToolDetailDomainService {
    private static final String DEFAULT_PROPERTIES = "id, number, toolpageaddr, tooldetailtype, name, description, enable, index, issyspreset, status";
    private static final String RECORD_PROPERTIES = "id, user, workbenchrole, tool, count, issyspreset, creator, createtime, modifier,modifytime";
    private static final int INIT_COUNT = 1;
    private IToolDetailEntityService toolDetailEntityService = ServiceFactory.getService(IToolDetailEntityService.class);
    private IComToolRecordEntityService comToolRecordEntityService = ServiceFactory.getService(IComToolRecordEntityService.class);

    @Override
    public DynamicObject[] queryByIds(List<Long> toolIds) {
        return this.toolDetailEntityService.query(DEFAULT_PROPERTIES, toolIds.toArray());
    }

    @Override
    public DynamicObject[] queryAllTools() {
        return this.toolDetailEntityService.query(DEFAULT_PROPERTIES, new QFilter[]{QFilterConstants.Q_ENABLE});
    }

    @Override
    public DynamicObject[] queryCommonTools(Long userId, Long workBenchRoleId) {
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        userFilter.and(new QFilter("workbenchrole", "=", (Object)workBenchRoleId));
        QFilter workBenchRoleFilter = new QFilter("workbenchrole", "=", (Object)workBenchRoleId);
        workBenchRoleFilter.and(new QFilter("issyspreset", "=", (Object)Boolean.TRUE));
        return this.comToolRecordEntityService.query("tool", new QFilter[]{userFilter.or(workBenchRoleFilter)}, "count desc");
    }

    @Override
    public void saveOrUpdateCommonTool(Long userId, Long workBenchRoleId, Long toolId) {
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        QFilter workBenchRoleFilter = new QFilter("workbenchrole", "=", (Object)workBenchRoleId);
        QFilter toolFilter = new QFilter("tool", "=", (Object)toolId);
        DynamicObject comToolRecord = this.comToolRecordEntityService.queryOne(RECORD_PROPERTIES, new QFilter[]{userFilter, workBenchRoleFilter, toolFilter});
        if (HRObjectUtils.isEmpty((Object)comToolRecord)) {
            comToolRecord = this.comToolRecordEntityService.generateEmptyDynamicObject();
            comToolRecord.set("id", (Object)ORM.create().genLongId("hrdt_comtoolrecord"));
            comToolRecord.set("user", (Object)userId);
            comToolRecord.set("workbenchrole", (Object)workBenchRoleId);
            DynamicObject toolDynamicObject = this.toolDetailEntityService.generateEmptyDynamicObject();
            toolDynamicObject.set("id", (Object)toolId);
            comToolRecord.set("tool", (Object)toolId);
            comToolRecord.set("count", (Object)1);
            comToolRecord.set("creator", (Object)userId);
            comToolRecord.set("createtime", (Object)new Date());
        } else {
            comToolRecord.set("count", (Object)(comToolRecord.getInt("count") + 1));
            comToolRecord.set("modifier", (Object)userId);
            comToolRecord.set("modifytime", (Object)new Date());
        }
        this.comToolRecordEntityService.save(comToolRecord);
    }
}

