/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.domain.workbench.impl;

import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.domain.workbench.IWorkBenchRoleDomainService;
import kd.hdtc.hrdt.business.domain.workbench.entity.IWorkBenchRoleEntityService;
import kd.hdtc.hrdt.business.domain.workbench.entity.IWorkBenchRoleRecordEntityService;
import kd.hr.hbp.common.util.HRObjectUtils;

public class WorkBenchRoleDomainServiceImpl
implements IWorkBenchRoleDomainService {
    private static final String DEFAULT_PROPERTIES = "id, number, name, description, enable, index, issyspreset, status";
    private IWorkBenchRoleEntityService workBenchRoleEntityService = ServiceFactory.getService(IWorkBenchRoleEntityService.class);
    private IWorkBenchRoleRecordEntityService workBenchRoleRecordEntityService = ServiceFactory.getService(IWorkBenchRoleRecordEntityService.class);

    @Override
    public DynamicObject[] queryAllWorkBenchRole() {
        return this.workBenchRoleEntityService.query(DEFAULT_PROPERTIES, new QFilter[]{QFilterConstants.Q_ENABLE}, "number asc");
    }

    @Override
    public DynamicObject queryCurrentRoleByUserId(Long userId) {
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        DynamicObject workBenchRoleRecord = this.workBenchRoleRecordEntityService.queryOne("workbenchrole", new QFilter[]{userFilter});
        if (HRObjectUtils.isEmpty((Object)workBenchRoleRecord)) {
            return null;
        }
        return workBenchRoleRecord.getDynamicObject("workbenchrole");
    }

    @Override
    public DynamicObject queryWorkBenchRole(Long workBenchRoleId) {
        DynamicObject[] allWorkBenchRole = this.queryAllWorkBenchRole();
        if (allWorkBenchRole != null && allWorkBenchRole.length > 0) {
            Map<Long, DynamicObject> dynamicObjectMap = Arrays.stream(allWorkBenchRole).collect(Collectors.toMap(workBenchRole -> workBenchRole.getLong("id"), work -> work));
            if (!HRObjectUtils.isEmpty((Object)dynamicObjectMap.get(workBenchRoleId))) {
                return dynamicObjectMap.get(workBenchRoleId);
            }
            return allWorkBenchRole[0];
        }
        return null;
    }

    @Override
    public void saveOrUpdateCurrentRole(Long userId, Long workBenchRoleId) {
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        DynamicObject workBenchRoleRecord = this.workBenchRoleRecordEntityService.queryOne("id, user, workbenchrole, modifier, modifytime,creator,createtime", new QFilter[]{userFilter});
        if (HRObjectUtils.isEmpty((Object)workBenchRoleRecord)) {
            workBenchRoleRecord = this.workBenchRoleRecordEntityService.generateEmptyDynamicObject();
            workBenchRoleRecord.set("id", (Object)ORM.create().genLongId("hrdt_wbrolerecord"));
            workBenchRoleRecord.set("workbenchrole", (Object)workBenchRoleId);
            workBenchRoleRecord.set("user", (Object)userId);
            workBenchRoleRecord.set("creator", (Object)userId);
            workBenchRoleRecord.set("createtime", (Object)new Date());
        } else {
            workBenchRoleRecord.set("workbenchrole", (Object)workBenchRoleId);
            workBenchRoleRecord.set("modifier", (Object)userId);
            workBenchRoleRecord.set("modifytime", (Object)new Date());
        }
        this.workBenchRoleRecordEntityService.save(workBenchRoleRecord);
    }
}

