/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.domain.workbench.impl;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.domain.workbench.IWorkItemSetDomainService;
import kd.hdtc.hrdt.business.domain.workbench.entity.IWorkItemEntityService;
import kd.hdtc.hrdt.business.domain.workbench.entity.IWorkItemSetEntityService;
import kd.hr.hbp.common.util.HRObjectUtils;

public class WorkItemSetDomainServiceImpl
implements IWorkItemSetDomainService {
    private static final String DEFAULT_PROP = "id, number, name, index, description, workbenchrole, vectorapvalue, entryentity";
    private static final String DEFAULT_WORK_ITEM_PROP = "id, number, name, index, description, tentryentity.tool, kentryentity.knowledge";
    private static final String DEFAULT_ORDER_BY = "index asc";
    private IWorkItemSetEntityService workItemSetEntityService = ServiceFactory.getService(IWorkItemSetEntityService.class);
    private IWorkItemEntityService workItemEntityService = ServiceFactory.getService(IWorkItemEntityService.class);

    @Override
    public List<DynamicObject> queryWorkItemSetList(Long workBenchRoleId, Integer limit) {
        QFilter workBenchRoleFilter = new QFilter("workBenchRole.FBasedataId", "=", (Object)workBenchRoleId);
        DynamicObject[] workItemSetCollection = this.workItemSetEntityService.query(DEFAULT_PROP, new QFilter[]{workBenchRoleFilter, QFilterConstants.Q_ENABLE}, DEFAULT_ORDER_BY);
        List<DynamicObject> workItemSetList = null;
        if (workItemSetCollection != null) {
            workItemSetList = Arrays.asList(workItemSetCollection);
        }
        if (limit != null && workItemSetList != null && workItemSetList.size() > limit) {
            return workItemSetList.subList(0, limit);
        }
        return workItemSetList;
    }

    @Override
    public Map<Long, List<DynamicObject>> queryWorkItemMap(List<Long> workItemSetIds) {
        QFilter idFilter = new QFilter("id", "in", workItemSetIds);
        DynamicObject[] workItemSets = this.workItemSetEntityService.query("id, name, number, entryentity.workitem", new QFilter[]{idFilter, QFilterConstants.Q_ENABLE});
        if (HRObjectUtils.isEmpty((Object)workItemSets)) {
            return null;
        }
        HashMap workItemSetMap = Maps.newHashMapWithExpectedSize((int)workItemSets.length);
        ArrayList allWorkItemIds = new ArrayList();
        HashMap workItemSetIdMap = Maps.newHashMapWithExpectedSize((int)workItemSets.length);
        for (DynamicObject workItemSet : workItemSets) {
            DynamicObjectCollection workItemCollection = workItemSet.getDynamicObjectCollection("entryentity");
            List workItemIds = null;
            if (!HRObjectUtils.isEmpty((Object)workItemCollection)) {
                workItemIds = workItemCollection.stream().map(workItem -> workItem.getDynamicObject("workitem").getLong("id")).collect(Collectors.toList());
                allWorkItemIds.addAll(workItemIds);
            }
            workItemSetIdMap.put(workItemSet.getLong("id"), workItemIds);
        }
        QFilter workItemIdsFilter = new QFilter("id", "in", allWorkItemIds);
        DynamicObject[] workItems = this.workItemEntityService.query(DEFAULT_WORK_ITEM_PROP, new QFilter[]{workItemIdsFilter, QFilterConstants.Q_ENABLE});
        if (HRObjectUtils.isEmpty((Object)workItems)) {
            return workItemSetMap;
        }
        Map<Long, DynamicObject> workItemMap = Arrays.stream(workItems).collect(Collectors.toMap(item -> item.getLong("id"), workItem -> workItem));
        for (Map.Entry workItemSetId : workItemSetIdMap.entrySet()) {
            ArrayList<DynamicObject> workItemList = new ArrayList<DynamicObject>();
            List workItemIds = (List)workItemSetId.getValue();
            if (CollectionUtils.isNotEmpty((Collection)workItemIds)) {
                for (Long workItemId : workItemIds) {
                    if (HRObjectUtils.isEmpty((Object)workItemMap.get(workItemId))) continue;
                    workItemList.add(workItemMap.get(workItemId));
                }
            }
            workItemSetMap.put(workItemSetId.getKey(), workItemList);
        }
        return workItemSetMap;
    }
}

