/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrip.business.common.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.entity.AppMenuInfo;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrip.business.common.model.homePage.AppMenuInfoTreeBo;

public class AppMenusUtils {
    private static final int MAX_LEVEL = 2;

    public static List<AppMenuInfoTreeBo> getAppMenuTreeDataByAppId(String appId, List<AppMenuInfo> allMenuList) {
        if (StringUtils.isEmpty((String)appId)) {
            return null;
        }
        if (CollectionUtils.isEmpty(allMenuList)) {
            return null;
        }
        ArrayList<AppMenuInfoTreeBo> dataDealBoList = new ArrayList<AppMenuInfoTreeBo>(allMenuList.size());
        allMenuList.stream().forEach(data -> dataDealBoList.add(AppMenuInfoTreeBo.buildObjectByAppMenuInfo(data)));
        AppMenusUtils.dealToParent(appId, appId, dataDealBoList, 1);
        List<AppMenuInfoTreeBo> resultDataDealBoList = dataDealBoList.stream().filter(data -> StringUtils.equals((String)appId, (String)data.getParentId())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(resultDataDealBoList)) {
            for (AppMenuInfoTreeBo appMenuInfoTreeBo : resultDataDealBoList) {
                List<AppMenuInfoTreeBo> children = appMenuInfoTreeBo.getChildren();
                if (!CollectionUtils.isEmpty(children)) continue;
                children.add(AppMenuInfoTreeBo.buildObjectByAppMenuInfo(appMenuInfoTreeBo));
            }
        }
        return resultDataDealBoList;
    }

    private static List<AppMenuInfoTreeBo> dealToParent(String appId, String parentId, List<AppMenuInfoTreeBo> menuList, int level) {
        Map<String, AppMenuInfoTreeBo> menuMap = menuList.stream().collect(Collectors.toMap(AppMenuInfo::getId, data -> data, (v1, v2) -> v2));
        List<AppMenuInfoTreeBo> deapChildren = null;
        for (AppMenuInfoTreeBo menu : menuList) {
            if (!StringUtils.equals((String)parentId, (String)menu.getParentId())) continue;
            menuList.stream().sorted(Comparator.comparing(AppMenuInfo::getSeq));
            if (StringUtils.equals((String)appId, (String)parentId)) {
                AppMenusUtils.dealToParent(appId, menu.getId(), menuList, ++level);
                continue;
            }
            AppMenuInfoTreeBo parentMenu = menuMap.get(parentId);
            if (parentMenu == null) continue;
            List<AppMenuInfoTreeBo> children = parentMenu.getChildren();
            List<AppMenuInfoTreeBo> deapChildrenData = AppMenusUtils.dealToParent(appId, menu.getId(), menuList, ++level);
            if (CollectionUtils.isNotEmpty(deapChildrenData)) {
                deapChildrenData.stream().sorted(Comparator.comparing(AppMenuInfo::getSeq));
                children.addAll(deapChildrenData);
            } else {
                children.add(menu);
            }
            if (level < 2) continue;
            deapChildren = children;
        }
        return deapChildren;
    }
}

