/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrip.business.common.util;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import kd.bos.bill.BillShowParameter;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.list.ListShowParameter;
import kd.bos.portal.util.OpenPageUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class OpenUrlUtils {
    private static final String CURRENT_ENV = "${current_env.}";
    private static final String APP = "app";
    private static final String APP_MAIN_NUMBER = "appmainnumber";
    private static final String RIGHT_APP = "rightapp";
    private static final String SUB_MAIN_TAB = "_submaintab_";

    public static void openAppMenuInfo(AppMenuInfo menu, IFormView view) {
        if (menu == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("view", view);
        map.put("formnumber", menu.getFormId());
        map.put("parametertype", menu.getParamType());
        map.put("parameter", JSON.parseObject((String)menu.getParams()));
        map.put("menuname", menu.getName());
        map.put("openType", menu.getOpenType());
        map.put("permItem", menu.getPermission());
        OpenPageUtils.openApp((String)menu.getAppId(), null, null, (IFormView)view);
        OpenPageUtils.openApp((String)menu.getAppId(), (String)menu.getId(), map, (IFormView)view);
    }

    public static void openApp(String appNumber, IFormView view) {
        if (StringUtils.isEmpty((String)appNumber)) {
            return;
        }
        OpenPageUtils.openApp((String)appNumber, null, null, (IFormView)view);
    }

    public static void openLink(IFormView view, String urlStr, Function<Object, Object> func) {
        if ((urlStr = urlStr.toLowerCase(Locale.ROOT)).contains(CURRENT_ENV)) {
            Map urlParam = Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)urlStr.substring(urlStr.indexOf(63) + 1));
            OpenUrlUtils.openPageInAppView(view, urlParam, func);
        } else {
            view.openUrl(urlStr);
        }
    }

    private static void openPageInAppView(IFormView view, Map<String, String> urlParam, Function<Object, Object> func) {
        String type = urlParam.get("type");
        String appId = urlParam.get(APP);
        if (APP.equals(type)) {
            if (StringUtils.isNotEmpty((String)appId)) {
                OpenUrlUtils.openApp(appId, view);
            }
        } else if ("menu".equals(type)) {
            String menuId = String.valueOf(urlParam.get("menuid"));
            if (StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)menuId)) {
                return;
            }
            AppMenuInfo menuInfo = AppMetadataCache.getAppMenuInfoByAppNumAndMenuId((String)appId, (String)menuId);
            if (menuInfo != null) {
                OpenUrlUtils.openAppMenuInfo(menuInfo, view);
            }
        } else {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)urlParam.get("billformid"));
            String openAppId = appId == null ? dataEntityType.getAppId() : appId;
            OpenPageUtils.openAppAndPage((String)openAppId, null, OpenUrlUtils.getParamMap(view, openAppId), (IFormView)view);
            if ("list".equals(type)) {
                OpenUrlUtils.openPageWhenAppPageOpen(view, openAppId, urlParam, func);
            } else if ("form".equals(type)) {
                OpenUrlUtils.openPageWhenAppFormPageOpen(view, openAppId, urlParam);
            }
        }
    }

    private static Map<String, Object> getParamMap(IFormView view, String openAppId) {
        AppInfo app = AppMetadataCache.getAppInfo((String)openAppId);
        HashMap paramMap = Maps.newHashMap();
        String appName = HRStringUtils.isNotEmpty((String)app.getName().getLocaleValue()) ? app.getName().getLocaleValue() : app.getNumber();
        paramMap.put("view", view);
        paramMap.put("appname", appName);
        paramMap.put(APP_MAIN_NUMBER, app.getHomeNum());
        return paramMap;
    }

    public static void openPageWhenAppFormPageOpen(IFormView view, String openAppId, Map<String, String> urlParam) {
        OpenUrlUtils.openPageWhenAppFormPageOpenMul(view, openAppId, urlParam, null);
    }

    private static void openPageWhenAppFormPageOpenMul(IFormView view, String openAppId, Map<String, String> urlParam, String targetKey) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)urlParam.get("billformid"));
        String checkRightAppId = urlParam.get(RIGHT_APP) == null ? openAppId : urlParam.get(RIGHT_APP);
        String formPageId = openAppId + urlParam.get("billformid") + urlParam.get("formid") + view.getPageId();
        IFormView appPageView = null;
        if (view.getMainView() != null) {
            appPageView = view.getMainView().getView(openAppId + view.getMainView().getPageId());
        }
        if (appPageView != null) {
            Tab subTab = (Tab)appPageView.getControl(SUB_MAIN_TAB);
            for (Control item : subTab.getItems()) {
                if (!item.getKey().startsWith(formPageId)) continue;
                subTab.activeTab(item.getKey());
                view.sendFormAction(appPageView);
                return;
            }
        }
        BillShowParameter show = new BillShowParameter();
        show.setFormId(urlParam.get("formid"));
        show.setAppId(openAppId);
        if (view.getMainView() != null) {
            show.setRootPageId(view.getMainView().getPageId());
            show.setParentPageId(openAppId + view.getMainView().getPageId());
        }
        show.setCustomParam("checkRightAppId", (Object)checkRightAppId);
        show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (StringUtils.isNotEmpty((String)targetKey)) {
            show.getOpenStyle().setShowType(ShowType.InContainer);
            show.getOpenStyle().setTargetKey(targetKey);
        }
        show.setPageId(formPageId + kd.bos.util.StringUtils.randomNumber((int)16));
        String caption = dataEntityType.getDisplayName().getLocaleValue();
        show.setCaption(caption);
        view.showForm((FormShowParameter)show);
    }

    public static void openPageWhenAppPageOpen(IFormView view, String openAppId, Map<String, String> urlParam, Function<Object, Object> func) {
        OpenUrlUtils.openPageWhenAppPageOpenMul(view, openAppId, urlParam, null, func);
    }

    private static void openPageWhenAppPageOpenMul(IFormView view, String openAppId, Map<String, String> urlParam, String targetKey, Function<Object, Object> func) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)urlParam.get("billformid"));
        String checkRightAppId = urlParam.get(RIGHT_APP) == null ? openAppId : urlParam.get(RIGHT_APP);
        String formPageId = openAppId + urlParam.get("billformid") + urlParam.get("formid") + view.getPageId();
        IFormView appPageView = null;
        if (view.getMainView() != null) {
            appPageView = view.getMainView().getView(openAppId + view.getMainView().getPageId());
        }
        if (appPageView != null) {
            Tab subTab = (Tab)appPageView.getControl(SUB_MAIN_TAB);
            for (Control item : subTab.getItems()) {
                if (!item.getKey().startsWith(formPageId)) continue;
                subTab.activeTab(item.getKey());
                view.sendFormAction(appPageView);
                return;
            }
        }
        ListShowParameter show = new ListShowParameter();
        show.setFormId(urlParam.get("formid"));
        show.setBillFormId(urlParam.get("billformid"));
        show.setAppId(openAppId);
        if (view.getMainView() != null) {
            show.setRootPageId(view.getMainView().getPageId());
            show.setParentPageId(openAppId + view.getMainView().getPageId());
        }
        show.setCustomParam("checkRightAppId", (Object)checkRightAppId);
        show.setCustomParam("parentPageId", (Object)view.getPageId());
        show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (func != null) {
            func.apply(show);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)targetKey)) {
            show.getOpenStyle().setShowType(ShowType.InContainer);
            show.getOpenStyle().setTargetKey(targetKey);
        }
        show.setPageId(formPageId + kd.bos.util.StringUtils.randomNumber((int)16));
        String caption = dataEntityType.getDisplayName().getLocaleValue();
        show.setCaption(caption);
        if (view.getFormShowParameter().getOpenStyle().getShowType().compareTo((Enum)ShowType.Modal) == 0) {
            view.getFormShowParameter().getOpenStyle().setShowType(ShowType.MainNewTabPage);
        }
        view.showForm((FormShowParameter)show);
    }
}

