/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrip.business.domain.common.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ObjectUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrip.business.common.ServiceFactory;
import kd.hdtc.hrip.business.common.model.homePage.AppMenuInfoTreeBo;
import kd.hdtc.hrip.business.common.model.homePage.HomePageAppInfoBo;
import kd.hdtc.hrip.business.common.model.homePage.HomePageHotMenuBo;
import kd.hdtc.hrip.business.common.util.AppMenusUtils;
import kd.hdtc.hrip.business.domain.common.IHomePageAppInfoDomainService;
import kd.hdtc.hrip.business.entity.common.IHomePageAppInfoEntityService;

public class HomePageAppInfoDomainServiceImpl
implements IHomePageAppInfoDomainService {
    private final IHomePageAppInfoEntityService homePageAppInfoEntityService = ServiceFactory.getService(IHomePageAppInfoEntityService.class);

    @Override
    public DynamicObject[] getAllEnableData() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return this.homePageAppInfoEntityService.loadDynamicObjectArray(new QFilter[]{enableFilter});
    }

    @Override
    public List<HomePageAppInfoBo> getAllEnableBoData() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        Object[] arr = this.homePageAppInfoEntityService.loadDynamicObjectArray(new QFilter[]{enableFilter});
        if (ObjectUtils.isEmpty((Object[])arr)) {
            return null;
        }
        List dynList = Arrays.stream(arr).sorted(Comparator.comparing(dyn -> dyn.getInt("index"))).collect(Collectors.toList());
        ArrayList<HomePageAppInfoBo> homePageAppInfoBoList = new ArrayList<HomePageAppInfoBo>(dynList.size());
        for (DynamicObject dyn2 : dynList) {
            HomePageAppInfoBo homePageAppInfoBo = new HomePageAppInfoBo();
            DynamicObject appDyn = dyn2.getDynamicObject("app");
            if (appDyn == null) continue;
            String appId = appDyn.getString("id");
            homePageAppInfoBo.setAppId(appId);
            homePageAppInfoBo.setAppNumber(appDyn.getString("number"));
            homePageAppInfoBo.setAppName(appDyn.getString("name"));
            homePageAppInfoBo.setKnowledge(dyn2.getString("knowledge"));
            homePageAppInfoBo.setDescription(dyn2.getString("description"));
            homePageAppInfoBo.setIcon(dyn2.getString("icon"));
            List allMenuList = AppMetadataCache.getAppMenusInfoByAppId((String)appId);
            if (CollectionUtils.isEmpty((Collection)allMenuList)) continue;
            List<AppMenuInfoTreeBo> menuTreeList = AppMenusUtils.getAppMenuTreeDataByAppId(appId, allMenuList);
            homePageAppInfoBo.setHomePageMenuList(menuTreeList);
            DynamicObjectCollection hotMenuCollection = dyn2.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isNotEmpty((Collection)hotMenuCollection)) {
                ArrayList<HomePageHotMenuBo> homePageHotMenuList = new ArrayList<HomePageHotMenuBo>(hotMenuCollection.size());
                Map<String, AppMenuInfo> appMenuMap = allMenuList.stream().collect(Collectors.toMap(AppMenuInfo::getId, data -> data, (v1, v2) -> v2));
                for (DynamicObject hotMenu : hotMenuCollection) {
                    AppMenuInfo appMenuInfo;
                    String menuId = hotMenu.getString("menu");
                    if (StringUtils.isEmpty((String)menuId) || (appMenuInfo = appMenuMap.get(menuId)) == null) continue;
                    HomePageHotMenuBo homePageHotMenuBo = HomePageHotMenuBo.buildObjectByAppMenuInfo(appMenuInfo);
                    homePageHotMenuBo.setMenuDesc(hotMenu.getString("menuDesc"));
                    homePageHotMenuBo.setEffectInfo(hotMenu.getString("effectInfo"));
                    homePageHotMenuBo.setGuide(hotMenu.getString("guide"));
                    homePageHotMenuList.add(homePageHotMenuBo);
                }
                homePageAppInfoBo.setHomePageHotMenuList(homePageHotMenuList);
            }
            homePageAppInfoBoList.add(homePageAppInfoBo);
        }
        return homePageAppInfoBoList;
    }
}

