/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrip.formplugin.web.common.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hdtc.hrip.business.common.model.homePage.AppMenuInfoTreeBo;
import kd.hdtc.hrip.business.common.util.AppMenusUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class HomeAppInfoEditPlugin
extends HDTCDataBaseEdit
implements CellClickListener {
    private static final String APP = "app";
    private static final String MENU = "menu";
    private static final String CACHE_SUF = "MENU_";

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.renderMenuData();
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String propertyName;
        switch (propertyName = propertyChangedArgs.getProperty().getName()) {
            case "app": {
                this.clearEntry();
            }
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    public void cellClick(CellClickEvent evt) {
        String fieldKey = evt.getFieldKey();
        if (HRStringUtils.equals((String)fieldKey, (String)MENU)) {
            this.renderMenuData();
        }
    }

    private void renderMenuData() {
        String appId = this.getModel().getDataEntity().getString("app.id");
        if (StringUtils.isNotEmpty((String)appId)) {
            List<ComboItem> items = this.getMenuFromCache(appId);
            ComboEdit keyFieldEdit = (ComboEdit)this.getControl(MENU);
            keyFieldEdit.setComboItems(items);
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    private void clearEntry() {
        this.getModel().deleteEntryData("entryentity");
    }

    private void buildMenu(List<AppMenuInfoTreeBo> appMenu, List<ComboItem> itemList, StringBuilder parentName, String appId) {
        for (AppMenuInfoTreeBo appMenuInfoTreeBo : appMenu) {
            if (StringUtils.equals((String)appId, (String)appMenuInfoTreeBo.getParentId())) {
                parentName = new StringBuilder();
            }
            List children = appMenuInfoTreeBo.getChildren();
            if (parentName.length() > 0) {
                parentName.append("\u2014\u2014");
            }
            parentName.append(appMenuInfoTreeBo.getName().getLocaleValue());
            if (CollectionUtils.isEmpty((Collection)children)) {
                ComboItem item = new ComboItem();
                item.setValue(appMenuInfoTreeBo.getId());
                item.setCaption(new LocaleString(parentName.toString()));
                itemList.add(item);
                continue;
            }
            this.buildMenu(children, itemList, parentName, appId);
        }
    }

    private List<ComboItem> getMenuFromCache(String appId) {
        ArrayList<ComboItem> itemList = null;
        String cacheKey = CACHE_SUF + appId;
        String info = this.getPageCache().get(cacheKey);
        if (StringUtils.isNotEmpty((String)info)) {
            itemList = (ArrayList<ComboItem>)SerializationUtils.deSerializeFromBase64((String)info);
            return itemList;
        }
        List allMenuList = AppMetadataCache.getAppMenusInfoByAppId((String)appId);
        if (CollectionUtils.isEmpty((Collection)allMenuList)) {
            return null;
        }
        List allAppMenu = AppMenusUtils.getAppMenuTreeDataByAppId((String)appId, (List)allMenuList);
        if (CollectionUtils.isEmpty((Collection)allAppMenu)) {
            return null;
        }
        itemList = new ArrayList<ComboItem>(10);
        this.buildMenu(allAppMenu, itemList, new StringBuilder(), appId);
        if (CollectionUtils.isNotEmpty(itemList)) {
            this.getPageCache().put(cacheKey, SerializationUtils.serializeToBase64(itemList));
        }
        return itemList;
    }
}

