/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.formplugin.web.apply;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.ham.business.domain.repository.bill.DispatchBillRepository;
import kd.hr.ham.business.domain.service.ServiceFactory;
import kd.hr.ham.business.domain.service.bill.IDispatchBillService;
import kd.hr.ham.business.domain.service.bill.IDispatchValidatorService;
import kd.hr.ham.business.domain.service.common.IDispatchHRCSService;
import kd.hr.ham.business.domain.service.common.IOrgAboutService;
import kd.hr.ham.business.domain.service.common.IPersonAboutService;
import kd.hr.ham.business.domain.service.validator.DyObjValidateContext;
import kd.hr.ham.business.domain.status.dto.CrossValidateParamDto;
import kd.hr.ham.common.dispatch.bean.DispatchStatusBean;
import kd.hr.ham.common.dispatch.constants.DispatchBillConstants;
import kd.hr.ham.common.dispatch.enums.DispatchInStatusEnum;
import kd.hr.ham.common.dispatch.enums.DispatchOrderEnum;
import kd.hr.ham.common.dispatch.enums.DispatchOutStatusEnum;
import kd.hr.ham.common.dispatch.enums.DispatchPageTypeEnum;
import kd.hr.ham.common.dispatch.enums.DispatchStatusEnum;
import kd.hr.ham.formplugin.web.common.DispatchBillFormCommon;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import org.apache.commons.lang3.tuple.Pair;

public class DispatchBillFormPlugin
extends HRCoreBaseBillEdit
implements DispatchBillConstants,
BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(DispatchBillFormPlugin.class);
    private static final DispatchBillFormCommon FORM_COMMON = DispatchBillFormCommon.getInstance();
    private static final IPersonAboutService PERSON_SERVICE = IPersonAboutService.getInstance();
    private static final DispatchBillFormPlugin LAMBDA_INSTANCE = new DispatchBillFormPlugin();
    private static final Map<String, BiConsumer<IFormView, ChangeData>> propMap = new HashMap<String, BiConsumer<IFormView, ChangeData>>(32);

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String propertyName = property.getName();
        ChangeData changeData = e.getChangeSet()[0];
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        BiConsumer<IFormView, ChangeData> proFun = propMap.get(propertyName);
        if (!Objects.isNull(proFun)) {
            proFun.accept(view, changeData);
        }
        if ("affactionoperation".equals(propertyName)) {
            Object affactionoperation = model.getValue("affactionoperation");
            model.setValue("affaction", affactionoperation);
            DynamicObject dataEntity = model.getDataEntity(true);
            DispatchBillFormCommon.setBizChanged(dataEntity, "affactionoperation");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addBaseF7Listen("plandepin");
        this.addBaseF7Listen("deptin");
        this.addBaseF7Listen("planpositionin");
        this.addBaseF7Listen("positionin");
    }

    private void addBaseF7Listen(String key) {
        BasedataEdit baseData = (BasedataEdit)this.getView().getControl(key);
        if (!Objects.isNull(baseData)) {
            baseData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String name = arg.getProperty().getName();
        if (HRStringUtils.equals((String)"plandepin", (String)name)) {
            long id = dataEntity.getLong("plancompanyin.id");
            this.setDeptF7Filter(arg, id);
        } else if (HRStringUtils.equals((String)"deptin", (String)name)) {
            long id = dataEntity.getLong("companyin.id");
            this.setDeptF7Filter(arg, id);
        } else if (HRStringUtils.equals((String)"planpositionin", (String)name)) {
            long id = dataEntity.getLong("plandepin.id");
            this.setPosF7Filter(arg, id);
        } else {
            long id = dataEntity.getLong("deptin.id");
            this.setPosF7Filter(arg, id);
        }
    }

    private void setDeptF7Filter(BeforeF7SelectEvent arg, long id) {
        if (id != 0L) {
            QFilter filter = new QFilter("company.id", "=", (Object)id);
            arg.getCustomQFilters().add(filter);
        }
    }

    private void setPosF7Filter(BeforeF7SelectEvent arg, long id) {
        if (id != 0L) {
            QFilter isCurFilter = new QFilter("iscurrentversion", "=", (Object)"1");
            QFilter adminFilter = new QFilter("adminorg", "=", (Object)id);
            arg.getCustomQFilters().add(isCurFilter);
            arg.getCustomQFilters().add(adminFilter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("dispatchstatus", (Object)DispatchStatusEnum.WAIT_DISPATCH.getCode());
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IDataModel model = this.getModel();
        this.getView().setVisible(Boolean.FALSE, new String[]{"dispreasonview", "disptypeview", "startdateview", "enddateview", "durationview"});
        DynamicObject dataEntity = model.getDataEntity(true);
        model.setValue("affactionoperation", model.getValue("affaction"));
        DispatchBillFormCommon.setBizChanged(dataEntity, "affactionoperation");
        BasedataEdit affactionoperation = (BasedataEdit)this.getView().getControl("affactionoperation");
        affactionoperation.setMustInput(true);
        DispatchBillFormCommon.getInstance().posPatternFieldConsumer.accept(this.getView(), "1");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus status = ((BillView)this.getView()).getStatus();
        if (!HRObjectUtils.isEmpty((Object)this.getView().getPageCache().get("view"))) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
        } else if (OperationStatus.ADDNEW != status) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
        }
        this.processDynAreaInfo();
        IFormView view = this.getView();
        DynamicObject dataEntity = view.getModel().getDataEntity();
        String auditStats = dataEntity.getString("auditstatus");
        boolean isSubmit = dataEntity.getBoolean("issubmit");
        String bizKey = (String)view.getFormShowParameter().getCustomParam("businessKey");
        boolean showAuditPanel = !isSubmit || HRStringUtils.equals((String)auditStats, (String)"A") || !HRStringUtils.isEmpty((String)bizKey);
        this.getView().setVisible(Boolean.valueOf(!showAuditPanel), new String[]{"rightpanel"});
    }

    public void afterLoadData(EventObject event) {
        IDataModel model = this.getModel();
        if (model.getValue("b_ermanfile") == null) {
            model.setValue("b_ermanfile", model.getValue("ermanfile"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        operate.getOption().setVariableValue("id", this.getView().getFormShowParameter().getFormId());
        String operateKey = operate.getOperateKey();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status != OperationStatus.ADDNEW) {
            long id = this.getModel().getDataEntity().getLong("id");
            boolean exists = DispatchBillRepository.getInstance().isExists((Object)id);
            if (!exists) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\u3002", (String)"DispatchBillFormPlugin_8", (String)"hr-ham-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if (HRStringUtils.equals((String)operateKey, (String)"submit") || HRStringUtils.equals((String)operateKey, (String)"save") || HRStringUtils.equals((String)operateKey, (String)"modify")) {
            this.opStrongCheck(this.getModel().getDataEntity(), args, operateKey);
        }
    }

    private void opStrongCheck(DynamicObject obj, BeforeDoOperationEventArgs args, String operateKey) {
        String billFormId = this.getView().getFormShowParameter().getFormId();
        DispatchPageTypeEnum dispatchPageType = DispatchPageTypeEnum.getEnumByCode((String)billFormId);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        this.setDbStatusToFormEntity(obj);
        boolean addNew = OperationStatus.ADDNEW == status;
        Map validateRes = IDispatchBillService.getInstance().batchSubmitValidate(new DynamicObject[]{obj}, dispatchPageType, operateKey, addNew, true);
        log.info("DispatchBillFormPlugin.opStrongCheck");
        for (List value : validateRes.values()) {
            boolean valRes = value.stream().anyMatch(HRStringUtils::isNotEmpty);
            log.info("billNo: {} valRes : {}", (Object)obj.getString("billno"), (Object)valRes);
            if (!valRes) continue;
            value.stream().filter(tip -> !HRStringUtils.equals((String)"ignore", (String)tip)).forEach(arg_0 -> ((IFormView)this.getView()).showErrorNotification(arg_0));
            args.setCancel(true);
        }
    }

    private void setDbStatusToFormEntity(DynamicObject obj) {
        Object[] dynamicObjects = IDispatchBillService.getInstance().queryDispatch((Object[])new Long[]{obj.getLong("id")});
        if (!HRArrayUtils.isEmpty((Object[])dynamicObjects)) {
            Object dbObj = dynamicObjects[0];
            obj.set("instatus", dbObj.get("instatus"));
            obj.set("outstatus", dbObj.get("outstatus"));
            obj.set("dispatchstatus", dbObj.get("dispatchstatus"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (HRStringUtils.equals((String)operateKey, (String)"terminate")) {
            log.info("DispatchBill terminate operationResult: {}", (Object)JSONObject.toJSONString((Object)operationResult));
            if (!operationResult.isSuccess()) {
                return;
            }
            this.terminateDispatchBill(operateKey);
        }
        if (HRStringUtils.equals((String)operateKey, (String)"submit") || HRStringUtils.equals((String)operateKey, (String)"unsubmit") || HRStringUtils.equals((String)operateKey, (String)"save")) {
            if (operationResult.isSuccess()) {
                this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
            } else {
                operationResult.setShowMessage(false);
                List errInfoList = operationResult.getAllErrorOrValidateInfo();
                for (IOperateInfo iOperateInfo : errInfoList) {
                    String message = iOperateInfo.getMessage();
                    this.getView().showErrorNotification(message);
                }
            }
        }
        if (!HRObjectUtils.isEmpty((Object)operationResult) && operationResult.isSuccess() && operationResult.getValidateResult().isSuccess()) {
            if (DispatchBillFormCommon.REFRESH_REFRESH_KEY.contains(operateKey)) {
                this.getView().invokeOperation("refresh");
            }
            if ("modify".equals(operateKey)) {
                this.getView().setStatus(OperationStatus.EDIT);
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
                this.getView().cacheFormShowParameter();
                this.getView().getPageCache().put("view", "1");
                this.getView().updateView();
            }
        }
        if (HRStringUtils.equals((String)operateKey, (String)"viewflowchart_donothing") && operationResult.isSuccess()) {
            IDataModel model = this.getView().getModel();
            String order = model.getDataEntity().getString("disoutinorder");
            String entityNumber = this.getView().getEntityId();
            if (HRStringUtils.equals((String)order, (String)DispatchOrderEnum.IN_2_OUT.getOrder())) {
                entityNumber = "ham_dispatchin";
            }
            if (HRStringUtils.equals((String)order, (String)DispatchOrderEnum.OUT_2_IN.getOrder())) {
                entityNumber = "ham_dispatchout";
            }
            WorkflowServiceHelper.viewFlowchartWithEntityNumber((String)this.getView().getPageId(), (String)entityNumber, (Object)model.getValue("id"));
        }
    }

    private void terminateDispatchBill(String operateKey) {
        String entityId = this.getView().getEntityId();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long id = dataEntity.getLong("id");
        String select = "id,billno,submitnoticstatus,stopnoticstatus,effectstatus,effecttime,disoutinorder,billstatus,outstatus,instatus,dispatchstatus,terminatersn,ermanfile,startdate";
        DynamicObject bill = DispatchBillRepository.getInstance().queryOne(select, (Object)id);
        ArrayList dynamicObjects = Lists.newArrayListWithExpectedSize((int)1);
        dynamicObjects.add(bill);
        List dataDivs = IDispatchValidatorService.getInstance().terminateValidate((List)dynamicObjects, entityId);
        List errors = dataDivs.stream().filter(temp -> temp.getValidatorContext().getValidateResult().size() > 0).collect(Collectors.toList());
        if (!errors.isEmpty()) {
            this.getView().showErrorNotification(((DyObjValidateContext)errors.get(0)).getValidatorContext().getValidateResultStr());
        } else {
            FormShowParameter showParam = new FormShowParameter();
            showParam.setFormId("ham_terminateconfirm");
            showParam.getOpenStyle().setShowType(ShowType.Modal);
            showParam.setCustomParam("id", (Object)dataEntity.getLong("id"));
            showParam.setCustomParam("billFormId", (Object)entityId);
            showParam.setCustomParam("key", (Object)operateKey);
            showParam.setCustomParam("terminal_tip", (Object)"ham_dispatchout");
            showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bar_terminate"));
            this.getView().showForm(showParam);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("bar_terminate".equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) != null && "1".equals(String.valueOf(returnData))) {
            this.getView().getPageCache().put("view", null);
            this.getView().getPageCache().put("bar_terminate", "bar_terminate");
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.SUBMIT);
            this.getView().cacheFormShowParameter();
        }
    }

    private void processDynAreaInfo() {
        boolean isShowDispatchInInfo;
        log.info("DispatchBillFormPlugin_processDynAreaInfo_start");
        DispatchStatusBean statusBean = FORM_COMMON.getDispatchStatusBean(this.getView());
        DispatchInStatusEnum inStatus = statusBean.getInStatus();
        DispatchOutStatusEnum outStatus = statusBean.getOutStatus();
        String inStatusStr = !Objects.isNull(inStatus) ? inStatus.getCode() : "";
        String outStatusStr = !Objects.isNull(outStatus) ? outStatus.getCode() : "";
        boolean bl = isShowDispatchInInfo = DispatchStatusEnum.WAITEFFECT_DISPATCH == statusBean.getDispatchStatus() || DispatchStatusEnum.EFFECTED_DISPATCH == statusBean.getDispatchStatus() || DispatchStatusEnum.FAILED_DISPATCH == statusBean.getDispatchStatus();
        if (statusBean.getBillStatus() != BillOperationStatus.ADDNEW) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"initpanalflex"});
        }
        if (HRStringUtils.equals((String)statusBean.getBillName(), (String)"ham_dispatchin")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"dipatchdetailplanflex"});
        }
        log.info("DispatchBillFormPlugin_processDynAreaInfo_statusBean:{}", (Object)statusBean);
        if (statusBean.getBillStatus() == BillOperationStatus.ADDNEW) {
            log.info("DispatchBillFormPlugin_processDynAreaInfo_ADDNEW");
            this.cardViewLayoutA(this.getView());
        } else if ("1".equals(statusBean.getOutInOrder())) {
            if (HRStringUtils.equals((String)statusBean.getBillName(), (String)"ham_dispatchout")) {
                this.outToInPageShow(outStatusStr, isShowDispatchInInfo, statusBean.getOutInOrder());
            } else {
                this.inToOutPageShow(inStatusStr, false);
            }
        } else if (!HRStringUtils.equals((String)statusBean.getBillName(), (String)"ham_dispatchout")) {
            this.inToOutPageShow(inStatusStr, false);
        } else {
            this.outToInPageShow(outStatusStr, isShowDispatchInInfo, statusBean.getOutInOrder());
        }
    }

    private void outToInPageShow(String outStatus, boolean isEffect, String outInOrder) {
        if (HRStringUtils.equals((String)outStatus, (String)DispatchOutStatusEnum.WAITSUBMIT_DISPATCHOUT.getCode()) || HRStringUtils.equals((String)outStatus, (String)DispatchOutStatusEnum.WAITRESUBMIT_DISPATCHOUT.getCode())) {
            if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW && "2".equals(outInOrder)) {
                log.info("kd.hr.ham.formplugin.web.apply.DispatchBillFormPlugin.outToInPageShow_view_plane");
                this.changeCardViewLayoutC(this.getView(), isEffect);
            } else {
                this.changeCardViewLayoutB(this.getView());
            }
            if ("2".equals(outInOrder)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"dipatchdetailinflex"});
            }
        } else if (HRStringUtils.equals((String)outStatus, (String)DispatchOutStatusEnum.SUBMIT_DISPATCHOUT.getCode()) || HRStringUtils.equals((String)outStatus, (String)DispatchOutStatusEnum.APPROVING_DISPATCHOUT.getCode()) || HRStringUtils.equals((String)outStatus, (String)DispatchOutStatusEnum.APPROVED_DISPATCHOUT.getCode()) || HRStringUtils.equals((String)outStatus, (String)DispatchOutStatusEnum.SUSPEND_DISPATCHOUT.getCode())) {
            this.changeCardViewLayoutC(this.getView(), isEffect);
        } else if (HRStringUtils.equals((String)outStatus, (String)DispatchOutStatusEnum.SUSPEND_DISPATCHALL.getCode())) {
            this.changeCardViewLayoutD(this.getView());
        } else {
            log.info("outToInPageShow no match");
        }
    }

    private void inToOutPageShow(String inStatus, boolean isShowDispatchInInfo) {
        if (HRStringUtils.isEmpty((String)inStatus) || HRStringUtils.equals((String)inStatus, (String)DispatchInStatusEnum.WAITSUBMIT_DISPATCHIN.getCode()) || HRStringUtils.equals((String)inStatus, (String)DispatchInStatusEnum.WAITRESUBMIT_DISPATCHIN.getCode())) {
            this.changeCardViewLayoutB(this.getView());
        } else if (HRStringUtils.equals((String)inStatus, (String)DispatchInStatusEnum.SUBMIT_DISPATCHIN.getCode()) || HRStringUtils.equals((String)inStatus, (String)DispatchInStatusEnum.APPROVING_DISPATCHIN.getCode()) || HRStringUtils.equals((String)inStatus, (String)DispatchInStatusEnum.APPROVED_DISPATCHIN.getCode()) || HRStringUtils.equals((String)inStatus, (String)DispatchInStatusEnum.SUSPEND_DISPATCHIN.getCode())) {
            this.changeCardViewLayoutC(this.getView(), isShowDispatchInInfo);
        } else if (HRStringUtils.equals((String)inStatus, (String)DispatchInStatusEnum.SUSPEND_DISPATCHALL.getCode())) {
            this.changeCardViewLayoutD(this.getView());
        } else {
            log.info("inToOutPageShow no match");
        }
    }

    private void cardViewLayoutA(IFormView view) {
        FORM_COMMON.noPersonPage(view);
        FORM_COMMON.showBillHeadAdd(view);
    }

    private void changeCardViewLayoutB(IFormView view) {
        view.setVisible(Boolean.TRUE, new String[]{"headflex", "panel_dispinfo"});
        view.setVisible(Boolean.FALSE, new String[]{"personcardap", "compareinfoap", "headpaneladd", "terminatersnflex"});
        FORM_COMMON.showBillHeadEdit(view);
    }

    private void changeCardViewLayoutC(IFormView view, boolean isShowDispatchInInfo) {
        view.setVisible(Boolean.TRUE, new String[]{"headflex", "compareinfoap"});
        view.setVisible(Boolean.FALSE, new String[]{"personcardap", "headpaneladd", "terminatersnflex"});
        FORM_COMMON.showBillHeadEdit(view);
        FORM_COMMON.showBillCompareInfo(view, isShowDispatchInInfo);
    }

    private void changeCardViewLayoutD(IFormView view) {
        view.setVisible(Boolean.TRUE, new String[]{"headflex", "compareinfoap", "terminatersnflex"});
        view.setVisible(Boolean.FALSE, new String[]{"personcardap", "headpaneladd"});
        FORM_COMMON.showBillHeadEdit(view);
        FORM_COMMON.showBillCompareInfo(view, false);
    }

    private void propChangeErManFile(IFormView view, ChangeData changeData) {
        DispatchBillFormCommon.cleanData(view);
        Object ermanFileObj = changeData.getNewValue();
        if (HRObjectUtils.isEmpty((Object)ermanFileObj)) {
            FORM_COMMON.noPersonPage(view);
            return;
        }
        Map cardFields = PERSON_SERVICE.getCardFields(view.getModel().getDataEntity());
        boolean validateError = this.isValidateError(view, cardFields);
        if (validateError) {
            view.getModel().setValue("ermanfile", null);
            view.getModel().setValue("personfield", null);
        } else {
            Map outInitParams = PERSON_SERVICE.buildInitParams(cardFields);
            view.getModel().setValue("b_ermanfile", ermanFileObj);
            FORM_COMMON.intiDispatchOutInfo(view, outInitParams, "dispatchasuperior", "dispatchaincharge");
            FORM_COMMON.showPersonCard(view, "personcardap", cardFields);
            FORM_COMMON.personNoSavePage(view);
        }
    }

    public boolean isValidateError(IFormView view, Map<String, Object> cardFields) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        Long personId = (Long)cardFields.get("person_id");
        String hrCertValMsg = DispatchBillFormCommon.getInstance().getCertValidateMsg(personId, ResManager.loadKDString((String)"\u5916\u6d3e", (String)"DispatchBillFormPlugin_12", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        if (StringUtils.isNotEmpty((CharSequence)hrCertValMsg)) {
            view.showErrorNotification(hrCertValMsg);
            return true;
        }
        return this.isCrossAndBizValidateError(view, dataEntity, cardFields);
    }

    public boolean isCrossAndBizValidateError(IFormView view, DynamicObject dataEntity, Map<String, Object> cardFields) {
        boolean f7flag = false;
        String billFormId = view.getFormShowParameter().getFormId();
        DispatchPageTypeEnum dispatchPageType = DispatchPageTypeEnum.getEnumByCode((String)billFormId);
        Map validateInfo = IDispatchBillService.getInstance().getValidateInfo(new DynamicObject[]{view.getModel().getDataEntity()}, dispatchPageType, null, true);
        for (Map.Entry entry : validateInfo.entrySet()) {
            for (String msg : (List)entry.getValue()) {
                f7flag = true;
                view.showErrorNotification(msg);
            }
        }
        CrossValidateParamDto crossValidateDto = PERSON_SERVICE.getCrossValidateParamByCardFields(cardFields);
        boolean crossFlag = FORM_COMMON.tipCrossValidateRes(view, crossValidateDto, false);
        boolean directorFlag = FORM_COMMON.tipDirectorValidate(view, dataEntity);
        Pair probationPer = IDispatchBillService.getInstance().validateDispatchLaborrel(dataEntity.getDynamicObject("ermanfile"));
        if (((Boolean)probationPer.getKey()).booleanValue()) {
            view.showTipNotification((String)probationPer.getValue());
        }
        return f7flag || crossFlag || directorFlag;
    }

    private void propChangePerson(IFormView view, ChangeData changeData) {
        view.getModel().setValue("empgroupin", (Object)1010L);
        Object newValue = changeData.getNewValue();
        if (HRObjectUtils.isEmpty((Object)newValue)) {
            view.getModel().setValue("ermanfile", null);
            DispatchBillFormCommon.cleanData(view);
            FORM_COMMON.noPersonPage(view);
        } else {
            ArrayList ids = Lists.newArrayList((Object[])new Long[]{((DynamicObject)newValue).getLong("id")});
            Object[] erManFileByDeptEmpId = PERSON_SERVICE.getErManFileByDeptEmpId((List)ids);
            log.info("IPersonAboutService.getErManFileByDeptEmpId empty: {}", (Object)HRArrayUtils.isEmpty((Object[])erManFileByDeptEmpId));
            if (HRArrayUtils.isEmpty((Object[])erManFileByDeptEmpId)) {
                throw new KDBizException("not find ermanFile by hr emp person");
            }
            view.getModel().setValue("ermanfile", erManFileByDeptEmpId[0].getPkValue());
        }
    }

    private void propChangePlanStartDate(IFormView view, ChangeData changeData) {
        this.calcPlanDuration("planstartdate", "planstartdate", "planenddate", "planduration", view);
    }

    private void propChangePlanEndDate(IFormView view, ChangeData changeData) {
        this.calcPlanDuration("planenddate", "planstartdate", "planenddate", "planduration", view);
    }

    private void propChangeStartDate(IFormView view, ChangeData changeData) {
        this.calcPlanDuration("startdate", "startdate", "enddate", "duration", view);
    }

    private void propChangeEndDate(IFormView view, ChangeData changeData) {
        this.calcPlanDuration("enddate", "startdate", "enddate", "duration", view);
    }

    private void propChangeLeaveDate(IFormView view, ChangeData changeData) {
        boolean secondSubmit = DispatchBillFormCommon.isSecondSubmit(view.getModel().getDataEntity());
        String order = view.getModel().getDataEntity().getString("disoutinorder");
        if (secondSubmit || HRStringUtils.equals((String)order, (String)"2")) {
            this.calcLeaveWorkDate("leavedate", "leavedate", "reachdate", view, false);
        } else {
            this.calcLeaveWorkDate("leavedate", "leavedate", "planreachdate", view, true);
        }
    }

    private void propChangePlanLeaveDate(IFormView view, ChangeData changeData) {
        this.calcLeaveWorkDate("planreachdate", "leavedate", "planreachdate", view, true);
    }

    private void propChangeReachDateDate(IFormView view, ChangeData changeData) {
        this.calcLeaveWorkDate("reachdate", "leavedate", "reachdate", view, false);
    }

    private void propChangePlanDept(IFormView view, ChangeData changeData) {
        this.setCompanyByDep("plandepin", view);
    }

    private void propChangeDept(IFormView view, ChangeData changeData) {
        this.setCompanyByDep("deptin", view);
        IDataModel model = view.getModel();
        model.setValue("adminorgin", changeData.getNewValue());
        DynamicObject newValue = (DynamicObject)changeData.getNewValue();
        if (HRObjectUtils.isEmpty((Object)newValue)) {
            return;
        }
        model.setValue("orgin", (Object)this.getHrBuByIdByAdminOrgId(newValue.getLong("id")));
    }

    private Long getHrBuByIdByAdminOrgId(Long adminOrgId) {
        if (Objects.isNull(adminOrgId)) {
            return 0L;
        }
        HashMap param = Maps.newHashMapWithExpectedSize((int)4);
        param.put(adminOrgId, Collections.singleton(103010L));
        log.info("IDispatchHRCSService.invokeGetHrBuByBusinessType param {}", (Object)JSON.toJSONString((Object)param));
        log.info("IDispatchHRCSService.invokeGetHrBuByBusinessType type_id {}", (Object)1010L);
        List maps = IDispatchHRCSService.getInstance().invokeGetHrBuByBusinessType((Map)param, Long.valueOf(1010L));
        if (Objects.isNull(maps) || maps.isEmpty()) {
            log.info("IDispatchHRCSService.invokeGetHrBuByBusinessType => null");
            return 0L;
        }
        return (Long)((Map)maps.get(0)).get("hrBuId");
    }

    private void propChangePlanComp(IFormView view, ChangeData changeData) {
        IDataModel model = view.getModel();
        DynamicObject depObj = model.getDataEntity().getDynamicObject("plandepin");
        if (depObj == null) {
            model.setValue("dispatchplansup", null);
        }
        if ("0".equals(model.getValue("radiogroupfield"))) {
            DynamicObject comp = model.getDataEntity().getDynamicObject("plancompanyin");
            if (comp == null || depObj == null) {
                model.setValue("plandepin", null);
                return;
            }
            IOrgAboutService orgAboutService = (IOrgAboutService)ServiceFactory.getService(IOrgAboutService.class);
            Long companyId = orgAboutService.calculateCompanyByDep(depObj);
            if (comp.getLong("id") != companyId.longValue()) {
                model.setValue("plandepin", null);
            }
        }
        if (!"1".equals(model.getValue("radiogroupfield")) && depObj != null) {
            List personIdList = IDispatchBillService.getInstance().invokeGetSuperiorByRule(view.getModel().getDataEntity(), "plancompanyin", "radiogroupfield", "");
            model.setValue("dispatchplansup", (Object)personIdList.toArray());
        }
    }

    private void propChangeComp(IFormView view, ChangeData changeData) {
        IDataModel model = view.getModel();
        DynamicObject depObj = model.getDataEntity().getDynamicObject("deptin");
        if (depObj == null) {
            model.setValue("dispatchinsuperior", null);
        }
        if ("0".equals(model.getValue("inradiogroupfield"))) {
            DynamicObject comp = model.getDataEntity().getDynamicObject("companyin");
            if (comp == null || depObj == null) {
                model.setValue("deptin", null);
                return;
            }
            IOrgAboutService orgAboutService = (IOrgAboutService)ServiceFactory.getService(IOrgAboutService.class);
            Long companyId = orgAboutService.calculateCompanyByDep(depObj);
            if (comp.getLong("id") != companyId.longValue()) {
                model.setValue("deptin", null);
            }
        }
        if (!"1".equals(model.getValue("inradiogroupfield")) && depObj != null) {
            List personIdList = IDispatchBillService.getInstance().invokeGetSuperiorByRule(view.getModel().getDataEntity(), "companyin", "inradiogroupfield", "");
            model.setValue("dispatchinsuperior", (Object)personIdList.toArray());
        }
    }

    private void propChangePlanPos(IFormView view, ChangeData changeData) {
        view.getModel().setValue("plancountry", null);
        view.getModel().setValue("planjob", null);
        view.getModel().setValue("dispatchplansup", null);
        Object newValue = changeData.getNewValue();
        if (Objects.isNull(newValue)) {
            return;
        }
        IDataModel model = view.getModel();
        FORM_COMMON.setCountryAndDeptByPos(model, changeData, "plancountry", "plandepin", "planjob");
        String posPattern = model.getDataEntity().getString("radiogroupfield");
        if (HRStringUtils.equals((String)posPattern, (String)"1")) {
            FORM_COMMON.setInChargeByPos(model, "dispatchplansup", "plandepin", "radiogroupfield", "planpositionin");
        }
        FORM_COMMON.validateCrossTransaction(view, "2");
    }

    private void propChangePlanStdPos(IFormView view, ChangeData changeData) {
        log.info("propChangePlanStdPos");
        view.getModel().setValue("planjob", null);
        FORM_COMMON.setJobByStdPos(view.getModel(), changeData, "planjob");
        FORM_COMMON.validateCrossTransaction(view, "2");
    }

    private void propChangePlanJob(IFormView view, ChangeData changeData) {
        log.info("propChangePlanStdPos");
        FORM_COMMON.validateCrossTransaction(view, "2");
    }

    private void propChangeJob(IFormView view, ChangeData changeData) {
        log.info("propChangePlanStdPos");
        FORM_COMMON.validateCrossTransaction(view, "3");
    }

    private void propChangePos(IFormView view, ChangeData changeData) {
        view.getModel().setValue("countryin", null);
        view.getModel().setValue("jobin", null);
        Object newValue = changeData.getNewValue();
        if (Objects.isNull(newValue)) {
            return;
        }
        IDataModel model = view.getModel();
        FORM_COMMON.setCountryAndDeptByPos(model, changeData, "countryin", "deptin", "jobin");
        String radio = model.getDataEntity().getString("inradiogroupfield");
        if (HRStringUtils.equals((String)radio, (String)"1")) {
            FORM_COMMON.setInChargeByPos(model, "dispatchinsuperior", "deptin", "inradiogroupfield", "positionin");
        }
        FORM_COMMON.validateCrossTransaction(view, "3");
    }

    private void propChangeStdPos(IFormView view, ChangeData changeData) {
        view.getModel().setValue("jobin", null);
        FORM_COMMON.setJobByStdPos(view.getModel(), changeData, "jobin");
        FORM_COMMON.validateCrossTransaction(view, "3");
    }

    private void propChangePlanWordModelRadio(IFormView view, ChangeData changeData) {
        DispatchBillFormCommon.getInstance().posPatternFieldConsumer.accept(view, "2");
        DispatchBillFormCommon.getInstance().posPatternFieldMustInputConsumer.accept(view, "2");
        IDataModel model = view.getModel();
        DispatchBillFormCommon.cleanData(view, Arrays.asList("plancountry", "planpositionin", "planstandardposin", "planjob", "dispatchplansup"));
        if ("1".equals(model.getValue("radiogroupfield"))) {
            model.setValue("planstandardposin", null);
        } else {
            List personIdList = IDispatchBillService.getInstance().invokeGetSuperiorByRule(view.getModel().getDataEntity(), "plandepin", "radiogroupfield", "planpositionin");
            model.setValue("dispatchplansup", (Object)personIdList.toArray());
            model.setValue("planpositionin", null);
        }
        view.setEnable(Boolean.FALSE, new String[]{"dispatchplansup"});
    }

    private void propChangeWordModelRadio(IFormView view, ChangeData changeData) {
        DispatchBillFormCommon.getInstance().posPatternFieldConsumer.accept(view, "3");
        DispatchBillFormCommon.getInstance().posPatternFieldMustInputConsumer.accept(view, "3");
        IDataModel model = view.getModel();
        DispatchBillFormCommon.cleanData(view, Arrays.asList("countryin", "standardposin", "positionin", "jobin", "dispatchinsuperior"));
        if (!"1".equals(model.getValue("inradiogroupfield"))) {
            List personIdList = IDispatchBillService.getInstance().invokeGetSuperiorByRule(view.getModel().getDataEntity(), "deptin", "inradiogroupfield", "positionin");
            model.setValue("dispatchinsuperior", (Object)personIdList.toArray());
        }
        view.setEnable(Boolean.FALSE, new String[]{"dispatchinsuperior"});
    }

    private void setCompanyByDep(String dep, IFormView view) {
        IDataModel model = view.getModel();
        String prefix = "";
        if (dep.startsWith("plan")) {
            prefix = "plan";
        }
        DynamicObject depObj = model.getDataEntity().getDynamicObject(dep);
        DynamicObject comp = model.getDataEntity().getDynamicObject(prefix + "companyin");
        if (HRObjectUtils.isEmpty((Object)depObj)) {
            model.setValue(prefix + "companyin", null);
            if ("1".equals(model.getValue("radiogroupfield"))) {
                model.setValue(prefix + "companyin", null);
            }
            model.setValue(prefix + "positionin", null);
            model.setValue("orgin", null);
            model.setValue("adminorgin", null);
            if (dep.startsWith("plan")) {
                model.setValue("dispatchplanincha", null);
                model.setValue("plancountry", null);
            } else {
                model.setValue("dispatchinincharge", null);
                model.setValue("countryin", null);
            }
            return;
        }
        model.setValue("adminorgin", (Object)depObj);
        IOrgAboutService orgAboutService = (IOrgAboutService)ServiceFactory.getService(IOrgAboutService.class);
        Long companyId = orgAboutService.calculateCompanyByDep(depObj);
        model.setValue(prefix + "companyin", (Object)companyId);
        List orgChargers = IDispatchBillService.getInstance().invokeGetMainChargeInfoByOrg(Collections.singletonList(depObj.getLong("id")));
        Object[] objects = orgChargers.toArray();
        if (dep.startsWith("plan")) {
            model.setValue("dispatchplanincha", (Object)objects);
        } else {
            model.setValue("dispatchinincharge", (Object)objects);
        }
        if (comp == null) {
            return;
        }
        if (dep.startsWith("plan")) {
            model.setValue("plancountry", null);
            model.setValue("dispatchplansup", null);
        } else {
            model.setValue("countryin", null);
            model.setValue("dispatchinsuperior", null);
        }
        model.setValue(prefix + "positionin", null);
    }

    private void calcPlanDuration(String propertyName, String startKey, String endKey, String duration, IFormView view) {
        IDataModel model = view.getModel();
        Pair<Boolean, Long> dayRes = DispatchBillFormCommon.getInstance().getBetweenDays(startKey, endKey, model);
        if (!((Boolean)dayRes.getKey()).booleanValue()) {
            return;
        }
        Long days = (Long)dayRes.getRight();
        model.setValue(duration, (Object)days);
        if (days <= 0L) {
            model.setValue(propertyName, null);
            model.setValue(duration, null);
            String tip = propertyName.equals(startKey) ? ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5e94\u65e9\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"DispatchBillFormPlugin_0", (String)"hr-ham-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"DispatchBillFormPlugin_1", (String)"hr-ham-formplugin", (Object[])new Object[0]);
            FieldTip fieldTip = DispatchBillFormCommon.getInstance().getDateFileTip(propertyName, tip);
            view.showFieldTip(fieldTip);
        } else {
            model.setValue(duration, (Object)days);
        }
    }

    private void calcLeaveWorkDate(String propertyName, String startKey, String endKey, IFormView view, boolean plan) {
        IDataModel model = view.getModel();
        Pair<Boolean, Long> dayRes = DispatchBillFormCommon.getInstance().getBetweenDays(startKey, endKey, model);
        if (!((Boolean)dayRes.getKey()).booleanValue()) {
            return;
        }
        String tipLeaveDate = plan ? ResManager.loadKDString((String)"\u62df\u6d3e\u5165\u5230\u5c97\u65e5\u671f", (String)"DispatchBillFormPlugin_4", (String)"hr-ham-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6d3e\u5165\u5230\u5c97\u65e5\u671f", (String)"DispatchBillFormPlugin_5", (String)"hr-ham-formplugin", (Object[])new Object[0]);
        Long days = (Long)dayRes.getRight();
        if (days <= 0L) {
            model.setValue(propertyName, null);
            String tip = propertyName.equals(startKey) ? MessageFormat.format(ResManager.loadKDString((String)"\u6d3e\u51fa\u79bb\u5c97\u65e5\u671f\u5e94\u65e9\u4e8e{0}\u3002", (String)"DispatchBillFormPlugin_2", (String)"hr-ham-formplugin", (Object[])new Object[0]), tipLeaveDate) : MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d\u5e94\u665a\u4e8e\u6d3e\u51fa\u79bb\u5c97\u65e5\u671f\u3002", (String)"DispatchBillFormPlugin_3", (String)"hr-ham-formplugin", (Object[])new Object[0]), tipLeaveDate);
            FieldTip fieldTip = DispatchBillFormCommon.getInstance().getDateFileTip(propertyName, tip);
            view.showFieldTip(fieldTip);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DispatchBillFormCommon.setBizChanged(dataEntity, "billno", "orgout", "adminorgout", "empgroupout", "countryout", "companyout", "deptout", "cmpempout", "positionout", "standardposout", "dispatchasuperior", "dispatchaincharge", "orgin", "adminorgin", "person", "laborrelstatus", "radiogroupfield", "inradiogroupfield", "pospatternout", "jobout");
    }

    static {
        propMap.put("ermanfile", LAMBDA_INSTANCE::propChangeErManFile);
        propMap.put("personfield", LAMBDA_INSTANCE::propChangePerson);
        propMap.put("planstartdate", LAMBDA_INSTANCE::propChangePlanStartDate);
        propMap.put("planenddate", LAMBDA_INSTANCE::propChangePlanEndDate);
        propMap.put("startdate", LAMBDA_INSTANCE::propChangeStartDate);
        propMap.put("enddate", LAMBDA_INSTANCE::propChangeEndDate);
        propMap.put("leavedate", LAMBDA_INSTANCE::propChangeLeaveDate);
        propMap.put("planreachdate", LAMBDA_INSTANCE::propChangePlanLeaveDate);
        propMap.put("reachdate", LAMBDA_INSTANCE::propChangeReachDateDate);
        propMap.put("plandepin", LAMBDA_INSTANCE::propChangePlanDept);
        propMap.put("deptin", LAMBDA_INSTANCE::propChangeDept);
        propMap.put("plancompanyin", LAMBDA_INSTANCE::propChangePlanComp);
        propMap.put("companyin", LAMBDA_INSTANCE::propChangeComp);
        propMap.put("planpositionin", LAMBDA_INSTANCE::propChangePlanPos);
        propMap.put("planstandardposin", LAMBDA_INSTANCE::propChangePlanStdPos);
        propMap.put("positionin", LAMBDA_INSTANCE::propChangePos);
        propMap.put("standardposin", LAMBDA_INSTANCE::propChangeStdPos);
        propMap.put("planjob", LAMBDA_INSTANCE::propChangePlanJob);
        propMap.put("jobin", LAMBDA_INSTANCE::propChangeJob);
        propMap.put("radiogroupfield", LAMBDA_INSTANCE::propChangePlanWordModelRadio);
        propMap.put("inradiogroupfield", LAMBDA_INSTANCE::propChangeWordModelRadio);
    }
}

