/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.formplugin.web.apply;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.ham.business.domain.repository.bill.DispatchBillRepository;
import kd.hr.ham.business.domain.service.bill.IDispatchValidatorService;
import kd.hr.ham.business.domain.service.validator.DyObjValidateContext;
import kd.hr.ham.business.util.ExcelUtils;
import kd.hr.ham.common.dispatch.utils.AppLogUtils;
import kd.hr.ham.formplugin.web.common.DispatchBillListCommon;
import kd.hr.ham.formplugin.web.common.DispatchListPluginCommon;
import kd.hr.ham.formplugin.web.common.DispatchPageUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicListBasePlugin;

public class DispatchBillListPlugin
extends HRDynamicListBasePlugin
implements DispatchListPluginCommon {
    private static final Log LOGGER = LogFactory.getLog(DispatchBillListPlugin.class);
    private static final String CALLBACK_KEY_DELETE = "callback_delete";
    private static final String CALLBACK_KEY_UNSUBMIT = "callback_unSubmit";
    public static final String PERSON_HEADSCULPTURE = "person.headsculpture";

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List listColumns = args.getListColumns();
        for (IListColumn listColumn : listColumns) {
            String fieldName = listColumn.getListFieldKey();
            if (!HRStringUtils.equals((String)fieldName, (String)PERSON_HEADSCULPTURE) && !HRStringUtils.equals((String)fieldName, (String)"person.name")) continue;
            listColumn.setFixed(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        HashSet operateKeys = Sets.newHashSetWithExpectedSize((int)4);
        operateKeys.add("donoting_submitlist");
        operateKeys.add("donothing_unsubmitlist");
        operateKeys.add("donothing_deletelist");
        operateKeys.add("donothing_termination");
        if (selectedRows.size() == 1 && operateKeys.contains(operateKey)) {
            Long id = (Long)selectedRows.get(0).getPrimaryKeyValue();
            if (!DispatchBillRepository.getInstance().isExists((Object)id)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"DispatchBillListPlugin_15", (String)"hr-ham-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if (DispatchBillListCommon.getInstance().batchOpMax((ListView)this.getView(), args, operateKey, (HRBaseServiceHelper)DispatchBillRepository.getInstance())) {
            return;
        }
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String billFormId = listShowParameter.getBillFormId();
        switch (operateKey) {
            case "donoting_submitlist": {
                DispatchBillListCommon.getInstance().commitApply(this.getView(), this.getSelectedRows(), billFormId, args);
                args.setCancel(true);
                break;
            }
            case "donothing_unsubmitlist": {
                this.unSubmitBills(billFormId);
                args.setCancel(true);
                break;
            }
            case "donothing_deletelist": {
                this.deleteBills(billFormId);
                args.setCancel(true);
                break;
            }
            case "donothing_termination": {
                if (selectedRows.size() <= 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u201c\u7ec8\u6b62\u201d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DispatchBillListPlugin_1", (String)"hr-ham-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String billFormId = listShowParameter.getBillFormId();
        switch (operateKey = args.getOperateKey()) {
            case "donothing_termination": {
                this.terminateBill(billFormId, operateKey);
                break;
            }
        }
    }

    private void unSubmitBills(String billFormId) {
        DynamicObject[] bills = this.initData();
        List dyObjValidateContexts = IDispatchValidatorService.getInstance().batchUnSubmitValidate(Arrays.asList(bills), billFormId);
        if (dyObjValidateContexts.size() > 1) {
            this.handleBills(dyObjValidateContexts, "ham_cancelconfirm", ResManager.loadKDString((String)"\u64a4\u9500", (String)"DispatchBillListPlugin_6", (String)"hr-ham-formplugin", (Object[])new Object[0]), billFormId);
            return;
        }
        if (dyObjValidateContexts.size() == 1) {
            List errors = dyObjValidateContexts.stream().filter(temp -> temp.getValidatorContext().getValidateResult().size() > 0).collect(Collectors.toList());
            if (!errors.isEmpty()) {
                this.getView().showErrorNotification(((DyObjValidateContext)errors.get(0)).getValidatorContext().getFirValidateResultStr());
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6570\u636e\u64a4\u9500\u540e\u6d41\u7a0b\u5c06\u56de\u5230\u201c\u5f85\u63d0\u4ea4\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DispatchBillListPlugin_7", (String)"hr-ham-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACK_KEY_UNSUBMIT, (IFormPlugin)this));
            return;
        }
    }

    private void deleteBills(String billFormId) {
        DynamicObject[] bills = this.initData();
        List dyObjValidateContexts = IDispatchValidatorService.getInstance().batchDeleteValidate(Arrays.asList(bills), billFormId);
        if (dyObjValidateContexts.size() > 1) {
            this.handleBills(dyObjValidateContexts, "ham_deleteconfirm", ResManager.loadKDString((String)"\u5220\u9664", (String)"DispatchBillListPlugin_4", (String)"hr-ham-formplugin", (Object[])new Object[0]), billFormId);
            return;
        }
        if (dyObjValidateContexts.size() == 1) {
            List errors = dyObjValidateContexts.stream().filter(temp -> temp.getValidatorContext().getValidateResult().size() > 0).collect(Collectors.toList());
            if (!errors.isEmpty()) {
                this.getView().showErrorNotification(((DyObjValidateContext)errors.get(0)).getValidatorContext().getFirValidateResultStr());
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u8bb0\u5f55\u5220\u9664\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DispatchBillListPlugin_5", (String)"hr-ham-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACK_KEY_DELETE, (IFormPlugin)this));
        }
    }

    private void terminateBill(String billFormId, String operateKey) {
        DynamicObject[] bills = this.initData();
        List dyObjValidateContext = IDispatchValidatorService.getInstance().terminateValidate(Arrays.asList(bills), billFormId);
        if (dyObjValidateContext.size() == 1) {
            List errors = dyObjValidateContext.stream().filter(temp -> temp.getValidatorContext().getValidateResult().size() > 0).collect(Collectors.toList());
            if (!errors.isEmpty()) {
                this.getView().showErrorNotification(((DyObjValidateContext)errors.get(0)).getValidatorContext().getValidateResultStr());
            } else {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("ham_terminateconfirm");
                formShowParameter.setCustomParam("key", (Object)operateKey);
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                ListSelectedRowCollection listSelectedData = this.getSelectedRows();
                Object[] primaryKeyValues = listSelectedData.getPrimaryKeyValues();
                formShowParameter.setCustomParam("id", primaryKeyValues[0]);
                formShowParameter.setCustomParam("billFormId", (Object)billFormId);
                formShowParameter.setCustomParam("terminal_tip", (Object)"ham_dispatchout");
                this.getView().showForm(formShowParameter);
            }
        }
    }

    private void handleBills(List<DyObjValidateContext> dyObjValidateContexts, String confirmPageId, String keyword, String billFormId) {
        ArrayList<DyObjValidateContext> errors = new ArrayList<DyObjValidateContext>();
        ArrayList<Long> successIds = new ArrayList<Long>();
        for (DyObjValidateContext dyObjValidateContext : dyObjValidateContexts) {
            if (dyObjValidateContext.getValidatorContext().getValidateResult().size() > 0) {
                errors.add(dyObjValidateContext);
                continue;
            }
            successIds.add(dyObjValidateContext.getDynamicObject().getLong("id"));
        }
        this.showMulConfirmPage(dyObjValidateContexts, errors, successIds.toArray(), confirmPageId, keyword, billFormId);
    }

    private void showMulConfirmPage(List<DyObjValidateContext> dyObjValidateContexts, List<DyObjValidateContext> errors, Object[] ids, String confirmPageId, String keyWord, String billFormId) {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("sumlabel", dyObjValidateContexts.size());
        params.put("incongruentlabel", errors.size());
        params.put("coincidentlabel", dyObjValidateContexts.size() - errors.size());
        String billTypeName = "";
        if (HRStringUtils.equals((String)"ham_dispatchout", (String)billFormId)) {
            billTypeName = ResManager.loadKDString((String)"\u6d3e\u51fa", (String)"DispatchBillListPlugin_8", (String)"hr-ham-formplugin", (Object[])new Object[0]);
        }
        if (HRStringUtils.equals((String)"ham_dispatchin", (String)billFormId)) {
            billTypeName = ResManager.loadKDString((String)"\u6d3e\u5165", (String)"DispatchBillListPlugin_9", (String)"hr-ham-formplugin", (Object[])new Object[0]);
        }
        params.put("filename", String.format(ResManager.loadKDString((String)"%1$s\u7533\u8bf7%2$s\u786e\u8ba4\u6570\u636e_%3$s", (String)"DispatchBillListPlugin_10", (String)"hr-ham-formplugin", (Object[])new Object[0]), billTypeName, keyWord, LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE)));
        params.put("headDataList", ExcelUtils.initDisBillConfirmExcelHead((String)keyWord, (String)billFormId));
        params.put("exportDataList", ExcelUtils.initDisBillConfirmExportData(dyObjValidateContexts, (String)billFormId));
        params.put("ids", ids);
        String secondConfirmExportName = String.format(ResManager.loadKDString((String)"\u6279\u91cf%1$s%2$s\u7533\u8bf7\u5904\u7406\u7ed3\u679c_%3$s", (String)"DispatchBillListPlugin_11", (String)"hr-ham-formplugin", (Object[])new Object[0]), keyWord, billTypeName, LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        params.put("secondconfirm_exporttitle", secondConfirmExportName);
        DispatchPageUtil.showFormViewOfModal(this.getView(), confirmPageId, params);
    }

    private DynamicObject[] initData() {
        ListSelectedRowCollection listSelectedData = this.getSelectedRows();
        Object[] primaryKeyValues = listSelectedData.getPrimaryKeyValues();
        String queryProperties = String.join((CharSequence)",", Lists.newArrayList((Object[])new String[]{"id", "ermanfile", "billno", "billstatus", "outstatus", "instatus", "org", "dispatchstatus"}));
        return DispatchBillRepository.getInstance().query(queryProperties, new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (CALLBACK_KEY_UNSUBMIT.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.unSubmitBill();
        } else if (CALLBACK_KEY_DELETE.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.deleteBill();
        } else {
            this.getView().invokeOperation("refresh");
        }
    }

    private void unSubmitBill() {
        ListSelectedRowCollection listSelectedRowCollection = this.getSelectedRows();
        Object[] primaryKeyValues = listSelectedRowCollection.getPrimaryKeyValues();
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"unsubmit", (String)((IListView)this.getView()).getBillFormId(), (Object[])primaryKeyValues, (OperateOption)OperateOption.create());
        LOGGER.info("dispatch unsubmit operationResult: [{}]", (Object)JSON.toJSONString((Object)operationResult));
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f", (String)"DispatchBillListPlugin_12", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        } else {
            String message;
            String errorMessage = ResManager.loadKDString((String)"\u64a4\u9500\u5931\u8d25", (String)"DispatchBillListPlugin_13", (String)"hr-ham-formplugin", (Object[])new Object[0]);
            List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
            if (!CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo) && HRStringUtils.isNotEmpty((String)(message = ((IOperateInfo)allErrorOrValidateInfo.get(0)).getMessage()))) {
                errorMessage = message;
            }
            this.getView().showErrorNotification(errorMessage);
        }
        this.getView().invokeOperation("refresh");
    }

    private void deleteBill() {
        ListSelectedRowCollection listSelectedRowCollection = this.getSelectedRows();
        Object[] primaryKeyValues = listSelectedRowCollection.getPrimaryKeyValues();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String billFormId = listShowParameter.getBillFormId();
        DynamicObject[] bills = this.initData();
        List dyObjValidateContexts = IDispatchValidatorService.getInstance().batchDeleteValidate(Arrays.asList(bills), billFormId);
        List errors = dyObjValidateContexts.stream().filter(temp -> temp.getValidatorContext().getValidateResult().size() > 0).collect(Collectors.toList());
        if (!errors.isEmpty()) {
            this.getView().showErrorNotification(((DyObjValidateContext)errors.get(0)).getValidatorContext().getFirValidateResultStr());
            return;
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)billFormId, (Object[])primaryKeyValues, (OperateOption)OperateOption.create());
        if (this.handleOpResult(this.getView(), operationResult)) {
            return;
        }
        AppLogUtils.recordLog((String)billFormId, (String)"donothing_deletelist", (String)listSelectedRowCollection.get(0).getBillNo(), (String)ResManager.loadKDString((Lang)Lang.zh_CN, (String)"\u5220\u9664", (String)"DispatchBillListPlugin_19", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"DispatchBillListPlugin_14", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        this.getView().invokeOperation("refresh");
    }
}

