/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.formplugin.web.apply;

import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.hr.ham.business.domain.repository.bill.DispatchBillRepository;
import kd.hr.ham.business.domain.service.bill.IDispatchBillService;
import kd.hr.ham.common.dispatch.constants.DispatchBillConstants;
import kd.hr.ham.formplugin.web.common.DispatchPageUtil;
import kd.hr.hbp.formplugin.web.HRDynamicListBasePlugin;

public class DispatchInBillListPlugin
extends HRDynamicListBasePlugin
implements DispatchBillConstants {
    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        QFilter isNotNull = new QFilter("instatus", "<>", (Object)"");
        setFilterEvent.getQFilters().add(isNotNull);
        setFilterEvent.setOrderBy("reachdate desc,createtime asc");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        if ("donothing_apply".equals(args.getOperateKey())) {
            BillShowParameter formShowParameter = new BillShowParameter();
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            DispatchPageUtil.showNewAddPage(this.getView(), (FormShowParameter)new BillShowParameter(), "ham_dispatchin", ResManager.loadKDString((String)"\u65b0\u589e\u5916\u6d3e\u6d3e\u5165\u7533\u8bf7", (String)"DispatchInBillListPlugin_0", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        ListSelectedRow currentRow = event.getCurrentRow();
        Object pk = currentRow.getPrimaryKeyValue();
        if (!DispatchBillRepository.getInstance().isExists(pk)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"DispatchBillListPlugin_15", (String)"hr-ham-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dynamicObject = IDispatchBillService.getInstance().queryOneDispatch((Long)pk);
        String caption = String.format(ResManager.loadKDString((String)"\u5916\u6d3e\u6d3e\u5165\u7533\u8bf7-%s", (String)"DispatchInBillListPlugin_1", (String)"hr-ham-formplugin", (Object[])new Object[0]), dynamicObject.getString("person.name"));
        BillShowParameter parameter = new BillShowParameter();
        parameter.setCaption(caption);
        parameter.setPkId(pk);
        parameter.setPageId(this.getView().getPageId() + pk);
        parameter.setStatus(OperationStatus.VIEW);
        DispatchPageUtil.showNewAddPage(this.getView(), (FormShowParameter)parameter, "ham_dispatchin", caption);
    }
}

