/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.formplugin.web.back;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.hr.ham.common.dispatch.constants.DispatchBackPageConstants;
import kd.hr.ham.common.dispatch.constants.DispbackBillConstants;
import kd.hr.ham.common.dispatch.enums.DispatchBackStatusEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class DispatchBackButtonPlugin
extends HRDynamicFormBasePlugin
implements DispbackBillConstants,
DispatchBackPageConstants {
    private static final DispatchBackButtonPlugin INSTANCE = new DispatchBackButtonPlugin();
    private static final Map<String, Consumer<IFormView>> statusMap = new HashMap<String, Consumer<IFormView>>(8);

    private void buttonVisibleEditWaitSubmit(IFormView view) {
        this.buttonVisible(view, Lists.newArrayList((Object[])new String[]{"bar_save", "bar_submit"}));
    }

    private void buttonVisibleWaitSubmit(IFormView view) {
        this.buttonVisible(view, Lists.newArrayList((Object[])new String[]{"bar_modify", "bar_submit"}));
    }

    private void buttonVisibleWaitReSubmit(IFormView view) {
        this.buttonVisible(view, Lists.newArrayList((Object[])new String[]{"bar_modify", "bar_submit", "bar_discard", "bar_viewflowchart"}));
    }

    private void buttonVisibleWaitReSubmitEdit(IFormView view) {
        this.buttonVisible(view, Lists.newArrayList((Object[])new String[]{"bar_save", "bar_submit", "bar_discard", "bar_viewflowchart"}));
    }

    private void buttonVisibleSubmit(IFormView view) {
        this.buttonVisible(view, Lists.newArrayList((Object[])new String[]{"bar_unsubmit", "bar_discard", "bar_viewflowchart"}));
    }

    private void buttonVisibleDiscard(IFormView view) {
        this.buttonVisible(view, Lists.newArrayList((Object[])new String[]{"bar_discard", "bar_viewflowchart"}));
    }

    private void buttonVisibleNoPass(IFormView view) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        boolean isSubmit = dataEntity.getBoolean("issubmit");
        if (isSubmit) {
            this.buttonVisible(view, Lists.newArrayList((Object[])new String[]{"bar_viewflowchart"}));
        } else {
            this.buttonVisible(view, Lists.newArrayList());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        if (OperationStatus.EDIT == status || OperationStatus.ADDNEW == status) {
            String backStatus = dataEntity.getString("backstatus");
            if (HRStringUtils.equals((String)backStatus, (String)DispatchBackStatusEnum.WAIT_RESUBMIT.getCode())) {
                statusMap.get("modify" + DispatchBackStatusEnum.WAIT_RESUBMIT.getCode()).accept(this.getView());
                return;
            }
            statusMap.get("new").accept(this.getView());
            long id = dataEntity.getLong("id");
            if (id == 0L) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit"});
            }
        } else {
            String backStatus = dataEntity.getString("backstatus");
            statusMap.get(backStatus).accept(this.getView());
        }
    }

    private void buttonVisible(IFormView view, List<String> button) {
        ArrayList allButton = Lists.newArrayList((Object[])new String[]{"bar_save", "bar_modify", "bar_submit", "bar_unsubmit", "bar_discard", "bar_viewflowchart"});
        view.setVisible(Boolean.TRUE, button.toArray(new String[0]));
        allButton.removeAll(button);
        view.setVisible(Boolean.FALSE, allButton.toArray(new String[0]));
    }

    static {
        statusMap.put("new", INSTANCE::buttonVisibleEditWaitSubmit);
        statusMap.put(DispatchBackStatusEnum.WAIT_SUBMIT.getCode(), INSTANCE::buttonVisibleWaitSubmit);
        statusMap.put(DispatchBackStatusEnum.ALR_SUBMIT.getCode(), INSTANCE::buttonVisibleSubmit);
        statusMap.put(DispatchBackStatusEnum.WAIT_RESUBMIT.getCode(), INSTANCE::buttonVisibleWaitReSubmit);
        statusMap.put("modify" + DispatchBackStatusEnum.WAIT_RESUBMIT.getCode(), INSTANCE::buttonVisibleWaitReSubmitEdit);
        statusMap.put(DispatchBackStatusEnum.APPROVING.getCode(), INSTANCE::buttonVisibleDiscard);
        statusMap.put(DispatchBackStatusEnum.PASS.getCode(), INSTANCE::buttonVisibleNoPass);
        statusMap.put(DispatchBackStatusEnum.NOT_PASS.getCode(), INSTANCE::buttonVisibleNoPass);
        statusMap.put(DispatchBackStatusEnum.DISCARD.getCode(), INSTANCE::buttonVisibleNoPass);
    }
}

