/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.formplugin.web.back;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.hr.ham.business.domain.service.bill.IDispatchBackBillService;
import kd.hr.ham.business.domain.service.common.IPersonAboutService;
import kd.hr.ham.business.domain.service.common.IShowPageByBillService;
import kd.hr.ham.business.domain.service.record.DispatchRecordService;
import kd.hr.ham.common.dispatch.constants.DispatchBackPageConstants;
import kd.hr.ham.common.dispatch.constants.DispbackBillConstants;
import kd.hr.ham.common.dispatch.enums.DispatchBackStatusEnum;
import kd.hr.ham.common.dispatch.utils.HamNPEExpUtil;
import kd.hr.ham.formplugin.web.common.DispatchBillFormCommon;
import kd.hr.ham.formplugin.web.common.DispatchPageUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import org.apache.commons.lang3.tuple.Pair;

public class DispatchBackFormPlugin
extends HRCoreBaseBillEdit
implements DispbackBillConstants,
DispatchBackPageConstants {
    private static final Log log = LogFactory.getLog(DispatchBackFormPlugin.class);
    private static final DispatchBackFormPlugin INSTANCE = new DispatchBackFormPlugin();
    private static final DispatchBillFormCommon billCommon = DispatchBillFormCommon.getInstance();
    private static final Map<String, Consumer<IFormView>> statusMap = new HashMap<String, Consumer<IFormView>>(16);
    private final List<String> cleanFields = Lists.newArrayList((Object[])new String[]{"dispatchrecord", "countryback", "companyback", "deptback", "positionback", "poststandardback", "orgback", "adminorgback", "empgroupback", "cmpempback", "superiorback", "inchargeback", "person", "countryin", "companyin", "deptin", "positionin", "poststandardin", "orgin", "adminorgin", "empgroupin", "cmpempin", "insuperior", "inincharge", "startdate", "duration", "baselocationin", "laborrelstatus", "pospatternback", "pospatternin"});

    private void pageProcessNew(IFormView view) {
        Map<String, Object> params = this.getBillHeadParams(view);
        DispatchPageUtil.showPageInContainer(view, "ham_billheadadd", "billheadaddflex", params);
        this.pageVisibleFlexNew(view);
    }

    private void pageProcessEdit(IFormView view) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        long pkValue = dataEntity.getLong("id");
        if (0L == pkValue) {
            DynamicObject dispatchFileObj = dataEntity.getDynamicObject("ermanfile");
            long mainErmanFile = DispatchBillFormCommon.getInstance().getMainErmanFileId(dispatchFileObj);
            Map params = IPersonAboutService.getInstance().getCardFields(mainErmanFile);
            this.noSavePerson(view, params);
            this.pageVisibleFlexEdit(view);
            return;
        }
        this.saveDataBillHead(view);
        this.pageVisibleFlexSave(view);
        this.posAndStdPosVisible(view);
    }

    private void pageProcessPass(IFormView view) {
        this.saveDataBillHead(view);
        this.compareInfoPage(view);
        this.pageVisibleFlexSubmit(view);
    }

    private void pageProcessNoPass(IFormView view) {
        this.saveDataBillHead(view);
        this.compareInfoPage(view);
        this.pageVisibleFlexNoPass(view);
    }

    private void pageProcessDiscard(IFormView view) {
        this.saveDataBillHead(view);
        this.compareInfoPage(view);
        this.pageVisibleFlexDiscard(view);
    }

    private void noSavePerson(IFormView view, Map<String, Object> personCards) {
        IDataModel model = view.getModel();
        log.info("kd.hr.ham.formplugin.web.back.DispatchBackFormPlugin.noSavePerson");
        Map<String, Object> billHeadParam = this.getBillHeadParams(view);
        DispatchPageUtil.showPageInContainer(view, "ham_billheadadd", "billheadaddflex", billHeadParam);
        billCommon.showPersonCard(view, "personcardflex", personCards);
        this.posAndStdPosVisible(view);
        this.setDateMin(view, model);
    }

    private void setDateMin(IFormView view, IDataModel model) {
        DateTimeEdit backDate = (DateTimeEdit)view.getControl("backdate");
        Date startDate = model.getDataEntity().getDate("startdate");
        backDate.setMinDate(HRDateTimeUtils.addDay((Date)startDate, (long)1L));
        DateTimeEdit dispatchEndDate = (DateTimeEdit)view.getControl("enddate");
        dispatchEndDate.setMinDate(HRDateTimeUtils.addDay((Date)startDate, (long)1L));
    }

    private void saveDataBillHead(IFormView view) {
        Map<String, Object> params = this.getBillHeadParams(view);
        DispatchPageUtil.showPageInContainer(view, "ham_billheadedit", "headpaneledit", params);
        DynamicObject dispatchErmanFile = view.getModel().getDataEntity().getDynamicObject("ermanfile");
        long mainErmanFile = DispatchBillFormCommon.getInstance().getMainErmanFileId(dispatchErmanFile);
        Map personCards = IPersonAboutService.getInstance().getCardFields(mainErmanFile);
        billCommon.showPersonCard(view, "headpanelperson", personCards);
    }

    private Map<String, Object> getBillHeadParams(IFormView view) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        String billFormId = view.getFormShowParameter().getFormId();
        return IShowPageByBillService.getInstance().buildBillHeadParams(dataEntity, billFormId);
    }

    private void pageProcessWaitSubmit(IFormView view) {
        this.saveDataBillHead(view);
        this.pageVisibleFlexSave(view);
        this.posAndStdPosVisible(view);
    }

    private void pageProcessSubmit(IFormView view) {
        this.compareInfoPage(view);
        this.saveDataBillHead(view);
        this.pageVisibleFlexSubmit(view);
    }

    private void compareInfoPage(IFormView view) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        String billFormId = view.getFormShowParameter().getFormId();
        DispatchPageUtil.showPageInContainer(view, "ham_compareinfo", "compareinfoflex", IShowPageByBillService.getInstance().buildCompareBackInfo(dataEntity, billFormId));
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        Object customParam = formShowParameter.getCustomParam("dispatchrecord");
        if (status == OperationStatus.ADDNEW || !Objects.isNull(customParam)) {
            this.setAddCaption(formShowParameter, ResManager.loadKDString((String)"\u65b0\u589e\u5916\u6d3e\u6d3e\u8fd4\u7533\u8bf7", (String)"DispatchBackFormPlugin_0", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        } else {
            Object pkId = ((BillShowParameter)e.getSource()).getPkId();
            DynamicObject obj = IDispatchBackBillService.getInstance().queryOneDispatchBack((Long)pkId);
            this.setAddCaption(formShowParameter, ResManager.loadKDString((String)"\u5916\u6d3e\u6d3e\u8fd4\u7533\u8bf7-%s", (String)"DispatchBackFormPlugin_1", (String)"hr-ham-formplugin", (Object[])new Object[]{Optional.ofNullable(obj.getString("person.name")).orElse("")}));
        }
    }

    private void setAddCaption(FormShowParameter formShowParameter, String SYSTEM_TYPE_FORMPLUGIN) {
        formShowParameter.setCaption(SYSTEM_TYPE_FORMPLUGIN);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object customParam = formShowParameter.getCustomParam("dispatchrecord");
        if (!Objects.isNull(customParam)) {
            this.getModel().setValue("ermanfile", customParam);
        }
        OperationStatus status = ((BillView)this.getView()).getStatus();
        if (HRObjectUtils.isEmpty((Object)this.getView().getPageCache().get("view")) && OperationStatus.ADDNEW != status) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
        }
    }

    private void pageVisibleFlexNew(IFormView view) {
        ArrayList flexes = Lists.newArrayList((Object[])new String[]{"billheadeditflex", "personcardflex", "compareinfoflex", "dispatchbackinfoflex", "dispatchdetailflex", "curhumanrelationflex", "backhumanrelationflex", "terminateflex", "attachmentpanel", "commentflex"});
        this.visibleFlex(view, flexes);
    }

    private void pageVisibleFlexEdit(IFormView view) {
        ArrayList flexes = Lists.newArrayList((Object[])new String[]{"billheadeditflex", "compareinfoflex", "initpanalflex", "terminateflex", "initpanalflex"});
        this.visibleFlex(view, flexes);
    }

    private void pageVisibleFlexSave(IFormView view) {
        ArrayList flexes = Lists.newArrayList((Object[])new String[]{"billheadaddflex", "billinfoflex", "personcardflex", "compareinfoflex", "terminateflex", "initpanalflex"});
        this.visibleFlex(view, flexes);
    }

    private void pageVisibleFlexSubmit(IFormView view) {
        ArrayList flexes = Lists.newArrayList((Object[])new String[]{"billheadaddflex", "billinfoflex", "personcardflex", "dispatchdetailflex", "terminateflex", "initpanalflex"});
        this.visibleFlex(view, flexes);
    }

    private void pageVisibleFlexNoPass(IFormView view) {
        ArrayList flexes = Lists.newArrayList((Object[])new String[]{"billheadaddflex", "billinfoflex", "personcardflex", "dispatchdetailflex", "terminateflex", "initpanalflex"});
        this.visibleFlex(view, flexes);
    }

    private void pageVisibleFlexDiscard(IFormView view) {
        ArrayList flexes = Lists.newArrayList((Object[])new String[]{"billheadaddflex", "billinfoflex", "personcardflex", "dispatchdetailflex", "initpanalflex"});
        this.visibleFlex(view, flexes);
    }

    private void visibleFlex(IFormView view, List<String> visibleFalseFlex) {
        ArrayList allFlexes = Lists.newArrayList((Object[])new String[]{"billheadaddflex", "billheadeditflex", "billinfoflex", "headpanelperson", "personcardflex", "compareinfoflex", "dispatchbackinfoflex", "dispatchdetailflex", "initpanalflex", "terminateflex", "commentflex", "attachmentpanel"});
        DispatchBillFormCommon.getInstance().visibleFlexFalse(view, allFlexes, visibleFalseFlex);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DispatchBillFormCommon.getInstance().auditAreaShow(this.getView());
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject fileObj = dataEntity.getDynamicObject("ermanfile");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        if (HRObjectUtils.isEmpty((Object)fileObj)) {
            statusMap.get("new").accept(this.getView());
            return;
        }
        if (OperationStatus.EDIT == status || OperationStatus.ADDNEW == status) {
            statusMap.get("edit").accept(this.getView());
            if (OperationStatus.EDIT == status) {
                this.setDateMin(this.getView(), this.getView().getModel());
            }
        } else {
            String backStatus = dataEntity.getString("backstatus");
            log.info("backStatus:{}", (Object)backStatus);
            backStatus = this.convertStatus(backStatus);
            Consumer<IFormView> statusMethod = statusMap.get(backStatus);
            if (!Objects.isNull(statusMethod)) {
                statusMethod.accept(this.getView());
            }
        }
    }

    public void afterLoadData(EventObject event) {
        IDataModel model = this.getModel();
        if (model.getValue("b_ermanfile") == null) {
            model.setValue("b_ermanfile", model.getValue("ermanfile"));
        }
    }

    private void posAndStdPosVisible(IFormView view) {
        DispatchBillFormCommon.getInstance().posPatternFieldConsumer.accept(view, "4");
        DispatchBillFormCommon.getInstance().posPatternFieldConsumer.accept(view, "5");
    }

    private String convertStatus(String backStatus) {
        if (backStatus.equals(DispatchBackStatusEnum.APPROVING.getCode())) {
            backStatus = DispatchBackStatusEnum.ALR_SUBMIT.getCode();
        } else if (backStatus.equals(DispatchBackStatusEnum.WAIT_RESUBMIT.getCode())) {
            backStatus = DispatchBackStatusEnum.WAIT_SUBMIT.getCode();
        } else if (backStatus.equals(DispatchBackStatusEnum.NOT_PASS.getCode())) {
            backStatus = DispatchBackStatusEnum.NOT_PASS.getCode();
        } else {
            return backStatus;
        }
        return backStatus;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        log.info("kd.hr.ham.formplugin.web.back.DispatchBackFormPlugin.beforeDoOperation");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Pair<Boolean, Long> dayRes;
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        String propertyName = property.getName();
        if (HRStringUtils.equals((String)"ermanfile", (String)propertyName)) {
            this.cleanData(this.getView());
            if (!Objects.isNull(newValue)) {
                DynamicObject dispatchErmanFile = (DynamicObject)newValue;
                long dispatchErmanFileId = dispatchErmanFile.getLong("id");
                DynamicObject recordObj = DispatchRecordService.getInstance().queryOneDispatchRecord(Long.valueOf(dispatchErmanFileId));
                HamNPEExpUtil.throwExp((Object)recordObj, (String)ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38", (String)"DispatchBackFormPlugin_7", (String)"hr-ham-formplugin", (Object[])new Object[0]));
                boolean errUserFlag = DispatchBillFormCommon.getInstance().f7validateAndTip(this.getView(), dispatchErmanFile, recordObj);
                if (errUserFlag) {
                    this.getModel().setValue("ermanfile", null);
                    return;
                }
                this.getView().getModel().setValue("b_ermanfile", newValue);
                long mainErmanFile = DispatchBillFormCommon.getInstance().getMainErmanFileId(dispatchErmanFile);
                this.getModel().setValue("dispatchrecord", (Object)recordObj.getLong("boid"));
                Map params = IPersonAboutService.getInstance().getCardFields(mainErmanFile);
                this.initDispatchBackArea(params);
                this.initDispatchRecordArea(recordObj);
                this.noSavePerson(this.getView(), params);
                this.pageVisibleFlexEdit(this.getView());
            } else {
                statusMap.get("new").accept(this.getView());
            }
        }
        if (HRStringUtils.equals((String)"enddate", (String)propertyName) && Boolean.TRUE.equals((dayRes = DispatchBillFormCommon.getInstance().getBetweenDays("startdate", "enddate", this.getModel())).getKey())) {
            this.getModel().setValue("duration", dayRes.getRight());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        if (!HRObjectUtils.isEmpty((Object)operationResult) && operationResult.isSuccess() && operationResult.getValidateResult().isSuccess()) {
            String operateKey = args.getOperateKey();
            if (DispatchBillFormCommon.REFRESH_REFRESH_KEY.contains(operateKey)) {
                this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
                this.getView().invokeOperation("refresh");
            }
            if ("modify".equals(operateKey)) {
                this.getView().setStatus(OperationStatus.EDIT);
                this.getView().cacheFormShowParameter();
                this.getView().getPageCache().put("view", "1");
                this.getView().updateView();
            }
        }
    }

    private void initDispatchRecordArea(DynamicObject recordObj) {
        log.info("initDispatchRecordArea_recordAdminOrgIn:{}", recordObj.get("adminorgin"));
        Map recordInitParam = IDispatchBackBillService.getInstance().buildRecordAreaParam(recordObj);
        DynamicObjectCollection coll = recordObj.getDynamicObjectCollection("insuperior");
        Object[] superiorIds = coll.stream().map(col -> col.getLong("fbasedataid_id")).toArray();
        recordInitParam.put("insuperior", superiorIds);
        DynamicObjectCollection inchargeColl = recordObj.getDynamicObjectCollection("inincharge");
        Object[] inChargeIds = inchargeColl.stream().map(col -> col.getLong("fbasedataid_id")).toArray();
        recordInitParam.put("inincharge", inChargeIds);
        DispatchBillFormCommon.getInstance().intiDispatchOutInfo(this.getView(), recordInitParam, "insuperior", "inincharge");
    }

    private void initDispatchBackArea(Map<String, Object> personCardFields) {
        Map backInitParam = IDispatchBackBillService.getInstance().buildBackAreaParam(personCardFields);
        backInitParam.put("superiorback", personCardFields.get("superiorinfo"));
        backInitParam.put("inchargeback", personCardFields.get("chargeinfo"));
        DispatchBillFormCommon.getInstance().intiDispatchOutInfo(this.getView(), backInitParam, "superiorback", "inchargeback");
    }

    public void cleanData(IFormView view) {
        DispatchBillFormCommon.cleanData(view, this.cleanFields);
        DispatchBillFormCommon.cleanData(view, Lists.newArrayList((Object[])new String[]{"dispbackreason", "backdate", "description", "baselocationback"}));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        this.cleanFields.add("billno");
        this.cleanFields.add("number");
        DispatchBillFormCommon.setBizChanged(dataEntity, this.cleanFields.toArray(new String[0]));
        e.setSkipNoField(true);
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)"reachdate");
        if (!HRObjectUtils.isEmpty((Object)iDataEntityProperty)) {
            dataEntityState.setBizChanged(iDataEntityProperty.getOrdinal(), false);
        }
    }

    static {
        statusMap.put("new", INSTANCE::pageProcessNew);
        statusMap.put("edit", INSTANCE::pageProcessEdit);
        statusMap.put(DispatchBackStatusEnum.WAIT_SUBMIT.getCode(), INSTANCE::pageProcessWaitSubmit);
        statusMap.put(DispatchBackStatusEnum.ALR_SUBMIT.getCode(), INSTANCE::pageProcessSubmit);
        statusMap.put(DispatchBackStatusEnum.PASS.getCode(), INSTANCE::pageProcessPass);
        statusMap.put(DispatchBackStatusEnum.NOT_PASS.getCode(), INSTANCE::pageProcessNoPass);
        statusMap.put(DispatchBackStatusEnum.DISCARD.getCode(), INSTANCE::pageProcessDiscard);
    }
}

