/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.formplugin.web.back;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.IListView;
import kd.hr.ham.business.domain.repository.bill.DispatchBackRepository;
import kd.hr.ham.business.domain.service.bill.IDispatchBackBillService;
import kd.hr.ham.business.domain.service.validator.DyObjValidateContext;
import kd.hr.ham.formplugin.web.common.OperateUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class TerminateDispatchBackPlugin
extends HRDynamicFormBasePlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        if (!HRStringUtils.equals((String)source.getOperateKey(), (String)"discard_bill")) {
            return;
        }
        IFormView view = this.getView();
        boolean selectRowCheck = OperateUtils.selectRowCheck(view, 1);
        if (selectRowCheck) {
            view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u201c\u7ec8\u6b62\u201d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DispatchBillListPlugin_1", (String)"hr-ham-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Long idByView = OperateUtils.getIdByView(this.getView());
        if (!DispatchBackRepository.getInstance().isExists((Object)idByView)) {
            args.setCancel(true);
            String errorMsg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\u3002", (String)"TerminateDispatchBackPlugin_1", (String)"hr-ham-formplugin", (Object[])new Object[0]);
            if (this.getView() instanceof IListView) {
                errorMsg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"TerminateDispatchBackPlugin_0", (String)"hr-ham-formplugin", (Object[])new Object[0]);
            }
            this.getView().showErrorNotification(errorMsg);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (!HRStringUtils.equals((String)operateKey, (String)"discard_bill")) {
            return;
        }
        if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        DynamicObject dynamicObject = OperateUtils.getCurrentDO(this.getView());
        DyObjValidateContext context = IDispatchBackBillService.getInstance().terminateValidate(dynamicObject);
        String validateResultStr = context.getValidatorContext().getValidateResultStr();
        if (HRStringUtils.isNotEmpty((String)validateResultStr)) {
            this.getView().showErrorNotification(validateResultStr);
            return;
        }
        this.showTerminateForm(operateKey);
    }

    private void showTerminateForm(String operateKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ham_terminateconfirm");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("billFormId", (Object)"ham_dispback");
        showParameter.setCustomParam("id", (Object)OperateUtils.getIdByView(this.getView()));
        showParameter.setCustomParam("key", (Object)operateKey);
        showParameter.setCustomParam("terminal_tip", (Object)"ham_dispback");
        this.getView().showForm(showParameter);
    }
}

