/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.formplugin.web.change;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.ham.business.domain.repository.bill.RecordChangeRepository;
import kd.hr.ham.business.domain.service.bill.IDisChangeRecordValidatorService;
import kd.hr.ham.business.domain.service.validator.DyObjValidateContext;
import kd.hr.ham.common.dispatch.constants.DispbackBillConstants;
import kd.hr.ham.formplugin.web.common.DispatchBillFormCommon;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class DisChangeRecordOperateFormPlugin
extends HRDynamicFormBasePlugin
implements DispbackBillConstants {
    private static final Log LOGGER = LogFactory.getLog(DisChangeRecordOperateFormPlugin.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long pk = dataEntity.getLong("id");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            if (HRStringUtils.equals((String)operateKey, (String)"save")) {
                DynamicObject change = this.getModel().getDataEntity();
                boolean validResult = DispatchBillFormCommon.getInstance().f7validateAndTipChangeOp(this.getView(), change.getDynamicObject("ermanfile"), change.getDynamicObject("dispatchrecord"), pk);
                if (validResult) {
                    args.setCancel(true);
                    return;
                }
            }
            return;
        }
        if (HRStringUtils.equals((String)operateKey, (String)"submit") || HRStringUtils.equals((String)operateKey, (String)"unsubmit") || HRStringUtils.equals((String)operateKey, (String)"modify") || HRStringUtils.equals((String)operateKey, (String)"save") || HRStringUtils.equals((String)operateKey, (String)"viewflowchart")) {
            DyObjValidateContext dyObjValidateContext;
            List errors;
            boolean validResult;
            if (!RecordChangeRepository.getInstance().isExists((Object)pk)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\u3002", (String)"DispatchBillFormPlugin_8", (String)"hr-ham-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject bill = RecordChangeRepository.getInstance().queryOne((Object)pk);
            if ((HRStringUtils.equals((String)operateKey, (String)"save") || HRStringUtils.equals((String)operateKey, (String)"modify")) && (validResult = DispatchBillFormCommon.getInstance().f7validateAndTipChangeOp(this.getView(), bill.getDynamicObject("ermanfile"), bill.getDynamicObject("dispatchrecord"), pk))) {
                args.setCancel(true);
                return;
            }
            ArrayList dynamicObjects = Lists.newArrayListWithExpectedSize((int)1);
            dynamicObjects.add(bill);
            List dataDivs = Lists.newArrayListWithExpectedSize((int)4);
            String entityId = this.getView().getEntityId();
            if (HRStringUtils.equals((String)operateKey, (String)"submit")) {
                dataDivs = IDisChangeRecordValidatorService.getInstance().batchSubmitValidate((List)dynamicObjects, entityId);
            }
            if (HRStringUtils.equals((String)operateKey, (String)"unsubmit")) {
                dataDivs = IDisChangeRecordValidatorService.getInstance().batchUnSubmitValidate((List)dynamicObjects, entityId);
            }
            if (!(errors = dataDivs.stream().filter(temp -> temp.getValidatorContext().getValidateResult().size() > 0).collect(Collectors.toList())).isEmpty()) {
                this.getView().showErrorNotification(((DyObjValidateContext)errors.get(0)).getValidatorContext().getValidateResultStr());
                args.setCancel(true);
                return;
            }
            if (HRStringUtils.equals((String)operateKey, (String)"modify") && !(dyObjValidateContext = IDisChangeRecordValidatorService.getInstance().editValidate(bill)).isSuccess()) {
                args.setCancel(true);
                this.getView().showErrorNotification(dyObjValidateContext.getValidatorContext().getValidateResultStr());
                return;
            }
            if (HRStringUtils.equals((String)operateKey, (String)"save") && !(dyObjValidateContext = IDisChangeRecordValidatorService.getInstance().saveValidate(bill)).isSuccess()) {
                args.setCancel(true);
                this.getView().showErrorNotification(dyObjValidateContext.getValidatorContext().getValidateResultStr());
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"submit") || HRStringUtils.equals((String)operateKey, (String)"unsubmit")) {
            OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
            LOGGER.info("dispatch change form operationResult:{}", (Object)JSON.toJSONString((Object)operationResult));
            if (operationResult.isSuccess()) {
                this.getView().invokeOperation("refresh");
            } else {
                operationResult.setShowMessage(false);
                List errInfoList = operationResult.getAllErrorOrValidateInfo();
                if (CollectionUtils.isEmpty((Collection)errInfoList)) {
                    this.getView().showErrorNotification(operationResult.getMessage());
                }
                for (IOperateInfo iOperateInfo : errInfoList) {
                    String message = iOperateInfo.getMessage();
                    this.getView().showErrorNotification(message);
                }
            }
        }
    }
}

