/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.formplugin.web.change;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.hr.ham.business.domain.service.bill.IRecordChangeBillService;
import kd.hr.ham.business.domain.service.common.IPersonAboutService;
import kd.hr.ham.business.domain.service.common.IShowPageByBillService;
import kd.hr.ham.business.domain.service.record.DispatchRecordService;
import kd.hr.ham.common.dispatch.constants.DispatchChangeBillConstants;
import kd.hr.ham.common.dispatch.constants.DispatchChangePageConstants;
import kd.hr.ham.common.dispatch.enums.RecordChangeStatusEnum;
import kd.hr.ham.common.dispatch.utils.HamNPEExpUtil;
import kd.hr.ham.formplugin.web.common.DispatchBillFormCommon;
import kd.hr.ham.formplugin.web.common.DispatchPageUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import org.apache.commons.lang3.tuple.Pair;

public class DispatchChangeRecordFormPlugin
extends HRCoreBaseBillEdit
implements DispatchChangeBillConstants,
DispatchChangePageConstants {
    private static final Log log = LogFactory.getLog(DispatchChangeRecordFormPlugin.class);
    private static final DispatchBillFormCommon billCommon = DispatchBillFormCommon.getInstance();
    private static final DispatchChangeRecordFormPlugin INSTANCE = new DispatchChangeRecordFormPlugin();
    private static final Map<String, Consumer<IFormView>> statusFun = new HashMap<String, Consumer<IFormView>>(16);
    private static final Map<String, BiConsumer<IFormView, ChangeData>> propChangeFun = new HashMap<String, BiConsumer<IFormView, ChangeData>>(8);
    private final List<String> cleanFields = Lists.newArrayList((Object[])new String[]{"orgback", "cmpempback", "adminorgback", "empgroupback", "orgin", "cmpempin", "adminorgin", "empgroupin", "startdate", "bdisptype", "enddate", "duration", "person", "planduration", "planstartdate", "dispatchrecord", "laborrelstatus", "depemp"});

    private void propChangeEndDate(IFormView view, ChangeData changeData) {
        IDataModel model = view.getModel();
        Pair<Boolean, Long> dayRes = billCommon.getBetweenDays("planstartdate", "planenddate", model);
        if (!((Boolean)dayRes.getKey()).booleanValue()) {
            return;
        }
        Long days = (Long)dayRes.getRight();
        model.setValue("planduration", (Object)days);
    }

    private void propChangeErManFile(IFormView view, ChangeData changeData) {
        this.cleanData(view);
        IDataModel model = view.getModel();
        Object newValue = changeData.getNewValue();
        log.info("dispatch_record_val: {}", newValue);
        if (!Objects.isNull(newValue)) {
            DynamicObject dispatchErmanFile = (DynamicObject)newValue;
            long dispatchErmanFileId = dispatchErmanFile.getLong("id");
            DynamicObject recordObj = DispatchRecordService.getInstance().queryOneDispatchRecord(Long.valueOf(dispatchErmanFileId));
            HamNPEExpUtil.throwExp((Object)recordObj, (String)"no dispatch record for dispatchErmanFileId");
            boolean errUserFlag = DispatchBillFormCommon.getInstance().f7validateAndTipChange(view, dispatchErmanFile, recordObj);
            if (errUserFlag) {
                model.setValue("ermanfile", null);
                return;
            }
            view.getModel().setValue("b_ermanfile", newValue);
            model.setValue("dispatchrecord", (Object)recordObj.getLong("boid"));
            model.setValue("depemp", dispatchErmanFile.get("depemp_id"));
            long mainErmanFileId = DispatchBillFormCommon.getInstance().getMainErmanFileId(dispatchErmanFile);
            this.initErManFileInfo(view, mainErmanFileId);
            this.initDispatchRecordInfo(view, recordObj);
            this.noSavePerson(view);
            this.pageVisibleFlexEdit(view);
            this.dispatchCompareInfo(view);
            return;
        }
        statusFun.get("new").accept(view);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        if (!HRObjectUtils.isEmpty((Object)operationResult) && operationResult.isSuccess() && operationResult.getValidateResult().isSuccess()) {
            String operateKey = args.getOperateKey();
            if (DispatchBillFormCommon.REFRESH_REFRESH_KEY.contains(operateKey)) {
                this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
                this.getView().invokeOperation("refresh");
            }
            if ("modify".equals(operateKey)) {
                this.getView().setStatus(OperationStatus.EDIT);
                this.getView().cacheFormShowParameter();
                this.getView().getPageCache().put("view", "1");
                this.getView().updateView();
            }
        }
    }

    private void initDispatchRecordInfo(IFormView view, DynamicObject recordEntity) {
        Map<String, Object> initParams = this.buildRecordParam(recordEntity);
        billCommon.intiDispatchOutInfo(view, initParams, "superiorback", "inchargeback");
    }

    private void initErManFileInfo(IFormView view, long ermanFileId) {
        Map ermanFileMap = IPersonAboutService.getInstance().getCardFields(ermanFileId);
        Map<String, Object> initParams = this.buildErmanFileObjMap(ermanFileMap);
        billCommon.intiDispatchOutInfo(view, initParams, "superiorback", "inchargeback");
    }

    private void pageProcessNew(IFormView view) {
        Map<String, Object> params = this.getBillHeadParams(view);
        DispatchPageUtil.showPageInContainer(view, "ham_billheadadd", "billheadaddflex", params);
        this.pageVisibleFlexNew(view);
    }

    private void pageProcessPass(IFormView view) {
        this.saveDataBillHead(view);
        this.changeCompareInfo(view);
        this.dispatchCompareInfo(view);
        this.pageVisibleFlexSubmit(view);
    }

    private void pageProcessDiscard(IFormView view) {
        this.saveDataBillHead(view);
        this.changeCompareInfo(view);
        this.dispatchCompareInfo(view);
        this.pageVisibleFlexDiscard(view);
    }

    private void pageProcessEdit(IFormView view) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        long pkValue = dataEntity.getLong("id");
        this.dispatchCompareInfo(view);
        if (0L == pkValue) {
            this.noSavePerson(view);
            this.pageVisibleFlexEdit(view);
            return;
        }
        this.saveDataBillHead(view);
        this.pageVisibleFlexSave(view);
    }

    private void noSavePerson(IFormView view) {
        Map<String, Object> params = this.getBillHeadParams(view);
        DispatchPageUtil.showPageInContainer(view, "ham_billheadadd", "billheadaddflex", params);
        billCommon.showPersonCard(view, "personcardflex");
        this.setMinDate(view);
    }

    private void setMinDate(IFormView view) {
        DateTimeEdit endDate = (DateTimeEdit)view.getControl("planenddate");
        Date startDate = view.getModel().getDataEntity().getDate("planstartdate");
        endDate.setMinDate(HRDateTimeUtils.addDay((Date)startDate, (long)1L));
    }

    private void saveDataBillHead(IFormView view) {
        Map<String, Object> params = this.getBillHeadParams(view);
        DispatchPageUtil.showPageInContainer(view, "ham_billheadedit", "headpaneledit", params);
        billCommon.showPersonCard(view, "headpanelperson");
    }

    private Map<String, Object> getBillHeadParams(IFormView view) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        String billFormId = view.getFormShowParameter().getFormId();
        return IShowPageByBillService.getInstance().buildBillHeadParams(dataEntity, billFormId);
    }

    private void pageProcessWaitSubmit(IFormView view) {
        this.dispatchCompareInfo(view);
        this.saveDataBillHead(view);
        this.pageVisibleFlexSave(view);
    }

    private void pageProcessSubmit(IFormView view) {
        this.changeCompareInfo(view);
        this.dispatchCompareInfo(view);
        this.saveDataBillHead(view);
        this.pageVisibleFlexSubmit(view);
    }

    private void changeCompareInfo(IFormView view) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        String billFormId = view.getFormShowParameter().getFormId();
        DispatchPageUtil.showPageInContainer(view, "ham_compareinfo", "changecompareinfoflex", IShowPageByBillService.getInstance().buildCompareChangeInfo(dataEntity, billFormId));
    }

    private void dispatchCompareInfo(IFormView view) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        String billFormId = view.getFormShowParameter().getFormId();
        DispatchPageUtil.showPageInContainer(view, "ham_compareinfo", "compareinfoflex", IShowPageByBillService.getInstance().buildCompareDispatchInfo(dataEntity, billFormId));
    }

    private void pageProcessNoPass(IFormView view) {
        this.changeCompareInfo(view);
        this.dispatchCompareInfo(view);
        this.saveDataBillHead(view);
        this.pageVisibleFlexNoPass(view);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        Object customParam = formShowParameter.getCustomParam("dispatchrecord");
        if (status == OperationStatus.ADDNEW || !Objects.isNull(customParam)) {
            this.setAddCaption(formShowParameter, ResManager.loadKDString((String)"\u65b0\u589e\u5916\u6d3e\u53d8\u66f4\u7533\u8bf7", (String)"DispatchChangeRecordListPlugin_4", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        } else {
            Object pkId = ((BillShowParameter)e.getSource()).getPkId();
            DynamicObject obj = IRecordChangeBillService.getInstance().queryOneDispatchChange((Long)pkId);
            this.setAddCaption(formShowParameter, ResManager.loadKDString((String)"\u5916\u6d3e\u53d8\u66f4\u7533\u8bf7-%s", (String)"DispatchChangeRecordFormPlugin_0", (String)"hr-ham-formplugin", (Object[])new Object[]{Optional.ofNullable(obj.getString("person.name")).orElse("")}));
        }
    }

    private void setAddCaption(FormShowParameter formShowParameter, String caption) {
        formShowParameter.setCaption(caption);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object customParam = formShowParameter.getCustomParam("dispatchrecord");
        if (!Objects.isNull(customParam)) {
            this.getModel().setValue("ermanfile", customParam);
        }
        OperationStatus status = ((BillView)this.getView()).getStatus();
        if (HRObjectUtils.isEmpty((Object)this.getView().getPageCache().get("view")) && OperationStatus.ADDNEW != status) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
        }
    }

    private void pageVisibleFlexNew(IFormView view) {
        ArrayList flexes = Lists.newArrayList((Object[])new String[]{"billheadeditflex", "personcardflex", "compareinfoflex", "dispatchbackinfoflex", "dispatchdetailflex", "curhumanrelationflex", "backhumanrelationflex", "terminateflex", "attachmentpanel", "commentflex", "dispatchinflex", "changecompareinfoflex", "dispatchoutflex"});
        this.visibleFlex(view, flexes);
    }

    private void pageVisibleFlexEdit(IFormView view) {
        ArrayList flexes = Lists.newArrayList((Object[])new String[]{"billheadeditflex", "initpanalflex", "changecompareinfoflex", "terminateflex", "initpanalflex"});
        this.visibleFlex(view, flexes);
    }

    private void pageVisibleFlexSave(IFormView view) {
        ArrayList flexes = Lists.newArrayList((Object[])new String[]{"billheadaddflex", "billinfoflex", "personcardflex", "changecompareinfoflex", "terminateflex", "initpanalflex"});
        this.visibleFlex(view, flexes);
    }

    private void pageVisibleFlexSubmit(IFormView view) {
        ArrayList flexes = Lists.newArrayList((Object[])new String[]{"billheadaddflex", "billinfoflex", "personcardflex", "dispatchdetailflex", "terminateflex", "initpanalflex"});
        this.visibleFlex(view, flexes);
    }

    private void pageVisibleFlexNoPass(IFormView view) {
        ArrayList flexes = Lists.newArrayList((Object[])new String[]{"billheadaddflex", "billinfoflex", "personcardflex", "dispatchdetailflex", "terminateflex", "initpanalflex"});
        this.visibleFlex(view, flexes);
    }

    private void pageVisibleFlexDiscard(IFormView view) {
        ArrayList flexes = Lists.newArrayList((Object[])new String[]{"billheadaddflex", "billinfoflex", "personcardflex", "dispatchdetailflex", "initpanalflex"});
        this.visibleFlex(view, flexes);
    }

    private void visibleFlex(IFormView view, List<String> visibleFalseFlex) {
        ArrayList allFlexes = Lists.newArrayList((Object[])new String[]{"billheadaddflex", "billheadeditflex", "billinfoflex", "headpanelperson", "personcardflex", "compareinfoflex", "dispatchbackinfoflex", "dispatchdetailflex", "initpanalflex", "terminateflex", "commentflex", "attachmentpanel", "dispatchinflex", "changecompareinfoflex", "dispatchoutflex"});
        view.setVisible(Boolean.FALSE, visibleFalseFlex.toArray(new String[0]));
        allFlexes.removeAll(visibleFalseFlex);
        view.setVisible(Boolean.TRUE, allFlexes.toArray(new String[0]));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        billCommon.auditAreaShow(this.getView());
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject fileObj = dataEntity.getDynamicObject("ermanfile");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        if (HRObjectUtils.isEmpty((Object)fileObj)) {
            log.info("DispatchChangeRecordFormPlugin.afterBindData_NEW");
            statusFun.get("new").accept(this.getView());
            return;
        }
        if (OperationStatus.EDIT == status || OperationStatus.ADDNEW == status) {
            log.info("DispatchChangeRecordFormPlugin.afterBindData_EDIT");
            statusFun.get("edit").accept(this.getView());
            if (OperationStatus.EDIT == status) {
                this.setMinDate(this.getView());
            }
        } else {
            String changeStatus = dataEntity.getString("changestatus");
            log.info("DispatchChangeRecordFormPlugin.afterBindData_StatusCode:{}_Name:{}", (Object)changeStatus, (Object)RecordChangeStatusEnum.getName((String)changeStatus));
            changeStatus = this.convertStatus(changeStatus);
            Consumer<IFormView> statusMethod = statusFun.get(changeStatus);
            if (!Objects.isNull(statusMethod)) {
                statusMethod.accept(this.getView());
            }
        }
    }

    public void afterLoadData(EventObject event) {
        IDataModel model = this.getModel();
        if (model.getValue("b_ermanfile") == null) {
            model.setValue("b_ermanfile", model.getValue("ermanfile"));
        }
    }

    private String convertStatus(String backStatus) {
        if (HRStringUtils.equals((String)backStatus, (String)RecordChangeStatusEnum.WAIT_RESUBMIT.getCode())) {
            backStatus = RecordChangeStatusEnum.WAIT_SUBMIT.getCode();
        } else if (HRStringUtils.equals((String)backStatus, (String)RecordChangeStatusEnum.ALR_SUBMIT.getCode()) || HRStringUtils.equals((String)backStatus, (String)RecordChangeStatusEnum.APPROVING.getCode())) {
            backStatus = RecordChangeStatusEnum.ALR_SUBMIT.getCode();
        } else if (HRStringUtils.equals((String)backStatus, (String)RecordChangeStatusEnum.NOT_PASS.getCode())) {
            backStatus = RecordChangeStatusEnum.NOT_PASS.getCode();
        } else {
            return backStatus;
        }
        return backStatus;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        ChangeData changeData = e.getChangeSet()[0];
        String propertyName = property.getName();
        BiConsumer<IFormView, ChangeData> proFun = propChangeFun.get(propertyName);
        if (!Objects.isNull(proFun)) {
            proFun.accept(this.getView(), changeData);
        }
    }

    private Map<String, Object> buildErmanFileObjMap(Map<String, Object> cardFields) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)16);
        params.put("laborrelstatus", cardFields.get("laborrelstatus_id"));
        params.put("person", cardFields.get("person_id"));
        params.put("orgback", cardFields.get("org_id"));
        params.put("cmpempback", cardFields.get("managingscope_id"));
        params.put("adminorgback", cardFields.get("affiliateadminorg_id"));
        params.put("empgroupback", cardFields.get("empgroup_id"));
        return params;
    }

    private Map<String, Object> buildRecordParam(DynamicObject recordObj) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)16);
        params.put("orgin", recordObj.get("orgin"));
        params.put("cmpempin", recordObj.get("cmpempin"));
        params.put("adminorgin", recordObj.get("adminorgin"));
        params.put("empgroupin", recordObj.get("empgroupin"));
        params.put("planstartdate", recordObj.get("startdate"));
        params.put("startdate", recordObj.get("startdate"));
        params.put("bdisptype", recordObj.get("disptype"));
        params.put("enddate", recordObj.get("planenddate"));
        params.put("duration", recordObj.get("planduration"));
        return params;
    }

    public void cleanData(IFormView view) {
        DispatchBillFormCommon.cleanData(view, this.cleanFields);
        DispatchBillFormCommon.cleanData(view, Lists.newArrayList((Object[])new String[]{"plandisptype", "planenddate", "description"}));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        this.cleanFields.add("billno");
        this.cleanFields.add("number");
        DispatchBillFormCommon.setBizChanged(dataEntity, this.cleanFields.toArray(new String[0]));
    }

    static {
        statusFun.put("new", INSTANCE::pageProcessNew);
        statusFun.put("edit", INSTANCE::pageProcessEdit);
        statusFun.put(RecordChangeStatusEnum.WAIT_SUBMIT.getCode(), INSTANCE::pageProcessWaitSubmit);
        statusFun.put(RecordChangeStatusEnum.ALR_SUBMIT.getCode(), INSTANCE::pageProcessSubmit);
        statusFun.put(RecordChangeStatusEnum.PASS.getCode(), INSTANCE::pageProcessPass);
        statusFun.put(RecordChangeStatusEnum.NOT_PASS.getCode(), INSTANCE::pageProcessNoPass);
        statusFun.put(RecordChangeStatusEnum.DISCARD.getCode(), INSTANCE::pageProcessDiscard);
        propChangeFun.put("ermanfile", INSTANCE::propChangeErManFile);
        propChangeFun.put("planenddate", INSTANCE::propChangeEndDate);
    }
}

