/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.formplugin.web.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.FieldTip;
import kd.bos.form.IFormView;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.fieldtip.DeleteRule;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.ham.business.domain.repository.bill.DispatchBackRepository;
import kd.hr.ham.business.domain.repository.bill.RecordChangeRepository;
import kd.hr.ham.business.domain.repository.dispatchrecord.DispatchRecordRepository;
import kd.hr.ham.business.domain.service.bill.IDispatchBackBillService;
import kd.hr.ham.business.domain.service.bill.IDispatchBillService;
import kd.hr.ham.business.domain.service.bill.IRecordChangeBillService;
import kd.hr.ham.business.domain.service.common.IDispabackPersonChangeService;
import kd.hr.ham.business.domain.service.common.IPersonAboutService;
import kd.hr.ham.business.domain.service.common.IShowPageByBillService;
import kd.hr.ham.business.domain.status.dto.CrossValidateMsg;
import kd.hr.ham.business.domain.status.dto.CrossValidateParamDto;
import kd.hr.ham.business.domain.status.dto.CrossValidateResDto;
import kd.hr.ham.common.dispatch.bean.DispatchStatusBean;
import kd.hr.ham.common.dispatch.bean.PosPatternConfig;
import kd.hr.ham.common.dispatch.bean.PosPatternConfigBean;
import kd.hr.ham.common.dispatch.constants.DispatchBillConstants;
import kd.hr.ham.common.dispatch.enums.DispatchInStatusEnum;
import kd.hr.ham.common.dispatch.enums.DispatchOutStatusEnum;
import kd.hr.ham.common.dispatch.enums.DispatchPageTypeEnum;
import kd.hr.ham.common.dispatch.enums.DispatchStatusEnum;
import kd.hr.ham.common.dispatch.enums.record.DispatchRecordStatusEnum;
import kd.hr.ham.common.dispatch.utils.HamNPEExpUtil;
import kd.hr.ham.formplugin.web.common.DispatchPageUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.service.cert.HRCertValidateServiceHelper;
import org.apache.commons.lang3.tuple.Pair;

public class DispatchBillFormCommon
implements DispatchBillConstants {
    private static final Log log = LogFactory.getLog(DispatchBillFormCommon.class);
    private static final IPersonAboutService personService = IPersonAboutService.getInstance();
    public static Set<String> REFRESH_REFRESH_KEY = ImmutableSet.of((Object)"save", (Object)"submit", (Object)"unsubmit");
    public static final List<String> DISPATCH_INFO = ImmutableList.of((Object)"dispreason", (Object)"disptype", (Object)"startdate", (Object)"enddate");
    public static final List<String> PLAN_DISPATCH_INFO = ImmutableList.of((Object)"plandispreason", (Object)"plandisptype", (Object)"planstartdate", (Object)"planenddate");
    public static final List<String> DISPATCH_DETAIL = ImmutableList.of((Object)"countryin", (Object)"deptin", (Object)"cmpempin", (Object)"inradiogroupfield", (Object)"baselocationin", (Object)"reachdate");
    public static final List<String> PLAN_DISPATCH_DETAIL = ImmutableList.of((Object)"plancountry", (Object)"plandepin", (Object)"plancmpempin", (Object)"radiogroupfield", (Object)"planreachdate");
    public BiConsumer<IFormView, String> posPatternFieldConsumer = (view, type) -> {
        PosPatternConfigBean posPatternConfigKey = (PosPatternConfigBean)PosPatternConfig.CONFIG.get(type);
        String patternKey = posPatternConfigKey.getPatternKey();
        String posPattern = view.getModel().getDataEntity().getString(patternKey);
        String stdPosKey = posPatternConfigKey.getStdPosKey();
        String posKey = posPatternConfigKey.getPosKey();
        String jobKey = posPatternConfigKey.getJobKey();
        if ("2".equals(posPattern)) {
            view.setVisible(Boolean.TRUE, new String[]{jobKey});
            view.setVisible(Boolean.FALSE, new String[]{stdPosKey, posKey});
        } else if ("0".equals(posPattern)) {
            view.setVisible(Boolean.TRUE, new String[]{stdPosKey, jobKey});
            view.setVisible(Boolean.FALSE, new String[]{posKey});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{posKey, jobKey});
            view.setVisible(Boolean.FALSE, new String[]{stdPosKey});
        }
    };
    public BiConsumer<IFormView, String> posPatternFieldMustInputConsumer = (view, type) -> {
        PosPatternConfigBean posPatternConfigKey = (PosPatternConfigBean)PosPatternConfig.CONFIG.get(type);
        String patternKey = posPatternConfigKey.getPatternKey();
        String posPattern = view.getModel().getDataEntity().getString(patternKey);
        String stdPosKey = posPatternConfigKey.getStdPosKey();
        String posKey = posPatternConfigKey.getPosKey();
        String jobKey = posPatternConfigKey.getJobKey();
        String superiorKey = posPatternConfigKey.getSuperiorKey();
        OperationStatus status = view.getFormShowParameter().getStatus();
        if (OperationStatus.EDIT == status) {
            view.setEnable(Boolean.valueOf(!"1".equals(posPattern)), new String[]{superiorKey});
        }
        if ("2".equals(posPattern)) {
            this.setFieldsMustInput((IFormView)view, jobKey, true);
            this.setFieldsMustInput((IFormView)view, Arrays.asList(posKey, stdPosKey), false);
            view.setEnable(Boolean.TRUE, new String[]{jobKey});
        } else if ("0".equals(posPattern)) {
            this.setFieldsMustInput((IFormView)view, stdPosKey, true);
            this.setFieldsMustInput((IFormView)view, Arrays.asList(posKey, jobKey), false);
            view.setEnable(Boolean.FALSE, new String[]{jobKey});
        } else {
            this.setFieldsMustInput((IFormView)view, posKey, true);
            this.setFieldsMustInput((IFormView)view, Arrays.asList(stdPosKey, jobKey), false);
            view.setEnable(Boolean.FALSE, new String[]{jobKey});
        }
    };

    public void setFieldsMustInput(IFormView view, List<String> fields) {
        this.setFieldsMustInput(view, fields, true);
    }

    public void setFieldsMustInput(IFormView view, List<String> fields, boolean flag) {
        fields.forEach(field -> {
            FieldEdit fieldEdit = (FieldEdit)view.getControl(field);
            fieldEdit.setMustInput(flag);
        });
    }

    public void setFieldsMustInput(IFormView view, String field, boolean isMustInput) {
        this.setFieldsMustInput(view, Collections.singletonList(field), isMustInput);
    }

    public boolean tipCrossValidateRes(IFormView view, CrossValidateParamDto crossValidateDto, boolean isPos) {
        boolean flag = false;
        CrossValidateResDto crossValidateResDto = personService.buildCrossValidateParams(crossValidateDto);
        List validateMsg = crossValidateResDto.getMsgs();
        for (CrossValidateMsg msg : validateMsg) {
            String msgType = msg.getMsgType();
            if (HRStringUtils.equals((String)msgType, (String)"ignore")) continue;
            if (HRStringUtils.equals((String)msgType, (String)"error")) {
                flag = true;
                view.showErrorNotification(msg.getMsgInfo());
                continue;
            }
            if (isPos) continue;
            view.showTipNotification(msg.getMsgInfo());
        }
        return flag;
    }

    public static void setBizChanged(DynamicObject dataEntity, boolean isChanged, String ... propKeys) {
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        for (String propKey : propKeys) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)propKey);
            if (property == null) continue;
            dataEntityState.setBizChanged(property.getOrdinal(), isChanged);
            if (!(property instanceof BasedataProp)) continue;
            property = (IDataEntityProperty)properties.get((Object)(propKey + "_id"));
            Optional.ofNullable(property).ifPresent(p -> dataEntityState.setBizChanged(p.getOrdinal(), isChanged));
        }
    }

    public static void setBizChanged(DynamicObject dataEntity, String ... propKeys) {
        DispatchBillFormCommon.setBizChanged(dataEntity, false, propKeys);
    }

    public static void cleanData(IFormView view) {
        List<String> cleanFields = Arrays.asList("countryout", "companyout", "deptout", "positionout", "standardposout", "orgout", "adminorgout", "empgroupout", "dispatchasuperior", "dispatchaincharge", "cmpempout", "person", "laborrelstatus", "plandepin", "planpositionin", "plancountry", "plancompanyin", "plancmpempin", "planstandardposin", "dispatchplansup", "dispatchplanincha", "planreachdate", "deptin", "positionin", "countryin", "companyin", "cmpempin", "standardposin", "baselocationin", "dispatchinsuperior", "dispatchinincharge", "reachdate", "disptype", "dispreason", "startdate", "enddate", "duration", "leavedate", "plandispreason", "plandisptype", "planstartdate", "planenddate", "planduration", "description", "orgin", "adminorgin", "dependencyin", "dependencytypein", "pospatternout", "jobout");
        view.getModel().setValue("radiogroupfield", (Object)"1");
        view.getModel().setValue("inradiogroupfield", (Object)"1");
        DispatchBillFormCommon.cleanData(view, cleanFields);
    }

    public static void cleanData(IFormView view, List<String> fields) {
        fields.forEach(field -> view.getModel().setValue(field, null));
    }

    public void validateCrossTransaction(IFormView view, String type) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        CrossValidateParamDto crossDto = personService.getCrossValidateParamByCardFields(dataEntity, type);
        this.tipCrossValidateRes(view, crossDto, true);
        this.tipDirectorValidate(view, dataEntity);
    }

    public boolean tipDirectorValidate(IFormView view, DynamicObject dataEntity) {
        String billFormId = view.getFormShowParameter().getFormId();
        DispatchPageTypeEnum dispatchPageType = DispatchPageTypeEnum.getEnumByCode((String)billFormId);
        boolean billRes = IDispatchBillService.getInstance().validateDispatchAsDirector(dataEntity, dispatchPageType);
        if (billRes) {
            String tip = IDispatchBillService.getInstance().getDirectorTip(dispatchPageType, dataEntity);
            view.showErrorNotification(MessageFormat.format(tip, dataEntity.getString("person.name")));
        }
        return billRes;
    }

    public DispatchStatusBean getDispatchStatusBean(IFormView view) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        BillShowParameter parameter = (BillShowParameter)view.getFormShowParameter();
        BillOperationStatus billStatus = parameter.getBillStatus();
        String outInOrder = dataEntity.getString("disoutinorder");
        String outStatus = dataEntity.getString("outstatus");
        String inStatus = dataEntity.getString("instatus");
        String billName = view.getFormShowParameter().getFormId();
        String dispatchStatus = dataEntity.getString("dispatchstatus");
        String auditStatus = dataEntity.getString("auditstatus");
        DispatchStatusBean dispatchStatusBean = new DispatchStatusBean();
        dispatchStatusBean.setOutInOrder(outInOrder);
        dispatchStatusBean.setBillStatus(billStatus);
        dispatchStatusBean.setInStatus(DispatchInStatusEnum.getEnumByCode((String)inStatus));
        dispatchStatusBean.setOutStatus(DispatchOutStatusEnum.getEnumByCode((String)outStatus));
        dispatchStatusBean.setDispatchStatus(DispatchStatusEnum.getEnumByCode((String)dispatchStatus));
        dispatchStatusBean.setAuditStatus(auditStatus);
        dispatchStatusBean.setBillName(billName);
        dispatchStatusBean.setSubmit(dataEntity.getBoolean("issubmit"));
        log.info("dispatchStatusBean billName : {}, inStatus: {}, outStatus: {}", new Object[]{dispatchStatusBean.getBillName(), dispatchStatusBean.getInStatus(), dispatchStatusBean.getOutStatus()});
        return dispatchStatusBean;
    }

    private DispatchBillFormCommon() {
    }

    public static DispatchBillFormCommon getInstance() {
        return DispatchFormCommonMethodHolder.INSTANCE;
    }

    public void showBillHeadAdd(IFormView view) {
        this.showBillHead(view);
    }

    public void showBillHeadEdit(IFormView view) {
        this.showBillHead(view);
        Map cardFields = personService.getCardFields(view.getModel().getDataEntity());
        this.showPersonCard(view, "headpanelperson", cardFields);
    }

    public void showBillCompareInfo(IFormView view, boolean isShowDispatchInInfo) {
        String formId = view.getFormShowParameter().getFormId();
        DynamicObject billData = view.getModel().getDataEntity();
        DispatchPageUtil.showPageInContainer(view, "ham_compareinfo", "compareinfoap", IShowPageByBillService.getInstance().buildCompareInfo(billData, formId));
        if (isShowDispatchInInfo) {
            HashMap itemMap = Maps.newHashMapWithExpectedSize((int)4);
            HashMap tipMap = Maps.newHashMapWithExpectedSize((int)4);
            tipMap.put("zh_CN", ResManager.loadKDString((String)"\u6d3e\u5165\u4fe1\u606f", (String)"DispatchBillListCommon_10", (String)"hr-ham-formplugin", (Object[])new Object[0]));
            itemMap.put("text", tipMap);
            view.updateControlMetadata("panel_dispinfo", (Map)itemMap);
            view.setVisible(Boolean.FALSE, new String[]{"dipatchdetailoutflex", "dipatchdetailplanflex", "dispatchdetailin"});
            List<String> dispatchInfoFields = Arrays.asList("dispreason", "disptype", "startdate", "enddate", "duration");
            dispatchInfoFields.forEach(field -> view.getModel().setValue(field + "view", view.getModel().getValue(field)));
            view.setVisible(Boolean.TRUE, new String[]{"dipatchdetailinflex", "dispreasonview", "disptypeview", "startdateview", "enddateview", "durationview"});
            view.getModel().setValue("companyindigest", billData.get("companyin"));
            view.getModel().setValue("deptindigest", billData.get("deptin"));
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"panel_dispinfo"});
        }
    }

    public void showPersonCard(IFormView view, String targetKey, Map<String, Object> cardFields) {
        Map personChangeParams = personService.buildPersonChangeParams(cardFields);
        Map personCardParams = (Map)personChangeParams.get("personCardParams");
        DispatchPageUtil.showPageInContainer(view, "ham_personalcard", targetKey, personCardParams);
        view.setVisible(Boolean.TRUE, new String[]{targetKey});
    }

    public boolean f7validateAndTip(IFormView view, DynamicObject dispatchErmanFile, DynamicObject recordObj) {
        String hrCertValMsg = this.getCertValidateMsg(dispatchErmanFile.getLong("person.id"), ResManager.loadKDString((String)"\u6d3e\u8fd4", (String)"DispatchBillFormPlugin_13", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        if (HRStringUtils.isNotEmpty((String)hrCertValMsg)) {
            view.showErrorNotification(hrCertValMsg);
            return true;
        }
        String flag = "0";
        String statusTip = ResManager.loadKDString((String)"\u6240\u9009\u4eba\u5458\u201c{0}\u201d\u7684\u5916\u6d3e\u6863\u6848\u4e3a\u5df2\u5931\u6548\uff0c\u4e0d\u53ef\u53d1\u8d77\u6d3e\u8fd4\u3002", (String)"DispatchBackFormPlugin_3", (String)"hr-ham-formplugin", (Object[])new Object[0]);
        flag = this.ermanFileStatusValid(view, dispatchErmanFile, recordObj, flag, statusTip);
        flag = this.backBillValidate(view, dispatchErmanFile, flag);
        flag = this.crossValidate(view, dispatchErmanFile, flag, true);
        this.changeBillValidate(view, dispatchErmanFile, recordObj.getLong("id"));
        return "1".equals(flag);
    }

    public String getCertValidateMsg(Long personId, String busMsg) {
        String clientUrl = RequestContext.get().getClientUrl();
        log.info("DispatchBillFormCommon.getCertValidateMsg_{}", (Object)clientUrl);
        return HRCertValidateServiceHelper.getValidataMsg((Long)personId, (String)busMsg);
    }

    public boolean f7validateAndTipOp(IFormView view, DynamicObject dispatchErmanFile, DynamicObject recordObj, Long id) {
        String flag = "0";
        String statusTip = ResManager.loadKDString((String)"\u6240\u9009\u4eba\u5458\u201c{0}\u201d\u7684\u5916\u6d3e\u6863\u6848\u4e3a\u5df2\u5931\u6548\uff0c\u4e0d\u53ef\u53d1\u8d77\u6d3e\u8fd4\u3002", (String)"DispatchBackFormPlugin_3", (String)"hr-ham-formplugin", (Object[])new Object[0]);
        flag = this.ermanFileStatusValid(view, dispatchErmanFile, recordObj, flag, statusTip);
        if (!DispatchBackRepository.getInstance().isExists((Object)id)) {
            flag = this.backBillValidate(view, dispatchErmanFile, flag);
        }
        flag = this.crossValidate(view, dispatchErmanFile, flag, false);
        return "1".equals(flag);
    }

    private String ermanFileStatusValid(IFormView view, DynamicObject dispatchErmanFile, DynamicObject recordObj, String flag, String statusTip) {
        boolean hasTempRecord;
        log.info("ermanFileStatusValid_dispatchErmanFile:{}", dispatchErmanFile.getPkValue());
        String recordStatus = recordObj.getString("dispstatus");
        log.info("ermanFileStatusValid_recordStatus:{}", (Object)recordStatus);
        if (DispatchRecordStatusEnum.INVALID.getCode().equals(recordStatus)) {
            view.showErrorNotification(MessageFormat.format(statusTip, dispatchErmanFile.getString("name")));
            flag = "1";
        }
        if (hasTempRecord = DispatchRecordRepository.getInstance().hasTempRecordTermSource(Long.valueOf(recordObj.getLong("boid")))) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6863\u6848\u5b58\u5728\u201c\u5f85\u751f\u6548\u201d\u7684\u7ec8\u6b62\u4efb\u52a1\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"DispatchRecordServiceImpl_6", (String)"hr-ham-business", (Object[])new Object[0]));
            flag = "1";
        }
        return flag;
    }

    private String ermanFileStatusValidChange(IFormView view, DynamicObject dispatchErmanFile, DynamicObject recordObj, String flag, String statusTip) {
        boolean hasTempRecord;
        log.info("ermanFileStatusValid_dispatchErmanFile:{}", dispatchErmanFile.getPkValue());
        String recordStatus = recordObj.getString("dispstatus");
        log.info("ermanFileStatusValid_recordStatus:{}", (Object)recordStatus);
        if (DispatchRecordStatusEnum.INVALID.getCode().equals(recordStatus)) {
            view.showErrorNotification(MessageFormat.format(statusTip, dispatchErmanFile.getString("name")));
            flag = "1";
        }
        if (hasTempRecord = DispatchRecordRepository.getInstance().hasTempRecord(Long.valueOf(recordObj.getLong("boid")))) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6863\u6848\u5b58\u5728\u201c\u5f85\u751f\u6548\u201d\u7684\u7ec8\u6b62\u4efb\u52a1\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"DispatchRecordServiceImpl_6", (String)"hr-ham-business", (Object[])new Object[0]));
            flag = "1";
        }
        return flag;
    }

    public boolean f7validateAndTipChange(IFormView view, DynamicObject dispatchErmanFile, DynamicObject recordObj) {
        String hrCertValMsg = this.getCertValidateMsg(dispatchErmanFile.getLong("person.id"), ResManager.loadKDString((String)"\u53d8\u66f4", (String)"DispatchBillFormPlugin_14", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        if (HRStringUtils.isNotEmpty((String)hrCertValMsg)) {
            view.showErrorNotification(hrCertValMsg);
            return true;
        }
        String flag = "0";
        String statusTip = ResManager.loadKDString((String)"\u6240\u9009\u4eba\u5458\u201c{0}\u201d\u7684\u5916\u6d3e\u6863\u6848\u4e3a\u5df2\u5931\u6548\uff0c\u4e0d\u53ef\u53d1\u8d77\u53d8\u66f4\u3002", (String)"DispatchBackFormPlugin_4", (String)"hr-ham-formplugin", (Object[])new Object[0]);
        flag = this.ermanFileStatusValidChange(view, dispatchErmanFile, recordObj, flag, statusTip);
        DynamicObject changeObj = IRecordChangeBillService.getInstance().queryProcessingByRecord(Long.valueOf(recordObj.getLong("id")));
        log.info("f7validateAndTip_changeObj_empty: {}", (Object)changeObj);
        if (!HRObjectUtils.isEmpty((Object)changeObj)) {
            view.showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u6240\u9009\u4eba\u5458\u201c{0}\u201d\u5df2\u7ecf\u5b58\u5728\u4e8e\u53d8\u66f4\u5355\u636e\uff08{1}\uff09\u4e2d\u3002", (String)"DispatchBackFormPlugin_6", (String)"hr-ham-formplugin", (Object[])new Object[0]), dispatchErmanFile.getString("name"), changeObj.getString("billno")));
            flag = "1";
        }
        return "1".equals(flag);
    }

    public boolean f7validateAndTipChangeOp(IFormView view, DynamicObject dispatchErmanFile, DynamicObject recordObj, Long id) {
        String flag = "0";
        String statusTip = ResManager.loadKDString((String)"\u6240\u9009\u4eba\u5458\u201c{0}\u201d\u7684\u5916\u6d3e\u6863\u6848\u4e3a\u5df2\u5931\u6548\uff0c\u4e0d\u53ef\u53d1\u8d77\u53d8\u66f4\u3002", (String)"DispatchBackFormPlugin_4", (String)"hr-ham-formplugin", (Object[])new Object[0]);
        flag = this.ermanFileStatusValidChange(view, dispatchErmanFile, recordObj, flag, statusTip);
        if (!RecordChangeRepository.getInstance().isExists((Object)id)) {
            DynamicObject changeObj = IRecordChangeBillService.getInstance().queryProcessingByRecord(Long.valueOf(recordObj.getLong("id")));
            log.info("f7validateAndTip_changeObj_empty: {}", (Object)changeObj);
            if (!HRObjectUtils.isEmpty((Object)changeObj)) {
                view.showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u6240\u9009\u4eba\u5458\u201c{0}\u201d\u5df2\u7ecf\u5b58\u5728\u4e8e\u53d8\u66f4\u5355\u636e\uff08{1}\uff09\u4e2d\u3002", (String)"DispatchBackFormPlugin_6", (String)"hr-ham-formplugin", (Object[])new Object[0]), dispatchErmanFile.getString("name"), changeObj.getString("billno")));
                flag = "1";
            }
        }
        return "1".equals(flag);
    }

    private String crossValidate(IFormView view, DynamicObject ermanFile, String flag, boolean isF7) {
        IDispabackPersonChangeService instance = IDispabackPersonChangeService.getInstance();
        CrossValidateParamDto validDto = instance.getCrossValidateParamByRecordObj(ermanFile);
        CrossValidateResDto validResDto = instance.excutePersonOverlapCheckByParam(validDto);
        for (CrossValidateMsg msg : validResDto.getMsgs()) {
            String msgInfo = msg.getMsgInfo();
            if ("error".equals(msg.getMsgType())) {
                flag = "1";
                view.showErrorNotification(msgInfo);
                continue;
            }
            if (!isF7) continue;
            view.showTipNotification(msgInfo);
        }
        return flag;
    }

    private void changeBillValidate(IFormView view, DynamicObject dispatchErmanFile, long recordId) {
        DynamicObject changeObj = IRecordChangeBillService.getInstance().queryProcessingByRecord(Long.valueOf(recordId));
        log.info("f7validateAndTip_changeObj_empty: {}", (Object)changeObj);
        if (!HRObjectUtils.isEmpty((Object)changeObj)) {
            view.showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u6240\u9009\u4eba\u5458\u201c{0}\u201d\u5f53\u524d\u5df2\u6709\u8fdb\u884c\u4e2d\u7684\u5916\u6d3e\u53d8\u66f4\u5355\u201c{1}\u201d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u53d1\u8d77\u6d3e\u8fd4\u3002", (String)"DispatchBackFormPlugin_2", (String)"hr-ham-formplugin", (Object[])new Object[0]), dispatchErmanFile.getString("name"), changeObj.getString("billno")));
        }
    }

    private String backBillValidate(IFormView view, DynamicObject ermanFile, String flag) {
        DynamicObject backObj = IDispatchBackBillService.getInstance().queryOnGoingByErManFile(Long.valueOf(ermanFile.getLong("id")));
        log.info("f7validateAndTip_backObj_empty: {}", (Object)backObj);
        if (!HRObjectUtils.isEmpty((Object)backObj)) {
            flag = "1";
            view.showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u6240\u9009\u4eba\u5458\u201c{0}\u201d\u5f53\u524d\u5df2\u6709\u8fdb\u884c\u4e2d\u7684\u6d3e\u8fd4\u5355\uff08{1}\uff09\u3002", (String)"DispatchBackFormPlugin_5", (String)"hr-ham-formplugin", (Object[])new Object[0]), ermanFile.getString("name"), backObj.getString("billno")));
        }
        return flag;
    }

    public void showPersonCard(IFormView view, String targetKey) {
        DynamicObject billData = view.getModel().getDataEntity();
        log.info("start_request_getCardFields_method");
        Map cardFields = personService.getCardFields(billData);
        log.info("end_request_getCardFields_method");
        Map personChangeParams = personService.buildPersonChangeParams(cardFields);
        Map personCardParams = (Map)personChangeParams.get("personCardParams");
        DispatchPageUtil.showPageInContainer(view, "ham_personalcard", targetKey, personCardParams);
    }

    private void showBillHead(IFormView view) {
        IShowPageByBillService showPageService = IShowPageByBillService.getInstance();
        log.info("kd.hr.ham.business.domain.service.common.IShowPageByBillService->{}", (Object)showPageService);
        BillShowParameter parameter = (BillShowParameter)view.getFormShowParameter();
        DynamicObject billData = view.getModel().getDataEntity();
        String billFormId = view.getFormShowParameter().getFormId();
        log.info("showBillHead_start: {}", (Object)parameter.getBillStatus());
        if (parameter.getBillStatus().equals((Object)BillOperationStatus.ADDNEW)) {
            DispatchPageUtil.showPageInContainer(view, "ham_billheadadd", "headpaneladd", showPageService.buildBillHeadParams(billData, billFormId));
        } else {
            DispatchPageUtil.showPageInContainer(view, "ham_billheadedit", "headpaneledit", showPageService.buildBillHeadParams(billData, billFormId));
        }
        log.info("showBillHead_end: {}", (Object)parameter.getBillStatus());
    }

    public long getMainErmanFileId(DynamicObject dispatchErmanFile) {
        long employeeId = dispatchErmanFile.getLong("employee_id");
        DynamicObject primaryErManFile = personService.getPrimaryErManFile(employeeId);
        HamNPEExpUtil.throwExp((Object)primaryErManFile, (String)"select primary by personId fail");
        return primaryErManFile.getLong("id");
    }

    public void intiDispatchOutInfo(IFormView view, Map<String, Object> initParams, String keySuperior, String keyInCharge) {
        initParams.forEach((key, val) -> log.info("initParams_key:{}-value:{}", key, val));
        this.processListParam(initParams, keySuperior);
        this.processListParam(initParams, keyInCharge);
        initParams.forEach((key, value) -> view.getModel().setValue(key, value));
    }

    private void processListParam(Map<String, Object> initParams, String key) {
        Object obj = initParams.get(key);
        if (!Objects.isNull(obj)) {
            if (obj instanceof DynamicObjectCollection) {
                DynamicObjectCollection coll = (DynamicObjectCollection)obj;
                log.info("coll:{}", (Object)coll);
                Object[] objects = coll.stream().map(col -> col.getLong("id")).toArray();
                initParams.put(key, objects);
                return;
            }
            if (obj instanceof Object[]) {
                return;
            }
            List complexList = (List)obj;
            Object[] ids = complexList.stream().map(map -> (Long)map.get("id")).toArray();
            initParams.put(key, ids);
        }
    }

    public void setCountryAndDeptByPos(IDataModel model, ChangeData changeData, String countryKey, String deptKey, String jobKey) {
        Object newValue = changeData.getNewValue();
        if (!HRObjectUtils.isEmpty((Object)newValue)) {
            DynamicObject newPos = (DynamicObject)newValue;
            long countryId = newPos.getLong("countryregion.id");
            long adminOrgId = newPos.getLong("adminorg.id");
            long jobId = newPos.getLong("job.id");
            log.info("get country and dept by position countryId: {}, adminOrgId : {}", (Object)countryId, (Object)adminOrgId);
            model.setValue(countryKey, (Object)countryId);
            model.setValue(deptKey, (Object)adminOrgId);
            model.setValue(jobKey, (Object)jobId);
        }
    }

    public void setJobByStdPos(IDataModel model, ChangeData changeData, String jobKey) {
        Object newValue = changeData.getNewValue();
        if (!HRObjectUtils.isEmpty((Object)newValue)) {
            DynamicObject newStdPos = (DynamicObject)newValue;
            long jobId = newStdPos.getLong("job.id");
            model.setValue(jobKey, (Object)jobId);
        }
    }

    public void setInChargeByPos(IDataModel model, String inChargeKey, String orgField, String aPositionField, String positionField) {
        List<Long> personIds = this.getPersonIdsByPosition(model.getDataEntity(), orgField, aPositionField, positionField);
        model.setValue(inChargeKey, (Object)personIds.toArray());
    }

    private List<Long> getPersonIdsByPosition(DynamicObject dataEntity, String orgField, String aPositionField, String positionField) {
        List<Long> personId = new ArrayList<Long>();
        DynamicObject position = dataEntity.getDynamicObject(positionField);
        if (position != null) {
            personId = IDispatchBillService.getInstance().invokeGetSuperiorByRule(dataEntity, orgField, aPositionField, positionField);
        }
        return personId;
    }

    public static boolean isSecondSubmit(DynamicObject obj) {
        String inStatus = obj.getString("instatus");
        String outStatus = obj.getString("outstatus");
        return HRStringUtils.isNotEmpty((String)inStatus) && HRStringUtils.isNotEmpty((String)outStatus);
    }

    public Pair<Boolean, Long> getBetweenDays(String startKey, String endKey, IDataModel model) {
        Date start = model.getDataEntity().getDate(startKey);
        Date end = model.getDataEntity().getDate(endKey);
        if (HRObjectUtils.isEmpty((Object)start) || HRObjectUtils.isEmpty((Object)end)) {
            return Pair.of((Object)Boolean.FALSE, (Object)0L);
        }
        LocalDate startLocalDate = LocalDate.from(start.toInstant().atZone(ZoneId.systemDefault()));
        LocalDate endLocalDate = LocalDate.from(end.toInstant().atZone(ZoneId.systemDefault()));
        return Pair.of((Object)Boolean.TRUE, (Object)(ChronoUnit.DAYS.between(startLocalDate, endLocalDate) + 1L));
    }

    public void auditAreaShow(IFormView view) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        String auditStats = dataEntity.getString("auditstatus");
        boolean isSubmit = dataEntity.getBoolean("issubmit");
        String bizKey = (String)view.getFormShowParameter().getCustomParam("businessKey");
        boolean showAuditPanel = HRStringUtils.equals((String)auditStats, (String)"A") || HRStringUtils.equals((String)auditStats, (String)"G") || !HRStringUtils.isEmpty((String)bizKey) || !isSubmit;
        view.setVisible(Boolean.valueOf(!showAuditPanel), new String[]{"rightpanel"});
    }

    public FieldTip getDateFileTip(String propertyName, String tip) {
        FieldTip fieldTip = new FieldTip();
        fieldTip.setFieldKey(propertyName);
        fieldTip.setLevel(FieldTip.FieldTipsLevel.Warning);
        fieldTip.setSuccess(false);
        fieldTip.setTipsType(FieldTip.FieldTipsTypes.others);
        fieldTip.setTip(tip);
        DeleteRule deleteRule = new DeleteRule();
        deleteRule.setAction("isChange");
        deleteRule.setFields(Arrays.asList("planstartdate", "planenddate"));
        return fieldTip;
    }

    public void visibleFlexTrue(IFormView view, List<String> allFlexes, List<String> visibleFalseFlex) {
        this.visibleFlexFalse(view, allFlexes, visibleFalseFlex, Boolean.TRUE);
    }

    public void visibleFlexFalse(IFormView view, List<String> allFlexes, List<String> visibleFalseFlex) {
        this.visibleFlexFalse(view, allFlexes, visibleFalseFlex, Boolean.FALSE);
    }

    public void visibleFlexFalse(IFormView view, List<String> allFlexes, List<String> visibleFalseFlex, Boolean visible) {
        view.setVisible(visible, visibleFalseFlex.toArray(new String[0]));
        allFlexes.removeAll(visibleFalseFlex);
        view.setVisible(Boolean.valueOf(visible == false), allFlexes.toArray(new String[0]));
    }

    public void visibleFlexFalse(IFormView view, List<String> visibleFalseFlex) {
        ArrayList allFlexes = Lists.newArrayList((Object[])new String[]{"headpaneladd", "headflex", "panel_billinfo", "personcardap", "compareinfoap", "panel_business", "planpanel_business", "panel_dispinfo", "inpersonnelinfoflex", "terminatersnflex", "descriptionflex", "attachmentpanel", "initpanalflex"});
        DispatchBillFormCommon.getInstance().visibleFlexFalse(view, allFlexes, visibleFalseFlex);
    }

    public void visibleFlexTrue(IFormView view, List<String> visibleFalseFlex) {
        ArrayList allFlexes = Lists.newArrayList((Object[])new String[]{"headpaneladd", "headflex", "panel_billinfo", "personcardap", "compareinfoap", "panel_business", "planpanel_business", "panel_dispinfo", "inpersonnelinfoflex", "terminatersnflex", "descriptionflex", "attachmentpanel", "initpanalflex"});
        DispatchBillFormCommon.getInstance().visibleFlexTrue(view, allFlexes, visibleFalseFlex);
    }

    public void noPersonPage(IFormView view) {
        this.visibleFlexTrue(view, Lists.newArrayList((Object[])new String[]{"panel_billinfo", "headpaneladd", "initpanalflex"}));
    }

    public void personNoSavePage(IFormView view) {
        ArrayList flexes = Lists.newArrayList((Object[])new String[]{"headflex", "initpanalflex", "terminatersnflex", "compareinfoap"});
        String pageFlexStatus = this.getDispatchPageFlexStatus(view);
        if ("A".equals(pageFlexStatus)) {
            flexes.add("panel_business");
        } else {
            flexes.add("planpanel_business");
        }
        this.visibleFlexFalse(view, flexes);
        this.positionAreaVisible(view);
    }

    public void positionAreaVisible(IFormView view) {
        this.posPatternFieldConsumer.accept(view, "1");
    }

    public String getDispatchPageFlexStatus(IFormView view) {
        DispatchStatusBean statusBean = this.getDispatchStatusBean(view);
        String billName = statusBean.getBillName();
        String order = statusBean.getOutInOrder();
        if ("ham_dispatchout".equals(billName) && "1".equals(order)) {
            return "A";
        }
        if ("ham_dispatchout".equals(billName) || "ham_dispatchinlayout".equals(billName)) {
            return "C";
        }
        return "B";
    }

    private static class DispatchFormCommonMethodHolder {
        private static final DispatchBillFormCommon INSTANCE = new DispatchBillFormCommon();

        private DispatchFormCommonMethodHolder() {
        }
    }
}

