/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.formplugin.web.common;

import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.ham.business.domain.service.bill.IDispatchBillService;
import kd.hr.ham.business.util.ExcelUtils;
import kd.hr.ham.common.dispatch.enums.DispatchPageTypeEnum;
import kd.hr.ham.formplugin.web.common.DispatchPageUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DispatchBillListCommon {
    private static final Log log = LogFactory.getLog(DispatchBillListCommon.class);

    private DispatchBillListCommon() {
    }

    public static DispatchBillListCommon getInstance() {
        return DispatchFormCommonMethodHolder.INSTANCE;
    }

    public void commitApply(IFormView view, ListSelectedRowCollection listSelectedRows, String billFormId, BeforeDoOperationEventArgs args) {
        log.info("start_list_commitApply");
        Object[] ids = listSelectedRows.getPrimaryKeyValues();
        DynamicObject[] dispatchBills = IDispatchBillService.getInstance().queryDispatch(ids);
        DispatchPageTypeEnum dispatchPageType = DispatchPageTypeEnum.getEnumByCode((String)billFormId);
        Map validateRes = IDispatchBillService.getInstance().batchSubmitValidate(dispatchBills, dispatchPageType, null, false, false);
        validateRes.forEach((key, val) -> log.info("DispatchBillListCommon.commitApply.billNo={},vares={}", (Object)key.getString("billno"), val));
        Pair<List<DynamicObject>, List<DynamicObject>> sucAndFailDynamics = DispatchPageUtil.getSucAndFailDynamics(validateRes);
        log.info("sucSize:{}, errSize:{}", (Object)((List)sucAndFailDynamics.getKey()).size(), (Object)((List)sucAndFailDynamics.getValue()).size());
        if (validateRes.size() == 1 && ((List)sucAndFailDynamics.getValue()).isEmpty()) {
            DispatchBillListCommon.invokeSubmitOperation(view, ids, billFormId, false);
        } else if (dispatchBills.length == 1) {
            for (List value : validateRes.values()) {
                value.forEach(arg_0 -> ((IFormView)view).showErrorNotification(arg_0));
            }
            args.setCancel(true);
        } else {
            this.showMulCommitConfirmPage(view, dispatchBills, validateRes);
        }
        log.info("end_list_commitApply");
    }

    public static OperationResult invokeSubmitOperation(IFormView view, Object[] primaryKeyValues, String billFormId, boolean isMulSubmit) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("id", billFormId);
        OperationResult operationResult = view.invokeOperation("submit", operateOption);
        log.info("DispatchBillList submit result :{} ", (Object)operationResult.toString());
        if (isMulSubmit) {
            return operationResult;
        }
        if (operationResult.isSuccess() && operationResult.getValidateResult().isSuccess()) {
            boolean submitErrorInfoFlag = false;
            List allErrorInfo = operationResult.getAllErrorInfo();
            for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                String message = operateErrorInfo.getMessage();
                if (!HRStringUtils.isNotEmpty((String)message)) continue;
                view.showErrorNotification(message);
                submitErrorInfoFlag = true;
                log.info("dispatch_list_submit_mute_error:{}", (Object)message);
            }
            if (!submitErrorInfoFlag) {
                log.info("dispatch_list_submit_success");
                view.invokeOperation("refresh");
            }
        } else {
            log.info("dispatch_list_submit_fail");
            boolean needWfAssignPersons = operationResult.isNeedWfAssignPersons();
            List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
            String errorMsg = allErrorOrValidateInfo.isEmpty() ? operationResult.getMessage() : ((IOperateInfo)operationResult.getAllErrorOrValidateInfo().get(0)).getMessage();
            if (HRStringUtils.isEmpty((String)errorMsg) && needWfAssignPersons) {
                return operationResult;
            }
            String msg = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25", (String)"DispatchBillListCommon_1", (String)"hr-ham-formplugin", (Object[])new Object[0]);
            if (primaryKeyValues.length == 1 && !CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo) && HRStringUtils.isNotEmpty((String)errorMsg)) {
                msg = errorMsg;
            }
            view.showErrorNotification(msg);
        }
        return operationResult;
    }

    private void showMulCommitConfirmPage(IFormView view, DynamicObject[] bills, Map<DynamicObject, List<String>> validateRes) {
        String billFormId = ((ListShowParameter)view.getFormShowParameter()).getBillFormId();
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        Pair<List<DynamicObject>, List<DynamicObject>> sucAndFailDynamics = DispatchPageUtil.getSucAndFailDynamics(validateRes);
        params.put("sumlabel", bills.length);
        params.put("incongruentlabel", ((List)sucAndFailDynamics.getValue()).size());
        params.put("coincidentlabel", bills.length - ((List)sucAndFailDynamics.getValue()).size());
        params.put("filename", this.getSubmitFileName(view));
        params.put("headDataList", ExcelUtils.initDisBillConfirmExcelHead((String)ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"DispatchBillListCommon_3", (String)"hr-ham-formplugin", (Object[])new Object[0]), (String)billFormId));
        params.put("exportDataList", IDispatchBillService.getInstance().initCommitConfirmExportData(bills, validateRes, billFormId));
        List sucIds = ((List)sucAndFailDynamics.getKey()).stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
        params.put("ids", sucIds);
        String caption = ResManager.loadKDString((String)"\u63d0\u4ea4\u786e\u8ba4", (String)"DispatchBillListCommon_4", (String)"hr-ham-formplugin", (Object[])new Object[0]);
        params.put("caption", caption);
        DispatchPageUtil.showFormViewOfModal(view, "ham_commitconfirm", params);
    }

    private String getSubmitFileName(IFormView view) {
        String dateFormat = LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE);
        String formId = ((ListShowParameter)view.getFormShowParameter()).getBillFormId();
        String tip = HRStringUtils.equals((String)formId, (String)"ham_dispatchout") ? ResManager.loadKDString((String)"\u6d3e\u51fa\u7533\u8bf7\u63d0\u4ea4\u786e\u8ba4\u6570\u636e_{0}", (String)"DispatchBillListCommon_5", (String)"hr-ham-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6d3e\u5165\u7533\u8bf7\u63d0\u4ea4\u786e\u8ba4\u6570\u636e_{0}", (String)"DispatchBillListCommon_6", (String)"hr-ham-formplugin", (Object[])new Object[0]);
        return MessageFormat.format(tip, dateFormat);
    }

    public boolean batchOpMax(ListView view, BeforeDoOperationEventArgs args, String operateKey, HRBaseServiceHelper hrBaseServiceHelper) {
        if (HRStringUtils.equals((String)"donoting_submitlist", (String)operateKey) || HRStringUtils.equals((String)"donothing_unsubmitlist", (String)operateKey) || HRStringUtils.equals((String)"donothing_deletelist", (String)operateKey)) {
            int size = view.getSelectedRows().size();
            if (size > 100) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u9009\u62e9100\u6761\u6570\u636e\u6267\u884c\u3002", (String)"DispatchBillListCommon_7", (String)"hr-ham-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return true;
            }
            List selRowIds = view.getSelectedRows().stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
            boolean exists = hrBaseServiceHelper.isExists(new QFilter("id", "in", selRowIds));
            if (!exists) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"DispatchBillListCommon_2", (String)"hr-ham-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return true;
            }
        }
        return false;
    }

    private static class DispatchFormCommonMethodHolder {
        private static final DispatchBillListCommon INSTANCE = new DispatchBillListCommon();

        private DispatchFormCommonMethodHolder() {
        }
    }
}

