/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.formplugin.web.common;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.ham.business.domain.service.bill.IDispatchBillService;
import kd.hr.ham.common.dispatch.enums.DispatchAuditStatusEnum;
import kd.hr.ham.common.dispatch.enums.DispatchBackStatusEnum;
import kd.hr.ham.common.dispatch.enums.DispatchInStatusEnum;
import kd.hr.ham.common.dispatch.enums.DispatchOutStatusEnum;
import kd.hr.ham.common.dispatch.enums.RecordChangeStatusEnum;
import kd.hr.ham.common.dispatch.utils.CollUtils;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DispatchPageUtil {
    public static void showNewAddPage(IFormView view, FormShowParameter parameter, String formId, String caption) {
        parameter.setCaption(caption);
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm(parameter);
    }

    public static void showFormViewOfModal(IFormView view, String formId, Map<String, Object> params) {
        FormShowParameter showParameter = new FormShowParameter();
        Object caption = params.get("caption");
        if (!Objects.isNull(caption)) {
            showParameter.setCaption((String)caption);
        }
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParams(params);
        view.showForm(showParameter);
    }

    public static void showPageInContainer(IFormView view, String formId, String targetKey, Map<String, Object> customs) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        if (!HRObjectUtils.isEmpty(customs)) {
            showParameter.setCustomParams(customs);
        }
        view.showForm(showParameter);
    }

    public static void showSecondConfirm(AbstractBillPlugIn plugin, Map<String, List<DynamicObject>> operationResult, String secondConfirmExportName, String billFormId, Map<String, String> failId2ErrorMsg) {
        List success = Optional.ofNullable(operationResult.get("success")).orElseGet(() -> new ArrayList());
        List fail = Optional.ofNullable(operationResult.get("fail")).orElseGet(() -> new ArrayList());
        List<HRExportHeadObject> headDataList = DispatchPageUtil.getAuditHeadDataList(billFormId);
        List<Map<String, Object>> exportDataList = DispatchPageUtil.getTemplateExportDataList(operationResult, ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u8fd8\u6709\u672a\u68c0\u6d4b\u901a\u8fc7\u7684\u4fe1\u606f", (String)"DispatchPageUtil_0", (String)"hr-ham-formplugin", (Object[])new Object[0]), failId2ErrorMsg);
        FormShowParameter formShowParameter = DispatchPageUtil.getResultPage("", String.valueOf(success.size()), ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"DispatchPageUtil_1", (String)"hr-ham-formplugin", (Object[])new Object[0]), String.valueOf(fail.size()), ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"DispatchPageUtil_2", (String)"hr-ham-formplugin", (Object[])new Object[0]), secondConfirmExportName, exportDataList, headDataList);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "ham_listresult"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u679c", (String)"DispatchPageUtil_3", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        plugin.getView().showForm(formShowParameter);
    }

    public static void showDisBackSecondConfirm(AbstractBillPlugIn plugin, Map<String, List<DynamicObject>> operationResult, String secondConfirmExportName, String billFormId, Map<String, String> failId2ErrorMsg) {
        List success = Optional.ofNullable(operationResult.get("success")).orElseGet(() -> new ArrayList());
        List fail = Optional.ofNullable(operationResult.get("fail")).orElseGet(() -> new ArrayList());
        List<HRExportHeadObject> headDataList = DispatchPageUtil.getDisBackAuditHeadDataList(billFormId);
        List<Map<String, Object>> exportDataList = DispatchPageUtil.getDisBackTemplateExportDataList(operationResult, ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u8fd8\u6709\u672a\u68c0\u6d4b\u901a\u8fc7\u7684\u4fe1\u606f", (String)"DispatchPageUtil_0", (String)"hr-ham-formplugin", (Object[])new Object[0]), failId2ErrorMsg);
        FormShowParameter formShowParameter = DispatchPageUtil.getResultPage("", String.valueOf(success.size()), ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"DispatchPageUtil_1", (String)"hr-ham-formplugin", (Object[])new Object[0]), String.valueOf(fail.size()), ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"DispatchPageUtil_2", (String)"hr-ham-formplugin", (Object[])new Object[0]), secondConfirmExportName, exportDataList, headDataList);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "ham_listresult"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u679c", (String)"DispatchPageUtil_3", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        plugin.getView().showForm(formShowParameter);
    }

    public static void showDisChangeRecordConfirm(AbstractBillPlugIn plugin, Map<String, List<DynamicObject>> operationResult, String secondConfirmExportName, String billFormId, Map<String, String> failId2ErrorMsg) {
        List success = Optional.ofNullable(operationResult.get("success")).orElseGet(ArrayList::new);
        List fail = Optional.ofNullable(operationResult.get("fail")).orElseGet(ArrayList::new);
        List<HRExportHeadObject> headDataList = DispatchPageUtil.getDisChangeRecordAuditHeadDataList(billFormId);
        List<Map<String, Object>> exportDataList = DispatchPageUtil.getDisChangeRecordTemplateExportDataList(operationResult, ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u8fd8\u6709\u672a\u68c0\u6d4b\u901a\u8fc7\u7684\u4fe1\u606f", (String)"DispatchPageUtil_0", (String)"hr-ham-formplugin", (Object[])new Object[0]), failId2ErrorMsg);
        FormShowParameter formShowParameter = DispatchPageUtil.getResultPage("", String.valueOf(success.size()), ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"DispatchPageUtil_1", (String)"hr-ham-formplugin", (Object[])new Object[0]), String.valueOf(fail.size()), ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"DispatchPageUtil_2", (String)"hr-ham-formplugin", (Object[])new Object[0]), secondConfirmExportName, exportDataList, headDataList);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "ham_listresult"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u679c", (String)"DispatchPageUtil_3", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        plugin.getView().showForm(formShowParameter);
    }

    public static void showSubmitSecondConfirm(AbstractBillPlugIn plugin, Pair<List<DynamicObject>, List<DynamicObject>> sucAndFailDynamics, Map<DynamicObject, List<String>> subValidate, String billFormId) {
        List success = (List)sucAndFailDynamics.getLeft();
        List fail = (List)sucAndFailDynamics.getRight();
        List<HRExportHeadObject> headDataList = DispatchPageUtil.getAuditHeadDataList(billFormId);
        List<Map<String, Object>> exportDataList = DispatchPageUtil.getTemplateExportDataListSubmit(sucAndFailDynamics, subValidate);
        FormShowParameter formShowParameter = DispatchPageUtil.getResultPage("", String.valueOf(success.size()), ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"DispatchPageUtil_1", (String)"hr-ham-formplugin", (Object[])new Object[0]), String.valueOf(fail.size()), ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"DispatchPageUtil_2", (String)"hr-ham-formplugin", (Object[])new Object[0]), DispatchPageUtil.getSubmitFileName(billFormId), exportDataList, headDataList);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "ham_listresult"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u679c", (String)"DispatchPageUtil_3", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        plugin.getView().showForm(formShowParameter);
    }

    private static String getSubmitFileName(String formId) {
        String dateFormat = LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE);
        String tip = HRStringUtils.equals((String)formId, (String)"ham_dispatchout") ? ResManager.loadKDString((String)"\u6279\u91cf\u63d0\u4ea4\u6d3e\u51fa\u7533\u8bf7\u5904\u7406\u7ed3\u679c_{0}", (String)"DispatchPageUtil_4", (String)"hr-ham-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6279\u91cf\u63d0\u4ea4\u6d3e\u5165\u7533\u8bf7\u5904\u7406\u7ed3\u679c_{0}", (String)"DispatchPageUtil_5", (String)"hr-ham-formplugin", (Object[])new Object[0]);
        return MessageFormat.format(tip, dateFormat);
    }

    public static List<HRExportHeadObject> getAuditHeadDataList(String billFormId) {
        ArrayList<HRExportHeadObject> headdatalist = new ArrayList<HRExportHeadObject>();
        headdatalist.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"DispatchPageUtil_6", (String)"hr-ham-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("worknumber", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"DispatchPageUtil_7", (String)"hr-ham-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("org", ResManager.loadKDString((String)"\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7", (String)"DispatchPageUtil_8", (String)"hr-ham-formplugin", (Object[])new Object[0])));
        if (HRStringUtils.equals((String)"ham_dispatchin", (String)billFormId)) {
            headdatalist.add(new HRExportHeadObject("instatus", ResManager.loadKDString((String)"\u6d3e\u5165\u5ba1\u6279\u72b6\u6001", (String)"DispatchPageUtil_9", (String)"hr-ham-formplugin", (Object[])new Object[0])));
        } else {
            headdatalist.add(new HRExportHeadObject("outstatus", ResManager.loadKDString((String)"\u6d3e\u51fa\u5ba1\u6279\u72b6\u6001", (String)"DispatchPageUtil_10", (String)"hr-ham-formplugin", (Object[])new Object[0])));
        }
        headdatalist.add(new HRExportHeadObject("billstatus", ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001", (String)"DispatchPageUtil_11", (String)"hr-ham-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("isSuccess", ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u679c", (String)"DispatchPageUtil_3", (String)"hr-ham-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("reason", ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0", (String)"DispatchPageUtil_12", (String)"hr-ham-formplugin", (Object[])new Object[0])));
        return headdatalist;
    }

    public static List<HRExportHeadObject> getDisBackAuditHeadDataList(String billFormId) {
        ArrayList<HRExportHeadObject> headdatalist = new ArrayList<HRExportHeadObject>();
        headdatalist.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"DispatchPageUtil_6", (String)"hr-ham-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("worknumber", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"DispatchPageUtil_7", (String)"hr-ham-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("org", ResManager.loadKDString((String)"\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7", (String)"DispatchPageUtil_8", (String)"hr-ham-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("backstatus", ResManager.loadKDString((String)"\u6d3e\u8fd4\u5ba1\u6279\u72b6\u6001", (String)"DispatchPageUtil_15", (String)"hr-ham-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("billstatus", ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001", (String)"DispatchPageUtil_11", (String)"hr-ham-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("isSuccess", ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u679c", (String)"DispatchPageUtil_3", (String)"hr-ham-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("reason", ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0", (String)"DispatchPageUtil_12", (String)"hr-ham-formplugin", (Object[])new Object[0])));
        return headdatalist;
    }

    public static List<HRExportHeadObject> getDisChangeRecordAuditHeadDataList(String billFormId) {
        ArrayList<HRExportHeadObject> headdatalist = new ArrayList<HRExportHeadObject>();
        headdatalist.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"DispatchPageUtil_6", (String)"hr-ham-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("worknumber", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"DispatchPageUtil_7", (String)"hr-ham-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("org", ResManager.loadKDString((String)"\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7", (String)"DispatchPageUtil_8", (String)"hr-ham-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("changestatus", ResManager.loadKDString((String)"\u53d8\u66f4\u5ba1\u6279\u72b6\u6001", (String)"DispatchPageUtil_16", (String)"hr-ham-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("billstatus", ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001", (String)"DispatchPageUtil_11", (String)"hr-ham-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("isSuccess", ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u679c", (String)"DispatchPageUtil_3", (String)"hr-ham-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("reason", ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0", (String)"DispatchPageUtil_12", (String)"hr-ham-formplugin", (Object[])new Object[0])));
        return headdatalist;
    }

    public static Pair<List<DynamicObject>, List<DynamicObject>> getSucAndFailDynamics(Map<DynamicObject, List<String>> operationResult) {
        ArrayList success = Lists.newArrayList();
        ArrayList fail = Lists.newArrayList();
        for (Map.Entry<DynamicObject, List<String>> resEntry : operationResult.entrySet()) {
            DynamicObject resKey = resEntry.getKey();
            List<String> resVal = resEntry.getValue();
            if (CollUtils.isEmpty(resVal)) {
                success.add(resKey);
                continue;
            }
            fail.add(resKey);
        }
        return Pair.of((Object)success, (Object)fail);
    }

    public static List<Map<String, Object>> getTemplateExportDataList(Map<String, List<DynamicObject>> source, String defaultFailReason, Map<String, String> failId2ErrorMsg) {
        ArrayList<Map<String, Object>> exportdatalist = new ArrayList<Map<String, Object>>();
        List<DynamicObject> success = source.get("success");
        List<DynamicObject> fail = source.get("fail");
        DispatchPageUtil.buildExceportInfo(success, exportdatalist, ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"DispatchPageUtil_13", (String)"hr-ham-formplugin", (Object[])new Object[0]), "", null);
        DispatchPageUtil.buildExceportInfo(fail, exportdatalist, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"DispatchPageUtil_14", (String)"hr-ham-formplugin", (Object[])new Object[0]), defaultFailReason, failId2ErrorMsg);
        return exportdatalist;
    }

    public static List<Map<String, Object>> getDisBackTemplateExportDataList(Map<String, List<DynamicObject>> source, String defaultFailReason, Map<String, String> failId2ErrorMsg) {
        ArrayList<Map<String, Object>> exportdatalist = new ArrayList<Map<String, Object>>();
        List<DynamicObject> success = source.get("success");
        List<DynamicObject> fail = source.get("fail");
        DispatchPageUtil.buildDisBackExceportInfo(success, exportdatalist, ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"DispatchPageUtil_13", (String)"hr-ham-formplugin", (Object[])new Object[0]), "", null);
        DispatchPageUtil.buildDisBackExceportInfo(fail, exportdatalist, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"DispatchPageUtil_14", (String)"hr-ham-formplugin", (Object[])new Object[0]), defaultFailReason, failId2ErrorMsg);
        return exportdatalist;
    }

    public static List<Map<String, Object>> getDisChangeRecordTemplateExportDataList(Map<String, List<DynamicObject>> source, String defaultFailReason, Map<String, String> failId2ErrorMsg) {
        ArrayList<Map<String, Object>> exportdatalist = new ArrayList<Map<String, Object>>();
        List<DynamicObject> success = source.get("success");
        List<DynamicObject> fail = source.get("fail");
        DispatchPageUtil.buildDisChangeRecordExceportInfo(success, exportdatalist, ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"DispatchPageUtil_13", (String)"hr-ham-formplugin", (Object[])new Object[0]), "", null);
        DispatchPageUtil.buildDisChangeRecordExceportInfo(fail, exportdatalist, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"DispatchPageUtil_14", (String)"hr-ham-formplugin", (Object[])new Object[0]), defaultFailReason, failId2ErrorMsg);
        return exportdatalist;
    }

    public static List<Map<String, Object>> getTemplateExportDataListSubmit(Pair<List<DynamicObject>, List<DynamicObject>> source, Map<DynamicObject, List<String>> subValidate) {
        ArrayList<Map<String, Object>> exportdatalist = new ArrayList<Map<String, Object>>();
        Object[] objects = ((List)source.getLeft()).stream().map(obj -> obj.getPkValue()).toArray();
        DynamicObject[] successObjs = IDispatchBillService.getInstance().queryDispatch(objects);
        DispatchPageUtil.buildExceportInfo(successObjs, exportdatalist, ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"DispatchPageUtil_13", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        DispatchPageUtil.buildExceportFailInfo((List)source.getRight(), exportdatalist, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"DispatchPageUtil_14", (String)"hr-ham-formplugin", (Object[])new Object[0]), subValidate);
        return exportdatalist;
    }

    private static void buildExceportInfo(List<DynamicObject> source, List<Map<String, Object>> exportdatalist, String isSuccess, String defaultFailReason, Map<String, String> failId2ErrorMsg) {
        List temp = Optional.ofNullable(source).orElseGet(() -> new ArrayList());
        for (DynamicObject dynamicObject : temp) {
            HashMap<String, String> map = new HashMap<String, String>(source.size());
            map.put("name", dynamicObject.getString("ermanfile.name"));
            map.put("worknumber", dynamicObject.getString("ermanfile.number"));
            map.put("org", dynamicObject.getDynamicObject("org").getString("name"));
            map.put("billstatus", DispatchAuditStatusEnum.getName((String)dynamicObject.getString("billstatus")));
            map.put("instatus", DispatchInStatusEnum.getName((String)dynamicObject.getString("instatus")));
            map.put("outstatus", DispatchOutStatusEnum.getName((String)dynamicObject.getString("outstatus")));
            map.put("isSuccess", isSuccess);
            String reason = defaultFailReason;
            if (null != failId2ErrorMsg && failId2ErrorMsg.size() > 0) {
                reason = failId2ErrorMsg.get(dynamicObject.getString("id"));
            }
            map.put("reason", reason);
            exportdatalist.add(map);
        }
    }

    private static void buildDisBackExceportInfo(List<DynamicObject> source, List<Map<String, Object>> exportdatalist, String isSuccess, String defaultFailReason, Map<String, String> failId2ErrorMsg) {
        List temp = Optional.ofNullable(source).orElseGet(() -> new ArrayList());
        for (DynamicObject dynamicObject : temp) {
            HashMap<String, String> map = new HashMap<String, String>(source.size());
            map.put("name", dynamicObject.getString("ermanfile.name"));
            map.put("worknumber", dynamicObject.getString("ermanfile.number"));
            map.put("org", dynamicObject.getDynamicObject("org").getString("name"));
            map.put("billstatus", DispatchAuditStatusEnum.getName((String)dynamicObject.getString("billstatus")));
            map.put("backstatus", DispatchBackStatusEnum.getName((String)dynamicObject.getString("backstatus")));
            map.put("isSuccess", isSuccess);
            String reason = defaultFailReason;
            if (null != failId2ErrorMsg && failId2ErrorMsg.size() > 0) {
                reason = failId2ErrorMsg.get(dynamicObject.getString("id"));
            }
            map.put("reason", reason);
            exportdatalist.add(map);
        }
    }

    private static void buildDisChangeRecordExceportInfo(List<DynamicObject> source, List<Map<String, Object>> exportdatalist, String isSuccess, String defaultFailReason, Map<String, String> failId2ErrorMsg) {
        List temp = Optional.ofNullable(source).orElseGet(() -> new ArrayList());
        for (DynamicObject dynamicObject : temp) {
            HashMap<String, String> map = new HashMap<String, String>(source.size());
            map.put("name", dynamicObject.getString("ermanfile.name"));
            map.put("worknumber", dynamicObject.getString("ermanfile.number"));
            map.put("org", dynamicObject.getDynamicObject("org").getString("name"));
            map.put("billstatus", DispatchAuditStatusEnum.getName((String)dynamicObject.getString("billstatus")));
            map.put("changestatus", RecordChangeStatusEnum.getName((String)dynamicObject.getString("changestatus")));
            map.put("isSuccess", isSuccess);
            String reason = defaultFailReason;
            if (null != failId2ErrorMsg && failId2ErrorMsg.size() > 0) {
                reason = failId2ErrorMsg.get(dynamicObject.getString("id"));
            }
            map.put("reason", reason);
            exportdatalist.add(map);
        }
    }

    private static void buildExceportInfo(DynamicObject[] source, List<Map<String, Object>> exportdatalist, String isSuccess) {
        DynamicObject[] dynamicObjects;
        for (DynamicObject dynamicObject : dynamicObjects = Optional.ofNullable(source).orElseGet(() -> new DynamicObject[0])) {
            HashMap<String, String> map = new HashMap<String, String>(source.length);
            map.put("name", dynamicObject.getString("ermanfile.name"));
            map.put("worknumber", dynamicObject.getString("ermanfile.number"));
            map.put("org", dynamicObject.getDynamicObject("org").getString("name"));
            map.put("billstatus", DispatchAuditStatusEnum.getName((String)dynamicObject.getString("billstatus")));
            map.put("instatus", DispatchInStatusEnum.getName((String)dynamicObject.getString("instatus")));
            map.put("outstatus", DispatchOutStatusEnum.getName((String)dynamicObject.getString("outstatus")));
            map.put("isSuccess", isSuccess);
            map.put("reason", "");
            exportdatalist.add(map);
        }
    }

    private static void buildExceportFailInfo(List<DynamicObject> source, List<Map<String, Object>> exportdatalist, String isSuccess, Map<DynamicObject, List<String>> validate) {
        validate.forEach((key, val) -> {
            if (!CollUtils.isEmpty((Collection)val)) {
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put("name", key.getString("ermanfile.name"));
                map.put("worknumber", key.getString("ermanfile.number"));
                map.put("org", key.getDynamicObject("org").getString("name"));
                map.put("billstatus", DispatchAuditStatusEnum.getName((String)key.getString("billstatus")));
                map.put("instatus", DispatchInStatusEnum.getName((String)key.getString("instatus")));
                map.put("outstatus", DispatchOutStatusEnum.getName((String)key.getString("outstatus")));
                map.put("isSuccess", isSuccess);
                map.put("reason", String.join((CharSequence)"", val));
                exportdatalist.add(map);
            }
        });
    }

    public static FormShowParameter getResultPage(String workNumber, String successPerson, String successOperation, String failPerson, String failOperation, String excelName, List<Map<String, Object>> exportDataList, List<HRExportHeadObject> headDataList) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
        formShowParameter.setFormId("ham_listresult");
        formShowParameter.setCustomParam("successperson", (Object)successPerson);
        formShowParameter.setCustomParam("successoperation", (Object)successOperation);
        formShowParameter.setCustomParam("worknumber", (Object)workNumber);
        formShowParameter.setCustomParam("failperson", (Object)failPerson);
        formShowParameter.setCustomParam("failoperation", (Object)failOperation);
        formShowParameter.setCustomParam("excelname", (Object)excelName);
        formShowParameter.setCustomParam("exportdatalist", exportDataList);
        formShowParameter.setCustomParam("headdatalist", headDataList);
        return formShowParameter;
    }

    public static void showSecondConfirmForDelete(AbstractBillPlugIn plugin, Map<String, List<DynamicObject>> operationResult, int successNum, int failNum, String secondConfirmExportName, String billFormId, Map<String, String> failId2ErrorMsg) {
        List<HRExportHeadObject> headDataList = DispatchPageUtil.getAuditHeadDataList(billFormId);
        List<Map<String, Object>> exportDataList = DispatchPageUtil.getTemplateExportDataList(operationResult, ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u8fd8\u6709\u672a\u68c0\u6d4b\u901a\u8fc7\u7684\u4fe1\u606f", (String)"DispatchPageUtil_0", (String)"hr-ham-formplugin", (Object[])new Object[0]), failId2ErrorMsg);
        FormShowParameter formShowParameter = DispatchPageUtil.getResultPage("", String.valueOf(successNum), ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"DispatchPageUtil_1", (String)"hr-ham-formplugin", (Object[])new Object[0]), String.valueOf(failNum), ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"DispatchPageUtil_2", (String)"hr-ham-formplugin", (Object[])new Object[0]), secondConfirmExportName, exportDataList, headDataList);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "ham_listresult"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u679c", (String)"DispatchPageUtil_3", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        plugin.getView().showForm(formShowParameter);
    }

    public static void showDisBackSecondConfirmForDelete(AbstractBillPlugIn plugin, Map<String, List<DynamicObject>> operationResult, int successNum, int failNum, String secondConfirmExportName, String billFormId, Map<String, String> failId2ErrorMsg) {
        List<HRExportHeadObject> headDataList = DispatchPageUtil.getDisBackAuditHeadDataList(billFormId);
        List<Map<String, Object>> exportDataList = DispatchPageUtil.getDisBackTemplateExportDataList(operationResult, ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u8fd8\u6709\u672a\u68c0\u6d4b\u901a\u8fc7\u7684\u4fe1\u606f", (String)"DispatchPageUtil_0", (String)"hr-ham-formplugin", (Object[])new Object[0]), failId2ErrorMsg);
        FormShowParameter formShowParameter = DispatchPageUtil.getResultPage("", String.valueOf(successNum), ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"DispatchPageUtil_1", (String)"hr-ham-formplugin", (Object[])new Object[0]), String.valueOf(failNum), ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"DispatchPageUtil_2", (String)"hr-ham-formplugin", (Object[])new Object[0]), secondConfirmExportName, exportDataList, headDataList);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "ham_listresult"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u679c", (String)"DispatchPageUtil_3", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        plugin.getView().showForm(formShowParameter);
    }

    public static void showDisChangeRecordSecondConfirmForDelete(AbstractBillPlugIn plugin, Map<String, List<DynamicObject>> operationResult, int successNum, int failNum, String secondConfirmExportName, String billFormId, Map<String, String> failId2ErrorMsg) {
        List<HRExportHeadObject> headDataList = DispatchPageUtil.getDisChangeRecordAuditHeadDataList(billFormId);
        List<Map<String, Object>> exportDataList = DispatchPageUtil.getDisChangeRecordTemplateExportDataList(operationResult, ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u8fd8\u6709\u672a\u68c0\u6d4b\u901a\u8fc7\u7684\u4fe1\u606f", (String)"DispatchPageUtil_0", (String)"hr-ham-formplugin", (Object[])new Object[0]), failId2ErrorMsg);
        FormShowParameter formShowParameter = DispatchPageUtil.getResultPage("", String.valueOf(successNum), ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"DispatchPageUtil_1", (String)"hr-ham-formplugin", (Object[])new Object[0]), String.valueOf(failNum), ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"DispatchPageUtil_2", (String)"hr-ham-formplugin", (Object[])new Object[0]), secondConfirmExportName, exportDataList, headDataList);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "ham_listresult"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u679c", (String)"DispatchPageUtil_3", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        plugin.getView().showForm(formShowParameter);
    }
}

