/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.formplugin.web.common;

import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.list.IListView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.ham.business.domain.repository.dispatchrecord.DispatchRecordRepository;
import kd.hr.ham.formplugin.web.record.utils.RecordCustomParamUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class OperateUtils {
    private OperateUtils() {
    }

    public static boolean selectRowCheck(IFormView view, int maxSelectRow) {
        if (view instanceof IListView) {
            return ((IListView)view).getSelectedRows().size() > maxSelectRow;
        }
        return false;
    }

    public static Long getIdByView(IFormView view) {
        Long id = view instanceof IListView ? OperateUtils.getListViewCurrentPK((IListView)view) : (Long)view.getModel().getValue("id");
        return id;
    }

    public static DynamicObject getCurrentDO(IFormView view) {
        Long idByView = OperateUtils.getIdByView(view);
        String entityName = view instanceof IListView ? ((IListView)view).getBillFormId() : view.getEntityId();
        return new HRBaseServiceHelper(entityName).queryOne((Object)idByView);
    }

    public static Long getIdByViewForRecord(IFormView view) {
        Long id = view instanceof IListView ? OperateUtils.getListViewCurrentPK((IListView)view) : Long.valueOf(RecordCustomParamUtils.getErFileIdFromParam(view.getFormShowParameter()));
        return id;
    }

    private static Long getListViewCurrentPK(IListView view) {
        ListSelectedRowCollection selectedRows = view.getSelectedRows();
        if (selectedRows == null || selectedRows.isEmpty()) {
            return 0L;
        }
        return (Long)selectedRows.get(0).getPrimaryKeyValue();
    }

    public static DynamicObject getCurrentRecordDO(IFormView view) {
        DispatchRecordRepository instance = DispatchRecordRepository.getInstance();
        Long id = OperateUtils.getIdByViewForRecord(view);
        return instance.queryCurrentOneByErFileId((Object)id);
    }

    public static boolean verifyPermAndTip(String operateKey, String entityId, IFormView formView, Object[] ids) {
        String message;
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)operateKey, (String)entityId, (Object[])ids, (OperateOption)OperateOption.create());
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        if (!CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo) && HRStringUtils.isNotEmpty((String)(message = ((IOperateInfo)allErrorOrValidateInfo.get(0)).getMessage()))) {
            formView.showErrorNotification(message);
            return false;
        }
        return true;
    }
}

