/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.formplugin.web.formtemplate;

import java.util.EventObject;
import java.util.Map;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.ham.common.dispatch.bean.DispatchStatusColorMapping;
import kd.hr.ham.common.dispatch.constants.BillHeadConstants;
import kd.hr.ham.common.dispatch.enums.BillStatusColorEnum;
import kd.hr.ham.common.dispatch.enums.DispatchStatusEnum;
import kd.hr.ham.common.dispatch.utils.BillStatusColorUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class BillHeadPlugin
extends HRDynamicFormBasePlugin
implements BillHeadConstants {
    private static final Log log = LogFactory.getLog(BillHeadPlugin.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        log.info("BillHeadPlugin.beforeBindData");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        customParams.put("ermanfile", "");
        this.writeLapsValue(customParams);
        String billNo = (String)customParams.get("billno");
        Object obj = customParams.get("dispatchstatus");
        if (!HRObjectUtils.isEmpty(obj)) {
            String dispatchStatus = String.valueOf(obj);
            BillStatusColorEnum colorEnum = billNo.contains("EXPR") ? this.getDispatchBackColorByStatus(dispatchStatus) : (billNo.contains("EXPC") ? this.getDispatchChangeColorByStatus(dispatchStatus) : this.getDispatchApplyColorByStatus(dispatchStatus));
            this.getView().updateControlMetadata("billstatus", BillStatusColorUtil.getStatusColorMap((BillStatusColorEnum)colorEnum));
        } else {
            this.getView().updateControlMetadata("billstatus", BillStatusColorUtil.getStatusColorMap((BillStatusColorEnum)BillStatusColorEnum.ONGOING));
        }
    }

    private BillStatusColorEnum getDispatchApplyColorByStatus(String dispatchStatus) {
        DispatchStatusEnum enumByCode = DispatchStatusEnum.getEnumByCode((String)dispatchStatus);
        Label labelStatus = (Label)this.getView().getControl("billstatus");
        labelStatus.setText(enumByCode.getName());
        return DispatchStatusColorMapping.STATUS_DISPATCH_APPLY_COLOR_MAP.getOrDefault(dispatchStatus, BillStatusColorEnum.ONGOING);
    }

    private BillStatusColorEnum getDispatchBackColorByStatus(String dispatchStatus) {
        return DispatchStatusColorMapping.STATUS_DISPATCH_BACK_COLOR_MAP.getOrDefault(dispatchStatus, BillStatusColorEnum.ONGOING);
    }

    private BillStatusColorEnum getDispatchChangeColorByStatus(String dispatchStatus) {
        return DispatchStatusColorMapping.STATUS_DISPATCH_CHANGE_COLOR_MAP.getOrDefault(dispatchStatus, BillStatusColorEnum.ONGOING);
    }

    private void writeLapsValue(Map<String, Object> customParams) {
        customParams.forEach((key, labelValue) -> {
            Label label = (Label)this.getView().getControl(key);
            if (!HRObjectUtils.isEmpty((Object)label)) {
                if (!HRObjectUtils.isEmpty((Object)labelValue)) {
                    label.setText(labelValue.toString());
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{key});
                }
            }
        });
    }
}

