/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.formplugin.web.formtemplate;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.ham.business.domain.service.bill.IDisChangeRecordValidatorService;
import kd.hr.ham.business.domain.service.bill.IDispatchBackBillService;
import kd.hr.ham.business.domain.service.bill.IDispatchBackValidatorService;
import kd.hr.ham.business.domain.service.bill.IDispatchBillService;
import kd.hr.ham.business.domain.service.bill.IRecordChangeBillService;
import kd.hr.ham.business.domain.status.handler.DispBackStatusHandler;
import kd.hr.ham.business.domain.status.handler.RecordChangeStatusHandler;
import kd.hr.ham.business.domain.status.handler.StatusHandler;
import kd.hr.ham.business.domain.status.util.StatusHandleUtils;
import kd.hr.ham.common.dispatch.enums.DispatchPageTypeEnum;
import kd.hr.ham.formplugin.web.common.DispatchBillListCommon;
import kd.hr.ham.formplugin.web.common.DispatchPageUtil;
import kd.hr.ham.formplugin.web.formtemplate.MulConfirmPluginCommon;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MulCommitConfirmPlugin
extends HRDataBaseEdit
implements MulConfirmPluginCommon {
    private static final Log log = LogFactory.getLog(MulCommitConfirmPlugin.class);
    private final IDispatchBillService dispatchService = IDispatchBillService.getInstance();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button button = (Button)this.getControl("btnok");
        button.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        JSONArray sucIds = (JSONArray)this.getView().getFormShowParameter().getCustomParam("ids");
        if (Objects.isNull(sucIds) || sucIds.isEmpty()) {
            this.getView().close();
            return;
        }
        ArrayList<Long> list = new ArrayList<Long>();
        for (Object id : sucIds) {
            Long aLong = (Long)id;
            list.add(aLong);
        }
        log.info("sucIds: {}", list);
        String billFormId = ((ListView)this.getView().getParentView()).getBillFormId();
        if (HRStringUtils.equals((String)billFormId, (String)"ham_dispatchin") || HRStringUtils.equals((String)billFormId, (String)"ham_dispatchout")) {
            this.commitDispatchBill(list, billFormId);
        }
        if (HRStringUtils.equals((String)billFormId, (String)"ham_dispback")) {
            this.commitDispatchBackBill(sucIds, billFormId);
        }
        if (HRStringUtils.equals((String)billFormId, (String)"ham_dispatchrecordchg")) {
            this.commitDisChangeRecord(sucIds, billFormId);
        }
    }

    private void commitDisChangeRecord(JSONArray ids, String billFormId) {
        ArrayList firSuccessList = new ArrayList();
        ArrayList firSuccessIds = new ArrayList();
        ArrayList<DynamicObject> successList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> failList = new ArrayList<DynamicObject>();
        HashMap failId2ErrorMsg = Maps.newHashMapWithExpectedSize((int)4);
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        String selects = "id,ermanfile,org,auditstatus,changestatus,billno,dispatchrecord,billstatus";
        DynamicObject[] reQueryDataList = IRecordChangeBillService.getInstance().query(selects, new QFilter[]{qFilter});
        List dyObjValidateContexts = IDisChangeRecordValidatorService.getInstance().batchSubmitValidate(Arrays.asList(reQueryDataList), billFormId);
        this.buildValidateResult(firSuccessList, firSuccessIds, failList, failId2ErrorMsg, dyObjValidateContexts);
        Object[] idArray = firSuccessIds.toArray();
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"submit", (String)billFormId, (Object[])idArray, (OperateOption)OperateOption.create());
        List successPkIds = opResult.getSuccessPkIds();
        for (DynamicObject firSuccess : firSuccessList) {
            if (successPkIds.contains(firSuccess.getLong("id"))) {
                successList.add(firSuccess);
                continue;
            }
            failList.add(firSuccess);
        }
        this.handleFailedOpMsg(failId2ErrorMsg, opResult);
        if (!CollectionUtils.isEmpty(successList)) {
            StatusHandleUtils.batchHandle((StatusHandler)new RecordChangeStatusHandler(), (String)"submit", successList);
        }
        HashMap operationResult = Maps.newHashMapWithExpectedSize((int)4);
        operationResult.put("success", successList);
        operationResult.put("fail", failList);
        String secondConfirmExportName = (String)this.getView().getFormShowParameter().getCustomParam("secondconfirm_exporttitle");
        DispatchPageUtil.showDisChangeRecordConfirm((AbstractBillPlugIn)this, operationResult, secondConfirmExportName, billFormId, failId2ErrorMsg);
    }

    private void commitDispatchBackBill(JSONArray ids, String billFormId) {
        ArrayList firSuccessList = new ArrayList();
        ArrayList firSuccessIds = new ArrayList();
        ArrayList<DynamicObject> successList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> failList = new ArrayList<DynamicObject>();
        HashMap failId2ErrorMsg = Maps.newHashMapWithExpectedSize((int)4);
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        String selects = "id,ermanfile,org,auditstatus,backstatus,billno,dispatchrecord,billstatus";
        DynamicObject[] reQueryDataList = IDispatchBackBillService.getInstance().query(selects, new QFilter[]{qFilter});
        List dyObjValidateContexts = IDispatchBackValidatorService.getInstance().batchSubmitValidate(Arrays.asList(reQueryDataList), billFormId);
        this.buildValidateResult(firSuccessList, firSuccessIds, failList, failId2ErrorMsg, dyObjValidateContexts);
        Object[] idArray = firSuccessIds.toArray();
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"submit", (String)billFormId, (Object[])idArray, (OperateOption)OperateOption.create());
        List successPkIds = opResult.getSuccessPkIds();
        for (DynamicObject firSuccess : firSuccessList) {
            if (successPkIds.contains(firSuccess.getLong("id"))) {
                successList.add(firSuccess);
                continue;
            }
            failList.add(firSuccess);
        }
        this.handleFailedOpMsg(failId2ErrorMsg, opResult);
        if (!CollectionUtils.isEmpty(successList)) {
            StatusHandleUtils.batchHandle((StatusHandler)new DispBackStatusHandler(), (String)"submit", successList);
        }
        HashMap operationResult = Maps.newHashMapWithExpectedSize((int)4);
        operationResult.put("success", successList);
        operationResult.put("fail", failList);
        String secondConfirmExportName = (String)this.getView().getFormShowParameter().getCustomParam("secondconfirm_exporttitle");
        DispatchPageUtil.showDisBackSecondConfirm((AbstractBillPlugIn)this, operationResult, secondConfirmExportName, billFormId, failId2ErrorMsg);
    }

    private void commitDispatchBill(List<Long> list, String billFormId) {
        DynamicObject[] dispatchBills = this.dispatchService.queryDispatch((Object[])list.toArray(new Long[0]));
        DispatchPageTypeEnum dispatchPageType = DispatchPageTypeEnum.getEnumByCode((String)billFormId);
        log.info("start_mulCommitConfirm");
        Map preSubmitValidateInfo = this.dispatchService.batchSubmitValidate(dispatchBills, dispatchPageType, null, false, false);
        Pair<List<DynamicObject>, List<DynamicObject>> preSubmitPair = DispatchPageUtil.getSucAndFailDynamics(preSubmitValidateInfo);
        log.info("preSubmit_sucSize:{}, errSize:{}", (Object)((List)preSubmitPair.getKey()).size(), (Object)((List)preSubmitPair.getValue()).size());
        List sucObjs = (List)preSubmitPair.getKey();
        Object[] sucObjIds = sucObjs.stream().map(obj -> obj.getLong("id")).toArray();
        if (ArrayUtils.isNotEmpty((Object[])sucObjIds)) {
            log.info("invoke_suc_ids: {}", (Object)Arrays.toString(sucObjIds));
            OperationResult operationResult = DispatchBillListCommon.invokeSubmitOperation(this.getView().getParentView(), sucObjIds, billFormId, true);
            Map operateResInfo = IDispatchBillService.getInstance().getOperateResInfo(operationResult, dispatchPageType, false);
            IDispatchBillService.getInstance().addResultToPreSubmitInfo(operateResInfo, preSubmitValidateInfo);
            preSubmitPair = DispatchPageUtil.getSucAndFailDynamics(preSubmitValidateInfo);
        }
        log.info("submit_sucSize:{}, errSize:{}", (Object)((List)preSubmitPair.getKey()).size(), (Object)((List)preSubmitPair.getValue()).size());
        for (Map.Entry entry : preSubmitValidateInfo.entrySet()) {
            DynamicObject key = (DynamicObject)entry.getKey();
            List val = (List)entry.getValue();
            log.info("commitApply.billNo={},vares={}", (Object)key.getString("billno"), (Object)val);
        }
        log.info("end_mulCommitConfirm");
        DispatchPageUtil.showSubmitSecondConfirm((AbstractBillPlugIn)this, preSubmitPair, preSubmitValidateInfo, billFormId);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("ham_listresult")) {
            this.getView().close();
        }
    }
}

