/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.formplugin.web.formtemplate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.ham.business.domain.service.bill.IDisChangeRecordValidatorService;
import kd.hr.ham.business.domain.service.bill.IDispatchBackBillService;
import kd.hr.ham.business.domain.service.bill.IDispatchBackValidatorService;
import kd.hr.ham.business.domain.service.bill.IDispatchBillService;
import kd.hr.ham.business.domain.service.bill.IDispatchValidatorService;
import kd.hr.ham.business.domain.service.bill.IRecordChangeBillService;
import kd.hr.ham.common.dispatch.utils.AppLogUtils;
import kd.hr.ham.formplugin.web.common.DispatchPageUtil;
import kd.hr.ham.formplugin.web.formtemplate.MulConfirmPluginCommon;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class MulDeleteConfirmPlugin
extends HRDataBaseEdit
implements MulConfirmPluginCommon {
    private static final String BTN_OK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button button = (Button)this.getControl(BTN_OK);
        button.addClickListener((ClickListener)this);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("ham_listresult")) {
            this.getView().close();
        }
    }

    public void click(EventObject evt) {
        JSONArray ids = (JSONArray)this.getView().getFormShowParameter().getCustomParam("ids");
        if (Objects.isNull(ids) || ids.size() == 0) {
            this.getView().close();
            return;
        }
        String billFormId = ((ListShowParameter)this.getView().getParentView().getFormShowParameter()).getBillFormId();
        if (HRStringUtils.equals((String)billFormId, (String)"ham_dispatchin") || HRStringUtils.equals((String)billFormId, (String)"ham_dispatchout")) {
            this.deleteDispatchBill(ids, billFormId);
        }
        if (HRStringUtils.equals((String)billFormId, (String)"ham_dispback")) {
            this.deleteDispatchBackBill(ids, billFormId);
        }
        if (HRStringUtils.equals((String)billFormId, (String)"ham_dispatchrecordchg")) {
            this.deleteDisChangeRecord(ids, billFormId);
        }
    }

    private void deleteDisChangeRecord(JSONArray ids, String billFormId) {
        ArrayList firSuccessList = new ArrayList();
        ArrayList firSuccessIds = new ArrayList();
        ArrayList<DynamicObject> successList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> failList = new ArrayList<DynamicObject>();
        HashMap failId2ErrorMsg = Maps.newHashMapWithExpectedSize((int)4);
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        String selects = "id,ermanfile,org,billstatus,changestatus,billno";
        DynamicObject[] reQueryDataList = IRecordChangeBillService.getInstance().query(selects, new QFilter[]{qFilter});
        List dyObjValidateContexts = IDisChangeRecordValidatorService.getInstance().batchDeleteValidate(Arrays.asList(reQueryDataList), billFormId);
        this.buildValidateResult(firSuccessList, firSuccessIds, failList, failId2ErrorMsg, dyObjValidateContexts);
        Object[] idArray = firSuccessIds.toArray();
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"delete", (String)billFormId, (Object[])idArray, (OperateOption)OperateOption.create());
        log.info("MulDeleteConfirmPlugin deleteDisChangeRecord opResult: {}", (Object)JSONObject.toJSONString((Object)opResult));
        List successPkIds = opResult.getSuccessPkIds();
        for (DynamicObject firSuccess : firSuccessList) {
            if (successPkIds.contains(firSuccess.getLong("id"))) {
                successList.add(firSuccess);
                continue;
            }
            failList.add(firSuccess);
        }
        this.handleFailedOpMsg(failId2ErrorMsg, opResult);
        for (DynamicObject success : successList) {
            AppLogUtils.recordLog((String)billFormId, (String)"donothing_deletelist", (String)success.getString("billno"), (String)ResManager.loadKDString((Lang)Lang.zh_CN, (String)"\u5220\u9664", (String)"MulDeleteConfirmPlugin_0", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        }
        HashMap operationResult = Maps.newHashMapWithExpectedSize((int)4);
        operationResult.put("success", successList);
        operationResult.put("fail", failList);
        String secondConfirmExportName = (String)this.getView().getFormShowParameter().getCustomParam("secondconfirm_exporttitle");
        DispatchPageUtil.showDisChangeRecordSecondConfirmForDelete((AbstractBillPlugIn)this, operationResult, successList.size(), failList.size(), secondConfirmExportName, billFormId, failId2ErrorMsg);
    }

    private void deleteDispatchBill(JSONArray ids, String billFormId) {
        ArrayList firSuccessList = new ArrayList();
        ArrayList firSuccessIds = new ArrayList();
        ArrayList<DynamicObject> successList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> failList = new ArrayList<DynamicObject>();
        HashMap failId2ErrorMsg = Maps.newHashMapWithExpectedSize((int)4);
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        String selects = "id,ermanfile,org,billstatus,instatus,outstatus,billno,dispatchstatus";
        DynamicObject[] reQueryDataList = IDispatchBillService.getInstance().queryDispatch(selects, new QFilter[]{qFilter});
        List dyObjValidateContexts = IDispatchValidatorService.getInstance().batchDeleteValidate(Arrays.asList(reQueryDataList), billFormId);
        this.buildValidateResult(firSuccessList, firSuccessIds, failList, failId2ErrorMsg, dyObjValidateContexts);
        Object[] idArray = firSuccessIds.toArray();
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"delete", (String)billFormId, (Object[])idArray, (OperateOption)OperateOption.create());
        log.info("MulDeleteConfirmPlugin deleteDispatchBill opResult: {}", (Object)JSONObject.toJSONString((Object)opResult));
        List successPkIds = opResult.getSuccessPkIds();
        for (DynamicObject firSuccess : firSuccessList) {
            if (successPkIds.contains(firSuccess.getLong("id"))) {
                successList.add(firSuccess);
                continue;
            }
            failList.add(firSuccess);
        }
        this.handleFailedOpMsg(failId2ErrorMsg, opResult);
        for (DynamicObject success : successList) {
            AppLogUtils.recordLog((String)billFormId, (String)"donothing_deletelist", (String)success.getString("billno"), (String)ResManager.loadKDString((Lang)Lang.zh_CN, (String)"\u5220\u9664", (String)"MulDeleteConfirmPlugin_0", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        }
        HashMap operationResult = Maps.newHashMapWithExpectedSize((int)4);
        operationResult.put("success", successList);
        operationResult.put("fail", failList);
        String secondConfirmExportName = (String)this.getView().getFormShowParameter().getCustomParam("secondconfirm_exporttitle");
        DispatchPageUtil.showSecondConfirmForDelete((AbstractBillPlugIn)this, operationResult, successList.size(), failList.size(), secondConfirmExportName, billFormId, failId2ErrorMsg);
    }

    private void deleteDispatchBackBill(JSONArray ids, String billFormId) {
        ArrayList firSuccessList = new ArrayList();
        ArrayList firSuccessIds = new ArrayList();
        ArrayList<DynamicObject> successList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> failList = new ArrayList<DynamicObject>();
        HashMap failId2ErrorMsg = Maps.newHashMapWithExpectedSize((int)4);
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        String selects = "id,ermanfile,org,billstatus,backstatus,billno";
        DynamicObject[] reQueryDataList = IDispatchBackBillService.getInstance().query(selects, new QFilter[]{qFilter});
        List dyObjValidateContexts = IDispatchBackValidatorService.getInstance().batchDeleteValidate(Arrays.asList(reQueryDataList), billFormId);
        this.buildValidateResult(firSuccessList, firSuccessIds, failList, failId2ErrorMsg, dyObjValidateContexts);
        Object[] idArray = firSuccessIds.toArray();
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"delete", (String)billFormId, (Object[])idArray, (OperateOption)OperateOption.create());
        log.info("MulDeleteConfirmPlugin deleteDispatchBackBill opResult: {}", (Object)JSONObject.toJSONString((Object)opResult));
        List successPkIds = opResult.getSuccessPkIds();
        for (DynamicObject firSuccess : firSuccessList) {
            if (successPkIds.contains(firSuccess.getLong("id"))) {
                successList.add(firSuccess);
                continue;
            }
            failList.add(firSuccess);
        }
        this.handleFailedOpMsg(failId2ErrorMsg, opResult);
        for (DynamicObject success : successList) {
            AppLogUtils.recordLog((String)billFormId, (String)"donothing_deletelist", (String)success.getString("billno"), (String)ResManager.loadKDString((Lang)Lang.zh_CN, (String)"\u5220\u9664", (String)"MulDeleteConfirmPlugin_0", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        }
        HashMap operationResult = Maps.newHashMapWithExpectedSize((int)4);
        operationResult.put("success", successList);
        operationResult.put("fail", failList);
        String secondConfirmExportName = (String)this.getView().getFormShowParameter().getCustomParam("secondconfirm_exporttitle");
        DispatchPageUtil.showDisBackSecondConfirmForDelete((AbstractBillPlugIn)this, operationResult, successList.size(), failList.size(), secondConfirmExportName, billFormId, failId2ErrorMsg);
    }
}

