/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.formplugin.web.formtemplate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.ham.business.domain.service.bill.IDisChangeRecordValidatorService;
import kd.hr.ham.business.domain.service.bill.IDispatchBackBillService;
import kd.hr.ham.business.domain.service.bill.IDispatchBackValidatorService;
import kd.hr.ham.business.domain.service.bill.IDispatchBillService;
import kd.hr.ham.business.domain.service.bill.IDispatchValidatorService;
import kd.hr.ham.business.domain.service.bill.IRecordChangeBillService;
import kd.hr.ham.business.domain.status.handler.DispBackStatusHandler;
import kd.hr.ham.business.domain.status.handler.DispatchBillStatusHandler;
import kd.hr.ham.business.domain.status.handler.RecordChangeStatusHandler;
import kd.hr.ham.business.domain.status.handler.StatusHandler;
import kd.hr.ham.business.domain.status.util.StatusHandleUtils;
import kd.hr.ham.common.dispatch.enums.DispatchOrderEnum;
import kd.hr.ham.formplugin.web.common.DispatchPageUtil;
import kd.hr.ham.formplugin.web.formtemplate.MulConfirmPluginCommon;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class MulUncommitConfirmPlugin
extends HRDataBaseEdit
implements MulConfirmPluginCommon {
    private static final String BTN_OK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button button = (Button)this.getControl(BTN_OK);
        button.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        JSONArray ids = (JSONArray)this.getView().getFormShowParameter().getCustomParam("ids");
        if (Objects.isNull(ids) || ids.size() == 0) {
            this.getView().close();
            return;
        }
        String billFormId = ((ListShowParameter)this.getView().getParentView().getFormShowParameter()).getBillFormId();
        if (HRStringUtils.equals((String)billFormId, (String)"ham_dispatchin") || HRStringUtils.equals((String)billFormId, (String)"ham_dispatchout")) {
            this.unCommitDispatchBill(ids, billFormId);
        }
        if (HRStringUtils.equals((String)billFormId, (String)"ham_dispback")) {
            this.unCommitDispatchBackBill(ids, billFormId);
        }
        if (HRStringUtils.equals((String)billFormId, (String)"ham_dispatchrecordchg")) {
            this.unCommitDisChangeRecord(ids, billFormId);
        }
    }

    private void unCommitDisChangeRecord(JSONArray ids, String billFormId) {
        ArrayList firSuccessList = new ArrayList();
        ArrayList firSuccessIds = new ArrayList();
        ArrayList<DynamicObject> successList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> failList = new ArrayList<DynamicObject>();
        HashMap failId2ErrorMsg = Maps.newHashMapWithExpectedSize((int)4);
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        String selects = "id,ermanfile,org,auditstatus,changestatus,billstatus";
        DynamicObject[] reQueryDataList = IRecordChangeBillService.getInstance().query(selects, new QFilter[]{qFilter});
        List dyObjValidateContexts = IDisChangeRecordValidatorService.getInstance().batchUnSubmitValidate(Arrays.asList(reQueryDataList), billFormId);
        this.buildValidateResult(firSuccessList, firSuccessIds, failList, failId2ErrorMsg, dyObjValidateContexts);
        Object[] idArray = firSuccessIds.toArray();
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"unsubmit", (String)billFormId, (Object[])idArray, (OperateOption)OperateOption.create());
        log.info("MulUncommitConfirmPlugin unCommitDisChangeRecord opResult: {}", (Object)JSONObject.toJSONString((Object)opResult));
        List successPkIds = opResult.getSuccessPkIds();
        for (DynamicObject firSuccess : firSuccessList) {
            if (successPkIds.contains(firSuccess.getLong("id"))) {
                successList.add(firSuccess);
                continue;
            }
            failList.add(firSuccess);
        }
        this.handleFailedOpMsg(failId2ErrorMsg, opResult);
        if (!CollectionUtils.isEmpty(successList)) {
            StatusHandleUtils.batchHandle((StatusHandler)new RecordChangeStatusHandler(), (String)"unsubmit", successList);
        }
        HashMap operationResult = Maps.newHashMapWithExpectedSize((int)4);
        operationResult.put("success", successList);
        operationResult.put("fail", failList);
        String secondConfirmExportName = (String)this.getView().getFormShowParameter().getCustomParam("secondconfirm_exporttitle");
        DispatchPageUtil.showDisChangeRecordConfirm((AbstractBillPlugIn)this, operationResult, secondConfirmExportName, billFormId, failId2ErrorMsg);
    }

    private void unCommitDispatchBill(JSONArray ids, String billFormId) {
        ArrayList firSuccessList = new ArrayList();
        ArrayList firSuccessIds = new ArrayList();
        ArrayList<DynamicObject> successList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> failList = new ArrayList<DynamicObject>();
        HashMap failId2ErrorMsg = Maps.newHashMapWithExpectedSize((int)4);
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        String selects = "id,ermanfile,org,auditstatus,instatus,outstatus,dispatchstatus,disoutinorder,billstatus";
        DynamicObject[] reQueryDataList = IDispatchBillService.getInstance().queryDispatch(selects, new QFilter[]{qFilter});
        List dyObjValidateContexts = IDispatchValidatorService.getInstance().batchUnSubmitValidate(Arrays.asList(reQueryDataList), billFormId);
        this.buildValidateResult(firSuccessList, firSuccessIds, failList, failId2ErrorMsg, dyObjValidateContexts);
        Object[] idArray = firSuccessIds.toArray();
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"unsubmit", (String)billFormId, (Object[])idArray, (OperateOption)OperateOption.create());
        log.info("MulUncommitConfirmPlugin unCommitDispatchBill opResult: {}", (Object)JSONObject.toJSONString((Object)opResult));
        List successPkIds = opResult.getSuccessPkIds();
        for (DynamicObject firSuccess : firSuccessList) {
            if (successPkIds.contains(firSuccess.getLong("id"))) {
                successList.add(firSuccess);
                continue;
            }
            failList.add(firSuccess);
        }
        this.handleFailedOpMsg(failId2ErrorMsg, opResult);
        HashMap operationResult = Maps.newHashMapWithExpectedSize((int)4);
        successList.forEach(dynamicObject -> {
            String dispatchOrder = dynamicObject.getString("disoutinorder");
            DispatchOrderEnum dispatchOrderEnum = DispatchOrderEnum.getEnumByCode((String)dispatchOrder);
            String statusHandleKey = "";
            if (dispatchOrderEnum == DispatchOrderEnum.IN_2_OUT) {
                statusHandleKey = "in_fir_in_rollback";
            }
            if (dispatchOrderEnum == DispatchOrderEnum.OUT_2_IN) {
                statusHandleKey = "out_fir_out_rollback";
            }
            StatusHandleUtils.handle((StatusHandler)new DispatchBillStatusHandler(), (String)statusHandleKey, (DynamicObject)dynamicObject);
        });
        operationResult.put("success", successList);
        operationResult.put("fail", failList);
        String secondConfirmExportName = (String)this.getView().getFormShowParameter().getCustomParam("secondconfirm_exporttitle");
        DispatchPageUtil.showSecondConfirm((AbstractBillPlugIn)this, operationResult, secondConfirmExportName, billFormId, failId2ErrorMsg);
    }

    private void unCommitDispatchBackBill(JSONArray ids, String billFormId) {
        ArrayList firSuccessList = new ArrayList();
        ArrayList firSuccessIds = new ArrayList();
        ArrayList<DynamicObject> successList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> failList = new ArrayList<DynamicObject>();
        HashMap failId2ErrorMsg = Maps.newHashMapWithExpectedSize((int)4);
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        String selects = "id,ermanfile,org,auditstatus,backstatus,billstatus";
        DynamicObject[] reQueryDataList = IDispatchBackBillService.getInstance().query(selects, new QFilter[]{qFilter});
        List dyObjValidateContexts = IDispatchBackValidatorService.getInstance().batchUnSubmitValidate(Arrays.asList(reQueryDataList), billFormId);
        this.buildValidateResult(firSuccessList, firSuccessIds, failList, failId2ErrorMsg, dyObjValidateContexts);
        Object[] idArray = firSuccessIds.toArray();
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"unsubmit", (String)billFormId, (Object[])idArray, (OperateOption)OperateOption.create());
        log.info("MulUncommitConfirmPlugin unCommitDispatchBackBill opResult: {}", (Object)JSONObject.toJSONString((Object)opResult));
        List successPkIds = opResult.getSuccessPkIds();
        for (DynamicObject firSuccess : firSuccessList) {
            if (successPkIds.contains(firSuccess.getLong("id"))) {
                successList.add(firSuccess);
                continue;
            }
            failList.add(firSuccess);
        }
        this.handleFailedOpMsg(failId2ErrorMsg, opResult);
        if (!CollectionUtils.isEmpty(successList)) {
            StatusHandleUtils.batchHandle((StatusHandler)new DispBackStatusHandler(), (String)"unsubmit", successList);
        }
        HashMap operationResult = Maps.newHashMapWithExpectedSize((int)4);
        operationResult.put("success", successList);
        operationResult.put("fail", failList);
        String secondConfirmExportName = (String)this.getView().getFormShowParameter().getCustomParam("secondconfirm_exporttitle");
        DispatchPageUtil.showDisBackSecondConfirm((AbstractBillPlugIn)this, operationResult, secondConfirmExportName, billFormId, failId2ErrorMsg);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("ham_listresult")) {
            this.getView().close();
        }
    }
}

