/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.formplugin.web.formtemplate;

import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.hr.ham.common.dispatch.constants.PersonCardConstants;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class PersonCardPlugin
extends HRDynamicFormBasePlugin
implements PersonCardConstants {
    public void beforeBindData(EventObject args) {
        super.beforeBindData(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        IFormView formView = this.getView();
        String localName = RequestContext.get().getLang().name();
        if (HRStringUtils.isEmpty((String)localName)) {
            localName = "zh_CN";
        }
        this.setAvatar(formView, customParams, "avatar");
        this.setLabelValue(formView, customParams, "personname");
        this.setLabelValue(formView, customParams, "personnumber");
        this.setLabelValue(formView, customParams, "personsex");
        this.setLabelValue(formView, customParams, "laborreltype");
        this.setLabelValue(formView, customParams, "laborrelstatus");
        this.setLabelValue(formView, customParams, "postype");
        this.setLabelValue(formView, customParams, "company");
        this.setLabelValue(formView, customParams, "department");
        this.setLabelValue(formView, customParams, "position");
        if (HRObjectUtils.isEmpty(customParams.get("position"))) {
            this.setLabelValue(formView, customParams, "stdposition");
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"stdpositionflex"});
        }
    }

    private void setAvatar(IFormView formView, Map<String, Object> customParams, String key) {
        Object avatar = customParams.get(key);
        Image image = (Image)formView.getControl(key);
        if (HRObjectUtils.isEmpty((Object)avatar)) {
            image.setUrl("/images/pc/emotion/default_person_82_82.png");
        } else {
            image.setUrl(HRImageUrlUtil.getImageFullUrl((String)avatar.toString()));
        }
    }

    private void setLabelValue(IFormView formView, Map<String, Object> customParams, String labelKey) {
        Label label = (Label)formView.getControl(labelKey);
        String labelValue = (String)customParams.get(labelKey);
        if (HRObjectUtils.isEmpty((Object)label)) {
            return;
        }
        if (HRObjectUtils.isEmpty((Object)labelValue) || HRObjectUtils.isEmpty((Object)labelKey)) {
            String flexLabel = labelKey + "flex";
            Container labelFlex = (Container)formView.getControl(flexLabel);
            if (!HRObjectUtils.isEmpty((Object)labelFlex)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{flexLabel});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{labelKey});
            }
        } else {
            label.setText(labelValue);
        }
    }
}

