/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.formplugin.web.formtemplate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.ham.business.domain.repository.bill.DispatchBackRepository;
import kd.hr.ham.business.domain.repository.bill.DispatchBillRepository;
import kd.hr.ham.business.domain.repository.bill.RecordChangeRepository;
import kd.hr.ham.business.domain.service.ServiceFactory;
import kd.hr.ham.business.domain.service.bill.IDispatchBackBillService;
import kd.hr.ham.business.domain.service.bill.IDispatchValidatorService;
import kd.hr.ham.business.domain.service.bill.IRecordChangeBillService;
import kd.hr.ham.business.domain.service.common.IDispatchPersonChangeService;
import kd.hr.ham.business.domain.service.validator.DyObjValidateContext;
import kd.hr.ham.business.domain.status.handler.DispatchBillStatusHandler;
import kd.hr.ham.business.domain.status.handler.StatusHandler;
import kd.hr.ham.business.domain.status.util.StatusHandleUtils;
import kd.hr.ham.common.dispatch.enums.DispatchOrderEnum;
import kd.hr.ham.common.dispatch.enums.PersonChangeOperateTypeEnum;
import kd.hr.ham.common.dispatch.utils.AppLogUtils;
import kd.hr.ham.common.dispatch.utils.DispatchDateUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class TerminateConfirmPlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener {
    private static final String BTN_OK = "btn_ok";
    private static final String KEY_ABANDONREASON = "desc";
    private static final Log LOG = LogFactory.getLog(TerminateConfirmPlugin.class);
    public static final String TERMINAL_TIP = "terminal_tip";
    private final Map<String, String> TITLE_MAP = Maps.newHashMapWithExpectedSize((int)4);
    private final Map<String, String> TIP_MAP = Maps.newHashMapWithExpectedSize((int)4);

    public TerminateConfirmPlugin() {
        this.TITLE_MAP.put("ham_dispatchout", ResManager.loadKDString((String)"\u7ec8\u6b62\u5916\u6d3e\u6d41\u7a0b", (String)"TerminateConfirmPlugin_4", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        this.TITLE_MAP.put("ham_dispback", ResManager.loadKDString((String)"\u7ec8\u6b62\u6d3e\u8fd4\u6d41\u7a0b", (String)"TerminateConfirmPlugin_6", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        this.TITLE_MAP.put("ham_dispatchrecordchg", ResManager.loadKDString((String)"\u7ec8\u6b62\u5916\u6d3e\u53d8\u66f4\u6d41\u7a0b", (String)"TerminateConfirmPlugin_7", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        this.TIP_MAP.put("ham_dispatchout", ResManager.loadKDString((String)"\u7ec8\u6b62\u540e\u4eba\u5458\u7684\u5916\u6d3e\u6d41\u7a0b\u5c06\u5168\u90e8\u7ec8\u6b62\uff0c\u4e14\u4e0d\u53ef\u64a4\u9500\uff0c\u5982\u786e\u8ba4\uff0c\u8bf7\u586b\u5199\u4ee5\u4e0b\u4fe1\u606f\uff1a", (String)"TerminateConfirmPlugin_5", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        this.TIP_MAP.put("ham_dispback", ResManager.loadKDString((String)"\u7ec8\u6b62\u540e\u4eba\u5458\u7684\u6d3e\u8fd4\u6d41\u7a0b\u5c06\u5168\u90e8\u7ec8\u6b62\uff0c\u4e14\u4e0d\u53ef\u64a4\u9500\uff0c\u5982\u786e\u8ba4\uff0c\u8bf7\u586b\u5199\u4ee5\u4e0b\u4fe1\u606f\uff1a", (String)"TerminateConfirmPlugin_8", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        this.TIP_MAP.put("ham_dispatchrecordchg", ResManager.loadKDString((String)"\u7ec8\u6b62\u540e\u4eba\u5458\u7684\u5916\u6d3e\u53d8\u66f4\u6d41\u7a0b\u5c06\u5168\u90e8\u7ec8\u6b62\uff0c\u4e14\u4e0d\u53ef\u64a4\u9500\uff0c\u5982\u786e\u8ba4\uff0c\u8bf7\u586b\u5199\u4ee5\u4e0b\u4fe1\u606f\uff1a", (String)"TerminateConfirmPlugin_9", (String)"hr-ham-formplugin", (Object[])new Object[0]));
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Button btnOk = (Button)this.getControl(BTN_OK);
        btnOk.addClickListener((ClickListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        Optional<Object> terminalTip = Optional.ofNullable(formShowParameter.getCustomParam(TERMINAL_TIP));
        terminalTip.ifPresent(param -> formShowParameter.setCaption(this.TITLE_MAP.get(param)));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Optional<Object> terminalTip = Optional.ofNullable(formShowParameter.getCustomParam(TERMINAL_TIP));
        terminalTip.ifPresent(param -> {
            Label label = (Label)this.getView().getControl("labelap");
            label.setText(this.TIP_MAP.get(param));
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        if (!HRStringUtils.equals((String)afterDoOperationEventArgs.getOperateKey(), (String)"ok")) {
            return;
        }
        String desc = String.valueOf(this.getModel().getValue(KEY_ABANDONREASON));
        if (HRStringUtils.isEmpty((String)desc)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u7ec8\u6b62\u539f\u56e0\u8bf4\u660e\u201d\u3002", (String)"TerminateConfirmPlugin_0", (String)"hr-ham-formplugin", (Object[])new Object[0]));
            return;
        }
        Long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam("billFormId");
        String operateKey = (String)this.getView().getFormShowParameter().getCustomParam("key");
        if (HRStringUtils.equals((String)billFormId, (String)"ham_dispatchin") || HRStringUtils.equals((String)billFormId, (String)"ham_dispatchout")) {
            this.terminateDispatchBill(id, billFormId, operateKey);
        }
        if (HRStringUtils.equals((String)billFormId, (String)"ham_dispback")) {
            this.terminateDispatchBackBill(id, billFormId, operateKey);
        }
        if (HRStringUtils.equals((String)billFormId, (String)"ham_dispatchrecordchg")) {
            this.terminateRecordChange(id, billFormId, operateKey);
        }
    }

    private void terminateDispatchBill(Long id, String billFormId, String operateKey) {
        List errors;
        String message;
        String select = "id,billno,submitnoticstatus,stopnoticstatus,effectstatus,effecttime,disoutinorder,auditstatus,outstatus,instatus,dispatchstatus,terminatersn,ermanfile,startdate,billstatus,terminateuser,terminatetime";
        DynamicObject bill = DispatchBillRepository.getInstance().queryOne(select, (Object)id);
        OperationResult operation = OperationServiceHelper.executeOperate((String)"donothing_termination", (String)billFormId, (Object[])new Long[]{id}, (OperateOption)OperateOption.create());
        List allErrorOrValidateInfo = operation.getAllErrorOrValidateInfo();
        if (!CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo) && HRStringUtils.isNotEmpty((String)(message = ((IOperateInfo)allErrorOrValidateInfo.get(0)).getMessage()))) {
            this.getView().showErrorNotification(message);
            return;
        }
        ArrayList dynamicObjects = Lists.newArrayListWithExpectedSize((int)1);
        dynamicObjects.add(bill);
        List dyObjValidateContext = IDispatchValidatorService.getInstance().terminateValidate((List)dynamicObjects, billFormId);
        if (dyObjValidateContext.size() == 1 && !(errors = dyObjValidateContext.stream().filter(temp -> temp.getValidatorContext().getValidateResult().size() > 0).collect(Collectors.toList())).isEmpty()) {
            this.getView().showErrorNotification(((DyObjValidateContext)errors.get(0)).getValidatorContext().getValidateResultStr());
            return;
        }
        String operateCode = this.getOperateCode(billFormId, bill);
        String oldInStatus = bill.getString("instatus");
        String oldOutStatus = bill.getString("outstatus");
        StatusHandleUtils.handle((StatusHandler)new DispatchBillStatusHandler(), (String)operateCode, (DynamicObject)bill);
        if (HRStringUtils.isEmpty((String)oldInStatus)) {
            bill.set("instatus", (Object)oldInStatus);
        }
        if (HRStringUtils.isEmpty((String)oldOutStatus)) {
            bill.set("outstatus", (Object)oldOutStatus);
        }
        bill.set("terminatersn", (Object)String.valueOf(this.getModel().getValue(KEY_ABANDONREASON)));
        bill.set("terminateuser", (Object)RequestContext.get().getCurrUserId());
        bill.set("terminatetime", (Object)DispatchDateUtils.now());
        IDispatchPersonChangeService dispatchPersonChangeService = (IDispatchPersonChangeService)ServiceFactory.getService(IDispatchPersonChangeService.class);
        DynamicObject[] bills = new DynamicObject[]{bill};
        dispatchPersonChangeService.excutePersonChangeNotice(bills, PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_TERMINATIO, true);
        DispatchBillRepository.getInstance().updateDataOne(bill);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"discard", (String)billFormId, (Object[])new Long[]{id}, (OperateOption)OperateOption.create());
        LOG.info("Dispatch.terminate workflow id\uff1a{}\uff0cformId\uff1a{} result\uff1a {}\uff0cmessage\uff1a{}", new Object[]{id, bill, operationResult.isSuccess(), operationResult.getMessage()});
        this.recordTerminateLog(billFormId, bill, operateKey);
        this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u5916\u6d3e\u6d41\u7a0b\u7ec8\u6b62\u6210\u529f\u3002", (String)"TerminateConfirmPlugin_1", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        this.getView().getParentView().invokeOperation("refresh");
        this.getView().sendFormAction(this.getView().getParentView());
        this.getView().returnDataToParent((Object)"1");
        this.getView().close();
    }

    private String getOperateCode(String billFormId, DynamicObject bill) {
        String operateCode = "";
        if (HRStringUtils.equals((String)DispatchOrderEnum.OUT_2_IN.getOrder(), (String)bill.getString("disoutinorder")) && HRStringUtils.equals((String)"ham_dispatchout", (String)billFormId)) {
            operateCode = "out_fir_out_stop";
        }
        if (HRStringUtils.equals((String)DispatchOrderEnum.OUT_2_IN.getOrder(), (String)bill.getString("disoutinorder")) && HRStringUtils.equals((String)"ham_dispatchin", (String)billFormId)) {
            operateCode = "out_fir_in_stop";
        }
        if (HRStringUtils.equals((String)DispatchOrderEnum.IN_2_OUT.getOrder(), (String)bill.getString("disoutinorder")) && HRStringUtils.equals((String)"ham_dispatchout", (String)billFormId)) {
            operateCode = "in_fir_out_stop";
        }
        if (HRStringUtils.equals((String)DispatchOrderEnum.IN_2_OUT.getOrder(), (String)bill.getString("disoutinorder")) && HRStringUtils.equals((String)"ham_dispatchin", (String)billFormId)) {
            operateCode = "in_fir_in_stop";
        }
        return operateCode;
    }

    private void terminateDispatchBackBill(Long id, String billFormId, String operateKey) {
        String message;
        DynamicObject bill = DispatchBackRepository.getInstance().queryOne((Object)id);
        OperationResult operation = OperationServiceHelper.executeOperate((String)"discard_bill", (String)billFormId, (Object[])new Long[]{id}, (OperateOption)OperateOption.create());
        List allErrorOrValidateInfo = operation.getAllErrorOrValidateInfo();
        if (!CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo) && HRStringUtils.isNotEmpty((String)(message = ((IOperateInfo)allErrorOrValidateInfo.get(0)).getMessage()))) {
            this.getView().showErrorNotification(message);
            return;
        }
        DyObjValidateContext context = IDispatchBackBillService.getInstance().terminateValidate(bill);
        String validateResultStr = context.getValidatorContext().getValidateResultStr();
        if (HRStringUtils.isNotEmpty((String)validateResultStr)) {
            this.getView().showErrorNotification(validateResultStr);
            return;
        }
        IDispatchBackBillService.getInstance().terminate(bill, this.getModel().getValue(KEY_ABANDONREASON));
        this.recordTerminateLog(billFormId, bill, operateKey);
        this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u6d3e\u8fd4\u6d41\u7a0b\u7ec8\u6b62\u6210\u529f\u3002", (String)"TerminateConfirmPlugin_10", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        this.getView().getParentView().invokeOperation("refresh");
        this.getView().sendFormAction(this.getView().getParentView());
        this.getView().close();
    }

    private void terminateRecordChange(Long id, String billFormId, String operateKey) {
        String message;
        DynamicObject bill = RecordChangeRepository.getInstance().queryOne((Object)id);
        OperationResult operation = OperationServiceHelper.executeOperate((String)"discard_bill", (String)billFormId, (Object[])new Long[]{id}, (OperateOption)OperateOption.create());
        List allErrorOrValidateInfo = operation.getAllErrorOrValidateInfo();
        if (!CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo) && HRStringUtils.isNotEmpty((String)(message = ((IOperateInfo)allErrorOrValidateInfo.get(0)).getMessage()))) {
            this.getView().showErrorNotification(message);
            return;
        }
        DyObjValidateContext context = IRecordChangeBillService.getInstance().terminateValidate(bill);
        String validateResultStr = context.getValidatorContext().getValidateResultStr();
        if (HRStringUtils.isNotEmpty((String)validateResultStr)) {
            this.getView().showErrorNotification(validateResultStr);
            return;
        }
        IRecordChangeBillService.getInstance().terminate(bill, this.getModel().getValue(KEY_ABANDONREASON));
        this.recordTerminateLog(billFormId, bill, operateKey);
        this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u5916\u6d3e\u53d8\u66f4\u6d41\u7a0b\u7ec8\u6b62\u6210\u529f\u3002", (String)"TerminateConfirmPlugin_11", (String)"hr-ham-formplugin", (Object[])new Object[0]));
        this.getView().getParentView().invokeOperation("refresh");
        this.getView().sendFormAction(this.getView().getParentView());
        this.getView().close();
    }

    private void recordTerminateLog(String billFormId, DynamicObject bill, String operateKey) {
        AppLogUtils.recordLog((String)billFormId, (String)operateKey, (String)bill.getString("billno"), (String)ResManager.loadKDString((Lang)Lang.zh_CN, (String)"\u7ec8\u6b62\u6d41\u7a0b", (String)"TerminateConfirmPlugin_2", (String)"hr-ham-formplugin", (Object[])new Object[0]));
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }
}

