/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.formplugin.web.record;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.ham.common.dispatch.constants.operate.DispatchRecordOpCode;
import kd.hr.ham.common.dispatch.utils.DispatchDateUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import org.apache.commons.lang3.time.FastDateFormat;

public class DispatchRecordBillList
extends HRDataBaseList
implements DispatchRecordOpCode {
    private static final Log LOG = LogFactory.getLog(DispatchRecordBillList.class);
    private static final List<LocalDate> NOTSHOWLOCALDATELIST = Stream.of("2999-12-31", "2999-12-30", "2199-12-31", "2199-12-30").map(LocalDate::parse).collect(Collectors.toList());

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        Stream.of("fseq", "person.headsculpture", "person.name").forEach(fieldName -> args.getListColumn(fieldName).setFixed(true));
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        List qFilters = setFilterEvent.getQFilters();
        qFilters.add(new QFilter("empposrel.postype", "=", (Object)1040L));
        qFilters.add(new QFilter("ham_disprecord.iscurrentversion", "=", (Object)"1"));
        LOG.info("DispatchRecordBillList qFilters: {}", (Object)qFilters);
    }

    public void beforePackageData(BeforePackageDataEvent beforePackageData) {
        super.beforePackageData(beforePackageData);
        DynamicObjectCollection pageData = beforePackageData.getPageData();
        pageData.stream().filter(dynamicObject -> {
            Date endDate = dynamicObject.getDate("enddate");
            LocalDate endLocalDate = endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            return NOTSHOWLOCALDATELIST.contains(endLocalDate);
        }).forEach(dynamicObject -> dynamicObject.set("enddate", null));
    }

    public void afterExportFile(ExportFileEvent exportFileEvent) {
        super.afterExportFile(exportFileEvent);
        exportFileEvent.setFileName(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5916\u6d3e\u6863\u6848\u5217\u8868\u6570\u636e_%s", (String)"DispatchRecordBillList_0", (String)"hr-ham-formplugin", (Object[])new Object[0]), FastDateFormat.getInstance((String)"yyyyMMdd").format(DispatchDateUtils.now())));
    }
}

