/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.formplugin.web.record.multiview;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.ham.business.domain.drawpage.DrawPageService;
import kd.hr.ham.business.domain.repository.dispatchrecord.DispatchRecordRepository;
import kd.hr.ham.business.domain.service.common.IPersonAboutService;
import kd.hr.ham.common.dispatch.constants.record.DisprecordConstants;
import kd.hr.ham.formplugin.web.record.utils.PosPatternVisibleUtils;
import kd.hr.ham.formplugin.web.record.utils.RecordCustomParamUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class HamMainWorkInfoPlugin
extends HRDynamicFormBasePlugin
implements DisprecordConstants {
    private static final Log LOG = LogFactory.getLog(HamMainWorkInfoPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs preOpenFormEventArgs) {
        super.preOpenForm(preOpenFormEventArgs);
        preOpenFormEventArgs.getFormShowParameter().setStatus(OperationStatus.VIEW);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs loadCustomControlMetasArgs) {
        super.loadCustomControlMetas(loadCustomControlMetasArgs);
        FormShowParameter showParameter = (FormShowParameter)loadCustomControlMetasArgs.getSource();
        FlexPanelAp flexPanelAp = DrawPageService.getInstance().genFlexPanelAp(showParameter);
        HashMap mapHead = Maps.newHashMapWithExpectedSize((int)2);
        mapHead.put("id", "ham_empposorgrel_dv");
        mapHead.put("items", flexPanelAp.createControl().get("items"));
        loadCustomControlMetasArgs.getItems().add(mapHead);
    }

    public void getEntityType(GetEntityTypeEventArgs getEntityTypeEventArgs) {
        MainEntityType newMainType;
        MainEntityType oldMainType = getEntityTypeEventArgs.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new KDException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        DrawPageService.getInstance().registerProperty(newMainType, this.getView().getFormShowParameter());
        getEntityTypeEventArgs.setNewEntityType(newMainType);
    }

    public void afterCreateNewData(EventObject eventObject) {
        long erFileId = RecordCustomParamUtils.getErFileIdFromParam(this.getView().getFormShowParameter());
        Map<String, Object> mainWorkInfo = this.getMainWorkInfo(erFileId);
        if (CollectionUtils.isEmpty(mainWorkInfo)) {
            return;
        }
        this.getModel().getDataEntityType().getProperties().forEach(property -> {
            String name = property.getName();
            Object value = mainWorkInfo.get(name);
            if (property instanceof MulBasedataProp) {
                value = ((DynamicObjectCollection)value).stream().map(dynamicObject -> dynamicObject.getLong("id")).toArray();
            }
            LOG.info("HamMainWorkInfoPlugin.setValue, property: {}, value:{}", property, value);
            this.getModel().setValue(name, value);
        });
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FlexPanelAp flexPanelAp = DrawPageService.getInstance().genFlexPanelAp(this.getView().getFormShowParameter());
        Container myFldPanel = (Container)this.getView().getControl("flexpanelap");
        myFldPanel.getItems().addAll(((Container)flexPanelAp.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(myFldPanel.getItems());
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String posPattern = dataEntity.getString("pospattern");
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("position", "position");
        map.put("std_position", "stdposition");
        map.put("job", "job");
        PosPatternVisibleUtils.visibleFieldByPattern(this.getView(), posPattern, map);
    }

    private Map<String, Object> getMainWorkInfo(long erManFileId) {
        if (erManFileId == 0L) {
            LOG.warn("getMainWorkInfo erManFileId is 0");
            return Collections.emptyMap();
        }
        DynamicObject employee = DispatchRecordRepository.getInstance().getEmployee(Long.valueOf(erManFileId));
        return IPersonAboutService.getInstance().getPrimaryInfo(employee.getLong("id"));
    }
}

