/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.formplugin.web.record.multiview;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.hr.ham.business.domain.drawpage.DrawPageService;
import kd.hr.ham.business.domain.repository.dispatchrecord.DispatchRecordRepository;
import kd.hr.ham.common.dispatch.constants.record.DisprecordConstants;
import kd.hr.ham.common.dispatch.enums.record.DispatchRecordStatusEnum;
import kd.hr.ham.common.dispatch.enums.record.TermRecordSource;
import kd.hr.ham.formplugin.web.record.utils.PosPatternVisibleUtils;
import kd.hr.ham.formplugin.web.record.utils.RecordCustomParamUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class HamWorkInfoPlugin
extends HRDynamicFormBasePlugin
implements DisprecordConstants {
    private static final Log LOG = LogFactory.getLog(HamWorkInfoPlugin.class);
    private static final Set<String> BACK_FIELDS = Sets.newHashSetWithExpectedSize((int)8);
    private static final Set<String> TERM_FIELDS = Sets.newHashSetWithExpectedSize((int)8);

    public void preOpenForm(PreOpenFormEventArgs preOpenFormEventArgs) {
        super.preOpenForm(preOpenFormEventArgs);
        preOpenFormEventArgs.getFormShowParameter().setStatus(OperationStatus.VIEW);
    }

    public void createNewData(BizDataEventArgs bizDataEventArgs) {
        super.createNewData(bizDataEventArgs);
        DynamicObject dy = this.setValueByType("0");
        if (dy != null) {
            bizDataEventArgs.setDataEntity((Object)dy);
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs loadCustomControlMetasArgs) {
        super.loadCustomControlMetas(loadCustomControlMetasArgs);
        FormShowParameter showParameter = (FormShowParameter)loadCustomControlMetasArgs.getSource();
        FlexPanelAp flexPanelAp = DrawPageService.getInstance().genFlexPanelAp(showParameter);
        HashMap mapHead = Maps.newHashMapWithExpectedSize((int)2);
        mapHead.put("id", "ham_lastedworkinfo_dv");
        mapHead.put("items", flexPanelAp.createControl().get("items"));
        loadCustomControlMetasArgs.getItems().add(mapHead);
    }

    public void getEntityType(GetEntityTypeEventArgs getEntityTypeEventArgs) {
        MainEntityType newMainType;
        MainEntityType oldMainType = getEntityTypeEventArgs.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new KDException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        DrawPageService.getInstance().registerProperty(newMainType, this.getView().getFormShowParameter());
        getEntityTypeEventArgs.setNewEntityType(newMainType);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FlexPanelAp flexPanelAp = DrawPageService.getInstance().genFlexPanelAp(this.getView().getFormShowParameter());
        Container myFldPanel = (Container)this.getView().getControl("flexpanelap");
        myFldPanel.getItems().addAll(((Container)flexPanelAp.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(myFldPanel.getItems());
        this.setValueByType("1");
        this.setFieldsVisible();
    }

    private DynamicObject setValueByType(String type) {
        long erFileId = RecordCustomParamUtils.getErFileIdFromParam(this.getView().getFormShowParameter());
        List fieldParams = DrawPageService.getInstance().getFieldParams(this.getView().getFormShowParameter());
        List selectProperties = fieldParams.stream().map(fieldParam -> String.valueOf(fieldParam.get("number"))).collect(Collectors.toList());
        DynamicObject dispatchRecord = DispatchRecordRepository.getInstance().queryCurrentOneByErFileId((Object)erFileId, Joiner.on((char)',').skipNulls().join(selectProperties));
        if (Objects.isNull(dispatchRecord)) {
            return null;
        }
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        selectProperties.stream().filter(HRStringUtils::isNotEmpty).forEach(property -> {
            Object recordValue = dispatchRecord.get(property);
            LOG.info("HamWorkInfoPlugin.setValue, property: {}, value:{}", property, recordValue);
            boolean isTypeOne = "1".equals(type);
            boolean isMul = recordValue instanceof MulBasedataDynamicObjectCollection;
            if (isTypeOne && isMul) {
                MulBasedataDynamicObjectCollection valueCol = (MulBasedataDynamicObjectCollection)recordValue;
                List ids = valueCol.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toList());
                this.getModel().setValue(property, (Object)ids.toArray());
            } else if (!isTypeOne && !isMul) {
                dynamicObject.set(property, recordValue);
            }
        });
        return dynamicObject;
    }

    private void setFieldsVisible() {
        long erFileId = RecordCustomParamUtils.getErFileIdFromParam(this.getView().getFormShowParameter());
        String selectProperties = Joiner.on((String)",").skipNulls().join((Object)"dispstatus", (Object)"termsource", new Object[0]);
        DynamicObject dispatchRecord = DispatchRecordRepository.getInstance().queryCurrentOneByErFileId((Object)erFileId, selectProperties);
        if (Objects.isNull(dispatchRecord)) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String posPattern = dataEntity.getString("pospatternin");
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("position", "positionin");
        map.put("std_position", "standardposin");
        map.put("job", "jobin");
        PosPatternVisibleUtils.visibleFieldByPattern(this.getView(), posPattern, map);
        boolean recordIsInValid = HRStringUtils.equals((String)dispatchRecord.getString("dispstatus"), (String)DispatchRecordStatusEnum.INVALID.getCode());
        this.getView().setVisible(Boolean.valueOf(!recordIsInValid), new String[]{"planenddate"});
        this.getView().setVisible(Boolean.valueOf(recordIsInValid), new String[]{"enddate"});
        String termSource = dispatchRecord.getString("termsource");
        boolean showBackField = recordIsInValid && HRStringUtils.equals((String)termSource, (String)TermRecordSource.DISPATCH_BACK.getCode());
        this.getView().setVisible(Boolean.valueOf(showBackField), BACK_FIELDS.toArray(new String[0]));
        boolean showTermField = recordIsInValid && HRStringUtils.equals((String)termSource, (String)TermRecordSource.TERM_RECORD.getCode()) || HRStringUtils.equals((String)termSource, (String)TermRecordSource.PERSON_QUIT.getCode());
        this.getView().setVisible(Boolean.valueOf(showTermField), TERM_FIELDS.toArray(new String[0]));
    }

    static {
        BACK_FIELDS.add("dispbackreason");
        TERM_FIELDS.add("dispreasonend");
    }
}

