/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.formplugin.web.record.operate;

import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.hr.ham.business.domain.service.record.DispatchRecordService;
import kd.hr.ham.business.domain.service.validator.DyObjValidateContext;
import kd.hr.ham.common.dispatch.constants.operate.DispatchRecordOpCode;
import kd.hr.ham.formplugin.web.common.DispatchBillFormCommon;
import kd.hr.ham.formplugin.web.common.OperateUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class DispatchChangeRecordPlugin
extends HRDynamicFormBasePlugin
implements DispatchRecordOpCode {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (!HRStringUtils.equals((String)operate.getOperateKey(), (String)"dispchange")) {
            return;
        }
        if (OperateUtils.selectRowCheck(this.getView(), 1)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DispatchBackRecordPlugin_0", (String)"hr-ham-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        boolean hasPerm = OperateUtils.verifyPermAndTip(operate.getOperateKey(), "ham_ermanfilequery", this.getView(), new Object[]{OperateUtils.getIdByViewForRecord(this.getView())});
        if (!hasPerm) {
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (!HRStringUtils.equals((String)afterDoOperationEventArgs.getOperateKey(), (String)"dispchange")) {
            return;
        }
        if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        DynamicObject dispatchRecord = OperateUtils.getCurrentRecordDO(this.getView());
        DyObjValidateContext context = DispatchRecordService.getInstance().changeRecordValidate(dispatchRecord);
        String validateResultStr = context.getValidatorContext().getValidateResultStr();
        if (HRStringUtils.isNotEmpty((String)validateResultStr)) {
            this.getView().showErrorNotification(validateResultStr);
            return;
        }
        boolean validResult = DispatchBillFormCommon.getInstance().f7validateAndTipChange(this.getView(), dispatchRecord.getDynamicObject("ermanfile"), dispatchRecord);
        if (validResult) {
            return;
        }
        this.showChangeRecordPage(OperateUtils.getIdByViewForRecord(this.getView()));
    }

    private void showChangeRecordPage(Object pkId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("ham_dispatchrecordchg");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCustomParam("dispatchrecord", pkId);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

