/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.formplugin.web.record.operate;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.ham.business.domain.repository.dispatchrecord.DispatchRecordRepository;
import kd.hr.ham.business.domain.service.record.DispatchRecordService;
import kd.hr.ham.business.domain.service.validator.ValidateContext;
import kd.hr.ham.formplugin.web.common.OperateUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import org.apache.commons.lang3.time.FastDateFormat;

public class RecordTerminateConfirmPlugin
extends HRDynamicFormBasePlugin {
    private static final String BTN_OK = "btn_ok";
    public static final String DESC = "desc";
    public static final String BACK_LOCATION = "baselocationback";
    public static final String END_DATE = "enddate";
    private static final String CONFIRM_TERMINATE = "term_confirm";
    private static final Log LOG = LogFactory.getLog(RecordTerminateConfirmPlugin.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Button btnOk = (Button)this.getControl(BTN_OK);
        btnOk.addClickListener((ClickListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs preOpenFormEventArgs) {
        super.preOpenForm(preOpenFormEventArgs);
        FormShowParameter showParameter = preOpenFormEventArgs.getFormShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u5916\u6d3e\u7ec8\u6b62", (String)"RecordTerminateConfirmPlugin_0", (String)"hr-ham-formplugin", (Object[])new Object[0]));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        if (!HRStringUtils.equals((String)afterDoOperationEventArgs.getOperateKey(), (String)"ok")) {
            return;
        }
        DynamicObject dynamicObject = DispatchRecordRepository.getInstance().queryCurrentOneByErFileId((Object)this.getId());
        Date startDate = dynamicObject.getDate("startdate");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date endDate = dataEntity.getDate(END_DATE);
        if (endDate.before(startDate)) {
            String msg = ResManager.loadKDString((String)"\u5916\u6d3e\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u5916\u6d3e\u5f00\u59cb\u65e5\u671f\u201c%s\u201d\u3002", (String)"RecordTerminateConfirmPlugin_2", (String)"hr-ham-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(String.format(Locale.ROOT, msg, FastDateFormat.getInstance((String)"yyyy-MM-dd").format(startDate)));
            return;
        }
        boolean hasPerm = OperateUtils.verifyPermAndTip("dispterm", "ham_ermanfilequery", this.getView(), new Object[]{this.getId()});
        if (!hasPerm) {
            return;
        }
        ValidateContext validatorContext = DispatchRecordService.getInstance().terminateRecordValidate(dynamicObject).getValidatorContext();
        List strongValidKeys = validatorContext.getStrongValidKeys();
        if (!strongValidKeys.isEmpty()) {
            String validMsg = (String)validatorContext.getValidateResult().get(strongValidKeys.get(0));
            this.getView().showErrorNotification(validMsg);
            return;
        }
        this.doReturnToParent();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && HRStringUtils.equals((String)messageBoxClosedEvent.getCallBackId(), (String)CONFIRM_TERMINATE)) {
            this.doReturnToParent();
        }
    }

    private void doReturnToParent() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put(BACK_LOCATION, dataEntity.get(BACK_LOCATION));
        map.put(END_DATE, dataEntity.getDate(END_DATE));
        map.put(DESC, dataEntity.get(DESC));
        this.getView().returnDataToParent((Object)map);
        this.getView().close();
    }

    private long getId() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        return (Long)showParameter.getCustomParam("id");
    }
}

