/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.formplugin.web.record.operate;

import com.google.common.base.Joiner;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.hr.ham.business.domain.repository.dispatchrecord.DispatchRecordRepository;
import kd.hr.ham.business.domain.service.record.DispatchRecordService;
import kd.hr.ham.business.domain.service.validator.ValidateContext;
import kd.hr.ham.common.dispatch.constants.operate.DispatchRecordOpCode;
import kd.hr.ham.common.dispatch.utils.AppLogUtils;
import kd.hr.ham.formplugin.web.common.OperateUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class RecordTerminatePlugin
extends HRDynamicFormBasePlugin
implements DispatchRecordOpCode {
    private static final String CONFIRM_TERMINATE = "term_confirm";
    private static final String CLOSE_TERMINATE = "term_close";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (!HRStringUtils.equals((String)operate.getOperateKey(), (String)"dispterm")) {
            return;
        }
        if (OperateUtils.selectRowCheck(this.getView(), 1)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DispatchBackRecordPlugin_0", (String)"hr-ham-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        boolean hasPerm = OperateUtils.verifyPermAndTip(operate.getOperateKey(), "ham_ermanfilequery", this.getView(), new Object[]{OperateUtils.getIdByViewForRecord(this.getView())});
        if (!hasPerm) {
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (!HRStringUtils.equals((String)afterDoOperationEventArgs.getOperateKey(), (String)"dispterm")) {
            return;
        }
        if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        if (OperateUtils.selectRowCheck(this.getView(), 1)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DispatchRecordBillList_1", (String)"hr-ham-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dynamicObject = OperateUtils.getCurrentRecordDO(this.getView());
        ValidateContext validatorContext = DispatchRecordService.getInstance().terminateRecordValidate(dynamicObject).getValidatorContext();
        List strongValidKeys = validatorContext.getStrongValidKeys();
        if (!strongValidKeys.isEmpty()) {
            String validMsg = (String)validatorContext.getValidateResult().get(strongValidKeys.get(0));
            this.getView().showErrorNotification(validMsg);
            return;
        }
        List notStrongValidKeys = validatorContext.getNotStrongValidKeys();
        if (!notStrongValidKeys.isEmpty()) {
            List validateResultStrByKey = validatorContext.getValidateResultStrByKey(notStrongValidKeys);
            validateResultStrByKey.add(ResManager.loadKDString((String)"\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DispatchRecordBillList_2", (String)"hr-ham-formplugin", (Object[])new Object[0]));
            String msg = Joiner.on((char)'\n').skipNulls().join((Iterable)validateResultStrByKey);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_TERMINATE, (IFormPlugin)this));
            return;
        }
        this.showTerminateForm();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.showTerminateForm();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)CLOSE_TERMINATE)) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (Objects.isNull(returnData)) {
                return;
            }
            Date endDate = (Date)returnData.get("enddate");
            Object backLocation = returnData.get("baselocationback");
            Object termReason = returnData.get("desc");
            Long erManFileId = OperateUtils.getIdByViewForRecord(this.getView());
            boolean result = DispatchRecordService.getInstance().termBeforePersonTransValidByErManFile(erManFileId.longValue(), backLocation, endDate, termReason);
            DynamicObject person = DispatchRecordRepository.getInstance().getPerson(erManFileId);
            if (result) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5916\u6d3e\u7ec8\u6b62\u6210\u529f\u3002", (String)"RecordTerminatePlugin_1", (String)"hr-ham-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5916\u6d3e\u7ec8\u6b62\u5931\u8d25\u3002", (String)"RecordTerminatePlugin_3", (String)"hr-ham-formplugin", (Object[])new Object[0]));
            }
            AppLogUtils.recordLog((String)"ham_ermanfilequery", (String)"dispterm", (String)person.getString("number"), (String)ResManager.loadKDString((Lang)Lang.zh_CN, (String)"\u7ec8\u6b62\u5916\u6d3e", (String)"RecordTerminatePlugin_0", (String)"hr-ham-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    private void showTerminateForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ham_termrecord");
        showParameter.setCustomParam("id", (Object)OperateUtils.getIdByViewForRecord(this.getView()));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CLOSE_TERMINATE);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }
}

