/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.drawpage.executor.control;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.property.ComboProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.ham.business.domain.drawpage.executor.ControlExecutor;
import org.apache.http.util.Asserts;

public class ComboExecutor
extends ControlExecutor {
    private static final Log LOG = LogFactory.getLog(ComboExecutor.class);

    @Override
    public void registerProperty(DynamicObjectType dynamicObjectType) {
        IDataEntityProperty property = (IDataEntityProperty)MetadataServiceHelper.getDataEntityType((String)this.getEntityNumber()).getAllFields().get(this.getPropertyName());
        ComboProp comboProp = (ComboProp)property;
        dynamicObjectType.registerSimpleProperty((DynamicSimpleProperty)comboProp);
    }

    @Override
    public ControlAp generateFieldAp() {
        FieldAp fieldAp = this.genFieldAp();
        IDataEntityProperty property = (IDataEntityProperty)MetadataServiceHelper.getDataEntityType((String)this.getEntityNumber()).getAllFields().get(this.getPropertyName());
        ComboProp comboProp = (ComboProp)property;
        List values = comboProp.getComboItems();
        Asserts.check((!CollectionUtils.isEmpty((Collection)values) ? 1 : 0) != 0, (String)"ComboItems");
        List comboItems = values.stream().map(valueMapItem -> {
            ComboItem item = new ComboItem();
            item.setCaption(valueMapItem.getName());
            item.setValue(valueMapItem.getValue());
            item.setImageKey(valueMapItem.getImageKey());
            item.setItemVisible(true);
            return item;
        }).collect(Collectors.toList());
        ComboField field = new ComboField();
        field.setId(this.getPropertyName());
        field.setName(this.getDisplayName());
        field.setKey(this.getPropertyName());
        field.setItems(comboItems);
        fieldAp.setField((Field)field);
        return fieldAp;
    }
}

