/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.drawpage.impl;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.ham.business.domain.drawpage.DrawPageService;
import kd.hr.ham.business.domain.drawpage.executor.ControlExecutor;
import kd.hr.ham.business.domain.drawpage.executor.ControlExecutorFactory;

public class DrawPageServiceImpl
implements DrawPageService {
    private static final Log LOG = LogFactory.getLog(DrawPageServiceImpl.class);

    @Override
    public FlexPanelAp genFlexPanelAp(FormShowParameter showParameter) {
        List<Map<String, Object>> fieldParams = this.getFieldParams(showParameter);
        return this.genFlexPanelAp(fieldParams);
    }

    @Override
    public FlexPanelAp genFlexPanelAp(List<Map<String, Object>> fieldParams) {
        this.checkFieldParams(fieldParams);
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey("flexpanelap");
        fieldParams.forEach(fieldParam -> ControlExecutorFactory.getExecutor(fieldParam).ifPresent(controlExecutor -> flexPanelAp.getItems().add(controlExecutor.generateFieldAp())));
        return flexPanelAp;
    }

    @Override
    public void registerProperty(MainEntityType mainEntityType, FormShowParameter showParameter) {
        List<Map<String, Object>> fieldParams = this.getFieldParams(showParameter);
        this.registerProperty(mainEntityType, fieldParams);
    }

    @Override
    public void registerProperty(MainEntityType mainEntityType, List<Map<String, Object>> fieldParams) {
        this.checkFieldParams(fieldParams);
        fieldParams.forEach(fieldParam -> {
            Optional<ControlExecutor> executor = ControlExecutorFactory.getExecutor(fieldParam);
            if (executor.isPresent()) {
                LOG.info("DrawPageServiceImpl.registerProperty, fieldParam:{}, executor:{} ", fieldParam, (Object)executor.get());
                executor.ifPresent(controlExecutor -> controlExecutor.registerProperty((DynamicObjectType)mainEntityType));
            }
        });
    }

    private void checkFieldParams(List<Map<String, Object>> fieldParams) {
        if (CollectionUtils.isEmpty(fieldParams)) {
            throw new KDBizException(new ErrorCode("ERR_001", "no params"), new Object[0]);
        }
    }

    @Override
    public List<Map<String, Object>> getFieldParams(FormShowParameter showParameter) {
        if (Objects.isNull(showParameter)) {
            throw new KDBizException(new ErrorCode("ERR_001", "no params"), new Object[0]);
        }
        Object paramsObj = showParameter.getCustomParam("params");
        if (Objects.isNull(paramsObj)) {
            throw new KDBizException(new ErrorCode("ERR_001", "no params"), new Object[0]);
        }
        LOG.info("FieldParams: {}", (Object)JSON.toJSONString((Object)paramsObj));
        Map map = (Map)SerializationUtils.fromJsonString((String)String.valueOf(paramsObj), Map.class);
        List groups = (List)map.get("groups");
        if (CollectionUtils.isEmpty((Collection)groups)) {
            throw new KDBizException(new ErrorCode("ERR_001", "no groups"), new Object[0]);
        }
        return (List)((Map)groups.get(0)).get("fields");
    }
}

