/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.repository;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.ham.common.dispatch.constants.DispatchBillConstants;
import kd.hr.ham.common.dispatch.enums.DispatchStatusEnum;
import kd.hr.ham.common.dispatch.utils.HamEntityFieldUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class DispatchRepository
extends HRBaseServiceHelper
implements DispatchBillConstants {
    private static final DispatchRepository SERVICE = new DispatchRepository("ham_dispatch");
    private static final Log LOG = LogFactory.getLog(DispatchRepository.class);

    public static DispatchRepository getInstance() {
        return SERVICE;
    }

    private DispatchRepository(String entityName) {
        super(entityName);
    }

    public DynamicObject[] query(String fields, List<Long> ids) {
        QFilter idFilter = new QFilter("id", "in", ids);
        QFilter[] idFilterArray = new QFilter[]{idFilter};
        return this.query(fields, idFilterArray);
    }

    public DynamicObject[] queryOfApply(String fields, QFilter[] qFilters) {
        return this.query(fields, qFilters);
    }

    public DynamicObject[] queryPreValidBillInToday() {
        LOG.info("execute queryPreValidBillInToday start");
        QFilter personChangeStatusQFilter = new QFilter("effectstatus", "in", Arrays.asList("3", "0"));
        QFilter statusQFilter = new QFilter("dispatchstatus", "=", (Object)DispatchStatusEnum.WAITEFFECT_DISPATCH.getCode());
        LocalDate now = LocalDate.now();
        QFilter timeQFilter = new QFilter("startdate", ">", (Object)now.minusDays(3L)).and(new QFilter("startdate", "<=", (Object)now));
        String properties = HamEntityFieldUtils.getAllProperties((String)this.getEntityName());
        DynamicObject[] dynamicObjects = this.query(properties, new QFilter[]{statusQFilter, timeQFilter, personChangeStatusQFilter});
        LOG.info("execute queryPreValidBillInToday end: {}", (Object)dynamicObjects.length);
        return dynamicObjects;
    }
}

