/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.repository.bill;

import com.google.common.base.Joiner;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.ham.common.dispatch.enums.DispatchBackStatusEnum;
import kd.hr.ham.common.dispatch.utils.DispatchDateUtils;
import kd.hr.ham.common.dispatch.utils.HamEntityFieldUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class DispatchBackRepository
extends HRBaseServiceHelper {
    private static final DispatchBackRepository SERVICE = new DispatchBackRepository("ham_dispback");
    private static final Log LOG = LogFactory.getLog(DispatchBackRepository.class);

    public static DispatchBackRepository getInstance() {
        return SERVICE;
    }

    private DispatchBackRepository(String entityName) {
        super(entityName);
    }

    public DynamicObject queryUsefulByRecord(Long recordId) {
        QFilter qFilter = new QFilter("dispatchrecord", "=", (Object)recordId);
        QFilter statusQFilter = new QFilter("backstatus", "in", (Object)DispatchBackStatusEnum.usefulCode());
        String selectProperties = Joiner.on((char)',').skipNulls().join((Object)"billno", (Object)"id", new Object[]{"auditstatus", "billstatus", "enddate", "backstatus"});
        DynamicObject dynamicObject = this.queryOne(selectProperties, new QFilter[]{qFilter, statusQFilter});
        if (Objects.isNull(dynamicObject)) {
            LOG.warn("DispatchBackRepository.queryUsefulByRecord back is null, recordId:{}", (Object)recordId);
            return null;
        }
        if (!this.isPreValid(dynamicObject)) {
            return null;
        }
        return dynamicObject;
    }

    public DynamicObject queryUsefulByRecordForQuit(Long recordId) {
        QFilter qFilter = new QFilter("dispatchrecord", "=", (Object)recordId);
        List statusCodeList = DispatchBackStatusEnum.usefulCode();
        statusCodeList.add(DispatchBackStatusEnum.WAIT_SUBMIT.getCode());
        QFilter statusQFilter = new QFilter("backstatus", "in", (Object)statusCodeList);
        String selectProperties = HamEntityFieldUtils.getAllProperties((String)this.getEntityName());
        DynamicObject dynamicObject = this.queryOne(selectProperties, new QFilter[]{qFilter, statusQFilter});
        if (Objects.isNull(dynamicObject)) {
            LOG.warn("DispatchBackRepository.queryUsefulByRecord back is null, recordId:{}", (Object)recordId);
            return null;
        }
        if (!this.isPreValid(dynamicObject)) {
            return null;
        }
        return dynamicObject;
    }

    private boolean isPreValid(DynamicObject dynamicObject) {
        Date endDate = dynamicObject.getDate("enddate");
        String backStatus = dynamicObject.getString("backstatus");
        boolean isPreValidFlag = true;
        if (HRStringUtils.equals((String)DispatchBackStatusEnum.PASS.getCode(), (String)backStatus) && Objects.nonNull(endDate) && DispatchDateUtils.isBeforeNow((Date)endDate)) {
            isPreValidFlag = false;
        }
        LOG.info("DispatchBackRepository.isPreValid ,back:{},isPreValid:{}", (Object)dynamicObject.getLong("id"), (Object)isPreValidFlag);
        return isPreValidFlag;
    }

    public DynamicObject queryUsefulByErManFile(Long erManFileId) {
        QFilter qFilter = new QFilter("ermanfile", "=", (Object)erManFileId);
        QFilter statusQFilter = new QFilter("backstatus", "in", (Object)DispatchBackStatusEnum.usefulCode());
        String selectProperties = HamEntityFieldUtils.getAllProperties((String)this.getEntityName());
        DynamicObject dynamicObject = this.queryOne(selectProperties, new QFilter[]{qFilter, statusQFilter});
        if (Objects.isNull(dynamicObject)) {
            return null;
        }
        Date endDate = dynamicObject.getDate("enddate");
        if (Objects.nonNull(endDate) && DispatchDateUtils.isBeforeNow((Date)endDate)) {
            return null;
        }
        return dynamicObject;
    }

    public DynamicObject queryOnGoingByErManFile(Long erManFileId) {
        QFilter qFilter = new QFilter("ermanfile", "=", (Object)erManFileId);
        QFilter statusQFilter = new QFilter("backstatus", "in", (Object)DispatchBackStatusEnum.onGoingCode());
        QFilter formAdd = new QFilter("genbytermrecord", "=", (Object)"1");
        String selectProperties = HamEntityFieldUtils.getAllProperties((String)this.getEntityName());
        DynamicObject dynamicObject = this.queryOne(selectProperties, new QFilter[]{qFilter, statusQFilter, formAdd});
        return dynamicObject;
    }

    public DynamicObject[] queryPreValidBacks() {
        LOG.info("execute queryPreValidBacks start");
        QFilter personChangeStatusQFilter = new QFilter("effectstatus", "in", Arrays.asList("3", "0"));
        QFilter statusQFilter = new QFilter("backstatus", "=", (Object)DispatchBackStatusEnum.PASS.getCode());
        LocalDate now = LocalDate.now();
        QFilter timeQFilter = new QFilter("enddate", ">=", (Object)now.minusDays(3L)).and(new QFilter("enddate", "<", (Object)now));
        String allProperties = HamEntityFieldUtils.getAllProperties((String)this.getEntityName());
        DynamicObject[] dynamicObjects = this.query(allProperties, new QFilter[]{timeQFilter, personChangeStatusQFilter, statusQFilter});
        LOG.info("execute queryPreValidBacks end: {}", (Object)dynamicObjects.length);
        return dynamicObjects;
    }
}

