/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.repository.dispatchrecord;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.ham.common.dispatch.constants.record.DisprecordConstants;
import kd.hr.ham.common.dispatch.enums.record.DispatchRecordStatusEnum;
import kd.hr.ham.common.dispatch.enums.record.TermRecordTaskStatus;
import kd.hr.ham.common.dispatch.utils.HamEntityFieldUtils;
import kd.hr.ham.common.dispatch.utils.HamNPEExpUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRObjectUtils;

public class DispatchRecordRepository
extends HRBaseServiceHelper
implements DisprecordConstants {
    private static final DispatchRecordRepository SERVICE = new DispatchRecordRepository("ham_disprecord");

    public static DispatchRecordRepository getInstance() {
        return SERVICE;
    }

    public DynamicObject queryCurrentValidOneByErFileId(Object erFileId, String selectProperties) {
        if (erFileId == null) {
            return null;
        }
        QFilter qFilter = new QFilter("ermanfile", "=", erFileId);
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        qFilter.and(new QFilter("dispstatus", "=", (Object)DispatchRecordStatusEnum.VALID.getCode()));
        return this.queryOne(selectProperties, qFilter.toArray());
    }

    public DynamicObject loadCurrentValidOneByErFileId(Object erFileId) {
        HamNPEExpUtil.throwExp((Object)erFileId, (String)"loadCurrentValidOneByErFileId erFileId null");
        QFilter qFilter = new QFilter("ermanfile", "=", erFileId);
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        return this.loadDynamicObject(qFilter);
    }

    public DynamicObject queryInValidByErFileId(List<Object> erFileIds) {
        QFilter qFilter = new QFilter("ermanfile", "in", erFileIds);
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        qFilter.and(new QFilter("dispstatus", "=", (Object)DispatchRecordStatusEnum.INVALID.getCode()));
        return this.queryOne("id,dispstatus", qFilter.toArray());
    }

    public DynamicObject queryCurrentOneByErFileId(Object erFileId, String selectProperties) {
        if (erFileId == null) {
            return null;
        }
        QFilter qFilter = new QFilter("ermanfile", "=", erFileId);
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        return this.queryOne(selectProperties, qFilter.toArray());
    }

    public DynamicObject queryCurrentValidOneByErFileId(Object erFileId) {
        String selectProperties = HamEntityFieldUtils.getAllProperties((String)this.getEntityName());
        return this.queryCurrentValidOneByErFileId(erFileId, selectProperties);
    }

    public DynamicObject queryCurrentOneByErFileId(Object erFileId) {
        String selectProperties = HamEntityFieldUtils.getAllProperties((String)this.getEntityName());
        if (erFileId == null) {
            return null;
        }
        QFilter qFilter = new QFilter("ermanfile", "=", erFileId);
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        return this.queryOne(selectProperties, qFilter.toArray());
    }

    public DynamicObject queryCurrentValidOneByPerson(Object personId) {
        QFilter qFilter = new QFilter("depemp.person", "=", personId);
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        qFilter.and(new QFilter("dispstatus", "=", (Object)DispatchRecordStatusEnum.VALID.getCode()));
        String selectProperties = HamEntityFieldUtils.getAllProperties((String)this.getEntityName());
        return this.queryOne(selectProperties, qFilter.toArray());
    }

    public DynamicObject queryTempByBoId(Long boId) {
        QFilter qFilter = new QFilter("boid", "=", (Object)boId);
        QFilter statusQFilter = new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
        String selectProperties = HamEntityFieldUtils.getAllProperties((String)this.getEntityName());
        return this.queryOne(selectProperties, new QFilter[]{qFilter, statusQFilter});
    }

    public boolean hasValidRecordByDispatch(Long dispatchId) {
        QFilter qFilter = new QFilter("dispatch", "=", (Object)dispatchId);
        qFilter.and(new QFilter("dispstatus", "=", (Object)DispatchRecordStatusEnum.VALID.getCode()));
        return this.isExists(qFilter);
    }

    public DynamicObject queryCurrentOneByRecord(Long recordId) {
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter recordQFilter = new QFilter("id", "=", (Object)recordId);
        String selectProperties = HamEntityFieldUtils.getAllProperties((String)this.getEntityName());
        return this.queryOne(selectProperties, new QFilter[]{qFilter, recordQFilter});
    }

    public DynamicObject getPerson(Long erManFileId) {
        DynamicObject dispatchRecord = DispatchRecordRepository.getInstance().queryCurrentOneByErFileId(erManFileId, "ermanfile");
        if (HRObjectUtils.isEmpty((Object)dispatchRecord)) {
            return this.generateEmptyDynamicObject("hrpi_person");
        }
        DynamicObject erManFile = dispatchRecord.getDynamicObject("ermanfile");
        return erManFile.getDynamicObject("person");
    }

    public DynamicObject getEmployee(Long erManFileId) {
        DynamicObject dispatchRecord = DispatchRecordRepository.getInstance().queryCurrentOneByErFileId(erManFileId, "ermanfile");
        if (HRObjectUtils.isEmpty((Object)dispatchRecord)) {
            return this.generateEmptyDynamicObject("hrpi_employee");
        }
        DynamicObject erManFile = dispatchRecord.getDynamicObject("ermanfile");
        return erManFile.getDynamicObject("employee");
    }

    public boolean hasTempRecord(Long boId) {
        QFilter qFilter = new QFilter("boid", "=", (Object)boId);
        QFilter statusQFilter = new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
        QFilter termTaskQFilter = new QFilter("termtaskstatus", "=", (Object)TermRecordTaskStatus.PROCESSING.getCode());
        return this.isExists(new QFilter[]{qFilter, statusQFilter, termTaskQFilter});
    }

    public boolean hasTempRecordTermSource(Long boId) {
        QFilter qFilter = new QFilter("boid", "=", (Object)boId);
        QFilter statusQFilter = new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
        QFilter termTaskQFilter = new QFilter("termtaskstatus", "=", (Object)TermRecordTaskStatus.PROCESSING.getCode());
        QFilter termSource = new QFilter("termsource", "=", (Object)"2");
        return this.isExists(new QFilter[]{qFilter, statusQFilter, termTaskQFilter, termSource});
    }

    private DispatchRecordRepository(String entityName) {
        super(entityName);
    }
}

