/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.service.handler;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.ham.business.domain.repository.bill.DispatchBillRepository;
import kd.hr.ham.business.domain.service.common.IDispabackPersonChangeService;
import kd.hr.ham.business.domain.service.common.IPersonAboutService;
import kd.hr.ham.business.domain.service.handler.HPFSTemplatePropertyHandler;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sdk.hr.common.bean.DepempBean;
import kd.sdk.hr.common.bean.PerChgBizInfoNew;
import kd.sdk.hr.common.enums.FlowTypeEnum;
import kd.sdk.hr.ham.business.newchgaction.IDispatchBackChgExtendService;
import kd.sdk.hr.hpfs.business.mservice.helper.ChgRecordHelper;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgFlowTypeEnum;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgModeEnum;
import kd.sdk.hr.hpfs.business.service.impl.PerSaveSuccessService;
import kd.sdk.hr.hpfs.utils.PerChgNewBillUtils;
import kd.sdk.hr.hpfs.utils.PersonParamsBuilder;
import kd.sdk.hr.hpfs.utils.RepositoryUtils;

public class DispatchBackHPFSTemplatePropertyHandler
extends HPFSTemplatePropertyHandler {
    private static final Log LOGGER = LogFactory.getLog(DispatchBackHPFSTemplatePropertyHandler.class);
    private static final DispatchBackHPFSTemplatePropertyHandler handler = new DispatchBackHPFSTemplatePropertyHandler();
    private static final String[] CUSTOM_PARAM_ENTITY_NUMBERS = new String[]{"hrpi_cmpemp", "hrpi_managingscope", "hrpi_baselocation", "hrpi_empjobrel"};

    private DispatchBackHPFSTemplatePropertyHandler() {
    }

    public static DispatchBackHPFSTemplatePropertyHandler getInstance() {
        return handler;
    }

    @Override
    public void setPreProperty(DynamicObject dy) {
        dy.set("b_ermanfile", dy.get("ermanfile"));
        dy.set("b_effectivedate", (Object)this.getEndDate(dy));
        dy.set("bb_p_chgtype", (Object)ChgModeEnum.UNCHANGED.getChgMode());
        dy.set("ba_p_chgtype", null);
        dy.set("ba_e_chgtype", null);
        dy.set("bb_e_chgtype", (Object)ChgModeEnum.UNCHANGED.getChgMode());
        dy.set("bb_d_chgtype", (Object)ChgModeEnum.INVALID.getChgMode());
        dy.set("ba_d_chgtype", null);
    }

    private Date getEndDate(DynamicObject dy) {
        if ("0".equals(dy.getString("genbytermrecord"))) {
            return dy.getDate("enddate");
        }
        return dy.getDate("backdate");
    }

    @Override
    public void setBeforeDepEmpEntry(DynamicObject bill) {
        super.setBeforeDepEmpEntry(bill);
        LOGGER.info("HPFSTemplatePropertyHandler.setBeforeDepEmpEntry-start");
        DynamicObjectCollection entryEntityDys = bill.getDynamicObjectCollection("entry_b_depemp");
        Map<Long, DynamicObject> entryMap = entryEntityDys.stream().collect(Collectors.toMap(item -> item.getLong("b_d_tid"), item -> item));
        DynamicObject dispatchrecord = bill.getDynamicObject("dispatchrecord");
        Long depempId = dispatchrecord.getLong("depemp.id");
        DynamicObject depEmpEntryEntityDy = entryMap.get(depempId);
        if (depEmpEntryEntityDy == null) {
            depEmpEntryEntityDy = entryEntityDys.addNew();
        }
        List<String> entryList = Collections.singletonList("entry_b_depemp");
        Map entryAndFieldMap = PerChgNewBillUtils.getEntryAndFieldMap((DynamicObject)bill, entryList);
        List fields = (List)entryAndFieldMap.get("entry_b_depemp");
        DynamicObject ermanfileDy = IPersonAboutService.getInstance().getPrimaryErManFile(bill.getDynamicObject("ermanfile").getLong("employee_id"));
        if (ermanfileDy == null) {
            return;
        }
        QFilter idFilter = new QFilter("id", "=", (Object)ermanfileDy.getLong("empposrel.id"));
        DynamicObject[] empPosDys = this.listEmployeeAttach("hrpi_empposorgrel", idFilter);
        if (empPosDys.length > 0) {
            Map dmpFieldAndValue = PerChgNewBillUtils.getDepEmpFieldAndValue((List)fields, (DynamicObject)empPosDys[0]);
            dmpFieldAndValue.forEach((arg_0, arg_1) -> ((DynamicObject)depEmpEntryEntityDy).set(arg_0, arg_1));
        }
        DispatchBackHPFSTemplatePropertyHandler.setBeforeDepEmpValue(depEmpEntryEntityDy, bill, ermanfileDy);
        PerChgNewBillUtils.setMainBillTplFieldExcludeChgType((DynamicObject)bill, entryList, null);
        LOGGER.info("HPFSTemplatePropertyHandler.setBeforeDepEmpEntry-end");
    }

    private static void setBeforeDepEmpValue(DynamicObject entry, DynamicObject billDy, DynamicObject ermanfileDy) {
        if (ermanfileDy != null) {
            entry.set("b_d_org", ermanfileDy.get("org.id"));
            entry.set("b_d_affiliateadminorg", ermanfileDy.get("affiliateadminorg.id"));
            entry.set("b_d_empgroup", ermanfileDy.get("empgroup.id"));
        }
        entry.set("b_d_posstatus", billDy.get("posstatus"));
        entry.set("b_d_chgtype", (Object)ChgModeEnum.MODIFY.getChgMode());
    }

    @Override
    public void saveBatchPersonAttach(List<PerChgBizInfoNew> perChgBizInfoNews) {
        perChgBizInfoNews.forEach(perChgBizInfoNew -> {
            long billId = 0L;
            Long aErfileId = null;
            Map result = null;
            boolean success = false;
            try (TXHandle txHandle = TX.requiresNew();){
                DynamicObject bill = perChgBizInfoNew.getDy();
                billId = bill.getLong("id");
                List depempList = perChgBizInfoNew.getDepempList();
                aErfileId = ((DepempBean)depempList.get(depempList.size() - 1)).getaErfileId();
                LOGGER.info("IHRPIPersonGenericService.saveBatch start");
                result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonGenericService", (String)"saveBatch", (Object[])new Object[]{perChgBizInfoNew.getPersonParams()});
                LOGGER.info("IHRPIPersonGenericService.saveBatch result:{}", (Object)result);
                Map delPersonParams = perChgBizInfoNew.getDelPersonParams();
                if (delPersonParams != null && delPersonParams.size() > 0) {
                    Object deleteBatchResult = HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIPersonGenericService", (String)"deleteBatch", (Object[])new Object[]{delPersonParams});
                    LOGGER.info("deleteBatchResult:{}", deleteBatchResult);
                }
                if (success = ((Boolean)result.get("success")).booleanValue()) {
                    new PersonParamsBuilder().setChargePersonByPerChgNew(perChgBizInfoNew);
                }
                new PerSaveSuccessService().doIfPerSaveSuccessOperate(perChgBizInfoNew, result);
            }
            if (!success) {
                LOGGER.error("Dispback DispbackPersonChangeEffectCallBack is fail, the billId is : [{}], the error message is :[{}]", (Object)billId, (Object)result.get("errInfos").toString());
                IDispabackPersonChangeService.getInstance().excutePersonChangeEffectFail(billId);
            } else {
                LOGGER.info("Dispback DispbackPersonChangeEffectCallBack is success, the billId is : [{}]", (Object)billId);
                IDispabackPersonChangeService.getInstance().excutePersonChangeEffectSuccess(billId, aErfileId);
            }
        });
    }

    @Override
    public void saveEntryFields(DynamicObject[] dys) {
        DispatchBillRepository.getInstance().batchSave(dys);
    }

    @Override
    public Date getEffectDate(DynamicObject dy) {
        return this.getEndDate(dy);
    }

    @Override
    public void setBillProperty(DynamicObject dy) {
        DynamicObject ermanfile = dy.getDynamicObject("ermanfile");
        dy.set("bb_d_chgtype", (Object)ChgModeEnum.INVALID.getChgMode());
        dy.set("bb_d_tid", ermanfile.get("depemp.id"));
        dy.set("bb_d_adminorg", dy.get("deptin"));
        dy.set("bb_d_position", dy.get("positionin"));
        dy.set("bb_d_stdposition", dy.get("poststandardin"));
        dy.set("bb_d_job", dy.get("jobin"));
        if (Objects.nonNull(dy.get("org"))) {
            dy.set("bb_d_org", dy.get("org"));
        }
        dy.set("bb_d_empgroup", dy.get("empgroupin"));
        dy.set("bb_d_affiliateadminorg", dy.get("adminorgin"));
        dy.set("bb_d_enddate", (Object)this.getEndDate(dy));
        dy.set("bb_d_orgnumbervid", dy.get("deptlongnuminvid"));
        dy.set("ba_d_adminorg", dy.get("deptback"));
        dy.set("ba_d_position", dy.get("positionback"));
        dy.set("ba_d_job", dy.get("jobback"));
        dy.set("ba_d_stdposition", dy.get("poststandardback"));
        dy.set("ba_d_empgroup", dy.get("empgroupback"));
        dy.set("ba_d_org", dy.get("orgback"));
        dy.set("ba_d_cmpemp", dy.get("cmpempback"));
        dy.set("ba_d_affiliateadminorg", dy.get("adminorgback"));
        dy.set("ba_d_orgnumbervid", dy.get("deptlongnumbackvid"));
        this.setPosType(dy);
    }

    private void setPosType(DynamicObject dy) {
        if (HRObjectUtils.isEmpty((Object)dy.getDynamicObject("postype"))) {
            DynamicObject poststate = new HRBaseServiceHelper("hbss_poststate").loadDynamicObject(new QFilter("id", "=", (Object)1020L));
            dy.set("posstatus", (Object)poststate);
        }
    }

    @Override
    public void buildCustomPersonParams(List<PerChgBizInfoNew> perChgBizInfoNews, DynamicObject[] bills) {
        HashMap perChgBizInfoNewMap = Maps.newHashMapWithExpectedSize((int)perChgBizInfoNews.size());
        for (PerChgBizInfoNew perChgBizInfoNew : perChgBizInfoNews) {
            if (!perChgBizInfoNew.isSuccess()) {
                throw new KDBizException(perChgBizInfoNew.getErrMsg());
            }
            perChgBizInfoNewMap.put(perChgBizInfoNew.getBillId(), perChgBizInfoNew);
        }
        this.setCustomPersonParams(bills, perChgBizInfoNewMap);
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create(null, IDispatchBackChgExtendService.class, (String)"kd.sdk.hr.ham.business.newchgaction.IDispatchBackChgExtendService", null);
        pluginProxy.callReplace(service -> {
            service.setCustomPersonParamsExtend(bills, perChgBizInfoNewMap);
            return "";
        });
    }

    private void setCustomPersonParams(DynamicObject[] bills, Map<Long, PerChgBizInfoNew> perChgBizInfoNewMap) {
        Arrays.stream(bills).forEach(bill -> {
            PerChgBizInfoNew perChgBizInfoNew = (PerChgBizInfoNew)perChgBizInfoNewMap.get(bill.getLong("id"));
            Map entityRecordMap = perChgBizInfoNew.getEntityRecord();
            List chgRecordEntryList = (List)entityRecordMap.get("hrpi_empposorgrel");
            chgRecordEntryList.forEach(chgRecordEntry -> {
                DynamicObject dy = chgRecordEntry.getDataDy();
                if (!dy.getBoolean("isprimary")) {
                    dy.set("lastworkdate", (Object)this.getEndDate((DynamicObject)bill));
                    dy.set("posstatus", null);
                } else {
                    chgRecordEntry.setFlowType(FlowTypeEnum.IN.getValue());
                }
            });
            List depempList = (List)entityRecordMap.get("hrpi_depemp");
            depempList.forEach(chgRecordEntry -> {
                DynamicObject dy = chgRecordEntry.getDataDy();
                if (dy.getBoolean("isprimary")) {
                    chgRecordEntry.setFlowType(FlowTypeEnum.IN.getValue());
                }
            });
        });
        this.setCmpEmp(bills, perChgBizInfoNewMap);
        this.setBaseLocation(bills, perChgBizInfoNewMap);
        perChgBizInfoNewMap.values().forEach(perChgBizInfoNew -> this.setPersonParams((PerChgBizInfoNew)perChgBizInfoNew, CUSTOM_PARAM_ENTITY_NUMBERS));
    }

    private void setPersonParams(PerChgBizInfoNew perChgBizInfoNew, String[] entityNumbers) {
        List data = (List)perChgBizInfoNew.getPersonParams().get("data");
        Map entityRecordMap = perChgBizInfoNew.getEntityRecord();
        Arrays.stream(entityNumbers).forEach(entityNumber -> {
            List chgRecordEntryList = (List)entityRecordMap.get(entityNumber);
            if (HRCollUtil.isNotEmpty((Collection)chgRecordEntryList)) {
                HashMap map = Maps.newHashMapWithExpectedSize((int)chgRecordEntryList.size());
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                DynamicObjectCollection dynamicObjects = new DynamicObjectCollection((DynamicObjectType)dataEntityType, null);
                chgRecordEntryList.forEach(chgRecordEntry -> dynamicObjects.add((Object)chgRecordEntry.getDataDy()));
                map.put("hisDyns", dynamicObjects);
                data.add(map);
            }
        });
    }

    private void setCmpEmp(DynamicObject[] bills, Map<Long, PerChgBizInfoNew> perChgBizInfoNewMap) {
        HashMap todoMap = Maps.newHashMapWithExpectedSize((int)bills.length);
        ArrayList<Long> cmpEmpIds = new ArrayList<Long>();
        for (DynamicObject bill : bills) {
            if (HRObjectUtils.equals((Object)bill.getLong("cmpempback.id"), (Object)bill.getLong("cmpempin.id"))) continue;
            todoMap.put(bill.getLong("id"), bill);
            cmpEmpIds.add(bill.getLong("ermanfile.cmpemp.id"));
        }
        Map<Long, DynamicObject> managingScopeMap = this.listManagingScope(cmpEmpIds);
        Map<Long, DynamicObject> cmpEmpMap = this.listCmpEmp(cmpEmpIds);
        for (Map.Entry entry : todoMap.entrySet()) {
            DynamicObject bill = (DynamicObject)entry.getValue();
            PerChgBizInfoNew perChgBizInfoNew = perChgBizInfoNewMap.get(bill.getLong("id"));
            long cmpEmpId = bill.getLong("ermanfile.cmpemp.id");
            DynamicObject managingScope = managingScopeMap.get(cmpEmpId);
            DynamicObject cmpEmp = cmpEmpMap.get(cmpEmpId);
            if (managingScope == null) continue;
            DynamicObject hisManagingScope = this.invalidManagingScope(perChgBizInfoNew, bill, managingScope);
            ChgRecordHelper.updIdsRecord((String)"hrpi_managingscope", (DynamicObject)managingScope, (DynamicObject)hisManagingScope, (PerChgBizInfoNew)perChgBizInfoNew, (String)ChgModeEnum.INVALID.getChgMode());
            DynamicObject hisCmpEmp = this.invalidCmpEmp(perChgBizInfoNew, bill, cmpEmp);
            ChgRecordHelper.updIdsRecord((String)"hrpi_cmpemp", (DynamicObject)cmpEmp, (DynamicObject)hisCmpEmp, (PerChgBizInfoNew)perChgBizInfoNew, (String)ChgModeEnum.INVALID.getChgMode());
        }
    }

    private DynamicObject invalidCmpEmp(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill, DynamicObject cmpEmp) {
        return this.createNewHisDy(perChgBizInfoNew, bill, cmpEmp, "hrpi_cmpemp");
    }

    private DynamicObject invalidManagingScope(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill, DynamicObject managingScope) {
        DynamicObject newHisDy = this.createNewHisDy(perChgBizInfoNew, bill, managingScope, "hrpi_managingscope");
        newHisDy.set("lastworkdate", (Object)this.getEndDate(bill));
        return newHisDy;
    }

    private DynamicObject createNewHisDy(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill, DynamicObject currentDy, String entityNumber) {
        DynamicObject newHisDy = ChgRecordHelper.getHisDyById((PerChgBizInfoNew)perChgBizInfoNew, (DynamicObject)currentDy, (String)entityNumber);
        Date endDate = this.getEndDate(bill);
        newHisDy.set("bsed", (Object)endDate);
        newHisDy.set("businessstatus", (Object)"2");
        newHisDy.set("sysenddate", (Object)endDate);
        newHisDy.set("enddate", (Object)endDate);
        return newHisDy;
    }

    private DynamicObject invalidLocation(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill, DynamicObject location) {
        DynamicObject newHisDy = this.createNewHisDy(perChgBizInfoNew, bill, location, "hrpi_baselocation");
        newHisDy.set("location", (Object)bill.getDynamicObject("baselocationin"));
        return newHisDy;
    }

    private DynamicObject createDynamicObject(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill, String entityNumber) {
        DynamicObject dataEntity = ChgRecordHelper.createDynamicObject((PerChgBizInfoNew)perChgBizInfoNew, (String)entityNumber);
        Date endDate = this.getEndDate(bill);
        dataEntity.set("startdate", (Object)endDate);
        dataEntity.set("bsed", (Object)endDate);
        dataEntity.set("person", (Object)bill.getDynamicObject("person"));
        dataEntity.set("employee", (Object)bill.getDynamicObject("ermanfile.employee"));
        Date maxDate = DateUtils.stringToDate((String)"2999-12-31", (DatePattern)DatePattern.YYYY_MM_DD);
        dataEntity.set("bsled", (Object)maxDate);
        dataEntity.set("enddate", (Object)maxDate);
        dataEntity.set("businessstatus", (Object)"1");
        dataEntity.set("initstatus", (Object)"2");
        dataEntity.set("datastatus", (Object)"1");
        return dataEntity;
    }

    private DynamicObject createLocation(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill) {
        DynamicObject location = this.createDynamicObject(perChgBizInfoNew, bill, "hrpi_baselocation");
        location.set("location", (Object)bill.getDynamicObject("baselocationback"));
        return location;
    }

    private void setBaseLocation(DynamicObject[] bills, Map<Long, PerChgBizInfoNew> perChgBizInfoNewMap) {
        HashMap todoMap = Maps.newHashMapWithExpectedSize((int)bills.length);
        ArrayList<Long> employeeIds = new ArrayList<Long>();
        for (DynamicObject bill : bills) {
            if (bill.getLong("baselocationin.id") == bill.getLong("baselocationback.id")) {
                ChgRecordHelper.deleteEntityRecord((PerChgBizInfoNew)perChgBizInfoNewMap.get(bill.getLong("id")), (String)"hrpi_baselocation");
                continue;
            }
            todoMap.put(bill.getLong("id"), bill);
            employeeIds.add(bill.getLong("ermanfile.employee.id"));
        }
        Map<Long, DynamicObject> locationMap = this.listLocation(employeeIds);
        for (Map.Entry entry : todoMap.entrySet()) {
            DynamicObject bill;
            bill = (DynamicObject)entry.getValue();
            PerChgBizInfoNew perChgBizInfoNew = perChgBizInfoNewMap.get(bill.getLong("id"));
            long employeeId = bill.getLong("ermanfile.employee.id");
            DynamicObject location = locationMap.get(employeeId);
            if (location != null) {
                DynamicObject hisLocation = this.invalidLocation(perChgBizInfoNew, bill, location);
                ChgRecordHelper.updIdsRecord((String)"hrpi_baselocation", (DynamicObject)location, (DynamicObject)hisLocation, (PerChgBizInfoNew)perChgBizInfoNew, (String)ChgModeEnum.INVALID.getChgMode());
            }
            DynamicObject newLocation = this.createLocation(perChgBizInfoNew, bill);
            ChgRecordHelper.addChgIdRecord((String)"hrpi_baselocation", (PerChgBizInfoNew)perChgBizInfoNew, (Long)newLocation.getLong("id"), (String)ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), (DynamicObject)newLocation);
        }
    }

    private Map<Long, DynamicObject> listCmpEmp(List<Long> cmpEmpIdList) {
        QFilter qFilters = new QFilter("id", "in", cmpEmpIdList);
        DynamicObject[] dynamicObjects = this.listEmployeeAttach("hrpi_cmpemp", qFilters);
        if (dynamicObjects == null || dynamicObjects.length < 1) {
            return new HashMap<Long, DynamicObject>();
        }
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (o, n) -> n));
    }

    private Map<Long, DynamicObject> listManagingScope(List<Long> cmpEmpIds) {
        QFilter qFilters = new QFilter("cmpemp", "in", cmpEmpIds);
        DynamicObject[] dynamicObjects = this.listEmployeeAttach("hrpi_managingscope", qFilters);
        if (dynamicObjects == null || dynamicObjects.length < 1) {
            return new HashMap<Long, DynamicObject>();
        }
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("cmpemp.id"), dy -> dy, (o, n) -> n));
    }

    private Map<Long, DynamicObject> listLocation(List<Long> employeeIds) {
        QFilter qFilters = new QFilter("employee", "in", employeeIds);
        DynamicObject[] dynamicObjects = this.listEmployeeAttach("hrpi_baselocation", qFilters);
        if (dynamicObjects == null || dynamicObjects.length < 1) {
            return new HashMap<Long, DynamicObject>();
        }
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("employee.id"), dy -> dy, (o, n) -> n));
    }

    private DynamicObject[] listEmployeeAttach(String entityName, QFilter qFilters) {
        qFilters.and(new QFilter("iscurrentversion", "=", (Object)"1")).and(new QFilter("businessstatus", "=", (Object)"1")).and(new QFilter("datastatus", "=", (Object)"1"));
        return RepositoryUtils.queryDynamicObjects((String)entityName, null, (QFilter[])new QFilter[]{qFilters});
    }
}

