/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.service.handler;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.ham.business.domain.repository.bill.DispatchBillRepository;
import kd.hr.ham.business.domain.service.common.IDispatchPersonChangeService;
import kd.hr.ham.business.domain.service.handler.HPFSTemplatePropertyHandler;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sdk.hr.common.bean.DepempBean;
import kd.sdk.hr.common.bean.PerChgBizInfoNew;
import kd.sdk.hr.ham.business.newchgaction.IDispatchChgExtendService;
import kd.sdk.hr.hpfs.business.mservice.helper.ChgRecordHelper;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgFlowTypeEnum;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgModeEnum;
import kd.sdk.hr.hpfs.business.perchg.executor.model.ChgRecordEntryDto;
import kd.sdk.hr.hpfs.business.service.impl.PerSaveSuccessService;
import kd.sdk.hr.hpfs.utils.ChgActionUtils;
import kd.sdk.hr.hpfs.utils.PersonParamsBuilder;
import kd.sdk.hr.hpfs.utils.RepositoryUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class DispatchHPFSTemplatePropertyHandler
extends HPFSTemplatePropertyHandler {
    private static final Log LOGGER = LogFactory.getLog(DispatchHPFSTemplatePropertyHandler.class);
    private static final DispatchHPFSTemplatePropertyHandler handler = new DispatchHPFSTemplatePropertyHandler();
    private static final String[] CUSTOM_PARAM_ENTITY_NUMBERS = new String[]{"hrpi_cmpemp", "hrpi_managingscope", "hrpi_baselocation", "hrpi_empjobrel"};
    private static final String[] CMPEMP_PARAM_ENTITY_NUMBERS = new String[]{"hspm_ermanfile", "hrpi_depemp", "hrpi_empposorgrel", "hrpi_emporgrelall"};

    private DispatchHPFSTemplatePropertyHandler() {
    }

    public static DispatchHPFSTemplatePropertyHandler getInstance() {
        return handler;
    }

    @Override
    public void setPreProperty(DynamicObject dy) {
        dy.set("b_ermanfile", dy.get("ermanfile"));
        dy.set("b_effectivedate", dy.get("startdate"));
        dy.set("bb_d_chgtype", (Object)ChgModeEnum.MODIFY.getChgMode());
    }

    @Override
    public void saveBatchPersonAttach(List<PerChgBizInfoNew> perChgBizInfoNews) {
        perChgBizInfoNews.forEach(perChgBizInfoNew -> {
            long billId = 0L;
            Long aErfileId = null;
            Map result = null;
            boolean success = false;
            try (TXHandle txHandle = TX.requiresNew();){
                DynamicObject bill = perChgBizInfoNew.getDy();
                billId = bill.getLong("id");
                List depempList = perChgBizInfoNew.getDepempList();
                aErfileId = ((DepempBean)depempList.get(depempList.size() - 1)).getaErfileId();
                LOGGER.info("IHRPIPersonGenericService.saveBatch start");
                result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonGenericService", (String)"saveBatch", (Object[])new Object[]{perChgBizInfoNew.getPersonParams()});
                LOGGER.info("IHRPIPersonGenericService.saveBatch result:{}", (Object)result);
                Map delPersonParams = perChgBizInfoNew.getDelPersonParams();
                if (delPersonParams != null && delPersonParams.size() > 0) {
                    Object deleteBatchResult = HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIPersonGenericService", (String)"deleteBatch", (Object[])new Object[]{delPersonParams});
                    LOGGER.info("deleteBatchResult:{}", deleteBatchResult);
                }
                if (success = ((Boolean)result.get("success")).booleanValue()) {
                    new PersonParamsBuilder().setChargePersonByPerChgNew(perChgBizInfoNew);
                }
                new PerSaveSuccessService().doIfPerSaveSuccessOperate(perChgBizInfoNew, result);
            }
            if (!success) {
                LOGGER.error("Dispatch DispatchPersonChangeEffectCallBack is fail, the billId is : [{}], the error message is :[{}]", (Object)billId, (Object)result.get("errInfos").toString());
                IDispatchPersonChangeService.getInstance().excutePersonChangeEffectFail(billId);
            } else {
                LOGGER.info("Dispatch DispatchPersonChangeEffectCallBack is success, the billId is : [{}]", (Object)billId);
                IDispatchPersonChangeService.getInstance().excutePersonChangeEffectSuccess(billId, aErfileId);
            }
        });
    }

    @Override
    public void saveEntryFields(DynamicObject[] dys) {
        DispatchBillRepository.getInstance().batchSave(dys);
    }

    @Override
    public void setBillProperty(DynamicObject dy) {
    }

    @Override
    public void buildCustomPersonParams(List<PerChgBizInfoNew> perChgBizInfoNews, DynamicObject[] bills) {
        HashMap perChgBizInfoNewMap = Maps.newHashMapWithExpectedSize((int)perChgBizInfoNews.size());
        for (PerChgBizInfoNew perChgBizInfoNew : perChgBizInfoNews) {
            if (!perChgBizInfoNew.isSuccess()) {
                throw new KDBizException(perChgBizInfoNew.getErrMsg());
            }
            perChgBizInfoNewMap.put(perChgBizInfoNew.getBillId(), perChgBizInfoNew);
        }
        this.setCustomPersonParams(bills, perChgBizInfoNewMap);
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create(null, IDispatchChgExtendService.class, (String)"kd.sdk.hr.ham.business.newchgaction.IDispatchChgExtendService", null);
        pluginProxy.callReplace(service -> {
            service.setCustomPersonParamsExtend(bills, perChgBizInfoNewMap);
            return "";
        });
    }

    private void setCustomPersonParams(DynamicObject[] bills, Map<Long, PerChgBizInfoNew> perChgBizInfoNewMap) {
        Arrays.stream(bills).forEach(bill -> {
            PerChgBizInfoNew perChgBizInfoNew = (PerChgBizInfoNew)perChgBizInfoNewMap.get(bill.getLong("id"));
            this.setPrimaryForEmpposrel(perChgBizInfoNew, (DynamicObject)bill);
            Map entityRecord = perChgBizInfoNew.getEntityRecord();
            List hspmErmanfile = (List)entityRecord.get("hspm_ermanfile");
            if (CollectionUtils.isNotEmpty((Collection)hspmErmanfile)) {
                hspmErmanfile.forEach(chgRecordEntryDto -> {
                    if (ChgModeEnum.ADD_NEW.getChgMode().equals(chgRecordEntryDto.getChgMode())) {
                        DynamicObject ermanfile = chgRecordEntryDto.getDataDy();
                        ermanfile.set("dependency", (Object)bill.getDynamicObject("dependencyin"));
                        ermanfile.set("dependencytype", (Object)bill.getDynamicObject("dependencytypein"));
                    }
                });
            }
        });
        this.setCmpEmp(bills, perChgBizInfoNewMap);
        this.setBaseLocation(bills, perChgBizInfoNewMap);
        perChgBizInfoNewMap.values().forEach(perChgBizInfoNew -> this.setPersonParams((PerChgBizInfoNew)perChgBizInfoNew, CUSTOM_PARAM_ENTITY_NUMBERS));
    }

    private void setPersonParams(PerChgBizInfoNew perChgBizInfoNew, String[] entityNumbers) {
        List data = (List)perChgBizInfoNew.getPersonParams().get("data");
        Map entityRecordMap = perChgBizInfoNew.getEntityRecord();
        Arrays.stream(entityNumbers).forEach(entityNumber -> {
            List chgRecordEntryList = (List)entityRecordMap.get(entityNumber);
            if (HRCollUtil.isNotEmpty((Collection)chgRecordEntryList)) {
                HashMap map = Maps.newHashMapWithExpectedSize((int)chgRecordEntryList.size());
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                DynamicObjectCollection dynamicObjects = new DynamicObjectCollection((DynamicObjectType)dataEntityType, null);
                chgRecordEntryList.forEach(chgRecordEntry -> dynamicObjects.add((Object)chgRecordEntry.getDataDy()));
                map.put("hisDyns", dynamicObjects);
                data.add(map);
            }
        });
    }

    private void setPrimaryForEmpposrel(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill) {
        Map entityRecordMap = perChgBizInfoNew.getEntityRecord();
        List chgRecordEntryList = (List)entityRecordMap.get("hrpi_empposorgrel");
        chgRecordEntryList.forEach(chgRecordEntry -> {
            if (ChgModeEnum.ADD_NEW.getChgMode().equals(chgRecordEntry.getChgMode())) {
                chgRecordEntry.getDataDy().set("apositiontype", bill.get("inradiogroupfield"));
                chgRecordEntry.getDataDy().set("isprimary", (Object)"0");
            }
        });
    }

    private void setCmpEmp(DynamicObject[] bills, Map<Long, PerChgBizInfoNew> perChgBizInfoNewMap) {
        HashMap todoMap = Maps.newHashMapWithExpectedSize((int)bills.length);
        ArrayList<Long> cmpEmpIds = new ArrayList<Long>();
        for (DynamicObject bill : bills) {
            if (HRObjectUtils.equals((Object)bill.getLong("cmpempin.id"), (Object)bill.getLong("cmpempout.id"))) continue;
            todoMap.put(bill.getLong("id"), bill);
            cmpEmpIds.add(bill.getLong("ermanfile.cmpemp.id"));
        }
        Map<Long, DynamicObject> managingScopeMap = this.listManagingScope(cmpEmpIds);
        Map<Long, DynamicObject> cmpEmpMap = this.listCmpEmp(cmpEmpIds);
        List chgActionIds = perChgBizInfoNewMap.values().stream().map(PerChgBizInfoNew::getChgActionId).collect(Collectors.toList());
        Map actionTypeMap = ChgActionUtils.getChgCategoryActionType(chgActionIds);
        for (Map.Entry entry : todoMap.entrySet()) {
            DynamicObject bill = (DynamicObject)entry.getValue();
            PerChgBizInfoNew perChgBizInfoNew = perChgBizInfoNewMap.get(bill.getLong("id"));
            long cmpEmpId = bill.getLong("ermanfile.cmpemp.id");
            DynamicObject managingScope = managingScopeMap.get(cmpEmpId);
            DynamicObject cmpEmp = cmpEmpMap.get(cmpEmpId);
            if (managingScope != null) {
                DynamicObject hisManagingScope = this.invalidManagingScope(perChgBizInfoNew, bill, managingScope);
                ChgRecordHelper.updIdsRecord((String)"hrpi_managingscope", (DynamicObject)managingScope, (DynamicObject)hisManagingScope, (PerChgBizInfoNew)perChgBizInfoNew, (String)ChgModeEnum.INVALID.getChgMode());
                DynamicObject hisCmpEmp = this.invalidCmpEmp(perChgBizInfoNew, hisManagingScope, cmpEmp);
                ChgRecordHelper.updIdsRecord((String)"hrpi_cmpemp", (DynamicObject)cmpEmp, (DynamicObject)hisCmpEmp, (PerChgBizInfoNew)perChgBizInfoNew, (String)ChgModeEnum.INVALID.getChgMode());
            }
            DynamicObject newManagingScope = this.createManagingScope(perChgBizInfoNew, bill);
            DynamicObject chgActionDy = perChgBizInfoNew.getChgActionDy();
            if (actionTypeMap != null && !actionTypeMap.isEmpty()) {
                newManagingScope.set("variationtype", actionTypeMap.get(chgActionDy.getLong("id")));
            }
            DynamicObject newCmpEmp = this.createCmpEmp(perChgBizInfoNew, newManagingScope, bill);
            ChgRecordHelper.addChgIdRecord((String)"hrpi_managingscope", (PerChgBizInfoNew)perChgBizInfoNew, (Long)newManagingScope.getLong("id"), (String)ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), (DynamicObject)newManagingScope);
            ChgRecordHelper.addChgIdRecord((String)"hrpi_cmpemp", (PerChgBizInfoNew)perChgBizInfoNew, (Long)newCmpEmp.getLong("id"), (String)ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), (DynamicObject)newCmpEmp);
            Map entityRecordMap = perChgBizInfoNew.getEntityRecord();
            this.updateCmpEmp(CMPEMP_PARAM_ENTITY_NUMBERS, newCmpEmp, entityRecordMap);
        }
    }

    private void updateCmpEmp(String[] entityNames, DynamicObject newCmpEmp, Map<String, List<ChgRecordEntryDto>> entityRecordMap) {
        Arrays.stream(entityNames).forEach(entityName -> {
            List chgRecordEntryDTOs = (List)entityRecordMap.get(entityName);
            Optional<ChgRecordEntryDto> optional = chgRecordEntryDTOs.stream().filter(chgRecordEntryDTO -> ChgModeEnum.ADD_NEW.getChgMode().equals(chgRecordEntryDTO.getChgMode())).findFirst();
            optional.ifPresent(chgRecordEntryDto -> chgRecordEntryDto.getDataDy().set("cmpemp", (Object)newCmpEmp));
        });
    }

    private DynamicObject invalidCmpEmp(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill, DynamicObject cmpEmp) {
        return this.createNewHisDy(perChgBizInfoNew, bill, cmpEmp, "hrpi_cmpemp");
    }

    private DynamicObject invalidManagingScope(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill, DynamicObject managingScope) {
        DynamicObject newHisDy = this.createNewHisDy(perChgBizInfoNew, bill, managingScope, "hrpi_managingscope");
        newHisDy.set("lastworkdate", (Object)bill.getDate("startdate"));
        return newHisDy;
    }

    private DynamicObject createNewHisDy(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill, DynamicObject currentDy, String entityNumber) {
        DynamicObject newHisDy = ChgRecordHelper.getHisDyById((PerChgBizInfoNew)perChgBizInfoNew, (DynamicObject)currentDy, (String)entityNumber);
        newHisDy.set("bsled", (Object)DateUtils.stringToDate((String)"2999-12-31", (DatePattern)DatePattern.YYYY_MM_DD));
        newHisDy.set("businessstatus", (Object)"2");
        newHisDy.set("sysenddate", (Object)bill.getDate("startdate"));
        return newHisDy;
    }

    private DynamicObject invalidLocation(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill, DynamicObject location) {
        DynamicObject newHisDy = this.createNewHisDy(perChgBizInfoNew, bill, location, "hrpi_baselocation");
        newHisDy.set("enddate", (Object)HRDateTimeUtils.addDay((Date)bill.getDate("startdate"), (long)-1L));
        return newHisDy;
    }

    private DynamicObject createDynamicObject(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill, String entityNumber) {
        DynamicObject dataEntity = ChgRecordHelper.createDynamicObject((PerChgBizInfoNew)perChgBizInfoNew, (String)entityNumber);
        dataEntity.set("startdate", (Object)bill.getDate("startdate"));
        dataEntity.set("bsed", (Object)bill.getDate("startdate"));
        dataEntity.set("person", (Object)bill.getDynamicObject("person"));
        dataEntity.set("employee", (Object)bill.getDynamicObject("ermanfile.employee"));
        dataEntity.set("bsled", (Object)DateUtils.stringToDate((String)"2999-12-31", (DatePattern)DatePattern.YYYY_MM_DD));
        dataEntity.set("enddate", (Object)DateUtils.stringToDate((String)"2999-12-31", (DatePattern)DatePattern.YYYY_MM_DD));
        dataEntity.set("businessstatus", (Object)"1");
        dataEntity.set("initstatus", (Object)"2");
        dataEntity.set("datastatus", (Object)"1");
        return dataEntity;
    }

    private DynamicObject createManagingScope(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill) {
        DynamicObject managingScope = this.createDynamicObject(perChgBizInfoNew, bill, "hrpi_managingscope");
        managingScope.set("managingscope", (Object)bill.getDynamicObject("cmpempin"));
        managingScope.set("workplace", (Object)bill.getDynamicObject("baselocationin"));
        managingScope.set("cmpemp_id", (Object)ORM.create().genLongId("hrpi_cmpemp"));
        managingScope.set("isprimaryscope", (Object)Character.valueOf('0'));
        managingScope.set("lastworkdate", (Object)DateUtils.stringToDate((String)"2999-12-31", (DatePattern)DatePattern.YYYY_MM_DD));
        return managingScope;
    }

    private DynamicObject createLocation(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill) {
        DynamicObject location = this.createDynamicObject(perChgBizInfoNew, bill, "hrpi_baselocation");
        location.set("location", (Object)bill.getDynamicObject("baselocationin"));
        return location;
    }

    private DynamicObject createCmpEmp(PerChgBizInfoNew perChgBizInfoNew, DynamicObject managingScope, DynamicObject bill) {
        DynamicObject cmpEmp = this.createDynamicObject(perChgBizInfoNew, bill, "hrpi_cmpemp");
        cmpEmp.set("id", (Object)managingScope.getLong("cmpemp_id"));
        cmpEmp.set("managingscope", (Object)managingScope.getDynamicObject("managingscope"));
        cmpEmp.set("person", (Object)managingScope.getDynamicObject("person"));
        cmpEmp.set("employee", (Object)managingScope.getDynamicObject("employee"));
        cmpEmp.set("isprimaryscope", (Object)Character.valueOf('0'));
        cmpEmp.set("company", (Object)bill.getDynamicObject("companyin"));
        return cmpEmp;
    }

    private void setBaseLocation(DynamicObject[] bills, Map<Long, PerChgBizInfoNew> perChgBizInfoNewMap) {
        HashMap todoMap = Maps.newHashMapWithExpectedSize((int)bills.length);
        ArrayList<Long> employeeIds = new ArrayList<Long>();
        for (DynamicObject bill : bills) {
            long empId = bill.getLong("ermanfile.employee.id");
            Map<Long, DynamicObject> location = this.listLocation(Collections.singletonList(empId));
            if (ObjectUtils.isNotEmpty(location) && bill.getLong("baselocationin.id") == location.get(empId).getLong("id")) {
                ChgRecordHelper.deleteEntityRecord((PerChgBizInfoNew)perChgBizInfoNewMap.get(bill.getLong("id")), (String)"hrpi_baselocation");
                continue;
            }
            todoMap.put(bill.getLong("id"), bill);
            employeeIds.add(empId);
        }
        Map<Long, DynamicObject> locationMap = this.listLocation(employeeIds);
        for (Map.Entry entry : todoMap.entrySet()) {
            DynamicObject bill;
            bill = (DynamicObject)entry.getValue();
            PerChgBizInfoNew perChgBizInfoNew = perChgBizInfoNewMap.get(bill.getLong("id"));
            long employeeId = bill.getLong("ermanfile.employee.id");
            DynamicObject location = locationMap.get(employeeId);
            if (location != null) {
                DynamicObject hisLocation = this.invalidLocation(perChgBizInfoNew, bill, location);
                ChgRecordHelper.updIdsRecord((String)"hrpi_baselocation", (DynamicObject)location, (DynamicObject)hisLocation, (PerChgBizInfoNew)perChgBizInfoNew, (String)ChgModeEnum.INVALID.getChgMode());
            }
            DynamicObject newLocation = this.createLocation(perChgBizInfoNew, bill);
            ChgRecordHelper.addChgIdRecord((String)"hrpi_baselocation", (PerChgBizInfoNew)perChgBizInfoNew, (Long)newLocation.getLong("id"), (String)ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), (DynamicObject)newLocation);
        }
    }

    private Map<Long, DynamicObject> listCmpEmp(List<Long> cmpEmpIdList) {
        QFilter qFilters = new QFilter("id", "in", cmpEmpIdList);
        DynamicObject[] dynamicObjects = this.listEmployeeAttach("hrpi_cmpemp", qFilters);
        if (dynamicObjects == null || dynamicObjects.length < 1) {
            return new HashMap<Long, DynamicObject>();
        }
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (o, n) -> n));
    }

    private Map<Long, DynamicObject> listManagingScope(List<Long> cmpEmpIdList) {
        QFilter qFilters = new QFilter("cmpemp", "in", cmpEmpIdList);
        DynamicObject[] dynamicObjects = this.listEmployeeAttach("hrpi_managingscope", qFilters);
        if (dynamicObjects == null || dynamicObjects.length < 1) {
            return new HashMap<Long, DynamicObject>();
        }
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("cmpemp.id"), dy -> dy, (o, n) -> n));
    }

    private Map<Long, DynamicObject> listLocation(List<Long> employeeIds) {
        QFilter qFilters = new QFilter("employee", "in", employeeIds);
        DynamicObject[] dynamicObjects = this.listEmployeeAttach("hrpi_baselocation", qFilters);
        if (dynamicObjects == null || dynamicObjects.length < 1) {
            return new HashMap<Long, DynamicObject>();
        }
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("employee.id"), dy -> dy, (o, n) -> n));
    }

    private DynamicObject[] listEmployeeAttach(String entityName, QFilter qFilters) {
        qFilters.and(new QFilter("iscurrentversion", "=", (Object)"1")).and(new QFilter("businessstatus", "=", (Object)"1")).and(new QFilter("datastatus", "=", (Object)"1"));
        return RepositoryUtils.queryDynamicObjects((String)entityName, null, (QFilter[])new QFilter[]{qFilters});
    }
}

