/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.service.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.sdk.hr.common.bean.PerChgBizInfoNew;
import kd.sdk.hr.hpfs.business.config.repository.DevParamConfigRepository;
import kd.sdk.hr.hpfs.utils.HpfsSetSysAndEnddateUtils;
import kd.sdk.hr.hpfs.utils.PerChgNewBillUtils;
import kd.sdk.hr.hpfs.utils.PersonParamsBuilder;

public abstract class HPFSTemplatePropertyHandler {
    public void saveHPFSEffectMessage(DynamicObject[] bills) {
        Arrays.stream(bills).forEach(bill -> {
            this.setPreProperty((DynamicObject)bill);
            PerChgNewBillUtils.setEntryAndBillFields((DynamicObject)bill);
            this.setBillProperty((DynamicObject)bill);
            PerChgNewBillUtils.setEntryFields((DynamicObject)bill);
            this.setBeforeDepEmpEntry((DynamicObject)bill);
        });
        this.saveEntryFields(bills);
        List<PerChgBizInfoNew> perChgBizInfoNews = this.buildPersonParams(bills);
        HpfsSetSysAndEnddateUtils.setSysDateAndEnddate(perChgBizInfoNews);
        this.saveBatchPersonAttach(perChgBizInfoNews);
    }

    public abstract void setPreProperty(DynamicObject var1);

    public abstract void saveBatchPersonAttach(List<PerChgBizInfoNew> var1);

    public void setBeforeDepEmpEntry(DynamicObject bill) {
    }

    private List<PerChgBizInfoNew> buildPersonParams(DynamicObject[] bills) {
        List<PerChgBizInfoNew> perChgBizInfoNews = this.personParamsBuilder(bills);
        this.buildCustomPersonParams(perChgBizInfoNews, bills);
        return perChgBizInfoNews;
    }

    private List<PerChgBizInfoNew> personParamsBuilder(DynamicObject[] bills) {
        PersonParamsBuilder builder = new PersonParamsBuilder();
        ArrayList<PerChgBizInfoNew> allPerList = new ArrayList<PerChgBizInfoNew>();
        Arrays.stream(bills).forEach(bill -> {
            PerChgBizInfoNew perChgBizInfoNew = new PerChgBizInfoNew();
            perChgBizInfoNew.setEffectivedate(this.getEffectDate((DynamicObject)bill));
            perChgBizInfoNew.setBillId(Long.valueOf(bill.getLong("id")));
            perChgBizInfoNew.setBillNo(bill.getString("billno"));
            perChgBizInfoNew.setBillSource(bill.getDataEntityType().getName());
            perChgBizInfoNew.setChgActionId(Long.valueOf(bill.getLong("affaction.id")));
            allPerList.add(perChgBizInfoNew);
        });
        builder.validParamsAndBuildParams(allPerList);
        return allPerList;
    }

    public Date getEffectDate(DynamicObject dy) {
        return dy.getDate("startdate");
    }

    public abstract void saveEntryFields(DynamicObject[] var1);

    public abstract void setBillProperty(DynamicObject var1);

    public abstract void buildCustomPersonParams(List<PerChgBizInfoNew> var1, DynamicObject[] var2);

    public static boolean isNewChgAction(String devConfigKey) {
        DynamicObject dynamicObject = DevParamConfigRepository.queryConfigByBusinessKey((String)devConfigKey);
        boolean isNewChgAction = false;
        if (dynamicObject != null) {
            isNewChgAction = dynamicObject.getBoolean("businessvalue");
        }
        return isNewChgAction;
    }
}

