/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.service.impl.bill;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.ham.business.domain.repository.bill.DispatchBackRepository;
import kd.hr.ham.business.domain.repository.dispatchrecord.DispatchRecordRepository;
import kd.hr.ham.business.domain.service.bill.IDispatchBackBillService;
import kd.hr.ham.business.domain.service.common.IDispabackPersonChangeService;
import kd.hr.ham.business.domain.service.impl.common.AbsCommonBusinessService;
import kd.hr.ham.business.domain.service.validator.DyObjValidateContext;
import kd.hr.ham.business.domain.service.validator.ValidateProducer;
import kd.hr.ham.business.domain.status.handler.DispBackStatusHandler;
import kd.hr.ham.business.domain.status.util.StatusHandleUtils;
import kd.hr.ham.business.domain.vid.UpdateVidDto;
import kd.hr.ham.business.domain.vid.VidPropType;
import kd.hr.ham.business.domain.vid.service.UpdateHistoryVidService;
import kd.hr.ham.common.dispatch.constants.DispbackBillConstants;
import kd.hr.ham.common.dispatch.enums.DispatchBackStatusEnum;
import kd.hr.ham.common.dispatch.enums.PersonChangeOperateTypeEnum;
import kd.hr.ham.common.dispatch.utils.DispatchDateUtils;
import kd.hr.ham.common.dispatch.utils.DyObjOperateUtils;
import kd.hr.ham.common.dispatch.utils.HamResultUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class DispatchBackBillServiceImpl
extends AbsCommonBusinessService
implements IDispatchBackBillService,
DispbackBillConstants {
    private static final Log LOG = LogFactory.getLog(DispatchBackBillServiceImpl.class);
    private static final Map<VidPropType, List<String>> PROP_TYPE_LIST_HASH_MAP = Maps.newHashMapWithExpectedSize((int)VidPropType.values().length);
    private static final Map<String, String> RELATED_PROP_MAPPING = Maps.newHashMapWithExpectedSize((int)8);

    public DispatchBackBillServiceImpl() {
        this.init();
    }

    private void init() {
        this.setServiceHelper(DispatchBackRepository.getInstance());
    }

    @Override
    public Map<String, Object> terminate(DynamicObject dynamicObject, Object termReason) {
        return this.terminate(dynamicObject, termReason, null);
    }

    @Override
    public Map<String, Object> terminate(DynamicObject dynamicObject, Object termReason, Object laborRelStatus) {
        if (Objects.isNull(dynamicObject)) {
            return HamResultUtils.fail((Object)"dynamicObject is null");
        }
        this.doTerminate(dynamicObject, termReason, laborRelStatus);
        dynamicObject.set("terminateuser", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("terminatetime", (Object)DispatchDateUtils.now());
        this.serviceHelper.updateOne(dynamicObject);
        return HamResultUtils.success();
    }

    private void doTerminate(DynamicObject dynamicObject, Object termReason, Object laborRelStatus) {
        String backStatus = dynamicObject.getString("backstatus");
        if (!HRStringUtils.equals((String)backStatus, (String)DispatchBackStatusEnum.WAIT_SUBMIT.getCode())) {
            OperationServiceHelper.executeOperate((String)"wfdiscard", (String)"ham_dispback", (Object[])new Long[]{dynamicObject.getLong("id")}, (OperateOption)OperateOption.create());
            IDispabackPersonChangeService.getInstance().excutePersonChangeNotice(new DynamicObject[]{dynamicObject}, PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_TERMINATIO);
        }
        LOG.info("dispatchBack terminate billNo:{}", (Object)dynamicObject.getString("billno"));
        StatusHandleUtils.handle(new DispBackStatusHandler(), "discard_bill", dynamicObject);
        dynamicObject.set("terminatersn", termReason);
        dynamicObject.set("laborrelstatus", laborRelStatus);
        DyObjOperateUtils.updateModifyInfo((DynamicObject)dynamicObject);
    }

    @Override
    public Map<String, Object> terminateByPerson(Long personId, Object termReason, Date endDate, Long laborRelStatus) {
        DynamicObject dispatchRecord = DispatchRecordRepository.getInstance().queryCurrentValidOneByPerson(personId);
        if (Objects.isNull(dispatchRecord)) {
            return HamResultUtils.fail((Object)String.format("no valid record: \u3010%s\u3011", personId));
        }
        DynamicObject dispatchBack = DispatchBackRepository.getInstance().queryUsefulByRecordForQuit(dispatchRecord.getLong("id"));
        if (Objects.isNull(dispatchBack)) {
            return HamResultUtils.fail((Object)String.format("no useful back: \u3010%s\u3011", personId));
        }
        this.doTerminate(dispatchBack, termReason, laborRelStatus);
        dispatchBack.set("terminateuser", (Object)1L);
        dispatchBack.set("terminatetime", (Object)DispatchDateUtils.now());
        this.serviceHelper.updateOne(dispatchBack);
        return HamResultUtils.success();
    }

    @Override
    public DyObjValidateContext terminateValidate(DynamicObject dynamicObject) {
        DyObjValidateContext dyObjValidateContext = ValidateProducer.init(dynamicObject);
        String errorMsg = ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u662f\u201c\u6d3e\u8fd4\u5df2\u63d0\u4ea4\u201d\u3001\u201c\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u3001\u201c\u6d3e\u8fd4\u5ba1\u6279\u4e2d\u201d\u624d\u80fd\u7ec8\u6b62\u3002", (String)"DispatchBackBillServiceImpl_0", (String)"hr-ham-business", (Object[])new Object[0]);
        ValidateProducer.produce("backstatus", errorMsg, context -> {
            String status = context.getDynamicObject().getString("backstatus");
            return DispatchBackStatusEnum.isInProcess((String)status);
        }).test(dyObjValidateContext);
        return dyObjValidateContext;
    }

    @Override
    public void doValidDispatchBack(DynamicObject[] dynamicObjects) {
        LOG.info("doValidDispatchBack start ids: {}", Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        UpdateVidDto vidDto = new UpdateVidDto();
        vidDto.setDynamicObjectList(Arrays.asList(dynamicObjects)).setPropMapping(PROP_TYPE_LIST_HASH_MAP).setRelatedPropMapping(RELATED_PROP_MAPPING);
        UpdateHistoryVidService.getInstance().updateHistoryVid(vidDto);
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = DispatchDateUtils.now();
        ((Stream)Arrays.stream(dynamicObjects).parallel()).forEach(dy -> {
            dy.set("modifier", (Object)currUserId);
            dy.set("modifytime", (Object)now);
        });
        this.serviceHelper.update(dynamicObjects);
        LOG.info("doValidDispatchBack end");
    }

    @Override
    public DynamicObject queryOneDispatchBack(Long id) {
        return this.serviceHelper.queryOne((Object)id);
    }

    @Override
    public DynamicObject[] query(String properties, QFilter[] qFilter) {
        return this.serviceHelper.query(properties, qFilter);
    }

    @Override
    public DynamicObject queryOnGoingByErManFile(Long erManFileId) {
        return DispatchBackRepository.getInstance().queryOnGoingByErManFile(erManFileId);
    }

    @Override
    public Map<String, Object> buildBackAreaParam(Map<String, Object> cardFields) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)16);
        params.put("countryback", cardFields.get("location_country_id"));
        params.put("companyback", cardFields.get("company_id"));
        params.put("deptback", cardFields.get("adminorg_id"));
        params.put("positionback", cardFields.get("position_id"));
        params.put("poststandardback", cardFields.get("stdposition_id"));
        params.put("orgback", cardFields.get("org_id"));
        params.put("adminorgback", cardFields.get("affiliateadminorg_id"));
        params.put("empgroupback", cardFields.get("empgroup_id"));
        params.put("cmpempback", cardFields.get("managingscope_id"));
        params.put("person", cardFields.get("person_id"));
        params.put("laborrelstatus", cardFields.get("laborrelstatus_id"));
        params.put("pospatternback", cardFields.get("apositiontype"));
        params.put("jobback", cardFields.get("job_id"));
        return params;
    }

    @Override
    public Map<String, Object> buildRecordAreaParam(DynamicObject recordObj) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)16);
        params.put("countryin", recordObj.get("countryin"));
        params.put("companyin", recordObj.get("companyin"));
        params.put("deptin", recordObj.get("deptin"));
        params.put("positionin", recordObj.get("positionin"));
        params.put("poststandardin", recordObj.get("standardposin"));
        params.put("orgin", recordObj.get("orgin"));
        params.put("adminorgin", recordObj.get("adminorgin"));
        params.put("empgroupin", recordObj.get("empgroupin"));
        params.put("cmpempin", recordObj.get("cmpempin"));
        params.put("startdate", recordObj.get("startdate"));
        params.put("enddate", recordObj.get("planenddate"));
        params.put("duration", recordObj.get("planduration"));
        params.put("baselocationin", recordObj.get("baselocationin"));
        params.put("reachdate", recordObj.get("reachdate"));
        params.put("pospatternin", recordObj.get("pospatternin"));
        params.put("jobin", recordObj.get("jobin"));
        return params;
    }

    static {
        PROP_TYPE_LIST_HASH_MAP.put(VidPropType.ADMIN_ORG, Arrays.asList("companyback", "deptback", "companyin", "deptin", "adminorgin", "adminorgback"));
        PROP_TYPE_LIST_HASH_MAP.put(VidPropType.ADMIN_ORG_STRUCT, Arrays.asList("deptlongnumbackvid", "orglongnuminvid", "adminorglongnumbackvid"));
        PROP_TYPE_LIST_HASH_MAP.put(VidPropType.POSITION, Arrays.asList("positionback", "positionin"));
        PROP_TYPE_LIST_HASH_MAP.put(VidPropType.STAND_POSITION, Arrays.asList("poststandardback", "poststandardin"));
        RELATED_PROP_MAPPING.put("deptback", "deptlongnumbackvid");
        RELATED_PROP_MAPPING.put("adminorgin", "orglongnuminvid");
        RELATED_PROP_MAPPING.put("adminorgback", "adminorglongnumbackvid");
    }
}

