/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.service.impl.bill;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.ham.business.domain.repository.dispatchrecord.DispatchRecordRepository;
import kd.hr.ham.business.domain.service.bill.IDispatchBackValidatorService;
import kd.hr.ham.business.domain.service.common.IDispabackPersonChangeService;
import kd.hr.ham.business.domain.service.validator.DyObjValidateContext;
import kd.hr.ham.business.domain.service.validator.ValidateContext;
import kd.hr.ham.business.domain.service.validator.ValidateProducer;
import kd.hr.ham.business.domain.status.dto.CrossValidateMsg;
import kd.hr.ham.business.domain.status.dto.CrossValidateParamDto;
import kd.hr.ham.business.domain.status.dto.CrossValidateResDto;
import kd.hr.ham.common.dispatch.enums.DispatchBackStatusEnum;
import kd.hr.ham.common.dispatch.enums.record.DispatchRecordStatusEnum;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;

public class DispatchBackValidatorServiceImp
implements IDispatchBackValidatorService {
    @Override
    public List<DyObjValidateContext> batchSubmitValidate(List<DynamicObject> dynamicObjects, String billFormId) {
        List<DyObjValidateContext> dyObjValidateContexts = ValidateProducer.init(dynamicObjects);
        List ids = dynamicObjects.stream().map(temp -> (Long)temp.get("id")).collect(Collectors.toList());
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"presubmit", (String)billFormId, (Object[])ids.toArray(), (OperateOption)OperateOption.create());
        List allErrorOrValidateInfo = opResult.getAllErrorOrValidateInfo();
        if (!CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
            this.buildData(dynamicObjects, dyObjValidateContexts, allErrorOrValidateInfo);
        }
        dyObjValidateContexts.forEach(dyObjValidateContext -> {
            String statusErrorMsg = ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u662f\u201c\u5f85\u63d0\u4ea4\u201d\u3001\u201c\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u624d\u80fd\u63d0\u4ea4\u3002", (String)"DispatchBackValidatorServiceImp_3", (String)"hr-ham-common", (Object[])new Object[0]);
            Predicate<DyObjValidateContext> statusPredicate = ValidateProducer.produce("billstatus", statusErrorMsg, dynamicObjValidateContext -> {
                DynamicObject dynamicObject = dynamicObjValidateContext.getDynamicObject();
                String backStatus = dynamicObject.getString("backstatus");
                return HRStringUtils.equals((String)backStatus, (String)DispatchBackStatusEnum.WAIT_SUBMIT.getCode()) || HRStringUtils.equals((String)backStatus, (String)DispatchBackStatusEnum.WAIT_RESUBMIT.getCode());
            });
            DynamicObject bill = dyObjValidateContext.getDynamicObject();
            DynamicObject dispatchErmanFile = bill.getDynamicObject("ermanfile");
            DynamicObject recordObj = bill.getDynamicObject("dispatchrecord");
            String recordTip = ResManager.loadKDString((String)"\u6240\u9009\u4eba\u5458\u201c{0}\u201d\u7684\u5916\u6d3e\u6863\u6848\u4e3a\u5df2\u5931\u6548\uff0c\u4e0d\u53ef\u53d1\u8d77\u6d3e\u8fd4\u3002", (String)"DispatchBackFormPlugin_3", (String)"hr-ham-formplugin", (Object[])new Object[0]);
            String recordError = MessageFormat.format(recordTip, dispatchErmanFile.getString("name"));
            Predicate<DyObjValidateContext> recordPredicate = ValidateProducer.produce("dispatchrecord", recordError, dynamicObjValidateContext -> {
                String recordStatus = recordObj.getString("dispstatus");
                return !DispatchRecordStatusEnum.INVALID.getCode().equals(recordStatus);
            });
            String termTaskStatusMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6863\u6848\u5b58\u5728\u201c\u5f85\u751f\u6548\u201d\u7684\u7ec8\u6b62\u4efb\u52a1\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"DispatchRecordServiceImpl_6", (String)"hr-ham-business", (Object[])new Object[0]);
            Predicate<DyObjValidateContext> termTaskStatusPredicate = ValidateProducer.produce("dispatchrecord", termTaskStatusMsg, dynamicObjValidateContext -> {
                boolean result = DispatchRecordRepository.getInstance().hasTempRecord(recordObj.getLong("boid"));
                return !result;
            });
            statusPredicate.and(recordPredicate).and(termTaskStatusPredicate).test((DyObjValidateContext)dyObjValidateContext);
        });
        IDispabackPersonChangeService service = IDispabackPersonChangeService.getInstance();
        ArrayList crossValidateParams = Lists.newArrayListWithExpectedSize((int)dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            CrossValidateParamDto crossValidateParamByRecordObj = service.getCrossValidateParamByRecordObj(dynamicObject.getDynamicObject("ermanfile"));
            crossValidateParamByRecordObj.setBillId(dynamicObject.getLong("id"));
            crossValidateParams.add(crossValidateParamByRecordObj);
        }
        Map<Long, CrossValidateResDto> map = service.excutePersonOverlapCheckByParams(crossValidateParams);
        dyObjValidateContexts.forEach(dyObjValidateContext -> {
            Long id = dyObjValidateContext.getDynamicObject().getLong("id");
            CrossValidateResDto crossValidateResDto = (CrossValidateResDto)map.get(id);
            if (!HRObjectUtils.isEmpty((Object)crossValidateResDto)) {
                List<CrossValidateMsg> messages = crossValidateResDto.getMsgs();
                int i = 0;
                for (CrossValidateMsg msg : messages) {
                    if (!"error".equals(msg.getMsgType())) continue;
                    ValidateContext validatorContext = dyObjValidateContext.getValidatorContext();
                    Map<String, String> validateResult = validatorContext.getValidateResult();
                    validateResult.put("person" + i, msg.getMsgInfo());
                    ++i;
                }
            }
        });
        return dyObjValidateContexts;
    }

    @Override
    public List<DyObjValidateContext> batchUnSubmitValidate(List<DynamicObject> dynamicObjects, String billFormId) {
        List<DyObjValidateContext> dyObjValidateContexts = ValidateProducer.init(dynamicObjects);
        List ids = dynamicObjects.stream().map(temp -> (Long)temp.get("id")).collect(Collectors.toList());
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"preunsubmit", (String)billFormId, (Object[])ids.toArray(), (OperateOption)OperateOption.create());
        List allErrorOrValidateInfo = opResult.getAllErrorOrValidateInfo();
        if (!CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
            this.buildData(dynamicObjects, dyObjValidateContexts, allErrorOrValidateInfo);
        }
        dyObjValidateContexts.forEach(dyObjValidateContext -> {
            String errorMsg = ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u662f\u201c\u6d3e\u8fd4\u5df2\u63d0\u4ea4\u201d\u624d\u80fd\u64a4\u9500\u3002", (String)"DispatchBackValidatorServiceImp_0", (String)"hr-ham-common", (Object[])new Object[0]);
            Predicate<DyObjValidateContext> predicate = ValidateProducer.produce("billstatus", errorMsg, dynamicObjValidateContext -> {
                DynamicObject dynamicObject = dynamicObjValidateContext.getDynamicObject();
                String backStatus = dynamicObject.getString("backstatus");
                return HRStringUtils.equals((String)backStatus, (String)DispatchBackStatusEnum.ALR_SUBMIT.getCode());
            });
            predicate.test((DyObjValidateContext)dyObjValidateContext);
        });
        return dyObjValidateContexts;
    }

    @Override
    public List<DyObjValidateContext> batchDeleteValidate(List<DynamicObject> dynamicObjects, String billFormId) {
        List<DyObjValidateContext> dyObjValidateContexts = ValidateProducer.init(dynamicObjects);
        List ids = dynamicObjects.stream().map(temp -> (Long)temp.get("id")).collect(Collectors.toList());
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"predelete", (String)billFormId, (Object[])ids.toArray(), (OperateOption)OperateOption.create());
        List allErrorOrValidateInfo = opResult.getAllErrorOrValidateInfo();
        if (!CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
            this.buildData(dynamicObjects, dyObjValidateContexts, allErrorOrValidateInfo);
        }
        dyObjValidateContexts.forEach(dyObjValidateContext -> {
            String errorMsg = ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u662f\u201c\u5f85\u63d0\u4ea4\u201d\u624d\u80fd\u5220\u9664\u3002", (String)"DispatchBackValidatorServiceImp_1", (String)"hr-ham-common", (Object[])new Object[0]);
            Predicate<DyObjValidateContext> predicate = ValidateProducer.produce("billstatus", errorMsg, dynamicObjValidateContext -> {
                DynamicObject dynamicObject = dynamicObjValidateContext.getDynamicObject();
                String backStatus = dynamicObject.getString("backstatus");
                return HRStringUtils.equals((String)backStatus, (String)DispatchBackStatusEnum.WAIT_SUBMIT.getCode());
            });
            predicate.test((DyObjValidateContext)dyObjValidateContext);
        });
        return dyObjValidateContexts;
    }

    @Override
    public DyObjValidateContext editValidate(DynamicObject bill) {
        List<DyObjValidateContext> dyObjValidateContexts = ValidateProducer.init(Lists.newArrayList((Object[])new DynamicObject[]{bill}));
        dyObjValidateContexts.forEach(dyObjValidateContext -> {
            String errorMsg = ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u662f\u201c\u5f85\u63d0\u4ea4\u201d\u3001\u201c\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u624d\u80fd\u4fee\u6539\u3002", (String)"DispatchBackValidatorServiceImp_2", (String)"hr-ham-common", (Object[])new Object[0]);
            Predicate<DyObjValidateContext> predicate = ValidateProducer.produce("billstatus", errorMsg, dynamicObjValidateContext -> {
                DynamicObject dynamicObject = dynamicObjValidateContext.getDynamicObject();
                String backStatus = dynamicObject.getString("backstatus");
                return HRStringUtils.equals((String)backStatus, (String)DispatchBackStatusEnum.WAIT_SUBMIT.getCode()) || HRStringUtils.equals((String)backStatus, (String)DispatchBackStatusEnum.WAIT_RESUBMIT.getCode());
            });
            predicate.test((DyObjValidateContext)dyObjValidateContext);
        });
        return dyObjValidateContexts.get(0);
    }

    @Override
    public DyObjValidateContext saveValidate(DynamicObject bill) {
        List<DyObjValidateContext> dyObjValidateContexts = ValidateProducer.init(Lists.newArrayList((Object[])new DynamicObject[]{bill}));
        dyObjValidateContexts.forEach(dyObjValidateContext -> {
            String errorMsg = ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u662f\u201c\u5f85\u63d0\u4ea4\u201d\u3001\u201c\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u624d\u80fd\u4fdd\u5b58\u3002", (String)"DispatchBackValidatorServiceImp_4", (String)"hr-ham-common", (Object[])new Object[0]);
            Predicate<DyObjValidateContext> predicate = ValidateProducer.produce("billstatus", errorMsg, dynamicObjValidateContext -> {
                DynamicObject dynamicObject = dynamicObjValidateContext.getDynamicObject();
                String backStatus = dynamicObject.getString("backstatus");
                return HRStringUtils.equals((String)backStatus, (String)DispatchBackStatusEnum.WAIT_SUBMIT.getCode()) || HRStringUtils.equals((String)backStatus, (String)DispatchBackStatusEnum.WAIT_RESUBMIT.getCode());
            });
            predicate.test((DyObjValidateContext)dyObjValidateContext);
        });
        return dyObjValidateContexts.get(0);
    }

    private void buildData(List<DynamicObject> dynamicObjects, List<DyObjValidateContext> dyObjValidateContexts, List<IOperateInfo> allErrorOrValidateInfo) {
        HashMap failId2ErrorMsg = Maps.newHashMapWithExpectedSize((int)dynamicObjects.size());
        allErrorOrValidateInfo.stream().forEach(iOperateInfo -> failId2ErrorMsg.put(iOperateInfo.getPkValue().toString(), iOperateInfo.getMessage()));
        dyObjValidateContexts.forEach(dyObjValidateContext -> {
            if (failId2ErrorMsg.containsKey(dyObjValidateContext.getDynamicObject().getString("id"))) {
                ValidateContext validatorContext = dyObjValidateContext.getValidatorContext();
                Map<String, String> validateResult = validatorContext.getValidateResult();
                validateResult.put("id", (String)failId2ErrorMsg.get(dyObjValidateContext.getDynamicObject().getString("id")));
            }
        });
    }
}

