/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.service.impl.bill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.ham.business.domain.repository.DispatchRepository;
import kd.hr.ham.business.domain.repository.bill.DispatchBillRepository;
import kd.hr.ham.business.domain.service.ServiceFactory;
import kd.hr.ham.business.domain.service.bill.IDispatchBillService;
import kd.hr.ham.business.domain.service.common.IDispatchHBPMService;
import kd.hr.ham.business.domain.service.common.IDispatchHRPIService;
import kd.hr.ham.business.domain.service.common.IDispatchPersonChangeService;
import kd.hr.ham.business.domain.service.common.IPersonAboutService;
import kd.hr.ham.business.domain.service.impl.common.AbsCommonBusinessService;
import kd.hr.ham.business.domain.service.record.DispatchRecordService;
import kd.hr.ham.business.domain.status.dto.CrossValidateMsg;
import kd.hr.ham.business.domain.status.dto.CrossValidateParamDto;
import kd.hr.ham.business.domain.status.dto.CrossValidateResDto;
import kd.hr.ham.business.domain.status.handler.DispatchBillStatusHandler;
import kd.hr.ham.business.domain.status.util.StatusHandleUtils;
import kd.hr.ham.business.domain.vid.UpdateVidDto;
import kd.hr.ham.business.domain.vid.VidPropType;
import kd.hr.ham.business.domain.vid.service.UpdateHistoryVidService;
import kd.hr.ham.business.util.DirectLeaderHelper;
import kd.hr.ham.common.dispatch.bean.PosPatternConfig;
import kd.hr.ham.common.dispatch.bean.PosPatternConfigBean;
import kd.hr.ham.common.dispatch.constants.DispatchBillConstants;
import kd.hr.ham.common.dispatch.enums.DispatchAuditStatusEnum;
import kd.hr.ham.common.dispatch.enums.DispatchInStatusEnum;
import kd.hr.ham.common.dispatch.enums.DispatchOrderEnum;
import kd.hr.ham.common.dispatch.enums.DispatchOutStatusEnum;
import kd.hr.ham.common.dispatch.enums.DispatchPageTypeEnum;
import kd.hr.ham.common.dispatch.enums.DispatchStatusEnum;
import kd.hr.ham.common.dispatch.enums.PersonChangeOperateTypeEnum;
import kd.hr.ham.common.dispatch.utils.CollUtils;
import kd.hr.ham.common.dispatch.utils.DispatchDateUtils;
import kd.hr.ham.common.dispatch.utils.ObjectUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DispatchBillServiceImpl
extends AbsCommonBusinessService
implements IDispatchBillService,
DispatchBillConstants {
    private static final Log log = LogFactory.getLog(DispatchBillServiceImpl.class);
    private static final Map<VidPropType, List<String>> PROP_TYPE_LIST_HASH_MAP = Maps.newHashMapWithExpectedSize((int)VidPropType.values().length);
    private static final Map<String, String> RELATED_PROP_MAPPING = Maps.newHashMapWithExpectedSize((int)8);
    public BiFunction<DynamicObject, String, Boolean> directPosValidateFun = (bill, type) -> {
        boolean equal;
        PosPatternConfigBean outConfig = (PosPatternConfigBean)PosPatternConfig.CONFIG.get("1");
        PosPatternConfigBean inConfig = (PosPatternConfigBean)PosPatternConfig.CONFIG.get(type);
        String patternKey = inConfig.getPatternKey();
        String posPattern = bill.getString(patternKey);
        if ("2".equals(posPattern)) {
            List<String> compareKeys = Arrays.asList(outConfig.getJobKey(), inConfig.getJobKey(), outConfig.getDeptKey(), inConfig.getDeptKey());
            equal = this.compareEqual((DynamicObject)bill, compareKeys);
        } else if ("0".equals(posPattern)) {
            List<String> compareKeys = Arrays.asList(outConfig.getStdPosKey(), inConfig.getStdPosKey(), outConfig.getDeptKey(), inConfig.getDeptKey());
            equal = this.compareEqual((DynamicObject)bill, compareKeys);
        } else {
            List<String> compareKeys = Arrays.asList(outConfig.getPosKey(), inConfig.getPosKey());
            equal = this.compareEqual((DynamicObject)bill, compareKeys);
        }
        return equal;
    };

    public DispatchBillServiceImpl() {
        this.init();
    }

    private void init() {
        this.setServiceHelper(DispatchBillRepository.getInstance());
    }

    @Override
    public void setServiceHelper(HRBaseServiceHelper serviceHelper) {
        super.setServiceHelper(serviceHelper);
    }

    @Override
    public void batchCommitDispatchApply(DynamicObject[] dispatchApplyDys) {
        log.info("start_batch_commit_apply");
        for (DynamicObject dispatchApplyDy : dispatchApplyDys) {
            this.updateDispatchStatus(dispatchApplyDy);
        }
        try {
            IDispatchPersonChangeService dispatchPersonChangeService = ServiceFactory.getService(IDispatchPersonChangeService.class);
            dispatchPersonChangeService.excutePersonChangeNotice(dispatchApplyDys, PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_CREATE, true);
        }
        catch (Exception exception) {
            log.error("Dispatch-> excutePersonChange error:", (Throwable)exception);
        }
        DispatchRepository.getInstance().update(dispatchApplyDys);
        log.info("end_batch_commit_apply");
    }

    private void updateDispatchStatus(DynamicObject dyObj) {
        String outStatus = dyObj.getString("outstatus");
        String inStatus = dyObj.getString("instatus");
        log.info("start_update_apply_status");
        if (HRStringUtils.isEmpty((String)inStatus)) {
            log.info("start_update_apply_status_order1_out");
            StatusHandleUtils.handle(new DispatchBillStatusHandler(), "out_fir_out_submit", dyObj);
            dyObj.set("issubmit", (Object)"1");
        } else if (HRStringUtils.isEmpty((String)outStatus)) {
            log.info("start_update_apply_status_order2_in");
            StatusHandleUtils.handle(new DispatchBillStatusHandler(), "in_fir_in_submit", dyObj);
            dyObj.set("issubmit", (Object)"1");
        } else if (HRStringUtils.equals((String)DispatchInStatusEnum.WAITSUBMIT_DISPATCHIN.getCode(), (String)inStatus) || HRStringUtils.equals((String)DispatchInStatusEnum.WAITRESUBMIT_DISPATCHIN.getCode(), (String)inStatus)) {
            log.info("start_update_apply_status_order1_in");
            StatusHandleUtils.handle(new DispatchBillStatusHandler(), "out_fir_in_submit", dyObj);
            dyObj.set("auditstatus", (Object)"D");
        } else if (HRStringUtils.equals((String)DispatchOutStatusEnum.WAITSUBMIT_DISPATCHOUT.getCode(), (String)outStatus) || HRStringUtils.equals((String)DispatchOutStatusEnum.WAITRESUBMIT_DISPATCHOUT.getCode(), (String)outStatus)) {
            log.info("start_update_apply_status_order2_out");
            StatusHandleUtils.handle(new DispatchBillStatusHandler(), "in_fir_out_submit", dyObj);
            dyObj.set("auditstatus", (Object)"D");
        } else {
            log.info("start_update_apply_status_do_nothing");
        }
    }

    @Override
    public Map<DynamicObject, List<String>> batchSubmitValidate(DynamicObject[] bills, DispatchPageTypeEnum dispatchPageType, String opKey, boolean addNew, boolean isFromPage) {
        Object[] valIds = Arrays.stream(bills).map(obj -> obj.getLong("id")).filter(id -> id != 0L).toArray();
        Map<DynamicObject, List<String>> validateInfo = this.getValidateInfo(bills, dispatchPageType, opKey, addNew);
        if (!isFromPage) {
            Map<Long, List<String>> preValidateRes = this.preSubmitValidate(dispatchPageType, isFromPage, valIds);
            this.addResultToPreSubmitInfo(preValidateRes, validateInfo);
        }
        if (HRStringUtils.equals((String)opKey, (String)"modify")) {
            return validateInfo;
        }
        ArrayList crossParamList = Lists.newArrayListWithExpectedSize((int)bills.length);
        for (Map.Entry<DynamicObject, List<String>> entry : validateInfo.entrySet()) {
            DynamicObject bill = entry.getKey();
            boolean isPlan = this.getPlanDispatch(bill, dispatchPageType);
            CrossValidateParamDto crossDto = isPlan ? IPersonAboutService.getInstance().getCrossValidateParamByCardFields(bill, "2") : IPersonAboutService.getInstance().getCrossValidateParamByCardFields(bill, "3");
            crossParamList.add(crossDto);
        }
        Map<Long, CrossValidateResDto> crossResList = IDispatchPersonChangeService.getInstance().excutePersonOverlapCheckByParams(crossParamList);
        for (Map.Entry<DynamicObject, List<String>> entry : validateInfo.entrySet()) {
            DynamicObject bill = entry.getKey();
            long pk = bill.getLong("id");
            List<String> validateList = entry.getValue();
            CrossValidateResDto crossResDto = crossResList.get(pk);
            if (HRObjectUtils.isEmpty((Object)crossResDto)) continue;
            List<CrossValidateMsg> messages = crossResDto.getMsgs();
            for (CrossValidateMsg msg : messages) {
                if (!"error".equals(msg.getMsgType())) continue;
                validateList.add(msg.getMsgInfo());
            }
        }
        this.directValidate(bills, dispatchPageType, validateInfo);
        return validateInfo;
    }

    @Override
    public void addResultToPreSubmitInfo(Map<Long, List<String>> operateResInfo, Map<DynamicObject, List<String>> preSubmitValidateInfo) {
        for (Map.Entry<DynamicObject, List<String>> entry : preSubmitValidateInfo.entrySet()) {
            long pk = entry.getKey().getLong("id");
            List<String> validateList = entry.getValue();
            List preValidate = Optional.ofNullable(operateResInfo.get(pk)).orElseGet(Collections::emptyList);
            validateList.addAll(0, preValidate);
        }
    }

    private Map<Long, List<String>> preSubmitValidate(DispatchPageTypeEnum dispatchPageType, boolean isFromPage, Object[] valIds) {
        if (!HRArrayUtils.isEmpty((Object[])valIds)) {
            log.info("DispatchBillServiceImpl.batchSubmitValidate_preSubmitValidateBegin");
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("id", dispatchPageType.getPageKey());
            OperationResult preOpResult = OperationServiceHelper.executeOperate((String)"presubmit", (String)dispatchPageType.getPageKey(), (Object[])valIds, (OperateOption)operateOption);
            preOpResult.setShowMessage(false);
            return this.getOperateResInfo(preOpResult, dispatchPageType, isFromPage);
        }
        log.info("DispatchBillServiceImpl.batchSubmitValidate_preSubmitValidateEnd_idsNull");
        return Collections.emptyMap();
    }

    @Override
    public Map<Long, List<String>> getOperateResInfo(OperationResult opResult, DispatchPageTypeEnum dispatchPageType, boolean isFromPage) {
        List allInfo = opResult.getAllErrorOrValidateInfo();
        HashMap preValidateRes = Maps.newHashMapWithExpectedSize((int)allInfo.size());
        for (IOperateInfo info : allInfo) {
            Long id = (Long)info.getPkValue();
            String msg = info.getMessage();
            log.info("preSubmitValidateBegin_info:{}_id:{}", (Object)info, (Object)id);
            if (DispatchPageTypeEnum.DISPATCH_IN == dispatchPageType && isFromPage && ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5e38\u9a7b\u5de5\u4f5c\u5730\u201d\u3002", (String)"DispatchApplySubmitValidator_0", (String)"hr-ham-opplugin", (Object[])new Object[0]).equals(msg)) continue;
            if (msg.equals(ResManager.loadKDString((String)"\u5728\u9700\u8981\u6307\u5b9a\u4e0b\u4e00\u6b65\u53c2\u4e0e\u4eba\u7684\u60c5\u51b5\u4e0b\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"DispatchBillServiceImpl_1", (String)"hr-ham-business", (Object[])new Object[0]))) {
                Map billNos = opResult.getBillNos();
                if (ObjectUtils.isEmpty((Object)billNos)) continue;
                for (Object pkId : billNos.keySet()) {
                    preValidateRes.put(Long.valueOf(pkId.toString()), Lists.newArrayList((Object[])new String[]{msg}));
                }
                continue;
            }
            List strings = (List)preValidateRes.get(id);
            if (CollUtils.isEmpty((Collection)strings)) {
                preValidateRes.put(id, Lists.newArrayList((Object[])new String[]{msg}));
                continue;
            }
            strings.add(msg);
        }
        return preValidateRes;
    }

    private void directValidate(DynamicObject[] bills, DispatchPageTypeEnum dispatchPageType, Map<DynamicObject, List<String>> validateInfo) {
        Map<String, Pair<DynamicObject, Boolean>> directorValidate = this.validateDispatchAsDirector(bills, dispatchPageType);
        for (Map.Entry<DynamicObject, List<String>> entry : validateInfo.entrySet()) {
            DynamicObject bill = entry.getKey();
            List<String> validateMessages = entry.getValue();
            String billNo = bill.getString("billno");
            Pair<DynamicObject, Boolean> directValidate = directorValidate.get(billNo);
            if (!((Boolean)directValidate.getValue()).booleanValue()) continue;
            String personName = bill.getString("person.name");
            String tipTxt = this.getDirectorTip(dispatchPageType, bill);
            validateMessages.add(MessageFormat.format(tipTxt, personName));
        }
    }

    @Override
    public String getDirectorTip(DispatchPageTypeEnum dispatchPageType, DynamicObject obj) {
        boolean isPlan = this.getPlanDispatch(obj, dispatchPageType);
        String planInTip = ResManager.loadKDString((String)"\u6240\u9009\u4eba\u5458\u201c{0}\u201d\u62df\u6d3e\u5165\u4efb\u5c97\u4e0e\u4e3b\u4efb\u804c\u4efb\u5c97\u4e00\u81f4\uff0c\u4e0d\u53ef\u53d1\u8d77\u5916\u6d3e\u3002", (String)"DispatchBillListCommon_8", (String)"hr-ham-business", (Object[])new Object[0]);
        String inTip = ResManager.loadKDString((String)"\u6240\u9009\u4eba\u5458\u201c{0}\u201d\u6d3e\u5165\u4efb\u5c97\u4e0e\u4e3b\u4efb\u804c\u4efb\u5c97\u4e00\u81f4\uff0c\u4e0d\u53ef\u53d1\u8d77\u5916\u6d3e\u3002", (String)"DispatchBillListCommon_9", (String)"hr-ham-business", (Object[])new Object[0]);
        String tip = isPlan ? planInTip : inTip;
        return tip;
    }

    @Override
    public Map<Long, Pair<DynamicObject, Boolean>> validateDispatchFileStatus(DynamicObject[] dispatchObjs) {
        HashMap res = Maps.newHashMapWithExpectedSize((int)dispatchObjs.length);
        List<Long> depempIds = Arrays.stream(dispatchObjs).map(obj -> {
            DynamicObject ermanFile = obj.getDynamicObject("ermanfile");
            return ermanFile.getLong("depemp.id");
        }).collect(Collectors.toList());
        log.info("validateDispatchFileStatus_depEmpIds:{}", depempIds);
        Object[] recordObjs = DispatchRecordService.getInstance().getRecordByDispatchIds(depempIds);
        log.info("record_status_recordObjs:{}", (Object)Arrays.toString(recordObjs));
        Map<Long, List<DynamicObject>> recordDepEmpGroupFile = Arrays.stream(recordObjs).collect(Collectors.groupingBy(obj -> obj.getLong("depemp.id")));
        for (DynamicObject dispatchObj : dispatchObjs) {
            long ermanFileId = dispatchObj.getLong("ermanfile.id");
            long depEmpId = dispatchObj.getDynamicObject("ermanfile").getLong("depemp.id");
            List<DynamicObject> ermanFileList = recordDepEmpGroupFile.get(depEmpId);
            if (!CollUtils.isNotEmpty(ermanFileList)) continue;
            res.put(ermanFileId, Pair.of((Object)dispatchObj, (Object)Boolean.TRUE));
        }
        log.info("record_status_resIds:{}", res.keySet());
        return res;
    }

    @Override
    public Map<Long, Pair<DynamicObject, String>> validateDispatchInTransit(DynamicObject[] dynObjs, String opKey, boolean addNew) {
        HashMap res = Maps.newHashMapWithExpectedSize((int)dynObjs.length);
        Object[] ids = Arrays.stream(dynObjs).map(obj -> obj.getLong("ermanfile.id")).toArray();
        DynamicObject[] dispatchObjs = DispatchBillRepository.getInstance().query("dispatchstatus,ermanfile,billno", new QFilter[]{new QFilter("ermanfile.id", "in", (Object)ids), new QFilter("dispatchstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{DispatchStatusEnum.WAIT_DISPATCH.getCode(), DispatchStatusEnum.WAITEFFECT_DISPATCH.getCode(), DispatchStatusEnum.APPROVING_DISPATCH.getCode()}))});
        Map<Long, List<DynamicObject>> ermanfileMap = Arrays.stream(dispatchObjs).collect(Collectors.groupingBy(obj -> obj.getLong("ermanfile.id")));
        for (DynamicObject dispatchObj : dynObjs) {
            String validateBillNo = dispatchObj.getString("billno");
            long ermanfileId = dispatchObj.getLong("ermanfile.id");
            List<DynamicObject> transitBill = ermanfileMap.get(ermanfileId);
            if (CollUtils.isEmpty(transitBill)) continue;
            Iterator<DynamicObject> iterator = transitBill.iterator();
            boolean existEffectDispatch = false;
            while (iterator.hasNext()) {
                DynamicObject cur = iterator.next();
                String dispatchStatus = cur.getString("dispatchstatus");
                if (!DispatchStatusEnum.WAITEFFECT_DISPATCH.getCode().equals(dispatchStatus)) continue;
                res.put(ermanfileId, Pair.of((Object)cur, (Object)transitBill.get(0).getString("billno")));
                existEffectDispatch = true;
            }
            if (existEffectDispatch) continue;
            if (CollUtils.isNotEmpty(transitBill) && addNew) {
                res.put(ermanfileId, Pair.of((Object)dispatchObj, (Object)transitBill.get(0).getString("billno")));
                continue;
            }
            List filterBill = Optional.ofNullable(transitBill).orElseGet(ArrayList::new).stream().filter(obj -> {
                String billNo = obj.getString("billno");
                return !HRStringUtils.equals((String)billNo, (String)validateBillNo);
            }).collect(Collectors.toList());
            if (filterBill.isEmpty()) continue;
            res.put(ermanfileId, Pair.of((Object)dispatchObj, (Object)((DynamicObject)filterBill.get(0)).getString("billno")));
        }
        return res;
    }

    @Override
    public Map<String, Pair<DynamicObject, Boolean>> validateDispatchAsDirector(DynamicObject[] dynObjs, DispatchPageTypeEnum dispatchPageType) {
        HashMap res = Maps.newHashMapWithExpectedSize((int)dynObjs.length);
        for (DynamicObject bill : dynObjs) {
            boolean isPlan = this.getPlanDispatch(bill, dispatchPageType);
            String type = isPlan ? "2" : "3";
            Boolean compareRes = this.directPosValidateFun.apply(bill, type);
            res.put(bill.getString("billno"), Pair.of((Object)bill, (Object)compareRes));
        }
        return res;
    }

    private boolean compareEqual(DynamicObject obj, List<String> compareKeys) {
        for (int i = 0; i < compareKeys.size(); i += 2) {
            long left = obj.getLong(compareKeys.get(i) + ".id");
            long right = obj.getLong(compareKeys.get(i + 1) + ".id");
            if (right != 0L && left == right) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean validateDispatchAsDirector(DynamicObject dynObjs, DispatchPageTypeEnum dispatchPageType) {
        Map<String, Pair<DynamicObject, Boolean>> validateRes = this.validateDispatchAsDirector(new DynamicObject[]{dynObjs}, dispatchPageType);
        return (Boolean)validateRes.get(dynObjs.getString("billno")).getValue();
    }

    public boolean getPlanDispatch(DynamicObject dynObj, DispatchPageTypeEnum dispatchPageType) {
        if (dispatchPageType == DispatchPageTypeEnum.DISPATCH_OUT) {
            String order = dynObj.getString("disoutinorder");
            return "1".equals(order);
        }
        return false;
    }

    @Override
    public Map<DynamicObject, List<String>> getValidateInfo(DynamicObject[] dynObjs, DispatchPageTypeEnum dispatchPageType, String opKey, boolean addNew) {
        Map<Long, Pair<DynamicObject, Boolean>> ermanFileStatus = this.validateDispatchFileStatus(dynObjs);
        Map<Long, Pair<DynamicObject, String>> dispatchProcess = this.validateDispatchInTransit(dynObjs, opKey, addNew);
        HashMap res = Maps.newHashMapWithExpectedSize((int)dynObjs.length);
        String statusStr = ResManager.loadKDString((String)"\u6240\u9009\u4eba\u5458\u201c{0}\u201d\u5df2\u5728\u5916\u6d3e\u4e2d\uff0c\u4e0d\u53ef\u53d1\u8d77\u5916\u6d3e\u3002", (String)"DispatchBillServiceImpl_3", (String)"hr-ham-business", (Object[])new Object[0]);
        String transit = ResManager.loadKDString((String)"\u6240\u9009\u4eba\u5458\u201c{0}\u201d\u5df2\u7ecf\u5b58\u5728\u4e8e\u5916\u6d3e\u5355\uff08{1}\uff09\u4e2d\uff0c\u4e0d\u53ef\u53d1\u8d77\u5916\u6d3e\u3002", (String)"DispatchBillServiceImpl_4", (String)"hr-ham-business", (Object[])new Object[0]);
        for (DynamicObject dynObj : dynObjs) {
            Pair<DynamicObject, String> dispatchProcessRes;
            Pair<DynamicObject, Boolean> statusRes;
            LinkedList validateErrorInfo = Lists.newLinkedList();
            String ermanFileName = dynObj.getString("ermanfile.name");
            long ermanFileId = dynObj.getLong("ermanfile.id");
            String dispatchStatusTip = this.getStatusTip(dynObj, dispatchPageType, opKey);
            if (HRStringUtils.isNotEmpty((String)dispatchStatusTip)) {
                validateErrorInfo.add(dispatchStatusTip);
            }
            if (!Objects.isNull(statusRes = ermanFileStatus.get(ermanFileId)) && ((Boolean)statusRes.getValue()).booleanValue()) {
                validateErrorInfo.add(MessageFormat.format(statusStr, ermanFileName));
            }
            if (!HRObjectUtils.isEmpty(dispatchProcessRes = dispatchProcess.get(ermanFileId))) {
                String billNo = ((DynamicObject)dispatchProcessRes.getKey()).getString("billno");
                String dispatchStatus = ((DynamicObject)dispatchProcessRes.getKey()).getString("dispatchstatus");
                if (DispatchStatusEnum.WAITEFFECT_DISPATCH.getCode().equals(dispatchStatus)) {
                    validateErrorInfo.add(MessageFormat.format(statusStr, ermanFileName));
                } else if (HRStringUtils.equals((String)billNo, (String)dynObj.getString("billno"))) {
                    validateErrorInfo.add(MessageFormat.format(transit, ermanFileName, dispatchProcessRes.getValue()));
                }
            }
            res.put(dynObj, validateErrorInfo);
        }
        return res;
    }

    private String getStatusTip(DynamicObject dynObj, DispatchPageTypeEnum dispatchPageType, String opKey) {
        boolean modify = HRStringUtils.equals((String)"modify", (String)opKey);
        String statusTip = DispatchPageTypeEnum.DISPATCH_OUT == dispatchPageType ? this.getOutStatusTip(dynObj, modify, opKey) : this.getInStatusTip(dynObj, modify, opKey);
        return statusTip;
    }

    private String getOutStatusTip(DynamicObject dynObj, boolean modify, String opKey) {
        String outStatus = dynObj.getString("outstatus");
        if (!HRStringUtils.equals((String)outStatus, (String)DispatchOutStatusEnum.WAITSUBMIT_DISPATCHOUT.getCode()) && !HRStringUtils.equals((String)outStatus, (String)DispatchOutStatusEnum.WAITRESUBMIT_DISPATCHOUT.getCode())) {
            if (HRStringUtils.equals((String)"save", (String)opKey)) {
                return ResManager.loadKDString((String)"\u53ea\u80fd\u4fdd\u5b58\u5ba1\u6279\u72b6\u6001\u4e3a\u201c\u6d3e\u51fa\u5f85\u63d0\u4ea4\u201d\u201c\u6d3e\u51fa\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u7684\u5355\u636e\u3002", (String)"DispatchBillServiceImpl_17", (String)"hr-ham-business", (Object[])new Object[0]);
            }
            return !modify ? ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u662f\u201c\u5f85\u6d3e\u51fa\u90e8\u95e8\u63d0\u4ea4\u201d\u3001\u201c\u5f85\u6d3e\u51fa\u90e8\u95e8\u91cd\u65b0\u63d0\u4ea4\u201d\u624d\u80fd\u63d0\u4ea4\u3002", (String)"DispatchBillServiceImpl_0", (String)"hr-ham-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53ea\u80fd\u4fee\u6539\u5ba1\u6279\u72b6\u6001\u4e3a\u201c\u6d3e\u51fa\u5f85\u63d0\u4ea4\u201d\u201c\u6d3e\u51fa\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u7684\u5355\u636e\u3002", (String)"DispatchBillServiceImpl_15", (String)"hr-ham-business", (Object[])new Object[0]);
        }
        return null;
    }

    private String getInStatusTip(DynamicObject dynObj, boolean modify, String opKey) {
        String inStatus = dynObj.getString("instatus");
        if (!HRStringUtils.equals((String)inStatus, (String)DispatchInStatusEnum.WAITSUBMIT_DISPATCHIN.getCode()) && !HRStringUtils.equals((String)inStatus, (String)DispatchInStatusEnum.WAITRESUBMIT_DISPATCHIN.getCode())) {
            if (HRStringUtils.equals((String)"save", (String)opKey)) {
                return ResManager.loadKDString((String)"\u53ea\u80fd\u4fdd\u5b58\u5ba1\u6279\u72b6\u6001\u4e3a\u201c\u6d3e\u5165\u5f85\u63d0\u4ea4\u201d\u201c\u6d3e\u5165\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u7684\u5355\u636e\u3002", (String)"DispatchBillServiceImpl_18", (String)"hr-ham-business", (Object[])new Object[0]);
            }
            return !modify ? ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u662f\u201c\u5f85\u6d3e\u5165\u90e8\u95e8\u63d0\u4ea4\u201d\u3001\u201c\u5f85\u6d3e\u5165\u90e8\u95e8\u91cd\u65b0\u63d0\u4ea4\u201d\u624d\u80fd\u63d0\u4ea4\u3002", (String)"DispatchBillServiceImpl_5", (String)"hr-ham-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53ea\u80fd\u4fee\u6539\u5ba1\u6279\u72b6\u6001\u4e3a\u201c\u6d3e\u5165\u5f85\u63d0\u4ea4\u201d\u201c\u6d3e\u5165\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u7684\u5355\u636e\u3002", (String)"DispatchBillServiceImpl_16", (String)"hr-ham-business", (Object[])new Object[0]);
        }
        return null;
    }

    @Override
    public Pair<Boolean, String> validateDispatchLaborrel(DynamicObject obj) {
        boolean checkLaborrel = false;
        IDispatchHRPIService dispatchHRPIService = ServiceFactory.getService(IDispatchHRPIService.class);
        Map<String, Object> crossValidateRes = dispatchHRPIService.getEmployee(obj.getLong("employee.id"));
        String businessstatus = crossValidateRes.get("businessstatus").toString();
        String laborrelstatus_id = crossValidateRes.get("laborrelstatus_id").toString();
        String msg = null;
        if (businessstatus.equals("1") && laborrelstatus_id.equals("1010")) {
            checkLaborrel = true;
            msg = MessageFormat.format(ResManager.loadKDString((String)"\u6240\u9009\u4eba\u5458\u201c{0}\u201d\u4e3a\u8bd5\u7528\u671f\u5458\u5de5\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u53d1\u8d77\u5916\u6d3e\u3002", (String)"DispatchBillListCommon_10", (String)"hr-ham-business", (Object[])new Object[0]), obj.getString("name"));
        }
        return Pair.of((Object)checkLaborrel, msg);
    }

    @Override
    public List<Map<String, Object>> initCommitConfirmExportData(DynamicObject[] bills, Map<DynamicObject, List<String>> validateRes, String billFormId) {
        ArrayList exportDataList = Lists.newArrayListWithExpectedSize((int)bills.length);
        Map<Long, List> errLogForId = validateRes.entrySet().stream().collect(Collectors.toMap(set -> ((DynamicObject)set.getKey()).getLong("id"), Map.Entry::getValue));
        for (DynamicObject bill : bills) {
            List curErrLog = errLogForId.get(bill.getLong("id"));
            Map<String, Object> exportData = this.putCommonInfo(bill);
            if (curErrLog != null && !curErrLog.isEmpty()) {
                exportData.put("islegal", ResManager.loadKDString((String)"\u5426", (String)"DispatchBillServiceImpl_2", (String)"hr-ham-business", (Object[])new Object[0]));
                exportData.put("reason", String.join((CharSequence)"", curErrLog));
            } else {
                exportData.put("islegal", ResManager.loadKDString((String)"\u662f", (String)"DispatchBillServiceImpl_6", (String)"hr-ham-business", (Object[])new Object[0]));
            }
            exportDataList.add(exportData);
        }
        return exportDataList;
    }

    private Map<String, Object> putCommonInfo(DynamicObject bill) {
        HashMap exportData = Maps.newHashMapWithExpectedSize((int)16);
        exportData.put("id", bill.getLong("id"));
        exportData.put("person.name", bill.getString("ermanfile.name"));
        exportData.put("person.number", bill.getString("ermanfile.number"));
        exportData.put("org", bill.getDynamicObject("org").getLocaleString("name").toString());
        exportData.put("billstatus", DispatchAuditStatusEnum.getName((String)bill.getString("billstatus")));
        exportData.put("outstatus", DispatchOutStatusEnum.getName((String)bill.getString("outstatus")));
        exportData.put("instatus", DispatchInStatusEnum.getName((String)bill.getString("instatus")));
        return exportData;
    }

    @Override
    public DynamicObject queryOneDispatch(Long id, List<String> fields) {
        return DispatchRepository.getInstance().queryOne(String.join((CharSequence)",", fields), id);
    }

    @Override
    public DynamicObject queryOneDispatch(Long id) {
        Object[] dynamicObjects = this.queryDispatch(new Object[]{id});
        if (HRArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return null;
        }
        return dynamicObjects[0];
    }

    @Override
    public DynamicObject[] queryDispatch(String properties, QFilter[] qFilter) {
        return this.serviceHelper.query(properties, qFilter);
    }

    @Override
    public DynamicObject[] queryDispatch(Object[] ids) {
        return DispatchRepository.getInstance().loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", (Object)ids)});
    }

    @Override
    public void doValidDispatch(DynamicObject[] dispatchBills) {
        log.info("DispatchBillServiceImpl doValidDispatch start ids: {}", Arrays.stream(dispatchBills).map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        UpdateVidDto vidDto = new UpdateVidDto();
        vidDto.setDynamicObjectList(Arrays.asList(dispatchBills)).setPropMapping(PROP_TYPE_LIST_HASH_MAP).setRelatedPropMapping(RELATED_PROP_MAPPING);
        UpdateHistoryVidService.getInstance().updateHistoryVid(vidDto);
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = DispatchDateUtils.now();
        ((Stream)Arrays.stream(dispatchBills).parallel()).forEach(dy -> {
            dy.set("dispatchstatus", (Object)DispatchStatusEnum.EFFECTED_DISPATCH.getCode());
            dy.set("modifier", (Object)currUserId);
            dy.set("modifytime", (Object)now);
        });
        this.serviceHelper.update(dispatchBills);
        log.info("DispatchBillServiceImpl doValidDispatch end");
    }

    @Override
    public List<Long> invokeGetSuperiorByRule(DynamicObject dyn, String orgField, String aPositionTypeField, String positionField) {
        try {
            long personId = ORM.create().genLongId("hrpi_person");
            HashMap dynVsIdMap = Maps.newHashMapWithExpectedSize((int)1);
            dynVsIdMap.put(dyn, personId);
            List<Map<String, Object>> infInParamList = DirectLeaderHelper.buildParamMap(new DynamicObject[]{dyn}, dynVsIdMap, orgField, aPositionTypeField, positionField);
            log.info("start DispatchBillServiceImpl invokeGetSuperiorByRule param: {}", infInParamList);
            Map<Long, List<Map<String, Object>>> idVsLeaderListMap = IDispatchHRPIService.getInstance().invokeGetSuperiorByRule(infInParamList);
            if (CollectionUtils.isEmpty(idVsLeaderListMap)) {
                return Lists.newArrayListWithExpectedSize((int)1);
            }
            List<Map<String, Object>> leaderList = idVsLeaderListMap.getOrDefault(personId, Lists.newArrayListWithExpectedSize((int)0));
            List<Long> personIdList = leaderList.stream().filter(map -> Objects.nonNull(map.get("person.id"))).map(map -> (Long)map.get("person.id")).collect(Collectors.toList());
            log.info("end DispatchBillServiceImpl invokeGetSuperiorByRule personIdList : {}", personIdList);
            return personIdList;
        }
        catch (Exception exception) {
            log.error("\u83b7\u53d6\u76f4\u63a5\u4e0a\u7ea7\u5931\u8d25\uff1a", (Throwable)exception);
            return Lists.newArrayListWithExpectedSize((int)1);
        }
    }

    @Override
    public List<Long> invokeGetMainChargeInfoByOrg(List<Long> orgIds) {
        log.info("start DispatchBillServiceImpl invokeGetMainChargeInfoByOrg param: {}", orgIds);
        List<Map<String, Object>> maps = IDispatchHRPIService.getInstance().invokeGetMainChargeInfoByOrg(orgIds);
        if (null == maps || maps.isEmpty()) {
            log.error("DispatchBillServiceImpl invokeGetMainChargeInfoByOrg result is null");
            return new ArrayList<Long>();
        }
        log.info("end DispatchBillServiceImpl invokeGetMainChargeInfoByOrg result : {}", maps);
        return maps.stream().map(temp -> (Long)temp.get("person")).collect(Collectors.toList());
    }

    @Override
    public boolean terminateDispatch(Long personId, Date terminateTime, String terminatersn, Long laborrelStatusId) {
        OperationResult operationResult;
        boolean result = false;
        String queryProperties = "laborrelstatus,terminatetime,terminatersn,id,billno,submitnoticstatus,stopnoticstatus,effectstatus,effecttime,disoutinorder,auditstatus,outstatus,instatus,dispatchstatus,terminatersn,ermanfile,startdate,billstatus,terminateuser";
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)2);
        qFilters.add(new QFilter("person", "=", (Object)personId));
        qFilters.add(new QFilter("dispatchstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{DispatchStatusEnum.APPROVING_DISPATCH.getCode(), DispatchStatusEnum.WAITEFFECT_DISPATCH.getCode(), DispatchStatusEnum.WAIT_DISPATCH.getCode()})));
        DynamicObject[] bills = DispatchBillRepository.getInstance().query(queryProperties, qFilters.toArray(new QFilter[0]));
        if (bills.length == 0) {
            return true;
        }
        ArrayList inIds = Lists.newArrayListWithExpectedSize((int)bills.length);
        ArrayList outIds = Lists.newArrayListWithExpectedSize((int)bills.length);
        ArrayList personChanges = Lists.newArrayListWithExpectedSize((int)4);
        Arrays.stream(bills).forEach(bill -> {
            bill.set("terminatetime", (Object)terminateTime);
            bill.set("terminateuser", (Object)1L);
            bill.set("terminatersn", (Object)terminatersn);
            bill.set("laborrelstatus", (Object)laborrelStatusId);
            String dispatchStatus = bill.getString("dispatchstatus");
            if (HRStringUtils.equals((String)dispatchStatus, (String)DispatchStatusEnum.APPROVING_DISPATCH.getCode()) || HRStringUtils.equals((String)dispatchStatus, (String)DispatchStatusEnum.WAITEFFECT_DISPATCH.getCode())) {
                if (HRStringUtils.equals((String)DispatchOrderEnum.OUT_2_IN.getOrder(), (String)bill.getString("disoutinorder"))) {
                    outIds.add(bill.getLong("id"));
                }
                if (HRStringUtils.equals((String)DispatchOrderEnum.IN_2_OUT.getOrder(), (String)bill.getString("disoutinorder"))) {
                    inIds.add(bill.getLong("id"));
                }
                personChanges.add(bill);
            }
        });
        log.info("Dispatch.terminate workflow inIds\uff1a{}", (Object)JSON.toJSONString((Object)inIds));
        log.info("Dispatch.terminate workflow outIds\uff1a{}", (Object)JSON.toJSONString((Object)outIds));
        Arrays.stream(bills).forEach(bill -> {
            String oldInStatus = bill.getString("instatus");
            String oldOutStatus = bill.getString("outstatus");
            StatusHandleUtils.handle(new DispatchBillStatusHandler(), "quit_stop", bill);
            if (HRStringUtils.isEmpty((String)oldInStatus)) {
                bill.set("instatus", (Object)oldInStatus);
            }
            if (HRStringUtils.isEmpty((String)oldOutStatus)) {
                bill.set("outstatus", (Object)oldOutStatus);
            }
        });
        IDispatchPersonChangeService dispatchPersonChangeService = ServiceFactory.getService(IDispatchPersonChangeService.class);
        dispatchPersonChangeService.excutePersonChangeNotice(personChanges.toArray(new DynamicObject[0]), PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_TERMINATIO, true);
        DispatchBillRepository.getInstance().update(bills);
        if (!CollectionUtils.isEmpty((Collection)inIds)) {
            operationResult = OperationServiceHelper.executeOperate((String)"discard", (String)"ham_dispatchin", (Object[])inIds.toArray(), (OperateOption)OperateOption.create());
            log.info("Dispatch.terminate workflow inIds\uff1a{}\uff0cresult\uff1a {}\uff0cmessage\uff1a{}", new Object[]{JSON.toJSONString((Object)inIds), JSON.toJSONString((Object)operationResult), operationResult.getMessage()});
        }
        if (!CollectionUtils.isEmpty((Collection)outIds)) {
            operationResult = OperationServiceHelper.executeOperate((String)"discard", (String)"ham_dispatchout", (Object[])outIds.toArray(), (OperateOption)OperateOption.create());
            log.info("Dispatch.terminate workflow outIds\uff1a{}\uff0cresult\uff1a {}\uff0cmessage\uff1a{}", new Object[]{JSON.toJSONString((Object)outIds), JSON.toJSONString((Object)operationResult), operationResult.getMessage()});
        }
        result = true;
        return result;
    }

    @Override
    public void updateDarkPosition(DynamicObject[] dynamicObjects) {
        ArrayList updateBills = Lists.newArrayListWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String posPatter = dynamicObject.getString("inradiogroupfield");
            if (!"0".equals(posPatter) && !"2".equals(posPatter)) continue;
            this.createDispatchInDarkPosition(dynamicObject, posPatter);
            updateBills.add(dynamicObject);
        }
        DispatchRepository.getInstance().update(updateBills.toArray(new DynamicObject[0]));
    }

    @Override
    public void updateWorkRole(DynamicObject[] dynamicObjects) {
        if (Objects.isNull(dynamicObjects) || dynamicObjects.length == 0) {
            return;
        }
        log.info("DispatchBillServiceImpl.updateWorkRole ids:{}", Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        List<DynamicObject> dynamicObjectList = Arrays.stream(dynamicObjects).filter(dynamicObject -> {
            String inPositionPattern = dynamicObject.getString("inradiogroupfield");
            return HRStringUtils.equals((String)inPositionPattern, (String)"1");
        }).collect(Collectors.toList());
        dynamicObjectList.forEach(dynamicObject -> {
            Object positionObj = dynamicObject.get("positionin");
            DynamicObject positionDO = null;
            if (positionObj instanceof DynamicObject) {
                positionDO = (DynamicObject)positionObj;
            }
            if (positionObj instanceof Long) {
                HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("");
                positionDO = baseServiceHelper.queryOne("workrole", positionObj);
            }
            if (Objects.nonNull(positionDO)) {
                dynamicObject.set("workrole", positionDO.get("workrole"));
                log.info("DispatchBillServiceImpl.updateWorkRole,billId:{},workRoleId:{}", (Object)dynamicObject.getLong("id"), (Object)this.getLongFromBaseData(dynamicObject.get("workrole")));
            }
        });
        DispatchRepository.getInstance().update(dynamicObjectList.toArray(new DynamicObject[0]));
    }

    @Override
    public void updateJob(DynamicObject[] dynamicObjects) {
        if (Objects.isNull(dynamicObjects) || dynamicObjects.length == 0) {
            return;
        }
        log.info("DispatchBillServiceImpl.updateJob ids:{}", Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        List<DynamicObject> needUpdateDOs = Arrays.stream(dynamicObjects).filter(dy -> HRStringUtils.equals((String)dy.getString("inradiogroupfield"), (String)"0") || HRStringUtils.equals((String)dy.getString("inradiogroupfield"), (String)"1")).collect(Collectors.toList());
        needUpdateDOs.forEach(dy -> {
            if (HRStringUtils.equals((String)dy.getString("inradiogroupfield"), (String)"0")) {
                DynamicObject stdPositionInDO = dy.getDynamicObject("standardposin");
                Objects.requireNonNull(stdPositionInDO);
                dy.set("jobin", stdPositionInDO.get("job"));
                log.info("DispatchBillServiceImpl.updateJob-stdposition,billId:{},jobIn:{}", (Object)dy.getLong("id"), (Object)this.getLongFromBaseData(stdPositionInDO.get("job")));
            }
            if (HRStringUtils.equals((String)dy.getString("inradiogroupfield"), (String)"1")) {
                DynamicObject positionInDO = dy.getDynamicObject("positionin");
                Objects.requireNonNull(positionInDO);
                dy.set("jobin", positionInDO.get("job"));
                log.info("DispatchBillServiceImpl.updateJob-position,billId:{},jobIn:{}", (Object)dy.getLong("id"), (Object)this.getLongFromBaseData(positionInDO.get("job")));
            }
        });
        DispatchRepository.getInstance().update(needUpdateDOs.toArray(new DynamicObject[0]));
    }

    private long getLongFromBaseData(Object o) {
        if (o instanceof DynamicObject) {
            return ((DynamicObject)o).getLong("id");
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        return 0L;
    }

    private void createDispatchInDarkPosition(DynamicObject entity, String posPatter) {
        Map<String, Object> resultMap;
        Map<String, Object> paramMap = this.buildDispatchInDarkPositionParam(entity, posPatter);
        log.info("createDispatchInDarkPosition begin, the request param is : [{}] billId is {}", (Object)Collections.singletonList(paramMap).toString(), (Object)entity.getLong("id"));
        if ("0".equals(posPatter)) {
            resultMap = IDispatchHBPMService.getInstance().invokerAddDarkPosition(Collections.singletonList(paramMap));
        } else if ("2".equals(posPatter)) {
            resultMap = IDispatchHBPMService.getInstance().invokerAddDarkPositionByJob(Collections.singletonList(paramMap));
        } else {
            log.error("createDispatchInDarkPosition error no match postpattern : [{}]", (Object)posPatter);
            throw new KDBizException("createDispatchInDarkPosition error no match postpattern");
        }
        log.info("createDispatchInDarkPosition end,  the response is : [{}]", (Object)JSONObject.toJSONString(resultMap));
        if (this.isAddDarkPositionFail(resultMap)) {
            if (resultMap != null && resultMap.get("ErrMsg") != null) {
                log.error("Create dark position error, the billId is :[{}], the error message is :[{}]", (Object)entity.getLong("id"), resultMap.get("ErrMsg"));
            } else {
                log.error("Create dark position error, the billId is :[{}], the result is empty", (Object)entity.getLong("id"));
            }
            return;
        }
        List dataList = (List)resultMap.get("data");
        Map resultData = (Map)dataList.get(0);
        entity.set("positionin", resultData.get("position"));
        if ("2".equals(posPatter)) {
            entity.set("standardposin", resultData.get("standardposition"));
        }
    }

    private boolean isAddDarkPositionFail(Map<String, Object> resultMap) {
        return HRObjectUtils.isEmpty(resultMap) || HRObjectUtils.isEmpty((Object)resultMap.get("data")) || HRObjectUtils.isEmpty(((List)resultMap.get("data")).get(0)) || !this.isRequestPositionSuccess(resultMap) && HRObjectUtils.isEmpty(((Map)((List)resultMap.get("data")).get(0)).get("position"));
    }

    private boolean isRequestPositionSuccess(Map<String, Object> resultMap) {
        return !HRObjectUtils.isEmpty(resultMap) && "200".equals(resultMap.get("code")) && !HRObjectUtils.isEmpty((Object)resultMap.get("data"));
    }

    private Map<String, Object> buildDispatchInDarkPositionParam(DynamicObject entity, String posPatter) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("user", entity.getLong("person_id"));
        paramMap.put("effect", entity.getDate("startdate"));
        if (posPatter.equals("0")) {
            paramMap.put("standardposition", entity.getLong("standardposin.id"));
        } else if (posPatter.equals("2")) {
            paramMap.put("job", entity.getLong("jobin.id"));
        }
        paramMap.put("org", entity.getLong("deptin.id"));
        return paramMap;
    }

    static {
        PROP_TYPE_LIST_HASH_MAP.put(VidPropType.ADMIN_ORG, Arrays.asList("companyout", "deptout", "plancompanyin", "plandepin", "companyin", "deptin", "adminorgout", "adminorgin"));
        PROP_TYPE_LIST_HASH_MAP.put(VidPropType.ADMIN_ORG_STRUCT, Arrays.asList("deptlongnuminvid", "deptlongnumoutvid", "plandeptlongnuminvid", "orglongnuminvid", "orglongnumoutvid", "adminorglongnuminvid", "adminorglongnumoutvid"));
        PROP_TYPE_LIST_HASH_MAP.put(VidPropType.POSITION, Arrays.asList("positionout", "planpositionin", "positionin"));
        PROP_TYPE_LIST_HASH_MAP.put(VidPropType.STAND_POSITION, Arrays.asList("planstandardposin", "standardposin", "standardposout"));
        PROP_TYPE_LIST_HASH_MAP.put(VidPropType.JOB, Arrays.asList("jobin", "jobout", "planjob"));
        RELATED_PROP_MAPPING.put("deptin", "deptlongnuminvid");
        RELATED_PROP_MAPPING.put("deptout", "deptlongnumoutvid");
        RELATED_PROP_MAPPING.put("plandepin", "plandeptlongnuminvid");
        RELATED_PROP_MAPPING.put("orgin", "orglongnuminvid");
        RELATED_PROP_MAPPING.put("orgout", "orglongnumoutvid");
        RELATED_PROP_MAPPING.put("adminorgin", "adminorglongnuminvid");
        RELATED_PROP_MAPPING.put("adminorgout", "adminorglongnumoutvid");
    }
}

