/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.service.impl.bill;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.ham.business.domain.service.bill.IDispatchValidatorService;
import kd.hr.ham.business.domain.service.validator.DyObjValidateContext;
import kd.hr.ham.business.domain.service.validator.ValidateContext;
import kd.hr.ham.business.domain.service.validator.ValidateProducer;
import kd.hr.ham.common.dispatch.enums.DispatchAuditStatusEnum;
import kd.hr.ham.common.dispatch.enums.DispatchStatusEnum;
import kd.hr.hbp.common.util.HRStringUtils;

public class DispatchValidatorServiceImp
implements IDispatchValidatorService {
    private static final Log log = LogFactory.getLog(DispatchValidatorServiceImp.class);

    @Override
    public List<DyObjValidateContext> batchUnSubmitValidate(List<DynamicObject> dynamicObjects) {
        List<DyObjValidateContext> dyObjValidateContexts = ValidateProducer.init(dynamicObjects);
        this.validateStatus(dyObjValidateContexts);
        return dyObjValidateContexts;
    }

    @Override
    public List<DyObjValidateContext> batchUnSubmitValidate(List<DynamicObject> dynamicObjects, String billFormId) {
        List<DyObjValidateContext> dyObjValidateContexts = ValidateProducer.init(dynamicObjects);
        List ids = dynamicObjects.stream().map(temp -> (Long)temp.get("id")).collect(Collectors.toList());
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"preunsubmit", (String)billFormId, (Object[])ids.toArray(), (OperateOption)OperateOption.create());
        log.info("IDispatchValidatorService preunsubmit opResult: {}", (Object)JSONObject.toJSONString((Object)opResult));
        List allErrorOrValidateInfo = opResult.getAllErrorOrValidateInfo();
        if (!CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
            this.buildData(dynamicObjects, dyObjValidateContexts, allErrorOrValidateInfo);
        }
        this.validateStatus(dyObjValidateContexts);
        return dyObjValidateContexts;
    }

    private void validateStatus(List<DyObjValidateContext> dyObjValidateContexts) {
        dyObjValidateContexts.forEach(dyObjValidateContext -> {
            String errorMsg = ResManager.loadKDString((String)"\u53ea\u6709\u53d1\u8d77\u65b9\u53ef\u4ee5\u64a4\u9500\u53d1\u8d77\u65b9\u5ba1\u6279\u72b6\u6001\u4e3a\u201c\u6d3e\u51fa/\u6d3e\u5165\u5df2\u63d0\u4ea4\u201d\u7684\u5355\u636e\u3002", (String)"DispatchValidatorServiceImp_0", (String)"hr-ham-common", (Object[])new Object[0]);
            Predicate<DyObjValidateContext> predicate = ValidateProducer.produce("billstatus", errorMsg, dynamicObjValidateContext -> {
                DynamicObject dynamicObject = dynamicObjValidateContext.getDynamicObject();
                String audiStatus = dynamicObject.getString("billstatus");
                return HRStringUtils.equals((String)audiStatus, (String)DispatchAuditStatusEnum.ALREADYSUBMIT.getCode());
            });
            predicate.test((DyObjValidateContext)dyObjValidateContext);
        });
    }

    @Override
    public List<DyObjValidateContext> batchDeleteValidate(List<DynamicObject> dynamicObjects, String billFormId) {
        List<DyObjValidateContext> dyObjValidateContexts = ValidateProducer.init(dynamicObjects);
        List ids = dynamicObjects.stream().map(temp -> (Long)temp.get("id")).collect(Collectors.toList());
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"predelete", (String)billFormId, (Object[])ids.toArray(), (OperateOption)OperateOption.create());
        log.info("IDispatchValidatorService predelete opResult: {}", (Object)JSONObject.toJSONString((Object)opResult));
        List allErrorOrValidateInfo = opResult.getAllErrorOrValidateInfo();
        if (!CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
            this.buildData(dynamicObjects, dyObjValidateContexts, allErrorOrValidateInfo);
        }
        dyObjValidateContexts.forEach(dyObjValidateContext -> {
            String errorMsg = ResManager.loadKDString((String)"\u53ea\u6709\u53d1\u8d77\u65b9\u53ef\u4ee5\u5220\u9664\u5ba1\u6279\u72b6\u6001\u4e3a\u201c\u5f85\u6d3e\u51fa/\u6d3e\u5165\u90e8\u95e8\u63d0\u4ea4\u201d\u7684\u5355\u636e\u3002", (String)"DispatchValidatorServiceImp_1", (String)"hr-ham-common", (Object[])new Object[0]);
            Predicate<DyObjValidateContext> predicate = ValidateProducer.produce("billstatus", errorMsg, dynamicObjValidateContext -> {
                DynamicObject dynamicObject = dynamicObjValidateContext.getDynamicObject();
                String audiStatus = dynamicObject.getString("billstatus");
                String dispatchStatus = dynamicObject.getString("dispatchstatus");
                return HRStringUtils.equals((String)audiStatus, (String)DispatchAuditStatusEnum.TEMPSTORAGE.getCode()) && HRStringUtils.equals((String)dispatchStatus, (String)DispatchStatusEnum.WAIT_DISPATCH.getCode());
            });
            predicate.test((DyObjValidateContext)dyObjValidateContext);
        });
        return dyObjValidateContexts;
    }

    @Override
    public List<DyObjValidateContext> terminateValidate(List<DynamicObject> dynamicObjects, String billFormId) {
        List<DyObjValidateContext> dyObjValidateContexts = ValidateProducer.init(dynamicObjects);
        dyObjValidateContexts.forEach(dyObjValidateContext -> {
            String errorMsg = ResManager.loadKDString((String)"\u53ea\u80fd\u7ec8\u6b62\u5916\u6d3e\u72b6\u6001\u4e3a\u201c\u5916\u6d3e\u5ba1\u6279\u4e2d\u201d\u7684\u5355\u636e\u3002", (String)"DispatchValidatorServiceImp_2", (String)"hr-ham-common", (Object[])new Object[0]);
            Predicate<DyObjValidateContext> predicate = ValidateProducer.produce("billstatus", errorMsg, dynamicObjValidateContext -> {
                DynamicObject dynamicObject = dynamicObjValidateContext.getDynamicObject();
                String audiStatus = dynamicObject.getString("billstatus");
                String dispatchStatus = dynamicObject.getString("dispatchstatus");
                return HRStringUtils.equals((String)audiStatus, (String)DispatchAuditStatusEnum.ALREADYSUBMIT.getCode()) || HRStringUtils.equals((String)audiStatus, (String)DispatchAuditStatusEnum.WAITRESUBMIT.getCode()) || HRStringUtils.equals((String)audiStatus, (String)DispatchAuditStatusEnum.APPROVING.getCode()) || HRStringUtils.equals((String)audiStatus, (String)DispatchAuditStatusEnum.TEMPSTORAGE.getCode()) && HRStringUtils.equals((String)dispatchStatus, (String)DispatchStatusEnum.APPROVING_DISPATCH.getCode());
            });
            predicate.test((DyObjValidateContext)dyObjValidateContext);
        });
        return dyObjValidateContexts;
    }

    private void buildData(List<DynamicObject> dynamicObjects, List<DyObjValidateContext> dyObjValidateContexts, List<IOperateInfo> allErrorOrValidateInfo) {
        HashMap failId2ErrorMsg = Maps.newHashMapWithExpectedSize((int)dynamicObjects.size());
        allErrorOrValidateInfo.stream().forEach(iOperateInfo -> failId2ErrorMsg.put(iOperateInfo.getPkValue().toString(), iOperateInfo.getMessage()));
        dyObjValidateContexts.forEach(dyObjValidateContext -> {
            if (failId2ErrorMsg.containsKey(dyObjValidateContext.getDynamicObject().getString("id"))) {
                ValidateContext validatorContext = dyObjValidateContext.getValidatorContext();
                Map<String, String> validateResult = validatorContext.getValidateResult();
                validateResult.put("id", (String)failId2ErrorMsg.get(dyObjValidateContext.getDynamicObject().getString("id")));
            }
        });
    }
}

