/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.service.impl.bill;

import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.ham.business.domain.repository.bill.RecordChangeRepository;
import kd.hr.ham.business.domain.service.bill.IRecordChangeBillService;
import kd.hr.ham.business.domain.service.impl.common.AbsCommonBusinessService;
import kd.hr.ham.business.domain.service.validator.DyObjValidateContext;
import kd.hr.ham.business.domain.service.validator.ValidateProducer;
import kd.hr.ham.business.domain.status.handler.RecordChangeStatusHandler;
import kd.hr.ham.business.domain.status.util.StatusHandleUtils;
import kd.hr.ham.common.dispatch.enums.DisAuditStatusEnum;
import kd.hr.ham.common.dispatch.enums.RecordChangeStatusEnum;
import kd.hr.ham.common.dispatch.utils.DispatchDateUtils;
import kd.hr.ham.common.dispatch.utils.DyObjOperateUtils;
import kd.hr.ham.common.dispatch.utils.HamResultUtils;

public class RecordChangeBillServiceImpl
extends AbsCommonBusinessService
implements IRecordChangeBillService {
    private static final Log LOG = LogFactory.getLog(RecordChangeBillServiceImpl.class);

    public RecordChangeBillServiceImpl() {
        this.init();
    }

    private void init() {
        this.setServiceHelper(RecordChangeRepository.getInstance());
    }

    @Override
    public DynamicObject queryOneDispatchChange(Long id) {
        return this.serviceHelper.queryOne((Object)id);
    }

    @Override
    public Map<String, Object> terminate(DynamicObject dynamicObject, Object termReason) {
        AtomicReference result = new AtomicReference();
        Optional.ofNullable(dynamicObject).ifPresent(dy -> {
            LOG.info("recordChange terminate billNo:{}", (Object)dynamicObject.getString("billno"));
            StatusHandleUtils.handle(new RecordChangeStatusHandler(), "discard_bill", dynamicObject);
            dy.set("terminateuser", (Object)RequestContext.get().getCurrUserId());
            dy.set("terminatetime", (Object)DispatchDateUtils.now());
            dy.set("terminatersn", termReason);
            DyObjOperateUtils.updateModifyInfo((DynamicObject)dynamicObject);
            this.serviceHelper.updateOne(dynamicObject);
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"wfdiscard", (String)"ham_dispatchrecordchg", (Object[])new Long[]{dynamicObject.getLong("id")}, (OperateOption)OperateOption.create());
            result.set(HamResultUtils.recordResult((Object)operationResult.isSuccess(), (Object)operationResult.getMessage()));
        });
        return (Map)result.get();
    }

    @Override
    public DyObjValidateContext terminateValidate(DynamicObject dynamicObject) {
        DyObjValidateContext dyObjValidateContext = ValidateProducer.init(dynamicObject);
        String errorMsg = ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u662f\u201c\u53d8\u66f4\u5df2\u63d0\u4ea4\u201d\u3001\u201c\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u3001\u201c\u53d8\u66f4\u5ba1\u6279\u4e2d\u201d\u624d\u80fd\u7ec8\u6b62\u3002", (String)"RecordChangeBillServiceImpl_0", (String)"hr-ham-business", (Object[])new Object[0]);
        ValidateProducer.produce("changestatus", errorMsg, context -> {
            String status = context.getDynamicObject().getString("changestatus");
            return RecordChangeStatusEnum.isInProcess((String)status);
        }).test(dyObjValidateContext);
        return dyObjValidateContext;
    }

    @Override
    public DynamicObject[] query(String properties, QFilter[] qFilter) {
        return this.serviceHelper.query(properties, qFilter);
    }

    @Override
    public DynamicObject queryProcessingByRecord(Long recordId) {
        return RecordChangeRepository.getInstance().queryOnGoingByRecord(recordId);
    }

    @Override
    public Map<String, Object> updateDeptChgByDepEmpId(Long personId, Date effectTimeDate, Long laborRelStatus) {
        DynamicObject[] dispChgDOs = this.queryDeptch(personId);
        if (dispChgDOs.length > 0) {
            Arrays.stream(dispChgDOs).forEach(dynamicObject -> {
                dynamicObject.set("laborrelstatus", (Object)laborRelStatus);
                dynamicObject.set("terminatetime", (Object)effectTimeDate);
                dynamicObject.set("terminateuser", (Object)1L);
                dynamicObject.set("auditstatus", (Object)DisAuditStatusEnum.STOPED.getCode());
            });
            this.serviceHelper.update(dispChgDOs);
        }
        return HamResultUtils.success();
    }

    public DynamicObject[] queryDeptch(Object personId) {
        QFilter qFilter = new QFilter("person", "=", personId);
        qFilter.and(new QFilter("changestatus", "in", (Object)RecordChangeStatusEnum.inOnGoingCode()));
        String selectProperties = "laborrelstatus,id,billno,person,auditstatus,terminatetime,terminateuser";
        return this.query(selectProperties, qFilter.toArray());
    }
}

