/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.service.impl.common;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.ham.business.domain.repository.bill.DispatchBackRepository;
import kd.hr.ham.business.domain.service.common.DispatchBackEffectService;
import kd.hr.ham.business.domain.service.common.IDispabackPersonChangeService;
import kd.hr.ham.common.dispatch.utils.DispatchDateUtils;

public class DispatchBackEffectServiceImpl
implements DispatchBackEffectService {
    private static final Log LOG = LogFactory.getLog(DispatchBackEffectServiceImpl.class);

    @Override
    public void executeEffect() {
        DynamicObject[] dynamicObjects = DispatchBackRepository.getInstance().queryPreValidBacks();
        this.executeEffect(dynamicObjects);
    }

    @Override
    public void executeEffect(List<Long> dispatchBillIdList) {
    }

    @Override
    public void executeEffect(DynamicObject[] dynamicObjects) {
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            LOG.warn("DispatchBackEffectService no data in:{}", (Object)DispatchDateUtils.now());
            return;
        }
        LOG.info("DispatchBackEffectService execute start id:{}", Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                IDispabackPersonChangeService.getInstance().disprecordPersonChangeNoticeStop(dynamicObjects);
            }
            catch (Exception exception) {
                txHandle.markRollback();
                LOG.error("DispatchBackEffectService error: ", (Throwable)exception);
                throw exception;
            }
            LOG.info("DispatchBackEffectService execute end");
        }
    }
}

