/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.service.impl.common;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.ham.business.domain.repository.DispatchRepository;
import kd.hr.ham.business.domain.service.bill.IDispatchBillService;
import kd.hr.ham.business.domain.service.common.DispatchEffectService;
import kd.hr.ham.business.domain.service.common.IDispatchPersonChangeService;
import kd.hr.ham.common.dispatch.enums.PersonChangeOperateTypeEnum;
import kd.hr.ham.common.dispatch.utils.DispatchDateUtils;

public class DispatchEffectServiceImpl
implements DispatchEffectService {
    private static final Log LOG = LogFactory.getLog(DispatchEffectServiceImpl.class);

    @Override
    public void executeEffect() {
        DynamicObject[] dispatchBillArr = DispatchRepository.getInstance().queryPreValidBillInToday();
        this.executeEffect(dispatchBillArr);
    }

    @Override
    public void executeEffect(List<Long> dispatchBillIdList) {
    }

    @Override
    public void executeEffect(DynamicObject[] dispatchBills) {
        if (dispatchBills == null || dispatchBills.length == 0) {
            LOG.warn("DispatchEffectService no data in:{}", (Object)DispatchDateUtils.now());
            return;
        }
        IDispatchBillService.getInstance().updateDarkPosition(dispatchBills);
        LOG.info("DispatchEffectService execute start");
        try (TXHandle txHandle = TX.required((String)"DispatchEffectService");){
            try {
                IDispatchBillService.getInstance().updateJob(dispatchBills);
                IDispatchBillService.getInstance().updateWorkRole(dispatchBills);
                IDispatchPersonChangeService.getInstance().excutePersonChangeEffect(dispatchBills, PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_EFFECT);
            }
            catch (Exception exception) {
                txHandle.markRollback();
                LOG.error("DispatchEffectService error: ", (Throwable)exception);
                throw exception;
            }
            LOG.info("DispatchEffectService execute end");
        }
    }
}

