/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.service.impl.common;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.ham.business.domain.repository.DispatchRepository;
import kd.hr.ham.business.domain.service.bill.IDispatchBillService;
import kd.hr.ham.business.domain.service.common.IDispatchPersonChangeService;
import kd.hr.ham.business.domain.service.common.IPersonalChangeExternalService;
import kd.hr.ham.business.domain.service.handler.DispatchHPFSTemplatePropertyHandler;
import kd.hr.ham.business.domain.service.record.DispatchRecordService;
import kd.hr.ham.business.domain.status.dto.CrossValidateMsg;
import kd.hr.ham.business.domain.status.dto.CrossValidateParamDto;
import kd.hr.ham.business.domain.status.dto.CrossValidateResDto;
import kd.hr.ham.business.domain.status.util.PersonChangeUtils;
import kd.hr.ham.business.mq.sender.DispatchPersonChangeSend;
import kd.hr.ham.business.util.PromptUtil;
import kd.hr.ham.common.dispatch.bean.CreateRecordDto;
import kd.hr.ham.common.dispatch.constants.PrompConstants;
import kd.hr.ham.common.dispatch.enums.CrossActionEnum;
import kd.hr.ham.common.dispatch.enums.DisAuditStatusEnum;
import kd.hr.ham.common.dispatch.enums.PerChgEnum;
import kd.hr.ham.common.dispatch.enums.PersonChangeOperateTypeEnum;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class DispatchPersonChangeServiceImpl
implements IDispatchPersonChangeService {
    private static final Log LOGGER = LogFactory.getLog(DispatchPersonChangeServiceImpl.class);
    private static final String billNo = "billNo";
    private static final String actionId = "actionId";
    private static final String data = "data";

    @Override
    public CrossValidateResDto excutePersonOverlapCheckByParam(CrossValidateParamDto crossValidateParam) {
        CrossValidateResDto crossValidateRes = new CrossValidateResDto();
        crossValidateRes.setPersonName(crossValidateParam.getPersonName());
        crossValidateRes.setBillId(crossValidateParam.getBillId());
        Map<String, Object> params = PersonChangeUtils.getCheckParam(crossValidateParam);
        Map<String, Object> perChgResult = IPersonalChangeExternalService.getInstance().invokerPerChgCrossValidate(params);
        LOGGER.info("Dispatch perchgValidate------params:{}-------perChgResult:{}", (Object)params.toString(), perChgResult);
        if (!PersonChangeUtils.checkPerChgCrossValidateResult(perChgResult)) {
            LOGGER.error("Dispatch excutePersonOverlapCheckByParam result is error , the billId is : [{}], the result is :[{}]", (Object)crossValidateParam.getBillId(), perChgResult);
            return crossValidateRes;
        }
        List crossList = (List)perChgResult.get(data);
        List<CrossValidateMsg> msgs = this.getCrossValidateMsg(crossList, crossValidateParam);
        crossValidateRes.setMsgs(msgs);
        return crossValidateRes;
    }

    private List<CrossValidateMsg> getCrossValidateMsg(List<Map<String, Object>> crossList, CrossValidateParamDto crossValidateParam) {
        ArrayList<CrossValidateMsg> msgs = new ArrayList<CrossValidateMsg>();
        if (!Objects.isNull(crossList) && !crossList.isEmpty()) {
            crossList.forEach(validateResult -> {
                String actionIdStr = validateResult.get(actionId).toString();
                actionIdStr = actionIdStr.length() == 6 && actionIdStr.startsWith("20") ? actionIdStr.substring(2) : actionIdStr;
                CrossActionEnum actionEnum = CrossActionEnum.getAction((String)actionIdStr);
                switch (actionEnum) {
                    case DISPATCH_QUIT: 
                    case DISPATCH_RETIRE: 
                    case DISPATCH_REHIRE: 
                    case DISPATCH_REG: {
                        CrossValidateMsg msgQuit = PersonChangeUtils.dispatchGetCrossValidateMsg(crossValidateParam.getPersonName(), validateResult, actionEnum.getPrompId(), actionEnum);
                        msgs.add(msgQuit);
                        break;
                    }
                    case DISPATCH_TRANSFERINCO: 
                    case DISPATCH_TRANSFEROUTCO: {
                        CrossValidateMsg msgTransfer = this.getTransferCrossValidateMsg(crossValidateParam, (Map<String, Object>)validateResult, actionEnum);
                        msgs.add(msgTransfer);
                        break;
                    }
                    case DISPATCH_PARTTIME: {
                        CrossValidateMsg msgParttime = this.getParttimeCrossValidateMsg(crossValidateParam, (Map<String, Object>)validateResult, actionEnum);
                        msgs.add(msgParttime);
                        break;
                    }
                    default: {
                        CrossValidateMsg msgCommon = PersonChangeUtils.commonCrossValidateMsg(crossValidateParam.getPersonName(), validateResult);
                        msgs.add(msgCommon);
                    }
                }
            });
        }
        return msgs;
    }

    @Override
    public Map<Long, CrossValidateResDto> excutePersonOverlapCheckByParams(List<CrossValidateParamDto> crossValidateParam) {
        HashMap<Long, CrossValidateResDto> checkResult = new HashMap<Long, CrossValidateResDto>(crossValidateParam.size());
        List<Map<String, Object>> params = PersonChangeUtils.getCheckParamList(crossValidateParam);
        Map<String, Object> perChgResult = IPersonalChangeExternalService.getInstance().invokerPerChgCrossValidateBatch(params);
        LOGGER.info("Dispatch excutePersonOverlapCheckByParams------params:{}-------perChgResult:{}", (Object)params.toString(), perChgResult);
        if (!PersonChangeUtils.checkPerChgCrossValidateResult(perChgResult)) {
            LOGGER.error("Dispatch excutePersonOverlapCheckByParams result is error,perChgResult:{}", perChgResult);
            return checkResult;
        }
        Map crossListMap = (Map)perChgResult.get(data);
        LOGGER.info("Dispatch perChgResult1 :{}", perChgResult);
        LOGGER.info("Dispatch crossListMap2 :{}", (Object)crossListMap);
        for (CrossValidateParamDto crossValidate : crossValidateParam) {
            List crossList = (List)crossListMap.get(Long.parseLong(crossValidate.getDepEmpId()));
            LOGGER.info("Dispatch crossList3 :{}", (Object)crossList);
            CrossValidateResDto crossValidateRes = new CrossValidateResDto();
            crossValidateRes.setPersonName(crossValidate.getPersonName());
            crossValidateRes.setBillId(crossValidate.getBillId());
            List<CrossValidateMsg> msgs = this.getCrossValidateMsg(crossList, crossValidate);
            crossValidateRes.setMsgs(msgs);
            checkResult.put(crossValidate.getBillId(), crossValidateRes);
        }
        return checkResult;
    }

    private CrossValidateMsg getParttimeCrossValidateMsg(CrossValidateParamDto crossValidateParam, Map<String, Object> validateResult, CrossActionEnum actionEnum) {
        Long adminorgId;
        DynamicObject adminorgDO;
        CrossValidateMsg msg = new CrossValidateMsg();
        Long billId = Long.valueOf(validateResult.get("billId").toString());
        boolean positionCompairRes = false;
        Map<String, Object> perChgResult = IPersonalChangeExternalService.getInstance().queryParttimePositionInfoById(billId);
        LOGGER.info("Dispatch getParttimeCrossValidateMsg queryParttimePositionInfoById------params:{}-------perChgResult:{}", (Object)JSONObject.toJSONString((Object)crossValidateParam), perChgResult);
        if (crossValidateParam.getPosType() == null) {
            msg.setMsgType("ignore");
            return msg;
        }
        if (crossValidateParam.getPosType().equals("1") && perChgResult.get("position") != null) {
            DynamicObject positionDO = (DynamicObject)perChgResult.get("position");
            Long positionId = positionDO.getLong("boid");
            if (positionId.equals(crossValidateParam.getPositionBoId())) {
                positionCompairRes = true;
            }
            LOGGER.info("getParttimeCrossValidateMsg,position: {}", (Object)positionId);
            LOGGER.info("getParttimeCrossValidateMsg,we position:  {}", (Object)crossValidateParam.getPositionId());
            LOGGER.info("getParttimeCrossValidateMsg,we positionBoId:  {}", (Object)crossValidateParam.getPositionBoId());
        }
        if (crossValidateParam.getPosType().equals("0") && perChgResult.get("stdposition") != null) {
            DynamicObject stdpositionDO = (DynamicObject)perChgResult.get("stdposition");
            adminorgDO = (DynamicObject)perChgResult.get("adminorg");
            Long stdpositionId = stdpositionDO.getLong("boid");
            adminorgId = adminorgDO.getLong("id");
            if (stdpositionId.equals(crossValidateParam.getStdpositionBoId()) && adminorgId.equals(crossValidateParam.getDeptinId())) {
                positionCompairRes = true;
            }
            LOGGER.info("getParttimeCrossValidateMsg,stdposition:  {}", (Object)stdpositionId);
            LOGGER.info("getParttimeCrossValidateMsg,we stdposition:  {}", (Object)crossValidateParam.getStdpositionId());
            LOGGER.info("getParttimeCrossValidateMsg,we stdpositionBoId:  {}", (Object)crossValidateParam.getStdpositionBoId());
            LOGGER.info("getParttimeCrossValidateMsg,adminorgId:  {}", (Object)adminorgId);
            LOGGER.info("getParttimeCrossValidateMsg,we depInId:  {}", (Object)crossValidateParam.getDeptinId());
        }
        if (crossValidateParam.getPosType().equals("2") && perChgResult.get("job") != null) {
            DynamicObject jobDO = (DynamicObject)perChgResult.get("job");
            adminorgDO = (DynamicObject)perChgResult.get("adminorg");
            Long jobId = jobDO.getLong("boid");
            adminorgId = adminorgDO.getLong("id");
            if (jobId.equals(crossValidateParam.getJobBoId()) && adminorgId.equals(crossValidateParam.getDeptinId())) {
                positionCompairRes = true;
            }
            LOGGER.info("getParttimeCrossValidateMsg,jobId:  {}", (Object)jobId);
            LOGGER.info("getParttimeCrossValidateMsg,we getJobId:  {}", (Object)crossValidateParam.getJobId());
            LOGGER.info("getParttimeCrossValidateMsg,we getJobBoId:  {}", (Object)crossValidateParam.getJobBoId());
            LOGGER.info("getParttimeCrossValidateMsg,adminorgId:  {}", (Object)adminorgId);
            LOGGER.info("getParttimeCrossValidateMsg,we depInId:  {}", (Object)crossValidateParam.getDeptinId().toString());
        }
        if (positionCompairRes) {
            String prompt = PromptUtil.getPromptById(actionEnum.getPrompId());
            if (prompt != null) {
                msg.setMsgType("error");
                String msgInfo = MessageFormat.format(prompt, crossValidateParam.getPersonName(), validateResult.get(billNo).toString());
                msg.setMsgInfo(msgInfo);
            }
        } else {
            msg.setMsgType("ignore");
        }
        return msg;
    }

    private CrossValidateMsg getTransferCrossValidateMsg(CrossValidateParamDto crossValidateParam, Map<String, Object> validateResult, CrossActionEnum actionEnum) {
        Long promptId;
        Long stdpositionId;
        Long positionId;
        CrossValidateMsg msg = new CrossValidateMsg();
        boolean positionCompairRes = false;
        Long billId = Long.valueOf(validateResult.get("billId").toString());
        Map perChgResult = Optional.ofNullable(IPersonalChangeExternalService.getInstance().queryTransferPositionInfoById(billId)).orElseGet(HashMap::new);
        if (perChgResult.get("arealityposition") != null && !(positionId = Long.valueOf(Long.parseLong(perChgResult.get("arealityposition").toString()))).equals(0L) && positionId.equals(crossValidateParam.getPositionId())) {
            positionCompairRes = true;
            LOGGER.info("getTransferCrossValidateMsg,arealityposition:  {}", (Object)positionId);
            LOGGER.info("getTransferCrossValidateMsg,we arealityposition:  {}", (Object)crossValidateParam.getPositionId());
        }
        if (perChgResult.get("arealitystposition") != null && !(stdpositionId = Long.valueOf(Long.parseLong(perChgResult.get("arealitystposition").toString()))).equals(0L) && stdpositionId.equals(crossValidateParam.getStdpositionId())) {
            positionCompairRes = true;
            LOGGER.info("getTransferCrossValidateMsg,arealitystposition:  {}", (Object)stdpositionId);
            LOGGER.info("getTransferCrossValidateMsg,we arealitystposition:  {}", (Object)crossValidateParam.getStdpositionId());
        }
        String msgInfo = "";
        if (positionCompairRes) {
            promptId = PrompConstants.TRANSFER_POST_PROMPFID;
            msg.setMsgType("error");
            String prompt = PromptUtil.getPromptById(promptId);
            if (prompt != null) {
                msgInfo = MessageFormat.format(prompt, crossValidateParam.getPersonName(), validateResult.get(billNo).toString());
            }
            LOGGER.info("getTransferCrossValidateMsg,prompt eq:  {}", (Object)prompt);
            LOGGER.info("getTransferCrossValidateMsg,Info eq:  {}", (Object)msgInfo);
        } else {
            promptId = PrompConstants.TRANSFER_PROMPFID;
            msg.setMsgType("warn");
            String prompt = PromptUtil.getPromptById(promptId);
            if (prompt != null) {
                msgInfo = MessageFormat.format(prompt, crossValidateParam.getPersonName(), validateResult.get(billNo).toString());
            }
            LOGGER.info("getTransferCrossValidateMsg,prompt no eq:  {}", (Object)prompt);
            LOGGER.info("getTransferCrossValidateMsg,Info  no eq:  {}", (Object)msgInfo);
        }
        msg.setMsgInfo(msgInfo);
        return msg;
    }

    @Override
    public void excutePersonChangeNotice(DynamicObject[] dispatchBills, PersonChangeOperateTypeEnum operateTypeEnum, boolean isNotOperateDB) {
        for (DynamicObject dispatchBill : dispatchBills) {
            String inStatus = dispatchBill.getString("instatus");
            String outStatus = dispatchBill.getString("outstatus");
            if (operateTypeEnum == PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_CREATE && HRStringUtils.isNotEmpty((String)inStatus) && HRStringUtils.isNotEmpty((String)outStatus)) {
                operateTypeEnum = PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_MODIFY;
            }
            try {
                String noticStatusType = "";
                if (PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_CREATE == operateTypeEnum) {
                    noticStatusType = "submitnoticstatus";
                    dispatchBill.set("stopnoticstatus", (Object)"0");
                } else if (PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_TERMINATIO == operateTypeEnum) {
                    noticStatusType = "stopnoticstatus";
                }
                if (PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_MODIFY == operateTypeEnum) {
                    return;
                }
                if (!"0".equals(dispatchBill.getString(noticStatusType)) && !"3".equals(dispatchBill.getString(noticStatusType))) continue;
                DispatchPersonChangeSend.sendNoticePersonChangeMsg(dispatchBill, operateTypeEnum.getValue());
                dispatchBill.set(noticStatusType, (Object)"1");
            }
            catch (Exception e) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Dispatch sendPersonChangeMsg error, the billId is :");
                stringBuilder.append(dispatchBill.getString("id"));
                stringBuilder.append(",the errorMsg is {}");
                LOGGER.error(stringBuilder.toString(), (Throwable)e);
            }
        }
        if (!isNotOperateDB) {
            DispatchRepository.getInstance().update(dispatchBills);
        }
    }

    @Override
    public void excutePersonChangeNoticeFail(long billId, String operation) {
        DynamicObject dispatchBillData = this.getDispatchBillData(billId);
        if (HRObjectUtils.isEmpty((Object)dispatchBillData)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("dispatch bill data does not exist, the bill id is :");
            stringBuilder.append(billId);
            stringBuilder.append(",the exception is {}");
            LOGGER.error(stringBuilder.toString(), (Object)operation);
            return;
        }
        String noticStatusType = this.getNoticStatusTypeField(operation);
        dispatchBillData.set(noticStatusType, (Object)"3");
        DispatchRepository.getInstance().updateOne(dispatchBillData);
        LOGGER.info("dispatch bill excutePersonChangeNoticeFail, the bill id is {} operation is {}", (Object)billId, (Object)operation);
    }

    @Override
    public void excutePersonChangeNoticeSuccess(long billId, String operation) {
        DynamicObject dispatchBillData = this.getDispatchBillData(billId);
        if (HRObjectUtils.isEmpty((Object)dispatchBillData)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("dispatch bill data does not exist, the bill id is :");
            stringBuilder.append(billId);
            stringBuilder.append(",the exception is {}");
            LOGGER.error(stringBuilder.toString(), (Object)operation);
            return;
        }
        String noticStatusType = this.getNoticStatusTypeField(operation);
        dispatchBillData.set(noticStatusType, (Object)"2");
        DispatchRepository.getInstance().updateOne(dispatchBillData);
        LOGGER.info("dispatch bill excutePersonChangeNoticeSuccess, the bill id is {},operation is {} ", (Object)billId, (Object)operation);
    }

    private String getNoticStatusTypeField(String operation) {
        String noticStatusType = "";
        if (PerChgEnum.SUBMIT.getValue().equals(operation)) {
            noticStatusType = "submitnoticstatus";
        } else if (PerChgEnum.TERMINATION.getValue().equals(operation)) {
            noticStatusType = "stopnoticstatus";
        }
        return noticStatusType;
    }

    @Override
    public void excutePersonChangeEffect(DynamicObject[] dispatchBills, PersonChangeOperateTypeEnum operateTypeEnum) {
        for (DynamicObject dispatchBill : dispatchBills) {
            Long billId = dispatchBill.getLong("id");
            if (HRObjectUtils.isEmpty((Object)dispatchBill)) {
                LOGGER.error("dispatch bill data does not exist, the bill id is {}", (Object)billId);
                return;
            }
            if (!"0".equals(dispatchBill.getString("effectstatus")) && !"3".equals(dispatchBill.getString("effectstatus"))) continue;
            DynamicObject oneDispatch = IDispatchBillService.getInstance().queryOneDispatch(billId);
            boolean isnewchgaction = oneDispatch.getBoolean("affaction.isnewchgaction");
            if (isnewchgaction) {
                DispatchHPFSTemplatePropertyHandler.getInstance().saveHPFSEffectMessage(new DynamicObject[]{oneDispatch});
                continue;
            }
            DispatchPersonChangeSend.sendAckPersonChangeEffectMsg(dispatchBill, operateTypeEnum.getValue());
            dispatchBill.set("effectstatus", (Object)"1");
            DispatchRepository.getInstance().update(dispatchBills);
        }
    }

    @Override
    public void excutePersonChangeEffectFail(long billId) {
        DynamicObject dispatchBillData = this.getDispatchBillData(billId);
        if (HRObjectUtils.isEmpty((Object)dispatchBillData)) {
            LOGGER.error("dispatch bill data does not exist, the bill id is {}", (Object)billId);
            return;
        }
        dispatchBillData.set("effectstatus", (Object)"3");
        DispatchRepository.getInstance().updateOne(dispatchBillData);
        LOGGER.info("dispatch bill excutePersonChangeEffectFail, the bill id is {} ", (Object)billId);
    }

    @Override
    public void excutePersonChangeEffectSuccess(long billId, Long newErfileId) {
        DynamicObject dispatchBillData = this.getDispatchBillData(billId);
        if (HRObjectUtils.isEmpty((Object)dispatchBillData)) {
            LOGGER.error("dispatch bill data does not exist, the bill id is {}", (Object)billId);
            return;
        }
        dispatchBillData.set("effectstatus", (Object)"2");
        dispatchBillData.set("effecttime", (Object)new Date());
        dispatchBillData.set("auditstatus", (Object)DisAuditStatusEnum.PROCESSED.getCode());
        DispatchRepository.getInstance().updateOne(dispatchBillData);
        LOGGER.info("dispatch bill excutePersonChangeEffectSuccess, the bill id is {} ", (Object)billId);
        CreateRecordDto createRecordDto = new CreateRecordDto();
        createRecordDto.setDispatchId(Long.valueOf(billId));
        createRecordDto.setNewErmanFileId(newErfileId);
        LOGGER.info("dispatch bill excutePersonChangeEffectSuccess createRecord start, the Param is {} ", (Object)createRecordDto.toString());
        Map<String, Object> creatRes = DispatchRecordService.getInstance().createRecord(createRecordDto);
        LOGGER.info("dispatch bill excutePersonChangeEffectSuccess createRecord end, the result is {} ", (Object)creatRes.toString());
        LOGGER.info("dispatch bill excutePersonChangeEffectSuccess VID start, the bill is {} ", (Object)billId);
        DynamicObject[] dispatchBills = new DynamicObject[]{dispatchBillData};
        IDispatchBillService.getInstance().doValidDispatch(dispatchBills);
        LOGGER.info("dispatch bill excutePersonChangeEffectSuccess VID end, the bill is {} ", (Object)billId);
    }

    private DynamicObject getDispatchBillData(long billId) {
        DynamicObject query = IDispatchBillService.getInstance().queryOneDispatch(billId);
        return query;
    }
}

