/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.service.impl.common;

import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.ham.business.domain.repository.DispatchRepository;
import kd.hr.ham.business.domain.repository.bill.DispatchBackRepository;
import kd.hr.ham.business.domain.service.bill.IDispatchBackBillService;
import kd.hr.ham.business.domain.service.bill.IDispatchBillService;
import kd.hr.ham.business.domain.service.common.IDispabackPersonChangeService;
import kd.hr.ham.business.domain.service.common.IPersonalChangeExternalService;
import kd.hr.ham.business.domain.service.handler.DispatchBackHPFSTemplatePropertyHandler;
import kd.hr.ham.business.domain.service.handler.HPFSTemplatePropertyHandler;
import kd.hr.ham.business.domain.service.record.DispatchRecordService;
import kd.hr.ham.business.domain.status.dto.CrossValidateMsg;
import kd.hr.ham.business.domain.status.dto.CrossValidateParamDto;
import kd.hr.ham.business.domain.status.dto.CrossValidateResDto;
import kd.hr.ham.business.domain.status.util.PersonChangeUtils;
import kd.hr.ham.business.mq.sender.DispbackPersonChangeSend;
import kd.hr.ham.common.dispatch.constants.AffactionConstants;
import kd.hr.ham.common.dispatch.constants.DispatchMQConstants;
import kd.hr.ham.common.dispatch.enums.DispBackCrossActionEnum;
import kd.hr.ham.common.dispatch.enums.DispatchStatusEnum;
import kd.hr.ham.common.dispatch.enums.PerChgEnum;
import kd.hr.ham.common.dispatch.enums.PersonChangeOperateTypeEnum;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;

public class DispbackPersonChangeServiceImpl
implements IDispabackPersonChangeService {
    private static final Log LOGGER = LogFactory.getLog(DispbackPersonChangeServiceImpl.class);
    private static final String actionId = "actionId";
    private static final String data = "data";

    @Override
    public void disprecordPersonChangeNoticeStop(DynamicObject[] dispbackBills) {
        for (DynamicObject dispbackBill : dispbackBills) {
            Date dispbackEndDate = dispbackBill.getDate("enddate");
            String strDateToday = HRDateTimeUtils.formatDate((Date)new Date());
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date dtToday = HRDateTimeUtils.parseDate((String)strDateToday);
                Date dtBack = HRDateTimeUtils.parseDate((String)sdf.format(dispbackEndDate));
                boolean isEffectNow = HRDateTimeUtils.dayBefore((Date)dtBack, (Date)HRDateTimeUtils.addDay((Date)dtToday, (long)-1L));
                boolean isEqualNow = HRDateTimeUtils.dayEquals((Date)dtBack, (Date)HRDateTimeUtils.addDay((Date)dtToday, (long)-1L));
                LOGGER.info("Dispback disprecordPersonChangeNoticeStop check date dtToday:[{}],dtBack:[{}] <>isEffectNow:[{}],isEqualNow:[{}]", new Object[]{dtToday, dtBack, isEffectNow, isEqualNow});
                if (isEffectNow || isEqualNow) {
                    this.excutePersonChangeEffect(dispbackBills, PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_EFFECT);
                    continue;
                }
                this.excutePersonChangeNotice(dispbackBills, PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_CREATE);
            }
            catch (Exception exception) {
                LOGGER.error("Dispback excutePersonChangeEffect error: ", (Throwable)exception);
            }
        }
    }

    @Override
    public CrossValidateResDto excutePersonOverlapCheckByParam(CrossValidateParamDto crossValidateParam) {
        CrossValidateResDto dispBackcrossValidateRes = new CrossValidateResDto();
        dispBackcrossValidateRes.setPersonName(crossValidateParam.getPersonName());
        dispBackcrossValidateRes.setBillId(crossValidateParam.getBillId());
        Map<String, Object> params = PersonChangeUtils.getCheckParam(crossValidateParam);
        Map<String, Object> perChgResult = IPersonalChangeExternalService.getInstance().invokerPerChgCrossValidate(params);
        LOGGER.info("Dispback perchgValidate------params:{}-------perChgResult:{}", (Object)params.toString(), perChgResult);
        if (!PersonChangeUtils.checkPerChgCrossValidateResult(perChgResult)) {
            LOGGER.error("Dispback excutePersonOverlapCheckByParam result is error , the billId is : [{}], the result is :[{}]", (Object)crossValidateParam.getBillId(), perChgResult);
            return dispBackcrossValidateRes;
        }
        List crossList = (List)perChgResult.get(data);
        List<CrossValidateMsg> msgs = this.getCrossValidateMsg(crossList, crossValidateParam);
        dispBackcrossValidateRes.setMsgs(msgs);
        return dispBackcrossValidateRes;
    }

    private List<CrossValidateMsg> getCrossValidateMsg(List<Map<String, Object>> crossList, CrossValidateParamDto crossValidateParam) {
        ArrayList<CrossValidateMsg> msgs = new ArrayList<CrossValidateMsg>();
        if (!Objects.isNull(crossList) && !crossList.isEmpty()) {
            crossList.forEach(validateResult -> {
                LOGGER.info("Dispback validateResult actionId:{}", (Object)validateResult.get(actionId).toString());
                DispBackCrossActionEnum actionEnum = DispBackCrossActionEnum.getAction((String)validateResult.get(actionId).toString());
                switch (actionEnum) {
                    case DISPBACK_QUIT: 
                    case DISPBACK_TRANSFERINCO: 
                    case DISPBACK_TRANSFEROUTCO: 
                    case DISPBACK_RETIRE: 
                    case DISPBACK_REHIRE: {
                        CrossValidateMsg msgQuit = PersonChangeUtils.dispbackGetCrossValidateMsg(crossValidateParam.getPersonName(), validateResult, actionEnum.getPrompId(), actionEnum);
                        msgs.add(msgQuit);
                        break;
                    }
                    default: {
                        LOGGER.error("Dispback operation types that do not need to be processed, actionId is : [{}]", (Object)actionEnum.getActionId());
                    }
                }
            });
        }
        return msgs;
    }

    @Override
    public Map<Long, CrossValidateResDto> excutePersonOverlapCheckByParams(List<CrossValidateParamDto> crossValidateParam) {
        HashMap<Long, CrossValidateResDto> checkResult = new HashMap<Long, CrossValidateResDto>(crossValidateParam.size());
        List<Map<String, Object>> params = PersonChangeUtils.getCheckParamList(crossValidateParam);
        Map<String, Object> perChgResult = IPersonalChangeExternalService.getInstance().invokerPerChgCrossValidateBatch(params);
        LOGGER.info("Disback excutePersonOverlapCheckByParams------params:{}-------perChgResult:{}", (Object)params.toString(), perChgResult);
        if (!PersonChangeUtils.checkPerChgCrossValidateResult(perChgResult)) {
            LOGGER.error("Disback excutePersonOverlapCheckByParams result is error,perChgResult:{}", perChgResult);
            return checkResult;
        }
        Map crossListMap = (Map)perChgResult.get(data);
        LOGGER.info("Disback perChgResult1 :{}", perChgResult);
        LOGGER.info("Disback crossListMap2 :{}", (Object)crossListMap);
        for (CrossValidateParamDto crossValidate : crossValidateParam) {
            List crossList = (List)crossListMap.get(Long.parseLong(crossValidate.getDepEmpId()));
            LOGGER.info("Disback crossList3 :{}", (Object)crossList);
            CrossValidateResDto crossValidateRes = new CrossValidateResDto();
            crossValidateRes.setPersonName(crossValidate.getPersonName());
            crossValidateRes.setBillId(crossValidate.getBillId());
            List<CrossValidateMsg> msgs = this.getCrossValidateMsg(crossList, crossValidate);
            crossValidateRes.setMsgs(msgs);
            checkResult.put(crossValidate.getBillId(), crossValidateRes);
        }
        return checkResult;
    }

    @Override
    public CrossValidateParamDto getCrossValidateParamByRecordObj(DynamicObject erManFileObj) {
        CrossValidateParamDto crossValidateParam = new CrossValidateParamDto();
        boolean isNewChgAction = HPFSTemplatePropertyHandler.isNewChgAction("ham_dispatch_hpfs_new");
        if (isNewChgAction) {
            crossValidateParam.setActionId(String.valueOf(AffactionConstants.DISP_AFFACTION_NEW));
        } else {
            crossValidateParam.setActionId(String.valueOf(DispatchMQConstants.DISPATCH_ACTIONID));
        }
        crossValidateParam.setPersonName(erManFileObj.getString("name"));
        crossValidateParam.setPersonId(String.valueOf(erManFileObj.get("person.id")));
        crossValidateParam.setEmployeeId(String.valueOf(erManFileObj.get("employee.id")));
        crossValidateParam.setManagingScopeId(String.valueOf(erManFileObj.get("cmpemp.id")));
        crossValidateParam.setDepEmpId(String.valueOf(erManFileObj.get("depemp.id")));
        crossValidateParam.setEffectTime(System.currentTimeMillis());
        return crossValidateParam;
    }

    @Override
    public void excutePersonChangeNotice(DynamicObject[] dispbackBills, PersonChangeOperateTypeEnum operateTypeEnum) {
        for (DynamicObject dispbackBill : dispbackBills) {
            try {
                String noticStatusType = "";
                if (PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_CREATE == operateTypeEnum) {
                    noticStatusType = "submitnoticstatus";
                    dispbackBill.set("stopnoticstatus", (Object)"0");
                } else if (PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_TERMINATIO == operateTypeEnum) {
                    noticStatusType = "stopnoticstatus";
                }
                if (PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_MODIFY == operateTypeEnum) {
                    return;
                }
                if (!"0".equals(dispbackBill.getString(noticStatusType)) && !"3".equals(dispbackBill.getString(noticStatusType))) continue;
                DispbackPersonChangeSend.sendNoticePersonChangeMsg(dispbackBill, operateTypeEnum.getValue());
                dispbackBill.set(noticStatusType, (Object)"1");
            }
            catch (Exception e) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Dispback sendPersonChangeMsg error, the billId is :");
                stringBuilder.append(dispbackBill.getString("id"));
                stringBuilder.append(",the errorMsg is {}");
                LOGGER.error(stringBuilder.toString(), (Throwable)e);
            }
        }
        DispatchBackRepository.getInstance().update(dispbackBills);
    }

    @Override
    public void excutePersonChangeNoticeFail(long billId, String operation) {
        DynamicObject dispbackBillData = this.getDispbackBillData(billId);
        if (HRObjectUtils.isEmpty((Object)dispbackBillData)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("dispback bill data does not exist, the bill id is :");
            stringBuilder.append(billId);
            stringBuilder.append(",the exception is {}");
            return;
        }
        String noticStatusType = this.getNoticStatusTypeField(operation);
        dispbackBillData.set(noticStatusType, (Object)"3");
        DispatchBackRepository.getInstance().updateOne(dispbackBillData);
        LOGGER.info("dispback bill excutePersonChangeNoticeFail, the bill id is {} operation is {}", (Object)billId, (Object)operation);
    }

    @Override
    public void excutePersonChangeNoticeSuccess(long billId, String operation) {
        DynamicObject dispbackBillData = this.getDispbackBillData(billId);
        if (HRObjectUtils.isEmpty((Object)dispbackBillData)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("dispback bill data does not exist, the bill id is :");
            stringBuilder.append(billId);
            stringBuilder.append(",the exception is {}");
            LOGGER.error(stringBuilder.toString(), (Object)operation);
            return;
        }
        String noticStatusType = this.getNoticStatusTypeField(operation);
        dispbackBillData.set(noticStatusType, (Object)"2");
        DispatchBackRepository.getInstance().updateOne(dispbackBillData);
        LOGGER.info("dispback bill excutePersonChangeNoticeSuccess, the bill id is {},operation is {} ", (Object)billId, (Object)operation);
    }

    @Override
    public void excutePersonChangeEffect(DynamicObject[] dispbackBills, PersonChangeOperateTypeEnum operateTypeEnum) {
        ArrayList updateDys = Lists.newArrayListWithCapacity((int)dispbackBills.length);
        for (DynamicObject dispbackBill : dispbackBills) {
            Long billId = dispbackBill.getLong("id");
            if (HRObjectUtils.isEmpty((Object)dispbackBill)) {
                LOGGER.error("dispback bill data does not exist, the bill id is {}", (Object)billId);
                return;
            }
            if (!"0".equals(dispbackBill.getString("effectstatus")) && !"3".equals(dispbackBill.getString("effectstatus"))) continue;
            LOGGER.info("dispback bill excutePersonChangeEffect start, the bill id is {}", (Object)dispbackBill.getString("id"));
            DynamicObject oneDispatch = IDispatchBackBillService.getInstance().queryOneDispatchBack(billId);
            boolean isnewchgaction = oneDispatch.getBoolean("affaction.isnewchgaction");
            if (isnewchgaction) {
                DispatchBackHPFSTemplatePropertyHandler.getInstance().saveHPFSEffectMessage(new DynamicObject[]{oneDispatch});
            } else {
                DispbackPersonChangeSend.sendAckPersonChangeEffectMsg(dispbackBill, operateTypeEnum.getValue());
                dispbackBill.set("effectstatus", (Object)"1");
                updateDys.add(dispbackBill);
            }
            LOGGER.info("dispback bill excutePersonChangeEffect end, the bill id is {}", (Object)dispbackBill.getString("id"));
        }
        if (updateDys.size() > 0) {
            DispatchBackRepository.getInstance().update(updateDys.toArray(new DynamicObject[0]));
        }
    }

    @Override
    public void excutePersonChangeEffectFail(long billId) {
        DynamicObject dispbackBillData = this.getDispbackBillData(billId);
        if (HRObjectUtils.isEmpty((Object)dispbackBillData)) {
            LOGGER.error("Dispback bill data does not exist, the bill id is {}", (Object)billId);
            return;
        }
        dispbackBillData.set("effectstatus", (Object)"3");
        DispatchBackRepository.getInstance().updateOne(dispbackBillData);
        LOGGER.info("Dispback bill excutePersonChangeEffectFail, the bill id is {} ", (Object)billId);
    }

    @Override
    public void excutePersonChangeEffectSuccess(long billId, Long newErfileId) {
        DynamicObject dispbackBillData = this.getDispbackBillData(billId);
        if (HRObjectUtils.isEmpty((Object)dispbackBillData)) {
            LOGGER.error("Dispback bill data does not exist, the bill id is {}", (Object)billId);
            return;
        }
        LOGGER.info("Dispback bill excutePersonChangeEffectSuccess_terminateRecord start, the bill id is {} ", (Object)billId);
        boolean terminateRecordRes = DispatchRecordService.getInstance().terminateRecord(dispbackBillData);
        LOGGER.info("Dispback bill excutePersonChangeEffectSuccess_terminateRecord end, the bill id is {} ", (Object)billId);
        long dispatchBillId = dispbackBillData.getDynamicObject("dispatchrecord").getLong("dispatch");
        LOGGER.info("Dispback bill excutePersonChangeEffectSuccess_dispatchBillId start, the bill id is {} ", (Object)dispatchBillId);
        DynamicObject dispatchDO = this.getDispatchBillData(dispatchBillId);
        if (dispatchDO != null) {
            dispatchDO.set("dispatchstatus", (Object)DispatchStatusEnum.FAILED_DISPATCH.getCode());
            DispatchRepository.getInstance().updateOne(dispatchDO);
            LOGGER.info("Dispback bill excutePersonChangeEffectSuccess_dispatchBillId end, the bill id is {}", (Object)billId);
        }
        LOGGER.info("Dispback bill excutePersonChangeEffectSuccess VID start, the bill is {} ", (Object)billId);
        DynamicObject[] dispbackBills = new DynamicObject[]{dispbackBillData};
        IDispatchBackBillService.getInstance().doValidDispatchBack(dispbackBills);
        LOGGER.info("Dispback bill excutePersonChangeEffectSuccess VID end, the bill is {} ", (Object)billId);
    }

    private String getNoticStatusTypeField(String operation) {
        String noticStatusType = "";
        if (PerChgEnum.SUBMIT.getValue().equals(operation)) {
            noticStatusType = "submitnoticstatus";
        } else if (PerChgEnum.TERMINATION.getValue().equals(operation)) {
            noticStatusType = "stopnoticstatus";
        }
        return noticStatusType;
    }

    private DynamicObject getDispbackBillData(long billId) {
        return IDispatchBackBillService.getInstance().queryOneDispatchBack(billId);
    }

    private DynamicObject getDispatchBillData(long billId) {
        DynamicObject query = IDispatchBillService.getInstance().queryOneDispatch(billId);
        return query;
    }
}

