/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.service.impl.common;

import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.ham.business.domain.repository.bill.RecordChangeRepository;
import kd.hr.ham.business.domain.service.bill.IRecordChangeBillService;
import kd.hr.ham.business.domain.service.common.IDispchgPersonChangeService;
import kd.hr.ham.business.domain.service.record.DispatchRecordService;
import kd.hr.ham.business.mq.sender.DispchgPersonChangeSend;
import kd.hr.ham.business.util.MsgPublisherUtil;
import kd.hr.ham.common.dispatch.constants.DispatchMQConstants;
import kd.hr.ham.common.dispatch.enums.PersonChangeOperateTypeEnum;
import kd.hr.hbp.common.util.HRObjectUtils;

public class DispchgPersonChangeServiceImpl
implements IDispchgPersonChangeService {
    private static final Log LOGGER = LogFactory.getLog(DispchgPersonChangeServiceImpl.class);
    private static final String MSGPUBNO = "MP20220623001003";

    @Override
    public void excutePersonChangeEffect(DynamicObject[] dispchgApplyDys, PersonChangeOperateTypeEnum operateTypeEnum) {
        for (DynamicObject dispchgBill : dispchgApplyDys) {
            Long billId = dispchgBill.getLong("id");
            if (HRObjectUtils.isEmpty((Object)dispchgBill)) {
                LOGGER.error("dispchg bill data does not exist, the bill id is {}", (Object)billId);
                return;
            }
            if (!"0".equals(dispchgBill.getString("effectstatus"))) continue;
            DispchgPersonChangeSend.sendAckPersonChangeEffectMsg(dispchgBill, operateTypeEnum.getValue());
            dispchgBill.set("effectstatus", (Object)"1");
        }
        RecordChangeRepository.getInstance().update(dispchgApplyDys);
    }

    @Override
    public void excutePersonChangeEffectFail(long billId) {
        DynamicObject dispchgBillData = this.getDispchgBillData(billId);
        if (HRObjectUtils.isEmpty((Object)dispchgBillData)) {
            LOGGER.error("Dispchg bill data does not exist, the bill id is {}", (Object)billId);
            return;
        }
        dispchgBillData.set("effectstatus", (Object)"3");
        RecordChangeRepository.getInstance().updateOne(dispchgBillData);
        LOGGER.info("Dispback bill excutePersonChangeEffectFail, the bill id is {} ", (Object)billId);
    }

    @Override
    public void excutePersonChangeEffectSuccess(long billId, Long newErfileId) {
        DynamicObject dispchgBillData = this.getDispchgBillData(billId);
        if (HRObjectUtils.isEmpty((Object)dispchgBillData)) {
            LOGGER.error("dispchg bill data does not exist, the bill id is {}", (Object)billId);
            return;
        }
        DispatchRecordService.getInstance().changeRecord(dispchgBillData);
        dispchgBillData.set("effectstatus", (Object)"2");
        dispchgBillData.set("effecttime", (Object)new Date());
        RecordChangeRepository.getInstance().updateOne(dispchgBillData);
        LOGGER.info("dispchg bill excutePersonChangeEffectSuccess, the bill id is {} ", (Object)billId);
    }

    @Override
    public void dispchgSentMsg(DynamicObject dispchgBillDO) {
        LOGGER.info("Center dispchgSentMsg Message Start");
        String personName = dispchgBillDO.getDynamicObject("ermanfile").getString("name");
        Map<String, Object> messageContent = MsgPublisherUtil.getMessageContentNoAction(dispchgBillDO);
        String msgTitle = String.format(ResManager.loadKDString((String)"%s\u5916\u6d3e\u53d8\u66f4", (String)"DispchgPersonChangeServiceImpl_1", (String)"hr-ham-business", (Object[])new Object[0]), personName);
        MsgPublisherUtil.dispPublishAction(MSGPUBNO, dispchgBillDO.getLong("id"), msgTitle, DispatchMQConstants.DISPCHG_MGS_ACTIONID, messageContent);
        LOGGER.info("Center dispchgSentMsg Message End");
    }

    private DynamicObject getDispchgBillData(long billId) {
        return IRecordChangeBillService.getInstance().queryOneDispatchChange(billId);
    }
}

